/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.archive.NameFormatter;
import com.mimvista.d;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.metabase.a.b;
import com.mimvista.metabase.a.c;
import com.mimvista.metabase.a.e;
import com.mimvista.metabase.a.f;
import com.mimvista.metabase.a.g;
import com.mimvista.metabase.a.h;
import com.mimvista.metabase.a.j;
import com.mimvista.metabase.a.k;
import com.mimvista.metabase.a.m;
import com.mimvista.metabase.a.n;
import com.mimvista.metabase.a.o;
import com.mimvista.metabase.a.p;
import com.mimvista.metabase.a.q;
import com.mimvista.metabase.a.r;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DicomDataHelper {
    private static Map<VR, g> valueConverterMap = ImmutableMap.builder().put((Object)VR.AE, (Object)o.a).put((Object)VR.AS, (Object)o.a).put((Object)VR.AT, (Object)b.a).put((Object)VR.CS, (Object)o.a).put((Object)VR.DA, (Object)e.a).put((Object)VR.DS, (Object)f.a).put((Object)VR.DT, (Object)com.mimvista.metabase.a.d.a).put((Object)VR.FD, (Object)h.a).put((Object)VR.FL, (Object)j.a).put((Object)VR.IS, (Object)k.a).put((Object)VR.LO, (Object)o.a).put((Object)VR.LT, (Object)p.a).put((Object)VR.OB, (Object)c.a).put((Object)VR.OF, (Object)c.a).put((Object)VR.OW, (Object)c.a).put((Object)VR.PN, (Object)o.a).put((Object)VR.SH, (Object)o.a).put((Object)VR.SL, (Object)n.a).put((Object)VR.SS, (Object)m.a).put((Object)VR.ST, (Object)p.a).put((Object)VR.TM, (Object)q.a).put((Object)VR.UI, (Object)o.a).put((Object)VR.UL, (Object)r.a).put((Object)VR.UN, (Object)c.a).put((Object)VR.UN_SIEMENS, (Object)c.a).put((Object)VR.US, (Object)m.a).put((Object)VR.UT, (Object)p.a).build();

    public static Map<VR, g> getConverterMap() {
        return valueConverterMap;
    }

    public static g getConvertor(VR vR) {
        return valueConverterMap.get(vR);
    }

    public static Object getValue(DicomObject dicomObject, DicomElement dicomElement) {
        return DicomDataHelper.getValue(dicomObject, dicomElement, 0);
    }

    public static Object getValue(DicomObject dicomObject, DicomElement dicomElement, int n2) {
        g g2 = DicomDataHelper.getConvertor(dicomElement.vr());
        if (g2 == null) {
            return null;
        }
        return g2.a(dicomObject, dicomElement, n2);
    }

    public static Map<Integer, Object> convertToMap(DicomObject dicomObject) {
        HashMap hashMap = Maps.newHashMap();
        final Iterator iterator = dicomObject.iterator();
        if (iterator.hasNext()) {
            Iterable<DicomElement> iterable = new Iterable<DicomElement>(){

                @Override
                public Iterator<DicomElement> iterator() {
                    return iterator;
                }
            };
            for (DicomElement dicomElement : iterable) {
                Object object;
                if (dicomElement.vr() == VR.SQ) {
                    object = Lists.newArrayList();
                    for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                        DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                        object.add(DicomDataHelper.convertToMap(dicomObject2));
                    }
                    hashMap.put(dicomElement.tag(), object);
                    continue;
                }
                object = DicomDataHelper.getValue(dicomObject, dicomElement);
                if (object == null) continue;
                hashMap.put(dicomElement.tag(), object);
            }
        }
        return hashMap;
    }

    public static Map<String, Object> convertToJsonMap(DicomObject dicomObject) {
        Set<TagPath> set = Collections.emptySet();
        Set<TagPath> set2 = Collections.emptySet();
        Set<TagPath> set3 = Collections.emptySet();
        return DicomDataHelper.convertToJsonMap(dicomObject, 0, 0, set, set2, set3);
    }

    public static Map<String, Object> convertToJsonMap(DicomObject dicomObject, int n2, int n3, @d Set<TagPath> set, @d Set<TagPath> set2, @d Set<TagPath> set3) {
        n2 = n2 < 0 ? 0 : n2;
        n3 = n3 < 0 ? 0 : n3;
        set = set == null ? Collections.emptySet() : set;
        set2 = set2 == null ? Collections.emptySet() : set2;
        set3 = set3 == null ? Collections.emptySet() : set3;
        ListMultimap<TagPath, TagPath> listMultimap = DicomDataHelper.deignoredTagPathHierarchy(set2, set);
        return DicomDataHelper.convertToJsonMap(dicomObject, new TagPath(), null, n2, n3, set, listMultimap, set3);
    }

    private static Map<String, Object> convertToJsonMap(DicomObject dicomObject, TagPath tagPath, TagPath tagPath2, int n2, int n3, Set<TagPath> set, ListMultimap<TagPath, TagPath> listMultimap, Set<TagPath> set2) {
        HashMap hashMap = Maps.newHashMapWithExpectedSize((int)dicomObject.size());
        for (DicomElement dicomElement : dicomObject) {
            int n4;
            tagPath.addTag(dicomElement.tag());
            if (set.contains(tagPath) && tagPath2 == null) {
                if (listMultimap.containsKey((Object)tagPath)) {
                    tagPath2 = new TagPath(tagPath);
                } else {
                    tagPath.removeLastTag();
                    continue;
                }
            }
            if (dicomElement.vr() == VR.SQ) {
                if (!DicomDataHelper.shouldCurrentTagBeIncluded(tagPath, tagPath2, listMultimap, true)) {
                    tagPath.removeLastTag();
                    continue;
                }
                n4 = dicomElement.countItems();
                if (n3 > 0 && !set2.contains(tagPath)) {
                    n4 = Math.min(n4, n3);
                }
                ArrayList arrayList = Lists.newArrayListWithCapacity((int)n4);
                for (int i2 = 0; i2 < n4; ++i2) {
                    DicomObject dicomObject2 = dicomElement.getDicomObject(i2);
                    arrayList.add(DicomDataHelper.convertToJsonMap(dicomObject2, tagPath, tagPath2, n2, n3, set, listMultimap, set2));
                }
                if (!arrayList.isEmpty()) {
                    hashMap.put(MetabaseKeys.fromTag(dicomElement.tag()), arrayList);
                }
            } else {
                boolean bl2;
                Object object;
                n4 = DicomDataHelper.shouldCurrentTagBeIncluded(tagPath, tagPath2, listMultimap, false);
                if (n4 != 0 && (object = DicomDataHelper.getValue(dicomObject, dicomElement, (bl2 = set2.contains(tagPath)) ? 0 : n2)) != null) {
                    hashMap.put(MetabaseKeys.fromTag(dicomElement.tag()), object);
                }
            }
            if (tagPath.equals(tagPath2)) {
                tagPath2 = null;
            }
            tagPath.removeLastTag();
        }
        return hashMap;
    }

    public static boolean shouldCurrentTagBeIncluded(TagPath tagPath, TagPath tagPath2, ListMultimap<TagPath, TagPath> listMultimap, boolean bl2) {
        if (tagPath2 == null) {
            return true;
        }
        if (tagPath.equals(tagPath2)) {
            return bl2;
        }
        List list = listMultimap.get((Object)tagPath2);
        if (list != null) {
            for (TagPath tagPath3 : list) {
                if (tagPath.equals(tagPath3) || tagPath.isSubPathOf(tagPath3)) {
                    return true;
                }
                if (!bl2 || !tagPath3.isSubPathOf(tagPath)) continue;
                return true;
            }
        }
        return false;
    }

    public static ListMultimap<TagPath, TagPath> deignoredTagPathHierarchy(Set<TagPath> set, Set<TagPath> set2) {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        if (set.isEmpty() || set2.isEmpty()) {
            return arrayListMultimap;
        }
        for (TagPath tagPath : set2) {
            for (TagPath tagPath2 : set) {
                if (!tagPath2.isSubPathOf(tagPath)) continue;
                arrayListMultimap.put((Object)tagPath, (Object)tagPath2);
            }
        }
        return arrayListMultimap;
    }

    public static List<String> createCrunchedNameListForPatientName(String string) {
        string = string.toLowerCase();
        List<String> list = NameFormatter.e(string);
        Collections.sort(list);
        return list;
    }
}

