/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class DicomDiff {
    public static Set<Integer> topLevelDiff(DicomObject dicomObject, DicomObject dicomObject2) {
        HashSet hashSet = Sets.newHashSet();
        for (DicomElement dicomElement : dicomObject) {
            if (dicomObject2.contains(dicomElement.tag()) && Objects.equal((Object)dicomElement, (Object)dicomObject2.get(dicomElement.tag()))) continue;
            hashSet.add(dicomElement.tag());
        }
        return hashSet;
    }

    public static Set<Integer> topLevelDiff(Iterable<DicomObject> iterable) {
        if (Iterables.isEmpty(iterable)) {
            return Collections.emptySet();
        }
        HashSet hashSet = Sets.newHashSet();
        Iterator<DicomObject> iterator = iterable.iterator();
        DicomObject dicomObject = iterator.next();
        while (iterator.hasNext()) {
            hashSet.addAll(DicomDiff.topLevelDiff(dicomObject, iterator.next()));
        }
        return hashSet;
    }
}

