/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.dicom.util.AbstractDicomModifier;
import com.mimvista.dicom.util.DicomFixerSeriesScanner;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.util.DateUtils;
import com.mimvista.util.ay;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DicomFixer
extends AbstractDicomModifier<DicomFixerSeriesScanner> {
    private Long endTimeDelta = null;

    public DicomFixer(DicomFixerSeriesScanner dicomFixerSeriesScanner, SendToDestination sendToDestination) {
        this.series = dicomFixerSeriesScanner.getSeries();
        this.seriesScanner = dicomFixerSeriesScanner;
        this.destination = sendToDestination;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void processDataset(DicomObject dicomObject, boolean bl2) {
        void var8_13;
        Comparable<Integer> comparable;
        Map<Integer, Object> map = ((DicomFixerSeriesScanner)this.seriesScanner).getOldInfo();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(map.keySet());
        hashSet.add(1577080);
        hashSet.add(5505046);
        for (String object2 : ((DicomFixerSeriesScanner)this.seriesScanner).getInputNames()) {
            comparable = ((DicomFixerSeriesScanner)this.seriesScanner).getTag(object2);
            hashSet.add((Integer)comparable);
        }
        Object object3 = dicomObject.getDate(524322);
        Date date = dicomObject.getDate(524320);
        Date date2 = dicomObject.getDate(524321);
        Date date3 = this.getCorrectedDate(524322);
        comparable = this.getCorrectedDate(524320);
        Date date4 = this.getCorrectedDate(524321);
        if (object3 == null) {
            Object object = object3 = date2 != null ? date2 : date;
        }
        if (date3 == null) {
            Comparable<Date> comparable2;
            Comparable<Date> comparable3 = comparable2 = date4 != null ? date4 : comparable;
        }
        if (object3 != null && var8_13 != null) {
            this.endTimeDelta = var8_13.getTime() - ((Date)object3).getTime();
        }
        if (bl2) {
            Object object;
            Object object2 = object = var8_13 != null ? var8_13 : object3;
            if (object != null) {
                dicomObject.remove(524322);
                dicomObject.putDate(524322, null, (Date)object);
            }
        }
        for (Integer n2 : hashSet) {
            Object object;
            if (!bl2 && dicomObject.get(n2.intValue()) == null) continue;
            VR vR = TagUtils.vrOfTag(n2);
            if (vR.equals(VR.UN) && dicomObject.get(n2.intValue()) != null) {
                vR = dicomObject.get(n2.intValue()).vr();
            }
            if (vR.equals(VR.AS) || vR.equals(VR.CS) || vR.equals(VR.DA) || vR.equals(VR.IS) || vR.equals(VR.LO) || vR.equals(VR.LT) || vR.equals(VR.PN) || vR.equals(VR.SH) || vR.equals(VR.ST) || vR.equals(VR.DT)) {
                object = this.getCorrectedValue(n2);
                if (object == null) {
                    dicomObject.remove(n2.intValue());
                }
                if (n2 != 1577080 && n2 != 524322) {
                    dicomObject.putString(n2.intValue(), vR, (String)object);
                }
                if (n2 != 1577080 || !dicomObject.contains(1577080) || this.endTimeDelta == null) continue;
                Date date5 = dicomObject.getDate(1577080);
                Date date6 = new Date(date5.getTime() + this.endTimeDelta);
                dicomObject.putDate(1577080, null, date6);
                continue;
            }
            if (vR.equals(VR.UI)) {
                if (n2 == 0x200052 || n2 == 805699620) continue;
                object = dicomObject.getString(n2.intValue());
                if (object != null) {
                    String string = ((DicomFixerSeriesScanner)this.seriesScanner).getHistoryValue((String)object);
                    if (string == null && !bl2) continue;
                    string = ((DicomFixerSeriesScanner)this.seriesScanner).anonymizeUID((String)object);
                    dicomObject.putString(n2.intValue(), vR, string);
                    continue;
                }
                if (n2 != 0x20000D) continue;
                dicomObject.putString(n2.intValue(), vR, UIDGenerator.generateUID());
                continue;
            }
            if (vR.equals(VR.SQ)) {
                object = dicomObject.get(n2.intValue());
                if (object == null) continue;
                for (int i2 = 0; i2 < object.countItems(); ++i2) {
                    this.processDataset(object.getDicomObject(i2), false);
                }
                continue;
            }
            ay.c((Object)("Unexpected VR: " + vR.toString()), this);
        }
    }

    private Date getCorrectedDate(int n2) {
        Object object = this.getCorrectedValue(n2);
        if (object instanceof String) {
            return DateUtils.f((String)object);
        }
        return null;
    }

    private Object getCorrectedValue(int n2) {
        String string = ((DicomFixerSeriesScanner)this.seriesScanner).getUserInputValue(n2);
        if (string != null) {
            return string;
        }
        return ((DicomFixerSeriesScanner)this.seriesScanner).getNewValue(n2);
    }

    @Override
    protected String getQueuedText() {
        return ARCHIVE.getProperty("CORRECT_QUEUED");
    }

    @Override
    protected String getLoadText() {
        return ARCHIVE.getProperty("CORRECT_LOAD");
    }

    @Override
    protected String getProgressText() {
        return DICOM.getProperty("DCM_FIX_CORRECTING");
    }
}

