/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.util.AbstractSeriesScanner;
import com.mimvista.dicom.util.DicomFixerNotification;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.util.ay;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.data.VRMap;
import org.dcm4che2.io.DicomOutputStream;

public class DicomFixerSeriesScanner
extends AbstractSeriesScanner {
    private static HashMap<String, Integer> fixerUserInputTagList = new HashMap();
    public static String PATIENTNAME = props.getProperty("PATIENT_NAME");
    public static String PATIENTID = props.getProperty("PATIENT_ID");
    public static String ACCESSIONNUMBER = props.getProperty("ACCESSION_NUMBER");
    public static String PATIENTBIRTHDAY = props.getProperty("PATIENT_BIRTH_DATE");
    public static String STUDYDATE = props.getProperty("STUDY_DATE_YYYYMMDD");
    public static String SERIESDATE = props.getProperty("SERIES_DATE_YYYYMMDD");
    public static String SERIESDESC = props.getProperty("SERIES_DESC");
    public static String ACQUISITIONDATE = props.getProperty("ACQUISITION_DATE_YYYYMMDD");
    private static String[] fixerUserInputTagNameList = new String[]{PATIENTNAME, PATIENTID, ACCESSIONNUMBER, PATIENTBIRTHDAY, STUDYDATE, SERIESDATE, ACQUISITIONDATE, SERIESDESC};
    private static int[] persistentTagsInMemory = new int[0];
    private static Map<Integer, Map<String, String>> persistentUserInputHistory = new HashMap<Integer, Map<String, String>>();
    private static int[] autoFixTagList;
    private static ConcurrentHashMap<String, String> tagRevisionHistory;
    private static Set<String> visitedSOPInstanceSet;
    private HashMap<Integer, String> currentUserInputMap = new HashMap();
    private Map<Integer, String> tagMap;
    private DicomFixerNotification notification;

    public DicomFixerSeriesScanner(DcmSeries dcmSeries, Map<Integer, String> map, DicomFixerNotification dicomFixerNotification) {
        this.series = dcmSeries;
        this.tagMap = map;
        this.notification = dicomFixerNotification;
    }

    public String getUserInputValue(int n2) {
        String string = this.getOldValue(n2);
        String string2 = this.notification.getCachedValue(n2, string);
        if (string2 != null) {
            return string2;
        }
        if (persistentUserInputHistory.get(n2) != null) {
            string2 = persistentUserInputHistory.get(n2).get(string);
        }
        if (string2 != null) {
            return string2;
        }
        string2 = this.currentUserInputMap.get(n2);
        return string2;
    }

    public int getTag(String string) {
        return fixerUserInputTagList.get(string);
    }

    public String getHistoryValue(String string) {
        return tagRevisionHistory.get(string);
    }

    public String[] getInputNames() {
        return fixerUserInputTagNameList;
    }

    public void updateValue(String string, String string2) {
        int n2 = this.getTag(string);
        this.currentUserInputMap.put(n2, string2);
        String string3 = this.getOldValue(n2);
        this.notification.updateCacheIfNeeded(n2, string3, string2);
        if (persistentUserInputHistory.get(n2) != null) {
            persistentUserInputHistory.get(n2).put(string3, string2);
        }
    }

    @Override
    protected String getName() {
        return props.getProperty("DCM_FIX_SCAN");
    }

    @Override
    protected void scan() {
        for (int i2 = 0; i2 < autoFixTagList.length; ++i2) {
            int n2 = autoFixTagList[i2];
            String string = this.ds.getString(n2);
            if (string == null) continue;
            VR vR = VRMap.getVRMap().vrOf(n2);
            if (vR == VR.UI) {
                this.replaceUid(n2);
                continue;
            }
            ay.b((Object)("Unsupported VR in scan(): " + vR.toString()), this);
        }
        String string = this.ds.getString(0x20000D);
        if (string != null) {
            this.cacheStudyInstanceUid(string);
        }
        this.replaceUid(0x200052);
        this.processSequence(805699600, 0x200052);
        this.processSequence(805699616, 805699620);
        this.processSequence(805699602, 528725);
        this.processSequence(528656, 528725);
        this.processSequence(528657, 528725);
        this.processSequence(528704, 528725);
        this.processSequence(532754, 528725);
        this.processSequence(806092802, 528725);
        this.processSequence(806092896, 528725);
        this.processSequence(806092880, 528725);
        this.processSequence(0x30080030, 528725);
        this.processSequence(528714, 528725);
        this.processSequence(805699604, 805699606);
        this.processSequence(930283796, 806092896);
        this.replaceUid(1245186);
        this.processSequence(528896, new int[]{0x20000D, 528661});
        this.processSequence(528661, new int[]{0x20000E, 528714});
    }

    private void replaceUid(int n2) {
        String string = this.ds.getString(n2);
        if (string != null) {
            if (n2 == 524312) {
                if (visitedSOPInstanceSet.contains(string)) {
                    ay.b((Object)"Clearing anon cache due to duplicate SOP", this);
                    tagRevisionHistory.clear();
                    visitedSOPInstanceSet.clear();
                }
                visitedSOPInstanceSet.add(string);
            }
            this.record(n2, string, this.anonymizeUID(string));
        }
    }

    private void cacheStudyInstanceUid(String string) {
        String string2 = tagRevisionHistory.get(string);
        if (string2 == null) {
            tagRevisionHistory.put(string, string);
        }
    }

    @Override
    public String anonymizeUID(String string) {
        String string2 = tagRevisionHistory.get(string);
        if (string2 == null) {
            string2 = UIDGenerator.generateUID();
            tagRevisionHistory.put(string, string2);
        }
        return string2;
    }

    String getOldValue(String string) {
        return this.getOldValue(this.getTag(string));
    }

    private String getOldValue(int n2) {
        if (this.tagMap.get(n2) == null) {
            return "";
        }
        return this.tagMap.get(n2);
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "E:\\MIM_DATA\\ARCHIVE\\2003-11__Studies\\CAR^SA_031120-unk.01_PT_2003-11-20_113452_(Patient,.ECAT.FDG.@).Patient.2.1000.2i.8s_().SA.Cardiac.Gated_n488__A58D7";
        String string2 = "E:\\MIM_DATA\\ARCHIVE\\2003-11__Studies\\CAR^SA1_031120-unk.01_PT_2003-11-20_113452_(Patient,.ECAT.FDG.@).Patient.2.1000.2i.8s_().SA.Cardiac.Gated_n488__A58D7";
        File file = new File(string);
        File file2 = new File(string2);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        for (File file3 : file.listFiles()) {
            DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file3);
            if (dicomObject == null) continue;
            dicomObject.remove(0x100010);
            dicomObject.remove(0x100020);
            dicomObject.remove(524368);
            dicomObject.remove(0x100030);
            dicomObject.remove(524320);
            dicomObject.remove(528446);
            dicomObject.remove(528432);
            dicomObject.remove(524416);
            dicomObject.remove(524432);
            dicomObject.remove(0x200010);
            dicomObject.remove(524321);
            File file4 = new File(string2, file3.getName());
            DicomOutputStream dicomOutputStream = new DicomOutputStream((OutputStream)new FileOutputStream(file4));
            dicomOutputStream.writeDicomFile(dicomObject);
            dicomOutputStream.close();
        }
    }

    static {
        fixerUserInputTagList.put(PATIENTNAME, 0x100010);
        fixerUserInputTagList.put(PATIENTID, 0x100020);
        fixerUserInputTagList.put(ACCESSIONNUMBER, 524368);
        fixerUserInputTagList.put(PATIENTBIRTHDAY, 0x100030);
        fixerUserInputTagList.put(STUDYDATE, 524320);
        fixerUserInputTagList.put(SERIESDATE, 524321);
        fixerUserInputTagList.put(SERIESDESC, 528446);
        fixerUserInputTagList.put(ACQUISITIONDATE, 524322);
        for (int n2 : persistentTagsInMemory) {
            persistentUserInputHistory.put(n2, new HashMap());
        }
        autoFixTagList = new int[]{524312, 0x20000E};
        tagRevisionHistory = new ConcurrentHashMap();
        visitedSOPInstanceSet = new HashSet<String>();
    }
}

