/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.base.Objects;
import com.mimvista.archive.Parser;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.dicom.util.AbstractDicomModifier;
import com.mimvista.dicom.util.DicomHipaaSeriesScanner;
import com.mimvista.dicom.util.DicomHipaaUserInput;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.ay;
import com.mimvista.util.b;
import com.mimvista.util.progress.Progress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.data.VRMap;
import org.dcm4che2.util.TagUtils;

public class DicomHipaaAnonymizer
extends AbstractDicomModifier<DicomHipaaSeriesScanner> {
    private static final String NULL_STUDY_UID = "NULL_STUDY_UID";
    private static final int[] remainedPrivateTag = new int[]{1884487696, 1884491776, 1884491785, 536940552, 4526131, 4395065, 0x111012, 806162596, 806162601, 930283552, 930283553, 930283792, 930283794, 928055298, 928055300, 930283796, 928055304, 928055312, 928055314, 928055316, 928055318, 928055320, 928055328, 928055330, 930283798, 928055334, 928055336, 928055344, 930291986, 930291987, 928055346, 928055348, 928055350, 928055352, 928055360, 928055362, 928055553, 928055376, 930295832, 930283800, 928055632, 930283808, 930283810, 0x37733000, 930295809, 930295810, 1245186, 0x130003, 930283827, 930283824, 930283825, 930283826, 930283827, 930283828, 930283829, 930283830, 928055553, 928055554, 928055555, 928055556, 928055557, 0x37730030, 930295813, 930304000, 930295846, 930308096, 930308098, 930308099, 930308097, 930308352, 930308353};
    private DicomHipaaUserInput userInput;
    private boolean removePrivateTags;
    private String newStudyInstanceUid;
    protected String progressString = null;

    public DicomHipaaAnonymizer(DicomHipaaUserInput dicomHipaaUserInput, DicomHipaaSeriesScanner dicomHipaaSeriesScanner, SendToDestination sendToDestination, boolean bl2) {
        this.userInput = dicomHipaaUserInput;
        this.seriesScanner = dicomHipaaSeriesScanner;
        this.series = dicomHipaaSeriesScanner.getSeries();
        this.destination = sendToDestination;
        this.removePrivateTags = bl2;
    }

    public void forceStudyInstanceUid(String string) {
        this.newStudyInstanceUid = string;
    }

    @Override
    public void processSeries(Progress progress) throws RemoteException {
        super.processSeries(progress);
        b.a();
    }

    @Override
    protected String getQueuedText() {
        return ARCHIVE.getProperty("ANONYMIZE_QUEUED");
    }

    @Override
    protected String getLoadText() {
        return ARCHIVE.getProperty("ANONYMIZE_LOAD");
    }

    @Override
    protected String getProgressText() {
        return MIMFormat.a(DICOM.getProperty("DCM_HIPAA_ANONYMIZE"), this.progressString);
    }

    public void setProgressString(String string) {
        this.progressString = string;
    }

    @Override
    protected void preprocessDataset(DicomObject dicomObject) {
        if (this.removePrivateTags) {
            this.removePrivateTags(dicomObject);
        }
    }

    @Override
    protected void processDataset(DicomObject dicomObject, boolean bl2) {
        Integer n2;
        Map<Integer, Object> map = ((DicomHipaaSeriesScanner)this.seriesScanner).getOldInfo();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.addAll(map.keySet());
        for (String string : this.userInput.getInputNames()) {
            n2 = this.userInput.getTag(string);
            hashSet.add(n2);
        }
        String string = dicomObject.getString(524293);
        int n3 = 0;
        for (Integer n4 : hashSet) {
            Object object;
            VR vR;
            n2 = dicomObject.get(n4.intValue());
            if (n2 == null && (!bl2 || this.getAnonymizedValue(n4) == null)) continue;
            VR vR2 = vR = n2 != null ? n2.vr() : VRMap.getVRMap().vrOf(n4.intValue());
            if (vR.equals(VR.AE) || vR.equals(VR.AS) || vR.equals(VR.CS) || vR.equals(VR.DA) || vR.equals(VR.DS) || vR.equals(VR.DT) || vR.equals(VR.IS) || vR.equals(VR.LO) || vR.equals(VR.LT) || vR.equals(VR.PN) || vR.equals(VR.SH) || vR.equals(VR.SS) || vR.equals(VR.ST) || vR.equals(VR.TM) || vR.equals(VR.SS) || vR.equals(VR.UT)) {
                object = this.getAnonymizedValue(n4);
                if (object instanceof String && Objects.equal((Object)string, (Object)"ISO_IR 100") && n3 == 0) {
                    String string2 = (String)object;
                    String string3 = "[\\p{InCJK_Unified_Ideographs}]";
                    Pattern pattern = Pattern.compile(string3);
                    Matcher matcher = pattern.matcher(string2);
                    if (matcher.find()) {
                        n3 = 1;
                        dicomObject.putString(524293, VR.CS, Parser.getDefaultSpecificCharacterSet());
                    }
                }
                if (object == null) {
                    dicomObject.remove(n4.intValue());
                    continue;
                }
                dicomObject.putString(n4.intValue(), vR, (String)object);
                continue;
            }
            if (vR.equals(VR.UI)) {
                object = dicomObject.getString(n4.intValue());
                object = this.checkNullStudyUID(n4, (String)object);
                if (object == null) continue;
                String string4 = n4 == 0x20000D && this.newStudyInstanceUid != null ? this.newStudyInstanceUid : ((DicomHipaaSeriesScanner)this.seriesScanner).anonymizeUID((String)object);
                dicomObject.putString(n4.intValue(), vR, string4);
                continue;
            }
            if (vR.equals(VR.SQ)) {
                object = dicomObject.get(n4.intValue());
                if (object == null) continue;
                for (int i2 = 0; i2 < object.countItems(); ++i2) {
                    this.processDataset(object.getDicomObject(i2), false);
                }
                continue;
            }
            ay.c((Object)("Unexpected VR: " + vR.toString()), this);
        }
    }

    private Object getAnonymizedValue(int n2) {
        if (this.userInput.getUserInputValue(n2) != null) {
            return this.userInput.getUserInputValue(n2);
        }
        return ((DicomHipaaSeriesScanner)this.seriesScanner).getNewValue(n2);
    }

    private String checkNullStudyUID(int n2, String string) {
        if (n2 == 0x20000D && string == null) {
            string = NULL_STUDY_UID + ((DicomHipaaSeriesScanner)this.seriesScanner).getLocalPath();
        }
        return string;
    }

    private void removePrivateTags(DicomObject dicomObject) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (DicomElement object : dicomObject) {
            int n2 = object.tag();
            if (TagUtils.isPrivateDataElement((int)n2) && !DicomHipaaAnonymizer.shouldRemainPrivateTag(n2)) {
                arrayList.add(n2);
                continue;
            }
            if (object.vr() != VR.SQ) continue;
            for (int i2 = 0; i2 < object.countItems(); ++i2) {
                this.removePrivateTags(object.getDicomObject(i2));
            }
        }
        for (Integer n3 : arrayList) {
            dicomObject.remove(n3.intValue());
        }
    }

    private static boolean shouldRemainPrivateTag(int n2) {
        for (int i2 = 0; i2 < remainedPrivateTag.length; ++i2) {
            if (n2 != remainedPrivateTag[i2]) continue;
            return true;
        }
        return false;
    }
}

