/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.util.Messages;
import com.mimvista.util.b;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class DicomHipaaUserInput {
    public static Messages props = Messages.a("Dicom");
    private static Map<String, Integer> anonUserInputTagList = new HashMap<String, Integer>();
    protected static Map<Integer, Map<String, String>> anonUserInputHistory = new HashMap<Integer, Map<String, String>>();
    private Map<Integer, String> lastEnteredPatInfo = new HashMap<Integer, String>();
    protected static String[] anonUserInputTagNameList = new String[]{props.getProperty("PATIENT_NAME"), props.getProperty("PATIENT_ID"), props.getProperty("STUDY_ID"), props.getProperty("STUDY_DESC"), props.getProperty("SERIES_DESC"), props.getProperty("ACCESSION_NUMBER"), props.getProperty("INSTITUTION_NAME"), props.getProperty("REFERRING_DOC")};
    private Map<Integer, String> currentUserInputMap = new HashMap<Integer, String>();
    private boolean mergeMultiplePatient = false;
    private Map<Integer, String> tagMap = new TreeMap<Integer, String>();

    boolean visibleWhenNull(String string) {
        int n2 = this.getTag(string);
        return n2 == 0x100010 || n2 == 0x100020 || n2 == 528432 || n2 == 528446 || n2 == 524416 || n2 == 524432;
    }

    public static HashMap<Integer, String> getPatientLevelInformation() {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(0x100010, null);
        hashMap.put(0x100020, null);
        return hashMap;
    }

    public DicomHipaaUserInput(Map<Integer, String> map, Map<Integer, String> map2) {
        this.tagMap = map;
        this.lastEnteredPatInfo = map2;
    }

    public void setMergeMultiplePatient(boolean bl2) {
        this.mergeMultiplePatient = bl2;
    }

    public String[] getInputNames() {
        return anonUserInputTagNameList;
    }

    public String getOldValue(String string) {
        return this.getTag(string) != null ? this.getOldValue(this.getTag(string)) : null;
    }

    public boolean isMergeMultiplePatient() {
        return this.mergeMultiplePatient;
    }

    public String getDefaultValue(String string) {
        Integer n2 = this.getTag(string);
        return n2 != null ? this.getDefaultValue(n2) : "";
    }

    public void updateValue(String string, String string2) {
        this.updateValue(this.getTag(string), string2);
    }

    public Integer getTag(String string) {
        return anonUserInputTagList.get(string);
    }

    public String getUserInputValue(int n2) {
        return this.currentUserInputMap.get(n2);
    }

    public String getOldValue(int n2) {
        return this.tagMap.get(n2);
    }

    public String getDefaultValue(int n2) {
        if (this.getHistoryValue(n2) != null) {
            return this.getHistoryValue(n2);
        }
        return this.createDefaultValue(n2);
    }

    public void updateValue(int n2, String string) {
        this.currentUserInputMap.put(n2, string);
        if (this.mergeMultiplePatient && this.isPatInfo(n2)) {
            this.lastEnteredPatInfo.put(n2, string);
        } else {
            String string2;
            if (!anonUserInputHistory.containsKey(n2)) {
                anonUserInputHistory.put(n2, new HashMap());
            }
            if ((string2 = this.getOldValue(n2)) == null) {
                string2 = "";
            }
            anonUserInputHistory.get(n2).put(string2, string);
        }
    }

    boolean isPatInfo(int n2) {
        return this.lastEnteredPatInfo.keySet().contains(n2);
    }

    private String getHistoryValue(int n2) {
        String string = this.getOldValue(n2);
        if (string == null) {
            string = "";
        }
        if (this.mergeMultiplePatient && this.lastEnteredPatInfo.get(n2) != null) {
            return this.lastEnteredPatInfo.get(n2);
        }
        if (anonUserInputHistory.containsKey(n2) && anonUserInputHistory.get(n2).get(string) != null) {
            return anonUserInputHistory.get(n2).get(string);
        }
        return null;
    }

    private String createDefaultValue(int n2) {
        if (n2 == 0x100010) {
            String string = this.tagMap.get(0x100040);
            return b.a(string);
        }
        if (n2 == 0x100020 || n2 == 0x200010) {
            if (this.tagMap.get(0x100020) != null) {
                return b.b(this.tagMap.get(0x100020));
            }
            return "";
        }
        if (n2 == 528432 || n2 == 528446 || n2 == 524368 || n2 == 524416 || n2 == 524432) {
            return this.tagMap.get(n2) != null ? this.tagMap.get(n2) : "";
        }
        return "";
    }

    private static void initAnonUserInputTagList() {
        anonUserInputTagList.put(props.getProperty("PATIENT_NAME"), 0x100010);
        anonUserInputTagList.put(props.getProperty("PATIENT_ID"), 0x100020);
        anonUserInputTagList.put(props.getProperty("STUDY_ID"), 0x200010);
        anonUserInputTagList.put(props.getProperty("STUDY_DESC"), 528432);
        anonUserInputTagList.put(props.getProperty("SERIES_DESC"), 528446);
        anonUserInputTagList.put(props.getProperty("ACCESSION_NUMBER"), 524368);
        anonUserInputTagList.put(props.getProperty("INSTITUTION_NAME"), 524416);
        anonUserInputTagList.put(props.getProperty("REFERRING_DOC"), 524432);
    }

    static {
        DicomHipaaUserInput.initAnonUserInputTagList();
    }
}

