/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.dicom.DicomImageConverter;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.util.jpeg.DicomJpegDecompressor;
import com.mimvista.numerics.ColorSpaceUtility;
import com.mimvista.util.ay;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;

public abstract class DicomRLEDecompressor {
    final DicomObject source;
    final int width;
    final int height;
    final int numFrames;
    final int bitsAlloc;
    final int spp;
    final int planarConfig;
    final String pmi;
    int bytesPerFragment;
    int bytesPerFrame;

    public DicomRLEDecompressor(DicomObject dicomObject) {
        this.source = dicomObject;
        this.width = dicomObject.getInt(2621457);
        this.height = dicomObject.getInt(2621456);
        this.numFrames = Math.max(1, dicomObject.getInt(0x280008));
        this.bitsAlloc = dicomObject.getInt(2621696, 8);
        this.spp = dicomObject.getInt(0x280002, 1);
        this.planarConfig = dicomObject.getInt(2621446, 0);
        this.pmi = dicomObject.getString(2621444);
        this.bytesPerFragment = this.width * this.height;
    }

    abstract byte[] decompressFrame(DicomElement var1, int var2, int[] var3);

    public final byte[] decompress() {
        int n2 = 0;
        int n3 = this.spp;
        if (this.bitsAlloc > 8) {
            n3 = 2;
        }
        byte[] byArray = new byte[this.width * this.height * n3 * this.numFrames];
        for (int i2 = 1; i2 <= this.numFrames; ++i2) {
            byte[] byArray2 = this.decompress(i2);
            System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
            n2 += byArray2.length;
        }
        return byArray;
    }

    final byte[] decompress(int n2) {
        DicomElement dicomElement = this.source.get(2145386512);
        int[] nArray = this.getSegmentOffsets(dicomElement, n2);
        this.bytesPerFrame = this.bytesPerFragment * nArray.length;
        return this.decompressFrame(dicomElement, n2, nArray);
    }

    public final void mutate() {
        byte[] byArray = this.decompress();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        byteBuffer = DicomImageConverter.adjustRGBFormat(byteBuffer, byteOrder, this.spp, this.bitsAlloc, this.planarConfig, this.pmi);
        this.source.putInt(0x280002, VR.US, this.spp);
        if (this.spp == 3) {
            this.source.putString(2621444, VR.CS, ColorSpaceUtility.ColorSpace.a.name());
            this.source.putInt(2621446, VR.US, 0);
        }
        this.source.putBytes(2145386512, VR.OW, byteBuffer.array());
        this.source.initFileMetaInformation("1.2.840.10008.1.2.1");
    }

    final int[] getSegmentOffsets(DicomElement dicomElement, int n2) {
        byte[] byArray = dicomElement.getFragment(n2);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        int n3 = intBuffer.get();
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = intBuffer.get();
        }
        return nArray;
    }

    public static boolean isRLECompressed(String string) {
        return "1.2.840.10008.1.2.5".equals(string);
    }

    public static boolean isRLECompressed(DicomObject dicomObject) {
        return DicomRLEDecompressor.isRLECompressed(dicomObject.getString(131088));
    }

    public static DicomRLEDecompressor get(DicomObject dicomObject) {
        boolean bl2;
        boolean bl3 = dicomObject.getInt(2621696, 8) > 8;
        boolean bl4 = bl2 = bl3 || dicomObject.getInt(2621446, 0) != 1;
        if (bl2) {
            return new InterleavingRLEDecompressor(dicomObject);
        }
        return new NonInterleavingRLEDecompressor(dicomObject);
    }

    public static byte[] getPixelDataFromCompressedRLEDicomObject(DicomObject dicomObject) {
        return DicomRLEDecompressor.get(dicomObject).decompress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompressFile(File file, File file2) {
        DicomObject dicomObject = DicomRLEDecompressor.decompressFileToDicomObject(file);
        if (dicomObject == null) {
            throw new DicomJpegDecompressor.DicomDecompressException("Can not decompress given file: " + file);
        }
        FileOutputStream fileOutputStream = null;
        DicomOutputStream dicomOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            dicomOutputStream = new DicomOutputStream((OutputStream)fileOutputStream);
            dicomOutputStream.writeDicomFile(dicomObject);
        }
        catch (IOException iOException) {
            ay.d((Object)"Error occurs when write dataset to file", (Throwable)iOException, DicomRLEDecompressor.class);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (dicomOutputStream != null) {
                    dicomOutputStream.close();
                }
            }
            catch (IOException iOException) {
                ay.d((Object)iOException, DicomRLEDecompressor.class);
            }
        }
    }

    public static DicomObject decompressFileToDicomObject(File file) {
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file);
        if (dicomObject == null) {
            String string = "Can not read file into DataSet: " + file.getAbsolutePath();
            ay.d((Object)string, DicomRLEDecompressor.class);
            return null;
        }
        if (DicomRLEDecompressor.isRLECompressed(dicomObject)) {
            DicomRLEDecompressor.get(dicomObject).mutate();
        }
        return dicomObject;
    }

    static class InterleavingRLEDecompressor
    extends DicomRLEDecompressor {
        public InterleavingRLEDecompressor(DicomObject dicomObject) {
            super(dicomObject);
        }

        @Override
        byte[] decompressFrame(DicomElement dicomElement, int n2, int[] nArray) {
            byte[] byArray = dicomElement.getFragment(n2);
            byte[] byArray2 = this.decompressFrameAndReinterleave(byArray, nArray, -1);
            return byArray2;
        }

        private byte[] decompressFrameAndReinterleave(byte[] byArray, int[] nArray, int n2) {
            int n3;
            int n4 = nArray.length;
            if (n4 != 3) {
                nArray = (int[])nArray.clone();
                for (int i2 = 0; i2 < nArray.length / 2; ++i2) {
                    n3 = nArray[i2];
                    nArray[i2] = nArray[nArray.length - i2 - 1];
                    nArray[nArray.length - i2 - 1] = n3;
                }
            }
            byte[] byArray2 = new byte[this.bytesPerFrame];
            n3 = 0;
            for (int i3 = 0; i3 < nArray.length; ++i3) {
                int n5 = nArray[i3];
                int n6 = n3 + i3;
                int n7 = 0;
                while (n6 - n3 < this.bytesPerFrame) {
                    int n8;
                    byte by2 = byArray[n5];
                    ++n5;
                    if (by2 >= 0) {
                        n7 = by2 + 1;
                        for (n8 = 0; n8 < n7; ++n8) {
                            byArray2[n6] = byArray[n5++];
                            n6 += nArray.length;
                        }
                        continue;
                    }
                    if (by2 == -128) continue;
                    n7 = -by2 + 1;
                    for (n8 = 0; n8 < n7; ++n8) {
                        byArray2[n6] = byArray[n5];
                        n6 += nArray.length;
                    }
                    ++n5;
                }
            }
            return byArray2;
        }
    }

    static class NonInterleavingRLEDecompressor
    extends DicomRLEDecompressor {
        public NonInterleavingRLEDecompressor(DicomObject dicomObject) {
            super(dicomObject);
        }

        @Override
        byte[] decompressFrame(DicomElement dicomElement, int n2, int[] nArray) {
            int n3 = 0;
            byte[] byArray = dicomElement.getFragment(n2);
            byte[] byArray2 = new byte[this.bytesPerFrame];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                byte[] byArray3 = this.decompressSegmentWithoutReinterleaving(byArray, nArray, i2);
                System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
                n3 += byArray3.length;
            }
            return byArray2;
        }

        private byte[] decompressSegmentWithoutReinterleaving(byte[] byArray, int[] nArray, int n2) {
            byte[] byArray2 = new byte[this.bytesPerFragment];
            int n3 = nArray[n2];
            int n4 = 0;
            int n5 = 0;
            while (n4 < this.bytesPerFragment) {
                byte by2 = byArray[n3];
                ++n3;
                if (by2 >= 0) {
                    n5 = by2 + 1;
                    System.arraycopy(byArray, n3, byArray2, n4, n5);
                    n3 += n5;
                    n4 += n5;
                    continue;
                }
                if (by2 == -128) continue;
                n5 = -by2 + 1;
                Arrays.fill(byArray2, n4, n4 + n5, byArray[n3]);
                ++n3;
                n4 += n5;
            }
            return byArray2;
        }
    }
}

