/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.Point3f;
import com.mimvista.numerics.TypedMatrix;
import com.mimvista.numerics.VoxelPoint3f;
import javax.vecmath.Matrix4f;

public class DicomRegUtils {
    public static TypedMatrix<DicomPoint3f, MetricPoint3f> generate_DICOM_M_METRIC(SimpleImageFrame simpleImageFrame) {
        return DicomRegUtils.generate_DICOM_M_METRIC(simpleImageFrame, simpleImageFrame.getUncopiedMutableInfo().imageOrientation);
    }

    public static TypedMatrix<DicomPoint3f, MetricPoint3f> generate_DICOM_M_METRIC(Point3f.PointVolumeInfo pointVolumeInfo) {
        return DicomRegUtils.generate_DICOM_M_METRIC(pointVolumeInfo, pointVolumeInfo.iop, pointVolumeInfo.dicomCenter);
    }

    public static TypedMatrix<DicomPoint3f, MetricPoint3f> generate_DICOM_M_METRIC(SimpleImageFrame simpleImageFrame, float[] fArray) {
        return DicomRegUtils.generate_DICOM_M_METRIC(simpleImageFrame, fArray, simpleImageFrame.G());
    }

    public static TypedMatrix<DicomPoint3f, MetricPoint3f> generate_DICOM_M_METRIC(SimpleImageFrame simpleImageFrame, float[] fArray, float[] fArray2) {
        return DicomRegUtils.generate_DICOM_M_METRIC(new Point3f.PointVolumeInfo(simpleImageFrame), fArray, fArray2);
    }

    public static TypedMatrix<DicomPoint3f, MetricPoint3f> generate_DICOM_M_METRIC(Point3f.PointVolumeInfo pointVolumeInfo, float[] fArray, float[] fArray2) {
        Float f2 = pointVolumeInfo.appliedGantryDetectorTilt;
        float[] fArray3 = SimpleOrientationHelper.a(fArray, f2);
        float[][] fArrayArray = new float[][]{{fArray[0], fArray[3], -fArray3[0], fArray2[0]}, {fArray[1], fArray[4], -fArray3[1], fArray2[1]}, {fArray[2], fArray[5], -fArray3[2], fArray2[2]}, {0.0f, 0.0f, 0.0f, 1.0f}};
        Matrix4f matrix4f = MatrixMultiplier.a(fArrayArray);
        return new TypedMatrix<DicomPoint3f, MetricPoint3f>(matrix4f);
    }

    public static TypedMatrix<MetricPoint3f, DicomPoint3f> generate_METRIC_M_DICOM(SimpleImageFrame simpleImageFrame) {
        return DicomRegUtils.generate_METRIC_M_DICOM(simpleImageFrame, simpleImageFrame.getUncopiedMutableInfo().imageOrientation);
    }

    public static TypedMatrix<MetricPoint3f, DicomPoint3f> generate_METRIC_M_DICOM(SimpleImageFrame simpleImageFrame, float[] fArray) {
        return DicomRegUtils.generate_METRIC_M_DICOM(simpleImageFrame, fArray, simpleImageFrame.G());
    }

    public static TypedMatrix<MetricPoint3f, DicomPoint3f> generate_METRIC_M_DICOM(SimpleImageFrame simpleImageFrame, float[] fArray, float[] fArray2) {
        Matrix4f matrix4f = DicomRegUtils.generate_DICOM_M_METRIC(simpleImageFrame, fArray, fArray2).b();
        matrix4f.invert();
        return new TypedMatrix<MetricPoint3f, DicomPoint3f>(matrix4f);
    }

    public static TypedMatrix<MetricPoint3f, DicomPoint3f> generate_METRIC_M_DICOM(Point3f.PointVolumeInfo pointVolumeInfo) {
        return DicomRegUtils.generate_METRIC_M_DICOM(pointVolumeInfo, pointVolumeInfo.iop, pointVolumeInfo.dicomCenter);
    }

    public static TypedMatrix<MetricPoint3f, DicomPoint3f> generate_METRIC_M_DICOM(Point3f.PointVolumeInfo pointVolumeInfo, float[] fArray, float[] fArray2) {
        Matrix4f matrix4f = DicomRegUtils.generate_DICOM_M_METRIC(pointVolumeInfo, fArray, fArray2).b();
        matrix4f.invert();
        return new TypedMatrix<MetricPoint3f, DicomPoint3f>(matrix4f);
    }

    public static TypedMatrix<VoxelPoint3f, MetricPoint3f> generate_VOXEL_M_METRIC(Point3f.PointVolumeInfo pointVolumeInfo) {
        float[] fArray = pointVolumeInfo.originOffsetMM;
        float[] fArray2 = pointVolumeInfo.voxel;
        float[][] fArrayArray = new float[][]{{1.0f / fArray2[0], 0.0f, 0.0f, fArray[0] / fArray2[0]}, {0.0f, 1.0f / fArray2[1], 0.0f, fArray[1] / fArray2[1]}, {0.0f, 0.0f, 1.0f / fArray2[2], fArray[2] / fArray2[2]}, {0.0f, 0.0f, 0.0f, 1.0f}};
        return new TypedMatrix<VoxelPoint3f, MetricPoint3f>(MatrixMultiplier.a(fArrayArray));
    }

    public static TypedMatrix<MetricPoint3f, VoxelPoint3f> generate_METRIC_M_VOXEL(Point3f.PointVolumeInfo pointVolumeInfo) {
        float[] fArray = pointVolumeInfo.originOffsetMM;
        float[] fArray2 = pointVolumeInfo.voxel;
        float[][] fArrayArray = new float[][]{{fArray2[0], 0.0f, 0.0f, -fArray[0]}, {0.0f, fArray2[1], 0.0f, -fArray[1]}, {0.0f, 0.0f, fArray2[2], -fArray[2]}, {0.0f, 0.0f, 0.0f, 1.0f}};
        return new TypedMatrix<MetricPoint3f, VoxelPoint3f>(MatrixMultiplier.a(fArrayArray));
    }
}

