/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mimvista.dicom.DicomSeries;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.JsonPathUtil;
import com.mimvista.dicom.util.Operator;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.dicom.util.VRUtils;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.BooleanCondition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dcm4che2.data.VR;

public class DicomSeriesEvaluator {
    private final JsonDicomSeries series;

    public DicomSeriesEvaluator(DicomSeries dicomSeries) {
        this.series = JsonDicomSeries.castOrConvert(dicomSeries);
    }

    public <T extends Comparable> boolean evaluate(TagPath tagPath, final Operator operator, String string) {
        if (tagPath.isEmpty()) {
            throw new IllegalArgumentException();
        }
        VR vR = TagUtils.vrOfTag(tagPath.getTag(tagPath.size() - 1));
        final VRUtils.VrValueParserForJsonDicomSeries<? extends Comparable> vrValueParserForJsonDicomSeries = VRUtils.getValueParser(vR);
        Object object = this.series.getTagValues(tagPath.toJsonPath());
        if (object.isEmpty()) {
            object = Collections.singletonList(null);
        }
        BooleanCondition booleanCondition = operator.isNegativeOperator() ? BooleanCondition.b : BooleanCondition.c;
        final Comparable comparable = vrValueParserForJsonDicomSeries.parseUserInputValue(string);
        Function<Object, Boolean> function = new Function<Object, Boolean>(){

            public Boolean apply(Object object) {
                return operator.evaluate(vrValueParserForJsonDicomSeries.parseJsonDicomValue(object), comparable, vrValueParserForJsonDicomSeries.getParseType());
            }
        };
        return FuncUtils.a(object, booleanCondition, function);
    }

    public Collection<Comparable> getParsedDicomValues(TagPath tagPath) {
        if (tagPath.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (MetabaseKeys.isMIMFakeDicomTag(tagPath.getTag(0))) {
            ImmutableList immutableList = this.series.getTagValues(JsonPathUtil.normalize(MetabaseKeys.getMIMFakeDicomTagMetabaseKey(tagPath.getTag(0))));
            ArrayList arrayList = Lists.newArrayList();
            for (Object e2 : immutableList) {
                arrayList.add(VRUtils.parseJsonDicomValue(tagPath.getTag(0), e2));
            }
            return arrayList;
        }
        VR vR = TagUtils.vrOfTag(tagPath.getTag(tagPath.size() - 1));
        VRUtils.VrValueParserForJsonDicomSeries<? extends Comparable> vrValueParserForJsonDicomSeries = VRUtils.getValueParser(vR);
        ImmutableList immutableList = this.series.getTagValues(tagPath.toJsonPath());
        ArrayList arrayList = Lists.newArrayList();
        for (Object e3 : immutableList) {
            arrayList.add(vrValueParserForJsonDicomSeries.parseJsonDicomValue(e3));
        }
        return arrayList;
    }

    public Object getParsedDicomValue(TagPath tagPath) {
        if (tagPath.isEmpty()) {
            throw new IllegalArgumentException();
        }
        if (MetabaseKeys.isMIMFakeDicomTag(tagPath.getTag(0))) {
            Object t2 = this.series.getTagValue(JsonPathUtil.normalize(MetabaseKeys.getMIMFakeDicomTagMetabaseKey(tagPath.getTag(0))));
            return VRUtils.parseJsonDicomValue(tagPath.getTag(0), t2);
        }
        VR vR = TagUtils.vrOfTag(tagPath.getTag(tagPath.size() - 1));
        VRUtils.VrValueParserForJsonDicomSeries<? extends Comparable> vrValueParserForJsonDicomSeries = VRUtils.getValueParser(vR);
        Object t3 = this.series.getTagValue(tagPath.toJsonPath());
        return vrValueParserForJsonDicomSeries.parseJsonDicomValue(t3);
    }

    public boolean evaluate(TagPath tagPath, Operator operator, List<String> list) {
        for (String string : list) {
            if (!this.evaluate(tagPath, operator, string)) continue;
            return true;
        }
        return false;
    }
}

