/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.dicom.read.DicomReader;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.g;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputStream;

public class EncapsulateDocDicomInputStream
extends DicomInputStream {
    private String fileName;
    private g progress;
    private boolean cancelled;
    private String targetFileName;
    private String resultFileName;

    public EncapsulateDocDicomInputStream(String string, String string2, g g2) throws IOException {
        super(new File(string));
        this.progress = g2;
        this.targetFileName = string2;
        this.fileName = string;
        this.attrs = new BasicDicomObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readValue(DicomInputStream dicomInputStream) throws IOException {
        if (this.cancelled) {
            return false;
        }
        if (dicomInputStream != this) {
            throw new IllegalArgumentException("dis != this");
        }
        switch (this.tag) {
            case -73728: {
                this.readItemValue();
                break;
            }
            case -73715: {
                if (this.vallen <= 0) break;
                ay.c((Object)("Item Delimitation Item (FFFE,E00D) with non-zero Item Length:" + this.vallen + " at pos: " + this.tagpos + " - try to skip length"), (Object)this);
                int n2 = this.vallen;
                while (n2 > 0) {
                    long l2 = this.skip(n2);
                    if (l2 < 0L) {
                        throw new EOFException("Premature end of stream.");
                    }
                    n2 = (int)((long)n2 - l2);
                }
                break;
            }
            case -73507: {
                if (this.vallen <= 0) break;
                ay.c((Object)("Sequence Delimitation Item (FFFE,E0DD) with non-zero Item Length:" + this.vallen + " at pos: " + this.tagpos + " - try to skip length"), (Object)this);
                int n3 = this.vallen;
                while (n3 > 0) {
                    long l3 = this.skip(n3);
                    if (l3 < 0L) {
                        throw new EOFException("Premature end of stream.");
                    }
                    n3 = (int)((long)n3 - l3);
                }
                break;
            }
            default: {
                if (this.vallen == -1 || this.vr == VR.SQ) {
                    DicomElement dicomElement;
                    DicomElement dicomElement2 = dicomElement = this.vr == VR.SQ ? this.attrs.putSequence(this.tag) : this.attrs.putFragments(this.tag, this.vr, this.ts.bigEndian());
                    if (this.sqStack == null) {
                        this.sqStack = new ArrayList();
                    }
                    this.sqStack.add(dicomElement);
                    try {
                        this.parse(this.vallen, -73507);
                        break;
                    }
                    finally {
                        this.sqStack.remove(this.sqStack.size() - 1);
                    }
                }
                if (this.tag == 4325393) {
                    this.readEncapsulatedData();
                    if (!this.cancelled) break;
                    return false;
                }
                DicomElement dicomElement = this.attrs.putBytes(this.tag, this.vr, this.readBytes(this.vallen), this.ts.bigEndian());
                if (this.tag != 131072) break;
                this.fmiEndPos = this.pos + (long)dicomElement.getInt(false);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readEncapsulatedData() {
        if (this.progress != null) {
            this.progress.a(this.fileName);
            this.progress.a(this.vallen);
            this.progress.b(0);
        }
        FilterOutputStream filterOutputStream = null;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(new File(this.targetFileName)));
            byte[] byArray = new byte[1024];
            int n2 = 0;
            int n3 = this.vallen;
            while (n2 < n3) {
                int n4;
                int n5 = 1024;
                if (n5 > n3 - n2) {
                    n5 = n3 - n2;
                }
                if ((n4 = this.read(byArray, 0, n5)) < 0) {
                    throw new EOFException();
                }
                n2 += n4;
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n4);
                if (this.progress != null) {
                    this.progress.c(n4);
                }
                if (this.progress == null || this.progress.n() != Progress.Status.e) continue;
                this.cancelled = true;
                return;
            }
            this.resultFileName = this.targetFileName;
            if (this.progress != null) {
                this.progress.b();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public String getTargetFileName() {
        return this.resultFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<String, File> restore(String string, String string2, g g2) {
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(new File(string), 4325393, false);
        if (dicomObject == null) {
            return null;
        }
        String string3 = string2 + File.separatorChar + dicomObject.getString(4325392);
        EncapsulateDocDicomInputStream encapsulateDocDicomInputStream = null;
        try {
            encapsulateDocDicomInputStream = new EncapsulateDocDicomInputStream(string, string3, g2);
            encapsulateDocDicomInputStream.parse(-1, -73715);
            Pair<String, File> pair = Pair.get(dicomObject.getString(4325394), new File(encapsulateDocDicomInputStream.getTargetFileName()));
            return pair;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            Pair<String, File> pair = null;
            return pair;
        }
        finally {
            if (encapsulateDocDicomInputStream != null) {
                try {
                    encapsulateDocDicomInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

