/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.SendToDestinationUIFactory;
import com.mimvista.archive.gui.SeriesFilesTransfer;
import com.mimvista.archive.gui.ag;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.util.EncapsulateDocumentHandler;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.k;
import com.mimvista.gui.util.l;
import com.mimvista.mui.AttachmentsPanel;
import com.mimvista.mui.ak;
import com.mimvista.properties.ab;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.o;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.dcm4che2.util.DateUtils;

public class EncapsulateDocumentFrame {
    public static Messages props = Messages.a("Dicom");
    private static File lastVisitedFolder = new File(ab.m());
    private JLabel patientNameLabel;
    private JLabel patientIdLabel;
    private JLabel modalityLabel;
    private JLabel dateLabel;
    private JLabel studyDescLabel;
    private JLabel seriesDescLabel;
    private l<SendToDestination> destInput;
    private JComboBox destCombo;
    private TreeMap<Integer, String> tagsMap;
    private DcmSeries series;
    private EncapsulateDocumentHandler encapsulateDocumentHandler;
    private InputNotification inputNot = new InputNotification(new Notification.a(), props.getProperty("ENCAPSULATE_FRAME_CREATE"), "modify_data");
    private l<String> seriesDescInput;
    private Runnable onFinish = null;
    private AttachmentsPanel panel = new AttachmentsPanel(this.inputNot){
        private static final long serialVersionUID = 7766317602200370584L;

        @Override
        public File getLastVisitedFolder() {
            return lastVisitedFolder;
        }

        @Override
        public void setLastVisitedFolder(File file) {
            lastVisitedFolder = file;
        }
    };
    private static String patientName = props.getProperty("PATIENT_NAME");
    private static String patientID = props.getProperty("PATIENT_ID");
    private static String modality = props.getProperty("MODALITY");
    private static String date = props.getProperty("DATE");
    private static String studyDesc = props.getProperty("STUDY_DESC");
    private static String seriesDesc = props.getProperty("SERIES_DESC");

    public EncapsulateDocumentFrame(TreeMap<Integer, String> treeMap, DcmSeries dcmSeries, ArrayList<File> arrayList, String string, String string2) {
        this.tagsMap = treeMap;
        this.series = dcmSeries;
        this.encapsulateDocumentHandler = new EncapsulateDocumentHandler(treeMap, new o());
        if (arrayList != null) {
            this.panel.addAttachments(arrayList);
        }
        if (string != null) {
            this.inputNot = new InputNotification(new Notification.a(), string, "modify_data");
        }
        if (string2 != null) {
            this.inputNot.addLabel(string2);
        }
        this.buildGui();
        this.initializeValues();
    }

    public void showGui() {
        if (!this.inputNot.containedInGrandNotifier()) {
            this.inputNot.addToGrandNotifier();
        } else {
            this.inputNot.selectMe();
        }
    }

    private void buildGui() {
        this.inputNot.addLabel(props.getProperty("ENCAPSULATE_FRAME_SOURCE_INFO"));
        this.patientNameLabel = this.inputNot.addCollection(patientName, null, 0).b("");
        this.patientIdLabel = this.inputNot.addCollection(patientID, null, 0).b("");
        this.modalityLabel = this.inputNot.addCollection(modality, null, 0).b("");
        this.dateLabel = this.inputNot.addCollection(date, null, 0).b("");
        this.studyDescLabel = this.inputNot.addCollection(studyDesc, null, 0).b("");
        this.seriesDescLabel = this.inputNot.addCollection(seriesDesc, null, 0).b("");
        List<SendToDestination> list = ag.a(ag.a(true, true, true, true));
        SendToDestination[] sendToDestinationArray = new SendToDestination[list.size()];
        list.toArray(sendToDestinationArray);
        this.destInput = this.inputNot.addComboBox(props.getProperty("ENCAPSULATE_FRAME_DESTINATION"), sendToDestinationArray);
        this.destCombo = (JComboBox)this.destInput.g();
        this.destCombo.setRenderer(new SendToDestinationUIFactory.SourceOrDestListCellRenderer());
        this.inputNot.addComponent(props.getProperty("ENCAPSULATE_DOC_FILES"), this.panel);
        this.inputNot.addInputDialogValidator(new k(){

            @Override
            public String validate(Object object) {
                if (EncapsulateDocumentFrame.this.panel.getAttachments().size() == 0) {
                    return props.getProperty("ENCAPSULATE_DOC_ATTACH");
                }
                return null;
            }
        });
        this.seriesDescInput = this.inputNot.addTextField(props.getProperty("SERIES_DESC"));
        this.inputNot.setShowReset(false);
        this.inputNot.setOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    @Override
                    public void run() {
                        EncapsulateDocumentFrame.this.createDicom();
                    }
                }.start();
            }
        });
    }

    private void createDicom() {
        this.encapsulateDocumentHandler.setSeriesDescription(this.seriesDescInput.b().trim());
        this.encapsulateDocumentHandler.setStudyDescription(this.null2Blank(this.tagsMap.get(528432)));
        ArrayList<File> arrayList = this.panel.getAttachments();
        SendToDestination sendToDestination = (SendToDestination)this.destCombo.getSelectedItem();
        EncapsulateDocumentFrame.encapsulate(this.encapsulateDocumentHandler, arrayList, this.series.getSearchSource(), sendToDestination);
        if (this.onFinish != null) {
            this.onFinish.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void encapsulate(EncapsulateDocumentHandler encapsulateDocumentHandler, List<File> list, SearchSource searchSource, SendToDestination sendToDestination) {
        MIMFile mIMFile = null;
        try {
            encapsulateDocumentHandler.setFiles(list);
            mIMFile = PathUtils.getTempPathUnique("encapsulateDoc");
            File file = new File(mIMFile, encapsulateDocumentHandler.getModality() + "_0001.dcm");
            if (encapsulateDocumentHandler.write(file.getAbsolutePath())) {
                new SeriesFilesTransfer(searchSource, file.getParent()).a(sendToDestination);
            }
        }
        catch (IOException iOException) {
            ay.d((Object)iOException, EncapsulateDocumentFrame.class);
            JOptionPane.showMessageDialog(ak.b().M(), Messages.a("Archive").getProperty("ENCAPSULATE_DOC_ACT_OP_FAIL"), "", 2);
        }
        finally {
            if (mIMFile != null) {
                mIMFile.delete();
            }
        }
    }

    private void initializeValues() {
        this.patientNameLabel.setText(this.null2Blank(this.tagsMap.get(0x100010)));
        this.patientIdLabel.setText(this.null2Blank(this.tagsMap.get(0x100020)));
        this.modalityLabel.setText(this.null2Blank(this.tagsMap.get(524384)));
        this.dateLabel.setText(this.getFullDate());
        this.studyDescLabel.setText(this.null2Blank(this.tagsMap.get(528432)));
        this.seriesDescLabel.setText(this.null2Blank(this.tagsMap.get(528446)));
        this.setDestination();
        this.seriesDescInput.a(this.null2Blank(this.tagsMap.get(528446)));
    }

    private void setDestination() {
        List<SendToDestination> list;
        SendToDestination sendToDestination = ag.a(this.series.getSearchSource());
        if (sendToDestination == null && (list = ag.a(ag.a(true, true, false, true))).size() > 0) {
            sendToDestination = list.get(0);
        }
        if (sendToDestination != null) {
            this.destInput.a(sendToDestination);
            this.destInput.b(sendToDestination);
        }
    }

    private String getFullDate() {
        Date date;
        String string = "";
        Date date2 = DateUtils.parseDA((String)this.tagsMap.get(524320), (boolean)false);
        if (date2 != null) {
            string = string + new SimpleDateFormat("MM-dd-yyyy").format(date2);
        }
        if ((date = DateUtils.parseTM((String)this.tagsMap.get(524336), (boolean)false)) != null) {
            string = string + " " + new SimpleDateFormat("HH:mm:ss").format(date);
        }
        return string;
    }

    private String null2Blank(String string) {
        return string == null ? "" : string;
    }

    public void setOnFinish(Runnable runnable) {
        this.onFinish = runnable;
    }

    public void setDestination(SendToDestination sendToDestination) {
        this.destInput.a(sendToDestination);
        this.destInput.b(sendToDestination);
    }

    public SendToDestination getDestination() {
        return this.destInput.b();
    }
}

