/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.collect.Lists;
import com.mimvista.cloud.CloudUtil;
import com.mimvista.cloud.shared.common.mim.EncapsulatedFileManifest;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.util.EncapsulateHandler;
import com.mimvista.dicom.util.MIMEType;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cm;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.o;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;

public class EncapsulateDocumentHandler
extends EncapsulateHandler {
    public static Messages props = Messages.a("Dicom");
    private static final int MAX_LT_STORAGE = 10240;
    public static final int[] EncapsulatedDocFilter = new int[]{0x100010, 0x100020, 0x100030, 0x100040, 1179747, 0x20000D, 524320, 524336, 524432, 0x200010, 524368, 524416, 524417, 0x200011, 524293};
    private File containerFile;
    private List<? extends File> attachedFiles = new ArrayList<File>();
    private List<SimpleImageFrame> referencesVolumes = Lists.newArrayList();
    private TreeMap<Integer, String> tagsMap;
    public static final String WHITELISTED_EXTENSIONS_PREFKEY = "ENC DOC EXT WHITELIST";
    public static final String ENC_DOC_SAVE_FOLDER_PREFKEY = "ENC DOC SAVE FOLDER";
    public static final List<String> DEFAULT_WHITELISTED_EXTENSIONS = Lists.newArrayList((Object[])new String[]{"zip", "txt", "pdf", "rtf", "doc", "xls", "ppt", "docx", "xlsx", "pptx", "odt", "ods", "odp", "numbers", "pages", "key", "png", "bmp", "jpg", "jpeg", "gif", "tiff"});

    public EncapsulateDocumentHandler(TreeMap<Integer, String> treeMap, Progress progress) {
        this.tagsMap = treeMap;
        this.progress = progress;
        this.loadOtherAttributes();
        this.setModality(Modality.DOC.get());
    }

    public void addReferences(Collection<? extends SimpleImageFrame> collection) {
        this.referencesVolumes.addAll(collection);
    }

    public void setAttachedFileInfo(File file, List<? extends File> list) {
        this.containerFile = file;
        this.attachedFiles = list;
    }

    public File writeToTemporary() throws IOException {
        String string = PathUtils.getTempPath();
        MIMFile mIMFile = new MIMFile(string, this.tagsMap.get(0x100020));
        mIMFile.mkdirs();
        MIMFile mIMFile2 = new MIMFile(mIMFile, this.getModality() + "_0001.dcm");
        if (!this.write(mIMFile2.getAbsolutePath())) {
            new MIMFile(string).delete();
            return null;
        }
        return mIMFile2;
    }

    @Override
    public boolean write(String string) throws IOException {
        this.generateMultiframeTemplate();
        this.generateMetaInfoTemplate();
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        DicomOutputStream dicomOutputStream = null;
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        if (this.progress != null) {
            this.progress = new o();
        }
        try {
            fileOutputStream = new FileOutputStream(string);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            dicomOutputStream = new DicomOutputStream((OutputStream)bufferedOutputStream);
            dicomOutputStream.writeFileMetaInformation(this.resultDicomObj);
            dicomOutputStream.writeDataset(this.resultDicomObj.subSet(524293, 4325393), "1.2.840.10008.1.2.1");
            fileInputStream = new FileInputStream(this.containerFile);
            bufferedInputStream = new BufferedInputStream(fileInputStream);
            int n2 = bufferedInputStream.available() + 1 & 0xFFFFFFFE;
            dicomOutputStream.writeHeader(4325393, VR.OB, n2);
            byte[] byArray = new byte[1024];
            int n3 = 0;
            int n4 = 0;
            if (this.progress != null) {
                this.progress.a(n2);
                this.progress.b(0);
            }
            while ((n4 = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                dicomOutputStream.write(byArray, 0, n4);
                n3 = n4;
                if (n4 > 0 && this.progress != null) {
                    this.progress.c(n4);
                }
                if (this.progress == null || this.progress.n() != Progress.Status.e) continue;
                boolean bl2 = false;
                return bl2;
            }
            if (n3 % 2 != 0) {
                dicomOutputStream.write(0);
            }
            dicomOutputStream.writeDataset(this.resultDicomObj.subSet(4325393, -1), "1.2.840.10008.1.2.1");
            if (this.progress != null) {
                this.progress.b();
            }
            boolean bl3 = true;
            return bl3;
        }
        catch (IOException iOException) {
            ay.d((Object)iOException, this);
            if (this.progress != null) {
                this.progress.b();
            }
            throw iOException;
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (dicomOutputStream != null) {
                    dicomOutputStream.close();
                }
                if (bufferedOutputStream != null) {
                    bufferedOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {
                ay.d((Object)iOException, this);
            }
        }
    }

    public String getSeriesInstanceUID() {
        return this.resultDicomObj.getString(0x20000E);
    }

    public String getSOPInstanceUID() {
        return this.resultDicomObj.getString(524312);
    }

    public static String getModality(String string) {
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(new File(string), 524385);
        String string2 = dicomObject.getString(524384);
        return string2;
    }

    protected void generateMultiframeTemplate() {
        this.rawDicomUtils.addSpecificCharacterSet(this.resultDicomObj);
        if (this.isImageSeries() && this.tagsMap.get(0x20000E) != null) {
            this.resultDicomObj.putString(1245186, VR.UI, this.tagsMap.get(0x20000E));
        }
        this.resultDicomObj.putString(930283552, VR.LO, "");
        Date date = new Date();
        if (cn.h(this.rawDicomUtils.getSeriesDescription())) {
            this.setSeriesDescription("MIM Software Encapsulated File");
        }
        this.setStudyDescription(this.tagsMap.get(528432));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss");
        this.resultDicomObj.putString(524337, VR.TM, simpleDateFormat.format(date));
        this.resultDicomObj.putString(524320, VR.DA, this.tagsMap.get(524320));
        this.resultDicomObj.putString(524321, VR.DT, DateUtils.b(date));
        this.resultDicomObj.putString(528496, VR.PN, this.tagsMap.get(528496));
        this.rawDicomUtils.addConceptNameCodeSequence(this.resultDicomObj);
        this.tagsMap.put(524293, this.resultDicomObj.getString(524293));
        this.loadFromMap(this.tagsMap, EncapsulatedDocFilter);
        this.rawDicomUtils.addSeriesDescription(this.resultDicomObj);
        this.rawDicomUtils.addStudyDescription(this.resultDicomObj);
        this.rawDicomUtils.addModality(this.resultDicomObj);
        RawDicomUtils.addSopClassUid(this.resultDicomObj, "1.2.840.10008.5.1.4.1.1.104.1");
        this.rawDicomUtils.addCfg(this.resultDicomObj);
        RawDicomUtils.addSeriesInstanceUid(this.resultDicomObj, UIDGenerator.generateUID());
        this.rawDicomUtils.addBurnedInAnnotation(this.resultDicomObj);
        this.rawDicomUtils.addConversionType(this.resultDicomObj);
        RawDicomUtils.addInstanceCreationDate(this.resultDicomObj, date);
        RawDicomUtils.addInstanceCreationTime(this.resultDicomObj, date);
        this.rawDicomUtils.addInstanceNumber(this.resultDicomObj);
        this.rawDicomUtils.addManufacturer(this.resultDicomObj);
        RawDicomUtils.addSopInstanceUid(this.resultDicomObj, UIDGenerator.generateUID());
        RawDicomUtils.addReferencedSeries(this.resultDicomObj, this.referencesVolumes);
        EncapsulatedFileManifest encapsulatedFileManifest = this.getManifest(this.containerFile, this.attachedFiles);
        RawDicomUtils.addContentDate(this.resultDicomObj, encapsulatedFileManifest.a().c());
        RawDicomUtils.addContentTime(this.resultDicomObj, encapsulatedFileManifest.a().c());
        this.rawDicomUtils.addAcquisitionDateTime(this.resultDicomObj, encapsulatedFileManifest.a().c());
        this.rawDicomUtils.addDocumentTitle(this.resultDicomObj, encapsulatedFileManifest.a().b());
        this.rawDicomUtils.addMimeType(this.resultDicomObj, encapsulatedFileManifest.a().d());
        String string = CloudUtil.b().toJson((Object)encapsulatedFileManifest, EncapsulatedFileManifest.class);
        if (string.length() <= 10240) {
            this.resultDicomObj.putString(930283553, VR.LT, string);
        }
    }

    private boolean isImageSeries() {
        String string = this.tagsMap.get(524384);
        if (string == null) {
            return false;
        }
        return Modality.isSameModality(string, Modality.CT, Modality.PT, Modality.MR, Modality.NM, Modality.US, Modality.XA);
    }

    private void loadOtherAttributes() {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        String string = this.tagsMap.get(524310) == null ? "" : this.tagsMap.get(524310);
        basicDicomObject.putString(524310, basicDicomObject.vrOf(524310), string);
        String string2 = this.tagsMap.get(524312) == null ? "" : this.tagsMap.get(524312);
        basicDicomObject.putString(524312, basicDicomObject.vrOf(524312), string2);
        this.resultDicomObj.putNestedDicomObject(4325395, (DicomObject)basicDicomObject);
    }

    public void setFiles(List<? extends File> list) throws IOException {
        if (list.size() == 1) {
            this.setAttachedFileInfo(list.get(0), list);
        } else {
            File file = this.zipFiles(list);
            if (file != null) {
                this.setAttachedFileInfo(file, list);
            } else {
                throw new IOException(props.getProperty("ENCAPSULATE_DOC_ZIP_FAIL"));
            }
        }
    }

    private EncapsulatedFileManifest getManifest(File file, List<? extends File> list) {
        EncapsulatedFileManifest encapsulatedFileManifest = new EncapsulatedFileManifest();
        encapsulatedFileManifest.a(this.getFileInfo(file));
        for (File file2 : list) {
            encapsulatedFileManifest.b().add(this.getFileInfo(file2));
        }
        return encapsulatedFileManifest;
    }

    private EncapsulatedFileManifest.EncapsulatedFileInfo getFileInfo(File file) {
        if (file == null) {
            return null;
        }
        EncapsulatedFileManifest.EncapsulatedFileInfo encapsulatedFileInfo = new EncapsulatedFileManifest.EncapsulatedFileInfo();
        encapsulatedFileInfo.a(file.getName());
        encapsulatedFileInfo.a(new Date(file.lastModified()));
        encapsulatedFileInfo.b(EncapsulateDocumentHandler.getMIMEType(file.getName()));
        encapsulatedFileInfo.a(file.length());
        return encapsulatedFileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File zipFiles(List<? extends File> list) {
        File file = new File(PathUtils.getTempPath(), "EncapsulateDocFrame.zip");
        if (file.exists()) {
            file.delete();
        }
        ZipOutputStream zipOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            for (File file2 : list) {
                ZipEntry iOException = new ZipEntry(file2.getName());
                zipOutputStream.putNextEntry(iOException);
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
                byte[] byArray = new byte[1024];
                while (bufferedInputStream.read(byArray) != -1) {
                    zipOutputStream.write(byArray);
                }
                bufferedInputStream.close();
                zipOutputStream.closeEntry();
            }
            File file3 = file;
            return file3;
        }
        catch (IOException iOException) {
            ay.d((Object)iOException, this);
            File file2 = null;
            return file2;
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    ay.d((Object)iOException, this);
                }
            }
            if (zipOutputStream != null) {
                try {
                    zipOutputStream.close();
                }
                catch (IOException iOException) {
                    ay.d((Object)iOException, this);
                }
            }
        }
    }

    public static File restore(DicomObject dicomObject) {
        if (dicomObject == null) {
            return null;
        }
        byte[] byArray = dicomObject.getBytes(4325393);
        File file = DicomPrefs.getEncapsulatedDocSaveFolderFromPrefs();
        if (file == null || !file.exists()) {
            file = PathUtils.getTempPathUnique("encapsdoc");
        }
        Integer[] integerArray = new Integer[]{4325392, 528446, 0x100010};
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Integer n2 : integerArray) {
            arrayList.add(dicomObject.getString(n2.intValue()));
        }
        arrayList.add("Report");
        for (String string : arrayList) {
            File file2;
            if (cn.g(string) || !EncapsulateDocumentHandler.writeEncapsulatedDataToTempFile(byArray, file2 = new File(file, PathUtils.safeFilename(string)))) continue;
            return file2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeEncapsulatedDataToTempFile(byte[] byArray, File file) {
        boolean bl2;
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            bufferedOutputStream.write(byArray);
            bl2 = true;
        }
        catch (IOException iOException) {
            boolean bl3;
            try {
                ay.d((Object)("Can't write to temp file " + file), EncapsulateDocumentHandler.class);
                bl3 = false;
            }
            catch (Throwable throwable) {
                cm.a(bufferedOutputStream);
                throw throwable;
            }
            cm.a((Closeable)bufferedOutputStream);
            return bl3;
        }
        cm.a((Closeable)bufferedOutputStream);
        return bl2;
    }

    public static String getMIMEType(String string) {
        String string2 = URLConnection.guessContentTypeFromName(string);
        if (string2 == null) {
            String string3 = "";
            if (string.contains(".")) {
                string3 = string.substring(string.lastIndexOf(".") + 1);
            }
            string2 = MIMEType.getType(string3);
        }
        return string2;
    }

    public static File restore(File file) {
        return EncapsulateDocumentHandler.restore(EncapsulateDocumentHandler.extract(file));
    }

    private static DicomObject extract(File file) {
        DicomObject dicomObject = null;
        if (file.isFile()) {
            dicomObject = DicomReader.readFileIntoDicomObject(file);
        } else if (file.isDirectory()) {
            dicomObject = DicomReader.getFirstDicomObjectFromSeriesFolder(file.getAbsolutePath());
        }
        return dicomObject;
    }

    public static boolean isSafeToOpen(String string) {
        String[] stringArray;
        if (string == null || string.indexOf(46) < 0) {
            return false;
        }
        String string2 = string.substring(string.lastIndexOf(46) + 1).toLowerCase();
        if (string2.isEmpty()) {
            return false;
        }
        for (String string3 : stringArray = DicomPrefs.encDocExtWhitelist.getValue()) {
            if (!string2.equalsIgnoreCase(string3) && !("." + string2).equalsIgnoreCase(string3)) continue;
            return true;
        }
        return false;
    }
}

