/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.read.SimpleDicomVolumeLoader;
import com.mimvista.dicom.read.SimpleDicomVolumeLoaderFactory;
import com.mimvista.util.ay;
import com.mimvista.util.progress.o;
import java.io.File;

public class FancyArchiveCacheCreator {
    public static Runnable createRunnable(File file) {
        return new CacheCreatorRunnable(file);
    }

    public static boolean generateCacheForFolder(File file) {
        if (new File(file, "mimfancycache.mim").exists()) {
            new File(file, "mimfancycache.mim").delete();
        }
        try {
            LoaderDataProvider.FileBasedLoaderDataProvider fileBasedLoaderDataProvider = new LoaderDataProvider.FileBasedLoaderDataProvider(file.listFiles());
            SimpleDicomVolumeLoader simpleDicomVolumeLoader = SimpleDicomVolumeLoaderFactory.getDefaultDicomVolumeLoader();
            simpleDicomVolumeLoader.setDataProvider(fileBasedLoaderDataProvider);
            simpleDicomVolumeLoader.setCacheOnly(true);
            simpleDicomVolumeLoader.setMemoryFriendlyLoading(true);
            simpleDicomVolumeLoader.load(new o());
            if (new File(file, "mimfancycache.mim").exists()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            ay.c((Object)("Couldn't make cache file for " + file), throwable, FancyArchiveCacheCreator.class);
        }
        return false;
    }

    public static void main(String[] stringArray) {
        File file = new File("/Library/Application Support/MIM/DATA/ARCHIVE/2010-06__Studies/RT-4D^WHOLEBODY_100624-705=L13_CT_2010-06-14_93116_(no.tag).PET.CT.BREAST_(M-ACQ,.DYN).CTAC_n363__078F1");
        new File(file, "mimfancycache.mim").delete();
        if (FancyArchiveCacheCreator.generateCacheForFolder(file)) {
            System.out.println("w00t");
        } else {
            System.out.println("ouch");
        }
        new File(file, "mimfancycache.mim").deleteOnExit();
        System.exit(0);
    }

    public static class CacheCreatorRunnable
    implements Runnable {
        private File seriesFolder;

        public CacheCreatorRunnable(File file) {
            this.seriesFolder = file;
        }

        @Override
        public void run() {
            FancyArchiveCacheCreator.generateCacheForFolder(this.seriesFolder);
        }
    }
}

