/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.search.FolderSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.automator.database.b;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.util.RawDataHandler;
import com.mimvista.dicom.util.secondarycapture.CaptureImageWriter;
import com.mimvista.dicom.util.secondarycapture.DefaultCaptureImageWriter;
import com.mimvista.dicom.util.secondarycapture.SecondaryCaptureImageHandler;
import com.mimvista.dicom.write.rtst.DicomRtStructCreator;
import com.mimvista.file.PathUtils;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.o;
import com.mimvista.mui.Session;
import com.mimvista.mui.captures.Capture;
import com.mimvista.mui.captures.CaptureStorage;
import com.mimvista.mui.findings.Finding;
import com.mimvista.mui.findings.FindingElement;
import com.mimvista.mui.findings.OverlayFindingElement;
import com.mimvista.mui.overlays.ac;
import com.mimvista.mui.radialmenu.DICOMCaptureAssociation;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.b.i;
import com.mimvista.util.cm;
import com.mimvista.util.cs;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.ProgressPanel;
import com.mimvista.util.progress.g;
import com.mimvista.util.progress.t;
import com.mimvista.viewer.SeriesInfo;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FindingsOverlayBundler {
    private final Set<ViewController> vcWithOverlay = Sets.newHashSet();
    private SeriesInfo findingsInfo;
    private SendToDestination destination;
    private g progress = new ProgressPanel();
    private boolean bundleSources;

    public FindingsOverlayBundler(List<Finding> list) {
        this(list, false);
    }

    public FindingsOverlayBundler(List<Finding> list, boolean bl2) {
        this.fillVolumeToOverlayMapWith(list);
        this.bundleSources = bl2;
    }

    public void setProgress(g g2) {
        this.progress = g2;
    }

    public String getDefaultSeriesDescription() {
        String string = "";
        List<String> list = this.getDates();
        if (list != null && list.size() > 1) {
            String string2 = list.get(0);
            String string3 = list.get(list.size() - 1);
            string = "(" + string2 + ")-(" + string3 + ")";
        } else {
            List<String> list2;
            List<String> list3;
            if (list != null && !list.isEmpty()) {
                string = list.get(0) + " ";
            }
            if ((list3 = this.getModalities()) != null && list3.size() == 2) {
                string = string + list3.get(0) + "-" + list3.get(1);
            } else if (list3 != null && list3.size() < 2 && (list2 = this.getTimes()) != null && list2.size() > 1) {
                String string4 = list2.get(0);
                String string5 = list2.get(list2.size() - 1);
                string = string + "(" + string4 + ")-(" + string5 + ")";
            }
        }
        return Messages.a("Findings", "FINDINGS_SIDEBAR_TITLE") + " " + string;
    }

    public List<String> getModalities() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (ViewController viewController : this.vcWithOverlay) {
            treeSet.add(viewController.getModality());
        }
        return Lists.newArrayList(treeSet);
    }

    public List<String> getDates() {
        List<Date> list = this.getChronologies();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Date date : list) {
            treeSet.add(DateUtils.a().format(date));
        }
        return Lists.newArrayList(treeSet);
    }

    public List<String> getTimes() {
        List<Date> list = this.getChronologies();
        TreeSet<String> treeSet = new TreeSet<String>();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        for (Date date : list) {
            treeSet.add(simpleDateFormat.format(date));
        }
        return Lists.newArrayList(treeSet);
    }

    public List<Date> getChronologies() {
        TreeSet<Date> treeSet = new TreeSet<Date>();
        for (ViewController viewController : this.vcWithOverlay) {
            treeSet.add(viewController.getUncopiedMutableInfo().j());
        }
        return Lists.newArrayList(treeSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(SendToDestination sendToDestination, SeriesInfo seriesInfo, boolean bl2) throws Exception {
        if (this.vcWithOverlay.isEmpty()) {
            ay.b((Object)"Skipping Findings save because no Findings are present.", this);
            return;
        }
        if (!this.vcWithOverlay.iterator().next().g().ay()) {
            ay.b((Object)"Skipping Findings save because the Findings have no unsaved changes.", this);
            return;
        }
        this.destination = sendToDestination;
        this.findingsInfo = seriesInfo;
        ProgressQueueNotification.a(this.progress);
        try {
            byte[] byArray = this.createZippedFindings(new t((Progress)this.progress, 0.5f), bl2);
            if (byArray != null) {
                this.encapsulateRtSts(byArray, new t((Progress)this.progress, 0.5f), bl2);
                if (!bl2) {
                    this.setFindingsLastTimeSaved();
                }
            }
        }
        finally {
            this.progress.b();
        }
    }

    private void setFindingsLastTimeSaved() {
        this.vcWithOverlay.stream().flatMap(viewController -> viewController.ba().h().stream()).filter(overlayish -> overlayish.I_()).filter(overlayish -> overlayish instanceof ac).map(overlayish -> (ac)((Object)overlayish)).forEach(ac2 -> ac2.b(System.currentTimeMillis()));
        this.vcWithOverlay.stream().map(viewController -> viewController.g()).distinct().forEach(session -> session.u().i());
    }

    private void fillVolumeToOverlayMapWith(List<Finding> list) {
        for (Finding finding : list) {
            for (FindingElement findingElement : finding) {
                if (findingElement instanceof OverlayFindingElement) {
                    OverlayFindingElement overlayFindingElement = (OverlayFindingElement)findingElement;
                    ViewController viewController = overlayFindingElement.f().au().aT();
                    this.vcWithOverlay.add(viewController);
                    continue;
                }
                ay.c((Object)("Element type " + findingElement.getClass() + " not recognized, skipping ..."), this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createZippedFindings(g g2, boolean bl2) {
        g2.a(this.vcWithOverlay.size() + 1);
        ByteArrayOutputStream byteArrayOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
            this.createAndZipRtsts(new t((Progress)g2, 0.5f), zipOutputStream, bl2);
            this.createAndZipCaptures(new t((Progress)g2, 0.5f), zipOutputStream);
            zipOutputStream.finish();
            zipOutputStream.flush();
        }
        catch (Exception exception) {
            ay.d((Object)"Error zipping RTSTs", (Throwable)exception, this.getClass());
            byte[] byArray = null;
            return byArray;
        }
        finally {
            cm.a((Closeable)byteArrayOutputStream, "Error closing byte stream", this.getClass());
            cm.a((Closeable)zipOutputStream, "Error closing zip stream", this.getClass());
        }
        return byteArrayOutputStream.toByteArray();
    }

    private void createAndZipRtsts(g g2, ZipOutputStream zipOutputStream, boolean bl2) throws IOException {
        int n2 = 0;
        g2.a(this.vcWithOverlay.size());
        for (ViewController viewController : this.vcWithOverlay) {
            if (viewController instanceof ViewController3D) {
                zipOutputStream.putNextEntry(new ZipEntry("RTST" + n2 + ".dcm"));
                DicomRtStructCreator dicomRtStructCreator = new DicomRtStructCreator((ViewController3D)viewController);
                dicomRtStructCreator.setSaveMeasurements(true);
                dicomRtStructCreator.setCanSaveEmptyContours(true);
                dicomRtStructCreator.setUpdateContourSaveTime(!bl2);
                dicomRtStructCreator.setSaveFindingsOnly(true);
                dicomRtStructCreator.writeTo(new cs(zipOutputStream), (Progress)new com.mimvista.util.progress.o());
                zipOutputStream.closeEntry();
                if (this.bundleSources) {
                    zipOutputStream.putNextEntry(new ZipEntry("RTST" + n2 + ".src"));
                    SearchSource searchSource = viewController.bJ();
                    String string = b.a(searchSource);
                    try (cs cs2 = new cs(zipOutputStream);){
                        cs2.write(string.getBytes());
                    }
                    zipOutputStream.closeEntry();
                }
                ++n2;
            }
            g2.N_();
        }
    }

    private void createAndZipCaptures(g g2, ZipOutputStream zipOutputStream) throws IOException {
        CaptureStorage captureStorage;
        if (!this.vcWithOverlay.iterator().hasNext()) {
            return;
        }
        ViewController viewController = this.vcWithOverlay.iterator().next();
        if (viewController != null && (captureStorage = CaptureStorage.a(viewController.g())) != null && captureStorage.iterator().hasNext()) {
            Iterable iterable;
            Object object;
            HashMap hashMap = Maps.newHashMap();
            for (Object object2 : captureStorage) {
                object = this.getVCForCapture((Capture)object2, viewController.g());
                if (object == null) {
                    object = viewController;
                }
                if (hashMap.containsKey(object)) {
                    iterable = (List)hashMap.get(object);
                    iterable.add(((Capture)object2).e());
                    continue;
                }
                iterable = Lists.newArrayList();
                iterable.add(((Capture)object2).e());
                hashMap.put(object, iterable);
            }
            for (Object object2 : hashMap.keySet()) {
                object = (List)hashMap.get(object2);
                iterable = new DefaultCaptureImageWriter(((ViewController)object2).getUncopiedMutableInfo(), (List<BufferedImage>)object);
                SecondaryCaptureImageHandler secondaryCaptureImageHandler = new SecondaryCaptureImageHandler((CaptureImageWriter)iterable, g2);
                secondaryCaptureImageHandler.write(new i(zipOutputStream));
            }
        }
    }

    private ViewController getVCForCapture(Capture capture, Session session) {
        ViewController viewController = null;
        for (DICOMCaptureAssociation dICOMCaptureAssociation : capture.h()) {
            if (!session.e(dICOMCaptureAssociation.a()) || (viewController = session.b(dICOMCaptureAssociation.a())) == null) continue;
            return viewController;
        }
        return null;
    }

    private void encapsulateRtSts(byte[] byArray, Progress progress, boolean bl2) throws IOException {
        RawDataHandler rawDataHandler = new RawDataHandler(this.findingsInfo);
        rawDataHandler.addData(930291776, byArray);
        rawDataHandler.setModality(Modality.FINDINGS.get());
        rawDataHandler.setSeriesDescription(this.findingsInfo.seriesDesc);
        List<ImageFrame> list = this.getAllFramesToReference();
        if (list == null || list.size() <= 0) {
            throw new IOException("No referenced series found for this FINDINGS object.");
        }
        rawDataHandler.addReferencedVolumes(list);
        rawDataHandler.addTypeDesc(RawDataHandler.MIMRawDataType.FINDINGS_BUNDLE);
        rawDataHandler.setSeriesDateTime(new Date());
        String string = PathUtils.getTempPathUnique("findings").getAbsolutePath();
        File file = new File(string, "findings_bundle.dcm");
        rawDataHandler.write(file.getAbsolutePath());
        FolderSearchSource.a(this.destination, file.getParentFile().getAbsolutePath(), true);
    }

    private List<ImageFrame> getAllFramesToReference() {
        HashSet hashSet = Sets.newHashSet();
        for (ViewController viewController : this.vcWithOverlay) {
            if (viewController instanceof ViewController3D) {
                ViewController3D viewController3D = (ViewController3D)viewController;
                o o2 = viewController3D.cE();
                if (o2 == null || o2.l() == null) continue;
                hashSet.addAll(o2.l());
                continue;
            }
            hashSet.add(viewController.aw());
        }
        return Lists.newArrayList((Iterable)hashSet);
    }
}

