/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.collect.Lists;
import com.mimvista.dicom.util.HUEDProfile;
import com.mimvista.numerics.Regression;
import com.mimvista.util.ay;
import java.io.Serializable;
import java.util.List;

public class HUEDConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double[] hus;
    private double[] eds;
    private double threshold;
    private List<double[]> huToEdParams = Lists.newArrayList();
    private String profileName;
    private String profileUID;

    public HUEDConverter(HUEDProfile hUEDProfile) {
        this.getProfileData(hUEDProfile);
        this.segmentalRegression();
    }

    public double getHUThreshold() {
        return this.threshold;
    }

    public float toED(float f2) {
        double[] dArray = this.huToEdParams.get(0);
        double[] dArray2 = this.huToEdParams.get(1);
        double d2 = (double)f2 <= this.threshold ? dArray[0] + dArray[1] * (double)f2 : dArray2[0] + dArray2[1] * (double)f2;
        return (float)d2;
    }

    public float toHU(float f2) {
        double[] dArray = this.huToEdParams.get(0);
        double[] dArray2 = this.huToEdParams.get(1);
        float f3 = this.toED((float)this.threshold);
        double d2 = f2 <= f3 ? ((double)f2 - dArray[0]) / dArray[1] : ((double)f2 - dArray2[0]) / dArray2[1];
        return (float)d2;
    }

    public float getCalibratedHU(float f2) {
        double d2;
        double[] dArray = this.huToEdParams.get(0);
        double[] dArray2 = this.huToEdParams.get(1);
        if ((double)f2 <= this.threshold) {
            d2 = f2;
        } else {
            double d3 = dArray2[0] + dArray2[1] * (double)f2;
            d2 = (d3 - dArray[0]) / dArray[1];
        }
        return (float)d2;
    }

    private void getProfileData(HUEDProfile hUEDProfile) {
        if (hUEDProfile.getSize() < 3) {
            ay.d((Object)"HU array and ED array are not valid.", this);
        } else {
            this.hus = new double[hUEDProfile.getSize()];
            this.eds = new double[hUEDProfile.getSize()];
            for (int i2 = 0; i2 < hUEDProfile.getSize(); ++i2) {
                this.hus[i2] = hUEDProfile.getHU(i2);
                this.eds[i2] = hUEDProfile.getED(i2);
            }
            this.sort();
            this.profileName = hUEDProfile.getName();
            this.profileUID = hUEDProfile.getUid();
        }
    }

    private void sort() {
        boolean bl2;
        do {
            bl2 = false;
            for (int i2 = 0; i2 < this.hus.length - 1; ++i2) {
                if (!(this.hus[i2] > this.hus[i2 + 1])) continue;
                double d2 = this.hus[i2];
                this.hus[i2] = this.hus[i2 + 1];
                this.hus[i2 + 1] = d2;
                d2 = this.eds[i2];
                this.eds[i2] = this.eds[i2 + 1];
                this.eds[i2 + 1] = d2;
                bl2 = true;
            }
        } while (bl2);
    }

    private void segmentalRegression() {
        try {
            int n2 = this.hus.length;
            double d2 = Double.MAX_VALUE;
            for (int i2 = 1; i2 < n2 - 1; ++i2) {
                double[] dArray = new double[i2 + 1];
                double[] dArray2 = new double[i2 + 1];
                System.arraycopy(this.hus, 0, dArray, 0, dArray.length);
                System.arraycopy(this.eds, 0, dArray2, 0, dArray2.length);
                double[] dArray3 = Regression.a(dArray, dArray2, 1);
                dArray = new double[n2 - i2];
                dArray2 = new double[n2 - i2];
                System.arraycopy(this.hus, i2, dArray, 0, dArray.length);
                System.arraycopy(this.eds, i2, dArray2, 0, dArray2.length);
                double[] dArray4 = Regression.a(dArray, dArray2, 1);
                double d3 = (dArray3[0] - dArray4[0]) / (dArray4[1] - dArray3[1]);
                double d4 = 0.0;
                for (int i3 = 0; i3 < n2; ++i3) {
                    double d5 = this.hus[i3] <= d3 ? dArray3[0] + dArray3[1] * this.hus[i3] : dArray4[0] + dArray4[1] * this.hus[i3];
                    d4 += Math.abs(d5 - this.eds[i3]);
                }
                if (!(d4 < d2)) continue;
                d2 = d4;
                this.threshold = d3;
                this.huToEdParams.clear();
                this.huToEdParams.add(dArray3);
                this.huToEdParams.add(dArray4);
            }
        }
        catch (Exception exception) {
            ay.d((Object)exception.getMessage(), this);
        }
    }

    public String getProfileUID() {
        return this.profileUID;
    }

    public String getProfileName() {
        return this.profileName;
    }
}

