/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.numerics.MathUtils;
import com.mimvista.util.DateUtils;
import com.mimvista.util.MIMDateFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.ck;
import com.mimvista.util.cn;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;

public class HUEDProfile
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String name = "";
    private String devNum = "";
    private String uid = "";
    private String lastUpdateTime = null;
    private Date lastUpdate = new Date();
    private float[] hus = new float[0];
    private float[] eds = new float[0];

    public HUEDProfile() {
        this.uid = UIDGenerator.generateUID();
    }

    public HUEDProfile(int n2) {
        this();
        this.hus = new float[n2];
        this.eds = new float[n2];
    }

    public int getSize() {
        return this.hus.length;
    }

    public String getName() {
        return cn.i(this.name);
    }

    public String getDevNum() {
        return cn.i(this.devNum);
    }

    public String getUid() {
        return this.uid;
    }

    public long getTimeOfLastUpdate() {
        return this.lastUpdate.getTime();
    }

    public String getFormattedUpdateTime() {
        if (this.lastUpdateTime != null) {
            return this.lastUpdateTime;
        }
        MIMDateFormat mIMDateFormat = new MIMDateFormat(DateUtils.b() + " H:mma");
        return mIMDateFormat.format(this.lastUpdate);
    }

    public float getMaxHU() {
        return MathUtils.u(this.hus);
    }

    public float getMinHU() {
        return MathUtils.s(this.hus);
    }

    public float getHU(int n2) {
        return this.hus[n2];
    }

    public float getED(int n2) {
        return this.eds[n2];
    }

    public float[] getCopiedHUs() {
        return (float[])this.hus.clone();
    }

    public float[] getCopiedEDs() {
        return (float[])this.eds.clone();
    }

    public void setUid(String string) {
        this.uid = string;
    }

    public void setName(String string) {
        if (cn.a(this.name, string, true)) {
            this.markAsUpdated();
        }
        this.name = string;
    }

    public void setDevNum(String string) {
        if (cn.a(this.devNum, string, true)) {
            this.markAsUpdated();
        }
        this.devNum = string;
    }

    public void setUpdateAsTime(String string) {
        try {
            long l2 = Long.parseLong(string);
            this.lastUpdate = new Date(l2);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error parsing time", throwable, this);
            this.lastUpdate = new Date();
        }
    }

    public void setLastUpdateTime(Date date) {
        this.lastUpdate = date == null ? new Date() : date;
    }

    public void setUpdateAsFormattedDate(String string) {
        MIMDateFormat mIMDateFormat = new MIMDateFormat("EEE MMM dd hh:mm:ss zzz yyyy");
        try {
            this.lastUpdate = mIMDateFormat.parse(string);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error parsing time", throwable, this);
            this.lastUpdateTime = string;
        }
    }

    public void setHU(int n2, float f2) {
        if (Float.compare(f2, this.hus[n2]) != 0) {
            this.markAsUpdated();
        }
        this.hus[n2] = f2;
    }

    public void setED(int n2, float f2) {
        if (Float.compare(f2, this.eds[n2]) != 0) {
            this.markAsUpdated();
        }
        this.eds[n2] = f2;
    }

    public void setSize(int n2) {
        float[] fArray = new float[n2];
        float[] fArray2 = new float[n2];
        System.arraycopy(this.hus, 0, fArray, 0, Math.min(this.hus.length, fArray.length));
        System.arraycopy(this.eds, 0, fArray2, 0, Math.min(this.eds.length, fArray2.length));
        this.hus = fArray;
        this.eds = fArray2;
    }

    public void addRow() {
        float[] fArray = new float[this.getSize() + 1];
        float[] fArray2 = new float[this.getSize() + 1];
        System.arraycopy(this.hus, 0, fArray, 0, this.hus.length);
        System.arraycopy(this.eds, 0, fArray2, 0, this.eds.length);
        this.hus = fArray;
        this.eds = fArray2;
        this.markAsUpdated();
    }

    public void removeRows(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return;
        }
        HashSet hashSet = Sets.newHashSet();
        for (int n2 : nArray) {
            hashSet.add(n2);
        }
        float[] fArray = new float[this.hus.length - nArray.length];
        float[] fArray2 = new float[this.hus.length - nArray.length];
        int n3 = 0;
        for (int n2 = 0; n2 < this.hus.length; ++n2) {
            if (hashSet.contains(n2)) continue;
            fArray[n3] = this.hus[n2];
            fArray2[n3] = this.eds[n2];
            ++n3;
        }
        this.hus = fArray;
        this.eds = fArray2;
        this.markAsUpdated();
    }

    public void sort() {
        int n2;
        ArrayList<Float> arrayList = new ArrayList<Float>(this.getSize());
        ArrayList<Float> arrayList2 = new ArrayList<Float>(this.getSize());
        for (n2 = 0; n2 < this.getSize(); ++n2) {
            arrayList.add(Float.valueOf(this.hus[n2]));
            arrayList2.add(Float.valueOf(this.eds[n2]));
        }
        ck.a(arrayList, arrayList2);
        for (n2 = 0; n2 < this.getSize(); ++n2) {
            this.hus[n2] = ((Float)arrayList.get(n2)).floatValue();
            this.eds[n2] = ((Float)arrayList2.get(n2)).floatValue();
        }
    }

    public String toString() {
        String string = cn.g(this.devNum) ? "" : " (" + this.getDevNum() + ")";
        return "<html><b>" + this.name + string + "</b><br>" + Messages.a("Dicom", "HUED_LAST_UPDATE") + " " + this.getFormattedUpdateTime() + "</html>";
    }

    public HUEDProfile clone() {
        try {
            HUEDProfile hUEDProfile = (HUEDProfile)super.clone();
            hUEDProfile.hus = (float[])this.hus.clone();
            hUEDProfile.eds = (float[])this.eds.clone();
            if (this.lastUpdate != null) {
                hUEDProfile.lastUpdate = (Date)this.lastUpdate.clone();
            }
            return hUEDProfile;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ay.d((Object)"Error cloning HUED Profile", (Throwable)cloneNotSupportedException, this);
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof HUEDProfile) {
            HUEDProfile hUEDProfile = (HUEDProfile)object;
            return Objects.equal((Object)this.name, (Object)hUEDProfile.name) && Objects.equal((Object)this.getDevNum(), (Object)hUEDProfile.getDevNum()) && Objects.equal((Object)this.getUid(), (Object)hUEDProfile.getUid()) && Objects.equal((Object)this.lastUpdateTime, (Object)hUEDProfile.lastUpdateTime) && Objects.equal((Object)this.lastUpdate, (Object)hUEDProfile.lastUpdate) && Arrays.equals(this.hus, hUEDProfile.hus) && Arrays.equals(this.eds, hUEDProfile.eds);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.getDevNum(), this.getUid(), this.lastUpdateTime, this.lastUpdate, Arrays.hashCode(this.hus), Arrays.hashCode(this.eds)});
    }

    private void markAsUpdated() {
        this.lastUpdate = new Date();
    }
}

