/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.collect.Lists;
import com.mimvista.dicom.util.HUEDProfile;
import com.mimvista.preferencesNew.cascade.CascadeSubfolder;
import com.mimvista.preferencesNew.cascade.c;
import com.mimvista.util.XMLUtils;
import com.mimvista.util.ay;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HUEDProfileManager {
    private static final String PROFILE_FILENAME = "hued_profile.xml";
    private Document doc = null;

    private static File getProfileFile() {
        return c.e().b(CascadeSubfolder.a, PROFILE_FILENAME);
    }

    public HUEDProfileManager() {
        File file = HUEDProfileManager.getProfileFile();
        if (file.exists()) {
            this.loadProfiles(file);
        } else {
            this.createFile(file);
        }
    }

    public List<HUEDProfile> getProfiles() {
        if (this.doc != null) {
            ArrayList arrayList = Lists.newArrayList();
            Element element = this.doc.getDocumentElement();
            List<Element> list = XMLUtils.a((Node)element, new String[]{"profile"});
            for (Element element2 : list) {
                HUEDProfile hUEDProfile = new HUEDProfile();
                hUEDProfile.setName(element2.getAttribute(TagName.NAME.toString()));
                hUEDProfile.setDevNum(element2.getAttribute(TagName.DEV_NUM.toString()));
                hUEDProfile.setUid(element2.getAttribute(TagName.UID.toString()));
                Node node = element2.getElementsByTagName(TagName.HUS.toString()).item(0);
                Node node2 = element2.getElementsByTagName(TagName.EDS.toString()).item(0);
                String string = node.getTextContent();
                String string2 = node2.getTextContent();
                float[] fArray = this.stringToFloats(string);
                float[] fArray2 = this.stringToFloats(string2);
                hUEDProfile.setSize(Math.min(fArray.length, fArray2.length));
                for (int i2 = 0; i2 < hUEDProfile.getSize(); ++i2) {
                    hUEDProfile.setHU(i2, fArray[i2]);
                    hUEDProfile.setED(i2, fArray2[i2]);
                }
                if (element2.hasAttribute(TagName.UPDATE_TIME.toString())) {
                    hUEDProfile.setUpdateAsFormattedDate(element2.getAttribute(TagName.UPDATE_TIME.toString()));
                } else {
                    hUEDProfile.setUpdateAsTime(element2.getAttribute(TagName.UPDATE_TIME.toString() + "_MS"));
                }
                arrayList.add(hUEDProfile);
            }
            return arrayList;
        }
        String string = "HU-ED profile file couldn't be parsed correctly!";
        ay.d((Object)string, this);
        ArrayList arrayList = Lists.newArrayList();
        return arrayList;
    }

    public HUEDProfile getProfileByUID(String string) {
        if (string != null) {
            List<HUEDProfile> list = this.getProfiles();
            for (HUEDProfile hUEDProfile : list) {
                if (!string.equals(hUEDProfile.getUid())) continue;
                return hUEDProfile;
            }
        }
        return null;
    }

    public void removeAll() {
        List<HUEDProfile> list = this.getProfiles();
        for (HUEDProfile hUEDProfile : list) {
            this.removeProfile(hUEDProfile);
        }
    }

    public void updateProfile(HUEDProfile hUEDProfile) {
        if (this.doc != null) {
            try {
                String string = "//calibration/profile[@UID=\"" + hUEDProfile.getUid() + "\"]";
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                XPathExpression xPathExpression = xPath.compile(string);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(this.doc, XPathConstants.NODESET);
                Element element = nodeList.getLength() > 0 ? (Element)nodeList.item(0) : (Element)this.doc.getDocumentElement().appendChild(this.doc.createElement("profile"));
                this.updateAProfileNode(element, hUEDProfile);
                XMLUtils.a(this.doc, HUEDProfileManager.getProfileFile().getAbsolutePath());
            }
            catch (Exception exception) {
                String string = "New HU-ED profile couldn't be added:\n" + exception.getMessage();
                ay.d((Object)string, this);
                throw new RuntimeException(string);
            }
        } else {
            String string = "HU-ED profile file couldn't be parsed correctly!";
            ay.d((Object)string, this);
            throw new RuntimeException(string);
        }
    }

    public void removeProfile(HUEDProfile hUEDProfile) {
        if (this.doc != null) {
            try {
                String string = "//calibration/profile[@UID=\"" + hUEDProfile.getUid() + "\"]";
                XPathFactory xPathFactory = XPathFactory.newInstance();
                XPath xPath = xPathFactory.newXPath();
                XPathExpression xPathExpression = xPath.compile(string);
                NodeList nodeList = (NodeList)xPathExpression.evaluate(this.doc, XPathConstants.NODESET);
                if (nodeList.getLength() > 0) {
                    this.doc.getDocumentElement().removeChild(nodeList.item(0));
                }
                XMLUtils.a(this.doc, HUEDProfileManager.getProfileFile().getAbsolutePath());
            }
            catch (Exception exception) {
                String string = "The HU-ED profile couldn't be removed:\n" + exception.getMessage();
                ay.d((Object)string, this);
                throw new RuntimeException(string);
            }
        } else {
            String string = "HU-ED profile file couldn't be parsed correctly!";
            ay.d((Object)string, this);
            throw new RuntimeException(string);
        }
    }

    private void updateAProfileNode(Element element, HUEDProfile hUEDProfile) {
        element.setAttribute(TagName.NAME.toString(), hUEDProfile.getName());
        element.setAttribute(TagName.DEV_NUM.toString(), hUEDProfile.getDevNum());
        element.setAttribute(TagName.UID.toString(), hUEDProfile.getUid());
        element.setAttribute(TagName.UPDATE_TIME.toString() + "_MS", String.valueOf(hUEDProfile.getTimeOfLastUpdate()));
        NodeList nodeList = element.getElementsByTagName(TagName.HUS.toString());
        Node node = nodeList.getLength() > 0 ? nodeList.item(0) : element.appendChild(this.doc.createElement(TagName.HUS.toString()));
        node.setTextContent(this.floatsToString(hUEDProfile.getCopiedHUs()));
        NodeList nodeList2 = element.getElementsByTagName(TagName.EDS.toString());
        Node node2 = nodeList2.getLength() > 0 ? nodeList2.item(0) : element.appendChild(this.doc.createElement(TagName.EDS.toString()));
        node2.setTextContent(this.floatsToString(hUEDProfile.getCopiedEDs()));
    }

    private String floatsToString(float[] fArray) {
        String string = "";
        if (fArray != null && fArray.length > 0) {
            for (int i2 = 0; i2 < fArray.length; ++i2) {
                string = string + fArray[i2] + ",";
            }
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private float[] stringToFloats(String string) {
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split(",");
            if (stringArray != null) {
                float[] fArray = new float[stringArray.length];
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    fArray[i2] = Float.parseFloat(stringArray[i2]);
                }
                return fArray;
            }
            return new float[0];
        }
        return new float[0];
    }

    private void loadProfiles(File file) {
        try {
            this.doc = XMLUtils.a(file);
        }
        catch (Exception exception) {
            this.doc = null;
            ay.d((Object)exception.getMessage(), this);
            exception.printStackTrace();
        }
    }

    private void createFile(File file) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.doc = documentBuilder.newDocument();
            this.doc.appendChild(this.doc.createElement("calibration"));
            XMLUtils.a(this.doc, file.getAbsolutePath());
        }
        catch (Exception exception) {
            this.doc = null;
            ay.d((Object)exception.getMessage(), this);
            exception.printStackTrace();
        }
    }

    public static enum TagName {
        NAME,
        DEV_NUM,
        UID,
        UPDATE_TIME,
        HUS,
        EDS;

    }
}

