/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.util.DicomAnonymizeNotification;
import com.mimvista.dicom.util.DicomHipaaSeriesScanner;
import com.mimvista.gui.util.l;
import com.mimvista.preferencesNew.ManufacturersPrefs;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.dcm4che2.data.DicomObject;

public class MIMInternalAnonymizerNotification
extends DicomAnonymizeNotification {
    private HashMap<Integer, ArrayList<l<String>>> fields = new HashMap();
    private String[] mimIDOptions = new String[]{"", "CAR", "CAR-CA", "CAR-EF", "CAR-MCA", "CAR-4D", "CON", "CON-ADAPT", "CON-ATLAS", "CON-4D", "FUS", "FUS-AA", "NEU", "NEU-AD", "NEU-ALZ", "NEU-ALZ-DYN", "NEU-ATLAS", "NEU-EPI", "NEU-PD", "NEU-NORM", "NEU-TUM", "NEU-TUM-DYN", "NM", "NM-BONE", "NM-DYN", "NM-2D", "MAM", "MAM-FUS", "MAM-PEM", "PAC", "PRECLIN", "PHANTOM", "PHANTOM-ALIGN", "PHANTOM-CALIB", "PHANTOM-CUBE", "PHANTOM-MC", "PHANTOM-PATTERN", "PHANTOM-RODS", "PHANTOM-SERVICE", "PHANTOM-SPHERES", "PHANTOM-VOLUMES", "ORI", "PAC", "RADS", "RADS-CON", "RADS-DYN", "RADS-FUS", "RT", "RT-ADAPT", "RT-ATLAS", "RT-BRACHY", "RT-CON", "RT-DOSE", "RT-FUS", "RT-IGRT", "RT-MR", "RT-PET", "RT-4D", "TR", "TR-PET", "TR-NM", "VAR", "2D", "2D-CA", "2D-DYN", "2D-FUS"};
    private String[] bodyRegionOptions = new String[]{"", "TOTAL", "WHOLEBODY", "UPPERBODY", "HEAD", "LUNG", "GUT", "BRAIN", "ORAL", "NECK", "HEART", "SA", "SPINE", "ABDOMEN", "PELVIS", "LOWERBODY", "LEG", "THIGH", "KNEE", "FOOT", "C-SPINE", "T-SPINE", "L-SPINE", "THORAX", "SHOULDER", "SA", "HA", "VA", "BREAST", "GI", "GU", "LIVER", "THYROID", "KIDNEY", "PROSTATE", "BLADDER", "ELBOW", "HAND", "WRIST", "ARM", "ANKLE"};

    public MIMInternalAnonymizerNotification(List<DcmSeries> list, List<TreeMap<Integer, String>> list2, boolean bl2) {
        super(list, list2, bl2);
    }

    @Override
    protected DicomHipaaSeriesScanner createSeriesScanner(DcmSeries dcmSeries, Map<Integer, String> map) {
        return new DicomHipaaSeriesScanner(dcmSeries){

            @Override
            protected void doExtraSeriesProcessing(DicomObject dicomObject) {
                int[] nArray;
                for (int n2 : nArray = new int[]{528446, 528432, 524432, 524432, 524416, 0x100010, 0x100020, 524400, 528528}) {
                    if (dicomObject.getString(n2) != null) continue;
                    dicomObject.putString(n2, null, " ");
                }
            }
        };
    }

    private void addFieldItem(int n2, l<String> l2) {
        ArrayList<l<String>> arrayList = this.fields.get(n2);
        if (arrayList == null) {
            arrayList = new ArrayList();
            this.fields.put(n2, arrayList);
        }
        arrayList.add(l2);
    }

    @Override
    protected void buildInputFields(DicomAnonymizeNotification.AnonymizeSeriesData anonymizeSeriesData) {
        l<String> l2 = this.addComboBox("MIM ID", this.mimIDOptions);
        l2.d(true);
        l2.a(this.getMimID(anonymizeSeriesData));
        new AutoCompleter((JComboBox)l2.g());
        this.addFieldItem(0x100010, l2);
        l<String> l3 = this.addComboBox("Body Region", this.bodyRegionOptions);
        l3.d(true);
        l3.a(this.getBodyRegion(anonymizeSeriesData));
        new AutoCompleter((JComboBox)l3.g());
        this.addFieldItem(0x100010, l3);
        this.addCollection("Patient ID", null, 0).b("YYMMDD-SiteID=Xdd");
        this.addFieldItem(0x100020, this.addTextField("").a(this.getPatientID()));
        this.addFieldItem(528432, this.addTextField("Study Description").a(this.getDescription(anonymizeSeriesData, 528432)));
        this.addFieldItem(528446, this.addTextField("Series Description").a(this.getSeriesDescription(anonymizeSeriesData, 528446)));
        this.addFieldItem(524416, this.addTextField("Institution").a(this.getInstitution(anonymizeSeriesData)));
        this.addFieldItem(524432, this.addTextField("Referring Physician").a(this.getReferringPhysicianName(anonymizeSeriesData)));
        this.removeCheckBox = this.addCheckBox(DICOM.getProperty("DCM_HIPAA_REMOVE_TAGS"));
        this.removeCheckBox.a(Boolean.valueOf(anonymizeSeriesData.removePrivateTags));
    }

    private String getReferringPhysicianName(DicomAnonymizeNotification.AnonymizeSeriesData anonymizeSeriesData) {
        return anonymizeSeriesData.userInput.getOldValue(524296);
    }

    private String getPatientID() {
        Date date = new Date();
        String string = new SimpleDateFormat("yyMMdd").format(date);
        return string + "-";
    }

    private String getInstitution(DicomAnonymizeNotification.AnonymizeSeriesData anonymizeSeriesData) {
        String string;
        String string2 = anonymizeSeriesData.userInput.getOldValue(524400);
        string2 = string2 == null ? "UNKNOWN" : string2;
        string2 = (String)ManufacturersPrefs.manufacturers.b(string2).getValue();
        String string3 = anonymizeSeriesData.userInput.getOldValue(528528);
        if (string3 == null) {
            string3 = " ";
        }
        if ((string = anonymizeSeriesData.userInput.getOldValue(1576992)) == null) {
            string = "";
        }
        return string2 + "-" + string3 + "(" + string + ")";
    }

    private String getDescription(DicomAnonymizeNotification.AnonymizeSeriesData anonymizeSeriesData, int n2) {
        String string = anonymizeSeriesData.userInput.getDefaultValue(n2);
        if (string == null) {
            string = "";
        }
        if (!string.startsWith("[")) {
            string = "[] " + string;
        }
        return string;
    }

    private String getSeriesDescription(DicomAnonymizeNotification.AnonymizeSeriesData anonymizeSeriesData, int n2) {
        String string = anonymizeSeriesData.userInput.getOldValue(n2);
        if (string == null) {
            string = "";
        }
        if (!string.startsWith("[")) {
            string = "[] " + string;
        }
        return string;
    }

    @Override
    protected void updateInputFields(DicomAnonymizeNotification.AnonymizeSeriesData anonymizeSeriesData) {
        for (Map.Entry<Integer, ArrayList<l<String>>> entry : this.fields.entrySet()) {
            Integer n2 = entry.getKey();
            String string = anonymizeSeriesData.userInput.getDefaultValue(n2);
            if (n2 == 0x100010) {
                String[] stringArray = this.guessPnSplits(string);
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (stringArray[i2] == null || stringArray[i2].trim().length() == 0) continue;
                    entry.getValue().get(i2).b(stringArray[i2]);
                }
                continue;
            }
            if (n2 == 528446) {
                entry.getValue().get(0).b(this.getSeriesDescription(anonymizeSeriesData, n2));
                continue;
            }
            if (n2 == 524432) {
                entry.getValue().get(0).b(this.getReferringPhysicianName(anonymizeSeriesData));
                continue;
            }
            entry.getValue().get(0).b(string);
        }
        if (this.removeCheckBox != null) {
            this.removeCheckBox.a(Boolean.valueOf(anonymizeSeriesData.removePrivateTags));
        }
    }

    private String getMimID(DicomAnonymizeNotification.AnonymizeSeriesData anonymizeSeriesData) {
        String string = anonymizeSeriesData.userInput.getDefaultValue(0x100010);
        return this.guessPnSplits(string)[0];
    }

    private String getBodyRegion(DicomAnonymizeNotification.AnonymizeSeriesData anonymizeSeriesData) {
        String string = anonymizeSeriesData.userInput.getDefaultValue(0x100010);
        return this.guessPnSplits(string)[1];
    }

    private String[] guessPnSplits(String string) {
        String[] stringArray;
        String[] stringArray2 = new String[2];
        for (String string2 : stringArray = string.split("\\^")) {
            if (Arrays.asList(this.mimIDOptions).contains(string2)) {
                stringArray2[0] = string2;
                continue;
            }
            if (!Arrays.asList(this.bodyRegionOptions).contains(string2)) continue;
            stringArray2[1] = string2;
        }
        return stringArray2;
    }

    @Override
    protected void storeInputFieldData(DicomAnonymizeNotification.AnonymizeSeriesData anonymizeSeriesData) {
        for (Map.Entry<Integer, ArrayList<l<String>>> entry : this.fields.entrySet()) {
            StringBuilder stringBuilder = new StringBuilder("");
            boolean bl2 = true;
            for (l<String> l2 : entry.getValue()) {
                String string = l2.b();
                if (string.trim().length() <= 0) continue;
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuilder.append("^");
                }
                stringBuilder.append(string);
            }
            anonymizeSeriesData.userInput.updateValue(entry.getKey(), stringBuilder.toString());
        }
        anonymizeSeriesData.removePrivateTags = this.removePrivate();
    }

    class AutoCompleter
    implements ItemListener,
    KeyListener {
        private JComboBox combo = null;
        private JTextField editor = null;
        private ComboBoxModel model = null;

        public AutoCompleter(JComboBox jComboBox) {
            this.combo = jComboBox;
            this.combo.addItemListener(this);
            this.editor = (JTextField)jComboBox.getEditor().getEditorComponent();
            this.editor.addKeyListener(this);
            this.model = jComboBox.getModel();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            char c2 = keyEvent.getKeyChar();
            if (c2 == '\uffff' || Character.isISOControl(c2) || c2 == '\u007f') {
                return;
            }
            int n2 = this.editor.getCaretPosition();
            String string = this.editor.getText();
            if (string.length() == 0) {
                return;
            }
            this.autoComplete(string, n2);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        private void autoComplete(String string, int n2) {
            Object[] objectArray = this.getMatchOpts(string.substring(0, n2));
            if (this.combo != null) {
                this.model = new DefaultComboBoxModel<Object>(objectArray);
                this.combo.setModel(this.model);
            }
            if (objectArray.length > 0) {
                this.editor.setText(string);
                if (n2 > this.editor.getText().length()) {
                    return;
                }
                this.editor.setCaretPosition(n2);
                if (this.combo != null) {
                    this.combo.showPopup();
                }
            }
        }

        private Object[] getMatchOpts(String string) {
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            for (int i2 = 0; i2 < this.model.getSize(); ++i2) {
                Object object = this.model.getElementAt(i2);
                if (object != null) {
                    String string2 = object.toString().toLowerCase();
                    if (string2.startsWith(string.toLowerCase())) {
                        vector.add((String)this.model.getElementAt(i2));
                        continue;
                    }
                    vector2.add((String)this.model.getElementAt(i2));
                    continue;
                }
                vector2.add((String)this.model.getElementAt(i2));
            }
            for (String string3 : vector2) {
                vector.add(string3);
            }
            return vector.toArray();
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            int n2;
            if (itemEvent.getStateChange() == 1 && (n2 = this.editor.getCaretPosition()) != -1) {
                this.editor.moveCaretPosition(n2);
            }
        }
    }
}

