/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.collect.Ordering;
import com.mimvista.archive.search.pro.MetabaseQueryish;
import com.mimvista.archive.search.pro.QueryParamGroup;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.dicom.util.VRUtils;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.metabase.MetabaseQuery;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.util.Arrays;
import java.util.Comparator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.dcm4che2.data.VR;

public enum Operator {
    IS(OperatorType.POSITIVE){

        @Override
        public <T> boolean evaluate(T t2, T t3, Comparator<? super T> comparator) {
            return comparator.compare(t2, t3) == 0;
        }

        public void apply(MetabaseQueryish metabaseQueryish, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            String string2 = MetabaseKeys.fromTag(tagPath);
            Comparable comparable = this.parseUserInput(vR, string);
            if (VRUtils.isStringTypeVR(vR)) {
                metabaseQueryish.a(string2, "^" + Pattern.quote(comparable.toString().trim()) + "$");
            } else {
                metabaseQueryish.a(string2, (Object)comparable);
            }
        }

        @Override
        public MetabaseQuery applyToMetabaseQuery(MetabaseQuery metabaseQuery, TagPath tagPath, String string) {
            this.apply(metabaseQuery, tagPath, string);
            return metabaseQuery;
        }

        @Override
        public QueryParamGroup applyToNewStyleQuery(QueryParamGroup queryParamGroup, TagPath tagPath, String string) {
            this.apply(queryParamGroup, tagPath, string);
            return queryParamGroup;
        }
    }
    ,
    IS_NOT(OperatorType.NEGATIVE){

        @Override
        public <T> boolean evaluate(T t2, T t3, Comparator<? super T> comparator) {
            return !IS.evaluate(t2, t3, comparator);
        }

        public void apply(MetabaseQueryish metabaseQueryish, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            String string2 = MetabaseKeys.fromTag(tagPath);
            Comparable comparable = this.parseUserInput(vR, string);
            if (VRUtils.isStringTypeVR(vR)) {
                metabaseQueryish.b(string2, "^" + Pattern.quote(comparable.toString()) + "$");
            } else {
                metabaseQueryish.b(string2, (Object)comparable);
            }
        }

        @Override
        public MetabaseQuery applyToMetabaseQuery(MetabaseQuery metabaseQuery, TagPath tagPath, String string) {
            this.apply(metabaseQuery, tagPath, string);
            return metabaseQuery;
        }

        @Override
        public QueryParamGroup applyToNewStyleQuery(QueryParamGroup queryParamGroup, TagPath tagPath, String string) {
            this.apply(queryParamGroup, tagPath, string);
            return queryParamGroup;
        }
    }
    ,
    IS_GREATER_THAN(OperatorType.POSITIVE){

        @Override
        public <T> boolean evaluate(T t2, T t3, Comparator<? super T> comparator) {
            return comparator.compare(t2, t3) > 0;
        }

        @Override
        public MetabaseQuery applyToMetabaseQuery(MetabaseQuery metabaseQuery, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            String string2 = MetabaseKeys.fromTag(tagPath);
            if (VRUtils.isStringTypeVR(vR)) {
                return metabaseQuery.h(Operator.getCaseInsensitiveStringComparison(string, string2, ">"));
            }
            return metabaseQuery.e(string2, this.parseUserInput(vR, string));
        }

        @Override
        public QueryParamGroup applyToNewStyleQuery(QueryParamGroup queryParamGroup, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            String string2 = MetabaseKeys.fromTag(tagPath);
            return queryParamGroup.e(string2, this.parseUserInput(vR, string));
        }
    }
    ,
    IS_LESS_THAN(OperatorType.POSITIVE){

        @Override
        public <T> boolean evaluate(T t2, T t3, Comparator<? super T> comparator) {
            return comparator.compare(t2, t3) < 0;
        }

        @Override
        public MetabaseQuery applyToMetabaseQuery(MetabaseQuery metabaseQuery, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            String string2 = MetabaseKeys.fromTag(tagPath);
            if (VRUtils.isStringTypeVR(vR)) {
                return metabaseQuery.h(Operator.getCaseInsensitiveStringComparison(string, string2, "<"));
            }
            return metabaseQuery.g(string2, this.parseUserInput(vR, string));
        }

        @Override
        public QueryParamGroup applyToNewStyleQuery(QueryParamGroup queryParamGroup, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            String string2 = MetabaseKeys.fromTag(tagPath);
            return queryParamGroup.g(string2, this.parseUserInput(vR, string));
        }
    }
    ,
    IS_GREATER_THAN_OR_EQUAL_TO(OperatorType.POSITIVE){

        @Override
        public <T> boolean evaluate(T t2, T t3, Comparator<? super T> comparator) {
            return comparator.compare(t2, t3) >= 0;
        }

        @Override
        public MetabaseQuery applyToMetabaseQuery(MetabaseQuery metabaseQuery, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            String string2 = MetabaseKeys.fromTag(tagPath);
            if (VRUtils.isStringTypeVR(vR)) {
                return metabaseQuery.h(Operator.getCaseInsensitiveStringComparison(string, string2, ">="));
            }
            return metabaseQuery.f(string2, this.parseUserInput(vR, string));
        }

        @Override
        public QueryParamGroup applyToNewStyleQuery(QueryParamGroup queryParamGroup, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            String string2 = MetabaseKeys.fromTag(tagPath);
            return queryParamGroup.f(string2, this.parseUserInput(vR, string));
        }
    }
    ,
    IS_LESS_THAN_OR_EQUAL_TO(OperatorType.POSITIVE){

        @Override
        public <T> boolean evaluate(T t2, T t3, Comparator<? super T> comparator) {
            return comparator.compare(t2, t3) <= 0;
        }

        @Override
        public MetabaseQuery applyToMetabaseQuery(MetabaseQuery metabaseQuery, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            String string2 = MetabaseKeys.fromTag(tagPath);
            if (VRUtils.isStringTypeVR(vR)) {
                return metabaseQuery.h(Operator.getCaseInsensitiveStringComparison(string, string2, "<="));
            }
            return metabaseQuery.h(string2, this.parseUserInput(vR, string));
        }

        @Override
        public QueryParamGroup applyToNewStyleQuery(QueryParamGroup queryParamGroup, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            String string2 = MetabaseKeys.fromTag(tagPath);
            return queryParamGroup.h(string2, this.parseUserInput(vR, string));
        }
    }
    ,
    CONTAINS(OperatorType.POSITIVE){

        @Override
        public <T> boolean evaluate(T t2, T t3, Comparator<? super T> comparator) {
            if (t2 == null || t3 == null) {
                return t2 == t3;
            }
            if (!Operator.areStrings(t2, t3)) {
                throw new InvalidOperandTypeException(this, String.class, t2.getClass(), t3.getClass());
            }
            return ((String)String.class.cast(t2)).toLowerCase().contains(((String)String.class.cast(t3)).toLowerCase());
        }

        private void apply(MetabaseQueryish metabaseQueryish, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            this.ensureStringVR(vR);
            metabaseQueryish.c(MetabaseKeys.fromTag(tagPath), this.parseUserInput(vR, string).toString());
        }

        @Override
        public MetabaseQuery applyToMetabaseQuery(MetabaseQuery metabaseQuery, TagPath tagPath, String string) {
            this.apply(metabaseQuery, tagPath, string);
            return metabaseQuery;
        }

        @Override
        public QueryParamGroup applyToNewStyleQuery(QueryParamGroup queryParamGroup, TagPath tagPath, String string) {
            this.apply(queryParamGroup, tagPath, string);
            return queryParamGroup;
        }
    }
    ,
    DOESNT_CONTAIN(OperatorType.NEGATIVE){

        @Override
        public <T> boolean evaluate(T t2, T t3, Comparator<? super T> comparator) {
            try {
                return !CONTAINS.evaluate(t2, t3, comparator);
            }
            catch (InvalidOperandTypeException invalidOperandTypeException) {
                throw invalidOperandTypeException.setOperator(this);
            }
        }

        private void apply(MetabaseQueryish metabaseQueryish, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            this.ensureStringVR(vR);
            metabaseQueryish.b(MetabaseKeys.fromTag(tagPath), Pattern.quote(this.parseUserInput(vR, string).toString()));
        }

        @Override
        public MetabaseQuery applyToMetabaseQuery(MetabaseQuery metabaseQuery, TagPath tagPath, String string) {
            this.apply(metabaseQuery, tagPath, string);
            return metabaseQuery;
        }

        @Override
        public QueryParamGroup applyToNewStyleQuery(QueryParamGroup queryParamGroup, TagPath tagPath, String string) {
            this.apply(queryParamGroup, tagPath, string);
            return queryParamGroup;
        }
    }
    ,
    EXISTS(OperatorType.POSITIVE, false){

        @Override
        public <T> boolean evaluate(T t2, T t3, Comparator<? super T> comparator) {
            T t4 = t2;
            if (t4 instanceof String) {
                return !cn.h((String)t4);
            }
            return t4 != null;
        }

        @Override
        public MetabaseQuery applyToMetabaseQuery(MetabaseQuery metabaseQuery, TagPath tagPath, String string) {
            String string2 = MetabaseKeys.fromTag(tagPath);
            return metabaseQuery.c(string2).d(string2, (Object)"").d(string2, (Object)null);
        }

        @Override
        public QueryParamGroup applyToNewStyleQuery(QueryParamGroup queryParamGroup, TagPath tagPath, String string) {
            String string2 = MetabaseKeys.fromTag(tagPath);
            return queryParamGroup.c(string2).d(string2, (Object)"").d(string2, (Object)null);
        }
    }
    ,
    DOESNT_EXIST(OperatorType.NEGATIVE, false){

        @Override
        public <T> boolean evaluate(T t2, T t3, Comparator<? super T> comparator) {
            return !EXISTS.evaluate(t2, t3, comparator);
        }

        @Override
        public MetabaseQuery applyToMetabaseQuery(MetabaseQuery metabaseQuery, TagPath tagPath, String string) {
            String string2 = MetabaseKeys.fromTag(tagPath);
            return metabaseQuery.b(metabaseQuery.f().e(string2), metabaseQuery.f().c(string2, (Object)""), metabaseQuery.f().c(string2, (Object)null));
        }

        @Override
        public QueryParamGroup applyToNewStyleQuery(QueryParamGroup queryParamGroup, TagPath tagPath, String string) {
            String string2 = MetabaseKeys.fromTag(tagPath);
            QueryParamGroup.QueryParamOrGroup queryParamOrGroup = queryParamGroup.c();
            queryParamOrGroup.d(string2).c(string2, (Object)"").c(string2, (Object)null);
            return queryParamGroup;
        }
    }
    ,
    REGEX(OperatorType.POSITIVE, true, false){

        @Override
        public <T> boolean evaluate(T object, T t2, Comparator<? super T> comparator) {
            Pattern pattern;
            if (t2 == null || "".equals(t2)) {
                throw new IllegalArgumentException("regex of null or empty string is not permitted");
            }
            if (object == null) {
                object = "";
            }
            if (!Operator.areStrings(object, t2)) {
                throw new InvalidOperandTypeException(this, String.class, object.getClass(), t2.getClass());
            }
            try {
                pattern = Pattern.compile((String)String.class.cast(t2), 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                ay.d((Object)patternSyntaxException, (Object)this);
                throw new IllegalArgumentException("invalid regex");
            }
            return pattern.matcher((CharSequence)String.class.cast(object)).matches();
        }

        @Override
        public MetabaseQuery applyToMetabaseQuery(MetabaseQuery metabaseQuery, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            this.ensureStringVR(vR);
            return metabaseQuery.d(MetabaseKeys.fromTag(tagPath), this.parseUserInput(vR, string).toString());
        }

        @Override
        public QueryParamGroup applyToNewStyleQuery(QueryParamGroup queryParamGroup, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            this.ensureStringVR(vR);
            return queryParamGroup.d(MetabaseKeys.fromTag(tagPath), this.parseUserInput(vR, string).toString());
        }

        @Override
        public boolean validateValue(String string) {
            if (cn.h(string)) {
                return false;
            }
            try {
                Pattern.compile(string, 2);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
    ,
    NOT_REGEX(OperatorType.NEGATIVE, true, false){

        @Override
        public <T> boolean evaluate(T t2, T t3, Comparator<? super T> comparator) {
            try {
                return !REGEX.evaluate(t2, t3, comparator);
            }
            catch (InvalidOperandTypeException invalidOperandTypeException) {
                throw invalidOperandTypeException.setOperator(this);
            }
        }

        @Override
        public MetabaseQuery applyToMetabaseQuery(MetabaseQuery metabaseQuery, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            this.ensureStringVR(vR);
            return metabaseQuery.e(MetabaseKeys.fromTag(tagPath), this.parseUserInput(vR, string).toString());
        }

        @Override
        public QueryParamGroup applyToNewStyleQuery(QueryParamGroup queryParamGroup, TagPath tagPath, String string) {
            VR vR = TagUtils.vrOfTag(tagPath);
            this.ensureStringVR(vR);
            return queryParamGroup.e(MetabaseKeys.fromTag(tagPath), this.parseUserInput(vR, string).toString());
        }

        @Override
        public boolean validateValue(String string) {
            return REGEX.validateValue(string);
        }
    };

    private final boolean twoOperands;
    private final boolean similarSeriesEnabled;
    private final OperatorType type;

    private Operator(OperatorType operatorType) {
        this(operatorType, true);
    }

    private Operator(OperatorType operatorType, boolean bl2) {
        this(operatorType, bl2, true);
    }

    private Operator(OperatorType operatorType, boolean bl2, boolean bl3) {
        this.twoOperands = bl2;
        this.similarSeriesEnabled = bl3;
        this.type = operatorType;
    }

    public abstract MetabaseQuery applyToMetabaseQuery(MetabaseQuery var1, TagPath var2, String var3);

    public abstract QueryParamGroup applyToNewStyleQuery(QueryParamGroup var1, TagPath var2, String var3);

    public abstract <T> boolean evaluate(T var1, T var2, Comparator<? super T> var3);

    public <T extends Comparable> boolean evaluate(Object object, Object object2, Class<T> clazz) {
        return this.evaluate((Comparable)object, (Comparable)object2, this.getComparator(clazz));
    }

    public String getDisplayText() {
        return Messages.a("Automator", "OPERATOR_" + this.name());
    }

    public String getDisplayExplanation() {
        return Messages.a("Automator", "OPERATOR_" + this.name() + "_EXPLANATION");
    }

    public boolean usesTwoOperands() {
        return this.twoOperands;
    }

    public boolean isSimilarSeriesEnabled() {
        return this.similarSeriesEnabled;
    }

    public boolean isPositiveOperator() {
        return this.type == OperatorType.POSITIVE;
    }

    public boolean isNegativeOperator() {
        return this.type == OperatorType.NEGATIVE;
    }

    private static boolean areStrings(Object object, Object object2) {
        return object instanceof String && object2 instanceof String;
    }

    public static Operator safeParse(String string) {
        try {
            return Operator.valueOf(string);
        }
        catch (Throwable throwable) {
            return CONTAINS;
        }
    }

    private <T extends Comparable> Comparator<? super T> getComparator(Class<T> clazz) {
        if (String.class == clazz) {
            return Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).nullsFirst();
        }
        return Ordering.natural().nullsFirst();
    }

    private static String getCaseInsensitiveStringComparison(String string, String string2, String string3) {
        String string4 = "String(obj['" + string2 + "']).toUpperCase() " + string3 + " '" + string.toUpperCase() + "'";
        ay.b((Object)string4, Operator.class);
        return string4;
    }

    protected Comparable parseUserInput(VR vR, String string) {
        return VRUtils.getValueParser(vR).parseUserInputValue(string);
    }

    protected void ensureStringVR(VR vR) {
        if (!VRUtils.isStringTypeVR(vR)) {
            throw new IllegalArgumentException(String.format("Operator %s can only be used with string VRs", this.name()));
        }
    }

    public boolean validateValue(String string) {
        return true;
    }

    public static class InvalidOperandTypeException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;
        private Operator op;
        private Class<?> expectedType;
        private Class<?>[] actualTypes;

        public InvalidOperandTypeException(Operator operator, Class<?> clazz, Class<?> ... classArray) {
            this.op = operator;
            this.expectedType = clazz;
            this.actualTypes = classArray;
        }

        public InvalidOperandTypeException setOperator(Operator operator) {
            this.op = operator;
            return this;
        }

        @Override
        public String getMessage() {
            return String.format("Operator %s expected input of type %s, but got %s", this.op.name(), this.expectedType, Arrays.toString(this.actualTypes));
        }
    }

    private static enum OperatorType {
        POSITIVE,
        NEGATIVE;

    }
}

