/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.util.DateUtils;
import com.mimvista.util.ay;
import com.mimvista.util.cm;
import com.mimvista.viewer.SeriesInfo;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;

public class RawDataHandler {
    private String transferSyntax = "1.2.840.10008.1.2.1";
    private RawDataInfo dataInfo = new RawDataInfo();
    private List<SimpleImageFrame> referencedVolumes = Lists.newArrayList();
    private String seriesUid = UIDGenerator.generateUID();

    public RawDataHandler() {
    }

    public RawDataHandler(SeriesInfo seriesInfo) {
        this.generateTemplate();
        this.loadTemplate(seriesInfo);
    }

    private void addCustomFieldsToDicom() {
        DicomObject dicomObject = this.getRootObject();
        if (this.seriesUid == null) {
            this.seriesUid = UIDGenerator.generateUID();
        }
        RawDicomUtils.addSeriesInstanceUid(dicomObject, this.seriesUid);
        RawDicomUtils.initFileMetaInformation(dicomObject, this.transferSyntax);
        RawDicomUtils.addReferencedSeries(dicomObject, this.referencedVolumes);
    }

    public boolean write(String string) {
        this.addCustomFieldsToDicom();
        this.outputRawData(new File(string));
        return true;
    }

    public void setTemplateInfo(SeriesInfo seriesInfo) {
        this.loadTemplate(seriesInfo);
    }

    public void addReferencedVolumes(List<? extends SimpleImageFrame> list) {
        this.referencedVolumes.addAll(list);
    }

    public DicomObject getRootObject() {
        return this.dataInfo.baseObject;
    }

    public void addSeq(int n2, List<RawDataInfo> list) {
        this.dataInfo.sequences.put(n2, list);
    }

    public void addSimpleSeq(int n2, List<DicomObject> list) {
        ArrayList arrayList = Lists.newArrayList();
        for (DicomObject dicomObject : list) {
            RawDataInfo rawDataInfo = new RawDataInfo(dicomObject);
            arrayList.add(rawDataInfo);
        }
        this.dataInfo.sequences.put(n2, arrayList);
    }

    public String getSeriesUid() {
        return this.seriesUid;
    }

    private void loadTemplate(SeriesInfo seriesInfo) {
        DicomObject dicomObject = this.dataInfo.baseObject;
        dicomObject.putString(0x100010, null, seriesInfo.patientNameRaw);
        dicomObject.putString(0x100020, null, seriesInfo.patientId);
        dicomObject.putString(0x100030, null, seriesInfo.birthDate);
        dicomObject.putString(0x100040, null, seriesInfo.sex);
        dicomObject.putString(0x20000D, null, seriesInfo.studyUID);
        dicomObject.putString(524320, null, seriesInfo.N());
        dicomObject.putDate(524336, null, seriesInfo.studyTime);
        dicomObject.putString(0x200010, null, seriesInfo.studyID);
        dicomObject.putString(524368, null, seriesInfo.accession);
        dicomObject.putString(524400, null, seriesInfo.manufacturer);
        dicomObject.putString(0x200011, null, seriesInfo.seriesNumber);
        dicomObject.putString(528496, null, seriesInfo.operatorName);
        dicomObject.putString(1576992, null, seriesInfo.softwareVersions);
        dicomObject.putString(131094, null, "MIM");
        dicomObject.putString(528528, null, "MIM");
    }

    private void generateTemplate() {
        RawDicomUtils rawDicomUtils = new RawDicomUtils();
        DicomObject dicomObject = this.getRootObject();
        rawDicomUtils.addSpecificCharacterSet(dicomObject);
        rawDicomUtils.addConceptNameCodeSequence(dicomObject);
        rawDicomUtils.addSeriesDescription(dicomObject);
        rawDicomUtils.addModality(dicomObject);
        rawDicomUtils.addAcquisitionContextDescription(dicomObject);
        rawDicomUtils.addCfg(dicomObject);
        RawDicomUtils.addSopClassUid(dicomObject, "1.2.840.10008.5.1.4.1.1.66");
        Date date = new Date();
        RawDicomUtils.addInstanceCreationDate(dicomObject, date);
        RawDicomUtils.addInstanceCreationTime(dicomObject, date);
        RawDicomUtils.addContentDate(dicomObject, date);
        RawDicomUtils.addContentTime(dicomObject, date);
        RawDicomUtils.addSopInstanceUid(dicomObject, UIDGenerator.generateUID());
        rawDicomUtils.addCreatorVersionUid(dicomObject);
    }

    private static List<WriteableDataChunk> buildList(RawDataInfo rawDataInfo) {
        Object object;
        ArrayList arrayList = Lists.newArrayList();
        for (Map.Entry<Integer, RawDataSource> object22 : rawDataInfo.dataTags.entrySet()) {
            object = new WriteableDataChunk();
            ((WriteableDataChunk)object).rds = object22.getValue();
            ((WriteableDataChunk)object).startTag = object22.getKey();
            ((WriteableDataChunk)object).endTag = ((WriteableDataChunk)object).startTag + 1;
            arrayList.add(object);
        }
        for (Map.Entry<Integer, Object> entry : rawDataInfo.sequences.entrySet()) {
            object = new WriteableDataChunk();
            ((WriteableDataChunk)object).seq = (List)entry.getValue();
            ((WriteableDataChunk)object).startTag = entry.getKey();
            ((WriteableDataChunk)object).endTag = ((WriteableDataChunk)object).startTag + 1;
            arrayList.add(object);
        }
        Collections.sort(arrayList, new Comparator<WriteableDataChunk>(){

            @Override
            public int compare(WriteableDataChunk writeableDataChunk, WriteableDataChunk writeableDataChunk2) {
                return (int)Math.signum(writeableDataChunk.startTag - writeableDataChunk2.startTag);
            }
        });
        WriteableDataChunk writeableDataChunk = new WriteableDataChunk();
        writeableDataChunk.startTag = 524293;
        writeableDataChunk.dob = rawDataInfo.baseObject;
        ArrayList arrayList2 = Lists.newArrayList();
        object = writeableDataChunk;
        for (WriteableDataChunk writeableDataChunk2 : arrayList) {
            ((WriteableDataChunk)object).endTag = writeableDataChunk2.startTag;
            arrayList2.add(object);
            arrayList2.add(writeableDataChunk2);
            object = new WriteableDataChunk();
            ((WriteableDataChunk)object).startTag = writeableDataChunk2.endTag;
            ((WriteableDataChunk)object).dob = rawDataInfo.baseObject;
        }
        ((WriteableDataChunk)object).endTag = -1;
        arrayList2.add(object);
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputRawData(File file) {
        FileOutputStream fileOutputStream = null;
        BufferedOutputStream bufferedOutputStream = null;
        DicomOutputStream dicomOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            dicomOutputStream = new DicomOutputStream((OutputStream)bufferedOutputStream);
            DicomObject dicomObject = this.getRootObject();
            dicomOutputStream.writeFileMetaInformation(dicomObject);
            this.writeDataRecurse(dicomOutputStream, this.dataInfo);
            dicomOutputStream.flush();
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error creating raw dicom object", throwable, this.getClass());
            return;
        }
        finally {
            cm.a((Closeable)fileOutputStream, "Error closing stream", this.getClass());
            cm.a((Closeable)bufferedOutputStream, "Error closing stream", this.getClass());
            cm.a((Closeable)dicomOutputStream, "Error closing stream", this.getClass());
        }
    }

    private void writeDataRecurse(DicomOutputStream dicomOutputStream, RawDataInfo rawDataInfo) throws IOException {
        List<WriteableDataChunk> list = RawDataHandler.buildList(rawDataInfo);
        for (WriteableDataChunk writeableDataChunk : list) {
            if (writeableDataChunk.dob != null) {
                dicomOutputStream.writeDataset(writeableDataChunk.dob.subSet(writeableDataChunk.startTag, writeableDataChunk.endTag), this.transferSyntax);
                continue;
            }
            if (writeableDataChunk.rds != null) {
                RawDataHandler.writeObTag(dicomOutputStream, writeableDataChunk.startTag, writeableDataChunk.rds.dataLen, writeableDataChunk.rds.dataSrc);
                if (!writeableDataChunk.rds.autoClose) continue;
                cm.a((Closeable)writeableDataChunk.rds.dataSrc, null, null);
                continue;
            }
            if (writeableDataChunk.seq != null) {
                dicomOutputStream.writeHeader(writeableDataChunk.startTag, VR.SQ, -1);
                for (RawDataInfo rawDataInfo2 : writeableDataChunk.seq) {
                    dicomOutputStream.writeHeader(-73728, null, -1);
                    this.writeDataRecurse(dicomOutputStream, rawDataInfo2);
                    dicomOutputStream.writeHeader(-73715, null, 0);
                }
                dicomOutputStream.writeHeader(-73507, null, 0);
                continue;
            }
            ay.d((Object)"Bad writeable, failure likely.", this);
        }
    }

    public static void writeObTag(DicomOutputStream dicomOutputStream, int n2, int n3, InputStream inputStream) throws IOException {
        int n4;
        int n5 = n3 + 1 & 0xFFFFFFFE;
        dicomOutputStream.writeHeader(n2, VR.OB, n5);
        int n6 = 0;
        long l2 = 0L;
        byte[] byArray = new byte[0xA00000];
        do {
            if ((n6 = inputStream.read(byArray, 0, n4 = (int)Math.min((long)n3 - l2, (long)byArray.length))) <= 0) continue;
            dicomOutputStream.write(byArray, 0, n6);
            l2 += (long)n6;
        } while (n6 != -1 && l2 < (long)n3);
        if (l2 < (long)n3) {
            ay.c((Object)"Reached end of stream before writing desired number of bytes. Padding with zeroes to compensate.", RawDataHandler.class);
            Arrays.fill(byArray, 0, byArray.length, (byte)0);
            while (l2 < (long)n3) {
                n4 = (int)Math.min((long)n3 - l2, (long)byArray.length);
                dicomOutputStream.write(byArray, 0, n4);
                l2 += (long)n4;
            }
        } else if (l2 > (long)n3) {
            ay.d((Object)"Wrote more bytes than desired, failure likely.", RawDataHandler.class);
        }
        if (n3 % 2 != 0) {
            dicomOutputStream.write(0);
        }
    }

    public static byte[] readRawData(String string) {
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(string, 2145386512);
        return dicomObject.getBytes(131330);
    }

    public void addData(int n2, byte[] byArray) {
        this.addData(n2, new ByteArrayInputStream(byArray), byArray.length);
    }

    public RawDataSource addData(int n2, InputStream inputStream, int n3) {
        RawDataSource rawDataSource = new RawDataSource(inputStream, n3);
        this.addData(n2, rawDataSource);
        return rawDataSource;
    }

    public void addData(int n2, RawDataSource rawDataSource) {
        this.dataInfo.dataTags.put(n2, rawDataSource);
    }

    public void addTypeDesc(MIMRawDataType mIMRawDataType) {
        DicomObject dicomObject = this.getRootObject();
        int n2 = mIMRawDataType.getTag() >> 8;
        dicomObject.putString(0x37730000 | n2, VR.SH, mIMRawDataType.getDesc());
    }

    public void setSeriesDescription(String string) {
        DicomObject dicomObject = this.getRootObject();
        dicomObject.putString(528446, VR.LO, string);
    }

    public void setSeriesDateTime(Date date) {
        DicomObject dicomObject = this.getRootObject();
        dicomObject.putString(524321, null, DateUtils.b(date));
        dicomObject.putString(524337, null, DateUtils.e(date));
    }

    public void setAcquisitionContextDescription(String string) {
        DicomObject dicomObject = this.getRootObject();
        dicomObject.putString(4195670, VR.ST, string);
    }

    public void setModality(String string) {
        DicomObject dicomObject = this.getRootObject();
        dicomObject.putString(524384, VR.CS, string);
    }

    private static class WriteableDataChunk {
        public int startTag;
        public int endTag;
        public DicomObject dob;
        public RawDataSource rds;
        public List<RawDataInfo> seq;

        private WriteableDataChunk() {
        }
    }

    public static class RawDataSource {
        public InputStream dataSrc;
        public int dataLen;
        public boolean autoClose = false;

        public RawDataSource(InputStream inputStream, int n2) {
            this.dataSrc = inputStream;
            this.dataLen = n2;
        }

        public RawDataSource(InputStream inputStream, int n2, boolean bl2) {
            this.dataSrc = inputStream;
            this.dataLen = n2;
            this.autoClose = bl2;
        }
    }

    public static class RawDataInfo {
        public DicomObject baseObject;
        public Map<Integer, List<RawDataInfo>> sequences = Maps.newHashMap();
        public Map<Integer, RawDataSource> dataTags = Maps.newHashMap();

        public RawDataInfo() {
            this.baseObject = new BasicDicomObject();
        }

        public RawDataInfo(DicomObject dicomObject) {
            this.baseObject = dicomObject;
        }
    }

    public static enum MIMRawDataType {
        SESSION("MIM_SESSION", 8224),
        SESSION_NEW("MIM_SESSION_NEW", 8240),
        FINDINGS_BUNDLE("FINDINGS", 8256);

        private String desc;
        private int tag;

        private MIMRawDataType(String string2, int n3) {
            this.desc = string2;
            this.tag = n3;
        }

        public String getDesc() {
            return this.desc;
        }

        public int getTag() {
            return this.tag;
        }
    }
}

