/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.mimvista.archive.Parser;
import com.mimvista.d;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.internals.PlanarImage;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.preferencesNew.ArchivePrefs;
import com.mimvista.util.Messages;
import com.mimvista.util.Pair;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import java.awt.Color;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.Tag;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.DateUtils;

public class RawDicomUtils {
    public static Messages props = Messages.a("Dicom");
    public static final Date defaultDicomDate = new Date(70, 0, 1);
    public static final String defaultDicomDateStr = com.mimvista.util.DateUtils.a(defaultDicomDate);
    public static final String defaultDicomTimeStr = new SimpleDateFormat("HHmmss").format(defaultDicomDate);
    private String seriesDescription = null;
    private String studyDescription = null;
    private String modality = null;
    private String acquisitionContextDescription = null;
    private HashMap<String, String> cfg = new HashMap();
    private static int instanceNumber = 1;
    private static final List<Integer> defaultDateTagList = ImmutableList.builder().add((Object)524320).add((Object)524321).add((Object)524322).add((Object)805699592).add((Object)524323).add((Object)1576978).add((Object)805961734).add((Object)0x400244).add((Object)524306).add((Object)3670048).add((Object)0x402004).add((Object)7340162).add((Object)805831248).add((Object)805830742).add((Object)805830740).add((Object)1057232).add((Object)1577472).build();
    private static final List<Integer> smartDateTagList = ImmutableList.builder().add((Object)524321).add((Object)524322).addAll(defaultDateTagList).build();
    private static final List<Integer> smartRtDateTagList = ImmutableList.builder().add((Object)524321).add((Object)805699592).add((Object)524322).add((Object)524306).addAll(defaultDateTagList).build();
    private static final BiMap<Integer, Integer> dicomDateTagToTimeTag = ImmutableBiMap.builder().put((Object)524306, (Object)524307).put((Object)524321, (Object)524337).put((Object)524320, (Object)524336).put((Object)524322, (Object)524338).put((Object)805699592, (Object)805699593).put((Object)524323, (Object)524339).put((Object)1576978, (Object)1576980).put((Object)805961734, (Object)805961735).put((Object)0x400244, (Object)4194885).put((Object)3670048, (Object)3670049).put((Object)0x402004, (Object)4202501).put((Object)7340162, (Object)7340163).put((Object)805831248, (Object)805831249).put((Object)1577472, (Object)1577473).build();

    public void addSpecificCharacterSet(DicomObject dicomObject) {
        Parser.setDefaultSpecificCharacterSet(dicomObject);
    }

    public void addConceptNameCodeSequence(DicomObject dicomObject) {
        dicomObject.putSequence(4235331);
    }

    public void setSeriesDescription(String string) {
        this.seriesDescription = string;
    }

    public String getSeriesDescription() {
        return this.seriesDescription;
    }

    public void setStudyDescription(String string) {
        this.studyDescription = string;
    }

    public void addSeriesDescription(DicomObject dicomObject) {
        dicomObject.putString(528446, VR.LO, this.seriesDescription);
    }

    public void addStudyDescription(DicomObject dicomObject) {
        dicomObject.putString(528432, VR.LO, this.studyDescription);
    }

    public void setModality(String string) {
        this.modality = string;
    }

    public String getModality() {
        return this.modality;
    }

    public void addModality(DicomObject dicomObject) {
        dicomObject.putString(524384, VR.CS, this.modality == null ? "OT" : this.modality);
    }

    public void setAcquisitionContextDescription(String string) {
        this.acquisitionContextDescription = string;
    }

    public void addAcquisitionContextDescription(DicomObject dicomObject) {
        dicomObject.putString(4195670, VR.ST, this.acquisitionContextDescription);
    }

    public void addCfg(DicomObject dicomObject) {
        for (String string : this.cfg.keySet()) {
            dicomObject.putString(Tag.toTagPath((String)string), null, this.cfg.get(string));
        }
    }

    public static void addSopClassUid(DicomObject dicomObject, String string) {
        dicomObject.putString(524310, VR.UI, string);
    }

    public static void addInstanceCreationDate(DicomObject dicomObject, Date date) {
        dicomObject.putDate(524306, VR.DA, date);
    }

    public static void addInstanceCreationTime(DicomObject dicomObject, Date date) {
        dicomObject.putDate(524307, VR.TM, date);
    }

    public static void addContentDate(DicomObject dicomObject, Date date) {
        dicomObject.putDate(524323, VR.DA, date);
    }

    public static void addContentTime(DicomObject dicomObject, Date date) {
        dicomObject.putDate(524339, VR.TM, date);
    }

    public void addInstanceNumber(DicomObject dicomObject) {
        dicomObject.putInt(2097171, VR.IS, instanceNumber++);
    }

    public void addManufacturer(DicomObject dicomObject) {
        dicomObject.putString(524400, null, props.getProperty("RAW_DICOM_UTILS_MIM_CORP"));
    }

    public static void addSopInstanceUid(DicomObject dicomObject, String string) {
        dicomObject.putString(524312, VR.UI, string);
    }

    public void addCreatorVersionUid(DicomObject dicomObject) {
        dicomObject.putString(561443, VR.UI, UIDGenerator.generateCreatorVersionUID());
    }

    public static void addSeriesInstanceUid(DicomObject dicomObject, String string) {
        dicomObject.putString(0x20000E, VR.UI, string);
    }

    public static void initFileMetaInformation(DicomObject dicomObject, String string) {
        dicomObject.initFileMetaInformation(string);
    }

    public void addBurnedInAnnotation(DicomObject dicomObject) {
        dicomObject.putString(2622209, VR.CS, "YES");
    }

    public void addConversionType(DicomObject dicomObject) {
        dicomObject.putString(524388, VR.CS, "WSD");
    }

    public void addAcquisitionDateTime(DicomObject dicomObject, Date date) {
        dicomObject.putDate(524330, VR.DT, date);
    }

    public void addDocumentTitle(DicomObject dicomObject, String string) {
        dicomObject.putString(4325392, VR.ST, string);
    }

    public void addMimeType(DicomObject dicomObject, String string) {
        dicomObject.putString(4325394, VR.LO, string);
    }

    public static void addReferencedSeries(DicomObject dicomObject, Iterable<SimpleImageFrame> iterable) {
        if (iterable == null || !iterable.iterator().hasNext()) {
            return;
        }
        DicomElement dicomElement = dicomObject.putSequence(528896);
        for (SimpleImageFrame object : iterable) {
            dicomElement.addDicomObject(RawDicomUtils.getScorisObject(object));
        }
        DicomElement dicomElement2 = dicomObject.putSequence(528661);
        for (SimpleImageFrame simpleImageFrame : iterable) {
            dicomElement2.addDicomObject(RawDicomUtils.getImageSOPInstanceMacro(simpleImageFrame));
        }
    }

    public static void addRoiDisplayColor(DicomObject dicomObject, Color color) {
        dicomObject.putInts(805699626, VR.IS, new int[]{color.getRed(), color.getGreen(), color.getBlue()});
    }

    public static Color readRoiDisplayColor(DicomObject dicomObject) {
        int[] nArray = dicomObject.getInts(805699626);
        if (nArray != null && nArray.length >= 3) {
            return new Color(nArray[0], nArray[1], nArray[2]);
        }
        ay.b((Object)"ROI is missing the ROIDisplayColor, so I'm making it red.", RawDicomUtils.class);
        return Color.RED;
    }

    public static DicomObject getScorisObject(SimpleImageFrame simpleImageFrame) {
        if (simpleImageFrame.getUncopiedMutableInfo().ag() == null || simpleImageFrame.getUncopiedMutableInfo().ag().trim().length() == 0) {
            System.out.println("Big trouble in warp reg writin'...");
        }
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        basicDicomObject.putString(0x20000D, VR.UI, simpleImageFrame.getUncopiedMutableInfo().studyUID);
        DicomElement dicomElement = basicDicomObject.putSequence(528661);
        BasicDicomObject basicDicomObject2 = new BasicDicomObject();
        basicDicomObject2.putString(0x20000E, VR.UI, simpleImageFrame.getUncopiedMutableInfo().ah());
        DicomElement dicomElement2 = basicDicomObject2.putSequence(528714);
        BasicDicomObject basicDicomObject3 = new BasicDicomObject();
        String string = RawDicomUtils.getSOPFromVolTrySliceInfoFirst(simpleImageFrame);
        basicDicomObject3.putString(528725, VR.UI, string);
        basicDicomObject3.putString(528720, VR.UI, simpleImageFrame.getUncopiedMutableInfo().sopClassUID);
        dicomElement2.addDicomObject((DicomObject)basicDicomObject3);
        dicomElement.addDicomObject((DicomObject)basicDicomObject2);
        return basicDicomObject;
    }

    public static void addScorisObjectAllSops(DicomObject dicomObject, SimpleImageVolume<?> simpleImageVolume) {
        DicomElement dicomElement = dicomObject.putSequence(528896);
        DicomObject dicomObject2 = RawDicomUtils.getScorisObjectAllSops(simpleImageVolume);
        dicomElement.addDicomObject(dicomObject2);
    }

    public static DicomObject getScorisObjectAllSops(SimpleImageVolume<?> simpleImageVolume) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        RawDicomUtils.getReferencedSeriesSequence((DicomObject)basicDicomObject, simpleImageVolume);
        basicDicomObject.putString(0x20000D, VR.UI, simpleImageVolume.I().studyUID);
        return basicDicomObject;
    }

    public static String getSOPFromVolTrySliceInfoFirst(SimpleImageFrame simpleImageFrame) {
        String string = null;
        if (simpleImageFrame instanceof SimpleImageVolume) {
            SimpleImageVolume simpleImageVolume = (SimpleImageVolume)simpleImageFrame;
            if (simpleImageVolume.ab().size() > 0) {
                string = simpleImageVolume.ab().get((int)0).sopInstanceUID;
            }
            if (string == null) {
                string = simpleImageVolume.getUncopiedMutableInfo().sopInstanceUID;
            }
        } else if (simpleImageFrame instanceof PlanarImage) {
            PlanarImage planarImage = (PlanarImage)simpleImageFrame;
            string = planarImage.O().b.uid;
        }
        return string;
    }

    public static DicomObject getImageSOPInstanceMacro(SimpleImageFrame simpleImageFrame) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        basicDicomObject.putString(528720, null, simpleImageFrame.getUncopiedMutableInfo().sopClassUID);
        String string = RawDicomUtils.getSOPFromVolTrySliceInfoFirst(simpleImageFrame);
        basicDicomObject.putString(528725, null, string);
        return basicDicomObject;
    }

    public static void getImageSOPInstanceMacroAllSops(DicomElement dicomElement, SimpleImageVolume<?> simpleImageVolume) {
        for (SliceInfo sliceInfo : Iterables.filter(simpleImageVolume.ab(), (Predicate)Predicates.notNull())) {
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            basicDicomObject.putString(528720, null, simpleImageVolume.getUncopiedMutableInfo().sopClassUID);
            String string = sliceInfo.sopInstanceUID;
            if (cn.h(string)) continue;
            basicDicomObject.putString(528725, null, string);
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
        }
    }

    public static void getReferencedSeriesSequence(DicomObject dicomObject, SimpleImageVolume<?> ... simpleImageVolumeArray) {
        DicomElement dicomElement = dicomObject.putSequence(528661);
        for (SimpleImageVolume<?> simpleImageVolume : simpleImageVolumeArray) {
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            DicomElement dicomElement2 = basicDicomObject.putSequence(528714);
            RawDicomUtils.getImageSOPInstanceMacroAllSops(dicomElement2, simpleImageVolume);
            basicDicomObject.putString(0x20000E, null, simpleImageVolume.I().ag());
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
        }
    }

    public static void writeCodeSequence(DicomObject dicomObject, int[] nArray, String[] stringArray) {
        if (stringArray == null || stringArray[0] == null || stringArray[1] == null) {
            dicomObject.putSequence(nArray);
            return;
        }
        int[] nArray2 = new int[nArray.length + 2];
        int n2 = nArray2.length;
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[n2 - 2] = 0;
        nArray2[n2 - 1] = 524546;
        dicomObject.putString(nArray2, null, stringArray[0]);
        nArray2[n2 - 1] = 524544;
        dicomObject.putString(nArray2, null, stringArray[1]);
        if (stringArray[0] != null) {
            nArray2[n2 - 1] = 524548;
            dicomObject.putString(nArray2, null, stringArray[2]);
        }
    }

    public static String[] readCodeSequence(DicomObject dicomObject, int[] nArray) {
        int[] nArray2 = new int[nArray.length + 2];
        int n2 = nArray2.length;
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
        nArray2[n2 - 2] = 0;
        String[] stringArray = new String[3];
        nArray2[n2 - 1] = 524546;
        stringArray[0] = dicomObject.getString(nArray2, (String)null);
        nArray2[n2 - 1] = 524544;
        stringArray[1] = dicomObject.getString(nArray2, (String)null);
        nArray2[n2 - 1] = 524548;
        stringArray[2] = dicomObject.getString(nArray2, "");
        if (stringArray[0] == null || stringArray[1] == null) {
            return null;
        }
        return stringArray;
    }

    public static Map<TagPath, String> flattenDicomObject(DicomObject dicomObject, DicomElementFilter dicomElementFilter) {
        HashMap hashMap = Maps.newHashMap();
        RawDicomUtils.recursiveFlattenHelper(dicomObject, dicomElementFilter, new TagPath(), hashMap);
        return hashMap;
    }

    private static void recursiveFlattenHelper(DicomObject dicomObject, DicomElementFilter dicomElementFilter, TagPath tagPath, Map<TagPath, String> map) {
        for (DicomElement dicomElement : dicomObject) {
            if (dicomElementFilter != null && !dicomElementFilter.accept(dicomObject, dicomElement)) continue;
            if (dicomElement.hasDicomObjects()) {
                for (int i2 = 0; i2 < dicomElement.countItems(); ++i2) {
                    tagPath.addTag(dicomElement.tag(), i2);
                    RawDicomUtils.recursiveFlattenHelper(dicomElement.getDicomObject(i2), dicomElementFilter, tagPath, map);
                    tagPath.removeLastTag();
                }
                continue;
            }
            if (dicomElement.hasFragments()) continue;
            try {
                tagPath.addTag(dicomElement.tag(), 0);
                String string = dicomElement.getString(dicomObject.getSpecificCharacterSet(), false);
                map.put(tagPath.deepCopy(), string == null ? null : string.substring(0, Math.min(string.length(), 255)));
                tagPath.removeLastTag();
            }
            catch (Exception exception) {
                ay.d((Object)"Could not get value for DicomElement", (Throwable)exception, RawDicomUtils.class);
            }
        }
    }

    public static String readProperDateForPatientList(DicomObject dicomObject) {
        Date date = (Date)RawDicomUtils.findProperDateAndTagForPatientList((DicomObject)dicomObject).y;
        if (date != null) {
            return com.mimvista.util.DateUtils.a(date);
        }
        return defaultDicomDateStr;
    }

    private static Pair<Integer, Date> findProperDateAndTagForPatientList(DicomObject dicomObject) {
        List<Integer> list = RawDicomUtils.getDateTagList(dicomObject);
        Pair<Integer, Date> pair = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            Date date = RawDicomUtils.getDicomDate(dicomObject.getString(list.get(i2).intValue()));
            if (date == null) continue;
            pair = Pair.get(list.get(i2), date);
            break;
        }
        if (pair == null || pair.y == null) {
            pair = RawDicomUtils.uberDicomDateParser(list, dicomObject);
        }
        if (pair.y == null) {
            pair.y = defaultDicomDate;
        }
        return pair;
    }

    private static List<Integer> getDateTagList(DicomObject dicomObject) {
        List<Integer> list = defaultDateTagList;
        boolean bl2 = ArchivePrefs.enableSmartArchive.getValue();
        boolean bl3 = ArchivePrefs.useSeriesDateAndTime.getValue();
        if (bl2 && bl3) {
            String string = dicomObject.getString(524384);
            list = string.toUpperCase().startsWith("RT") ? smartRtDateTagList : smartDateTagList;
        }
        return list;
    }

    public static String[] getDateAndTimeForDataset(DicomObject dicomObject) {
        String string;
        Integer n2;
        String[] stringArray = new String[]{defaultDicomDateStr, defaultDicomTimeStr};
        Pair<Integer, Date> pair = RawDicomUtils.findProperDateAndTagForPatientList(dicomObject);
        if (pair.y != null) {
            stringArray[0] = com.mimvista.util.DateUtils.a((Date)pair.y);
        }
        if (pair.x != null && (n2 = RawDicomUtils.getTimeTagForDateTag((Integer)pair.x)) != null && dicomObject.containsValue(n2.intValue()) && !cn.g(string = dicomObject.getString(n2.intValue(), "").trim())) {
            try {
                Date date = DateUtils.parseTM((String)string, (boolean)false);
                stringArray[1] = new SimpleDateFormat("HHmmss").format(date);
            }
            catch (Exception exception) {
                ay.d((Object)("Could not convert study time: " + string), (Throwable)exception, RawDicomUtils.class);
            }
        }
        return stringArray;
    }

    @d
    public static Integer getTimeTagForDateTag(int n2) {
        return (Integer)dicomDateTagToTimeTag.get((Object)n2);
    }

    @d
    public static Integer getDateTagForTimeTag(int n2) {
        return (Integer)dicomDateTagToTimeTag.inverse().get((Object)n2);
    }

    private static Pair<Integer, Date> uberDicomDateParser(List<Integer> list, DicomObject dicomObject) {
        HashMap<Integer, Date> hashMap = new HashMap<Integer, Date>();
        RawDicomUtils.uberParseHelper(list, dicomObject, hashMap);
        for (Integer n2 : list) {
            Date date = (Date)hashMap.get(n2);
            if (date == null) continue;
            return Pair.get(n2, date);
        }
        return Pair.get(null, null);
    }

    private static void uberParseHelper(List<Integer> list, DicomObject dicomObject, Map<Integer, Date> map) {
        for (Integer n2 : list) {
            Date date = RawDicomUtils.getDicomDate(dicomObject.getString(n2.intValue()));
            if (date == null || map.containsKey(n2)) continue;
            map.put(n2, date);
            break;
        }
        for (Integer n2 : dicomObject) {
            if (!n2.hasDicomObjects()) continue;
            for (int i2 = 0; i2 < n2.countItems(); ++i2) {
                RawDicomUtils.uberParseHelper(list, n2.getDicomObject(i2), map);
            }
        }
    }

    protected static boolean isValidDate(String string) {
        return RawDicomUtils.getDicomDate(string) != null;
    }

    protected static Date getDicomDate(String string) {
        if (cn.h(string)) {
            return null;
        }
        try {
            return DateUtils.parseDA((String)string, (boolean)false);
        }
        catch (Throwable throwable) {
            ay.c((Object)("Unable to parse date, \"" + string + "\": " + throwable), RawDicomUtils.class);
            return null;
        }
    }

    public static String readProperTimeForPatientList(DicomObject dicomObject) {
        return RawDicomUtils.getDateAndTimeForDataset(dicomObject)[1];
    }

    public static BigDecimal getMinimumSoftwareVersion(String string) {
        if (!cn.h(string)) {
            String[] stringArray = string.split("\\\\");
            BigDecimal bigDecimal = null;
            for (String string2 : stringArray) {
                int n2;
                if (string2 == null) continue;
                String string3 = string2.trim();
                int n3 = string3.indexOf(".");
                if (n3 != -1 && n3 < string3.length() && (n2 = string3.indexOf(".", n3 + 1)) != -1) {
                    string3 = string3.substring(0, n2);
                }
                if (!cn.h(string3 = RawDicomUtils.trimNonNumeric(string3))) {
                    try {
                        BigDecimal bigDecimal2 = new BigDecimal(string3);
                        if (bigDecimal != null && bigDecimal2.compareTo(bigDecimal) >= 0) continue;
                        bigDecimal = bigDecimal2;
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        ay.a((Object)("Error parsing Software Versions string: " + string3), (Throwable)numberFormatException, RawDicomUtils.class);
                        return null;
                    }
                }
                return null;
            }
            return bigDecimal;
        }
        return null;
    }

    private static String trimNonNumeric(String string) {
        if (!cn.h(string)) {
            int n2;
            int n3;
            int n4 = string.length() - 1;
            for (n3 = 0; n3 <= n4 && !Character.isDigit(string.codePointAt(n3)); ++n3) {
            }
            for (n2 = n4; n2 > 0 && !Character.isDigit(string.codePointAt(n2)); --n2) {
            }
            if (n3 <= n2) {
                return string.substring(n3, n2 + 1);
            }
        }
        return null;
    }

    public static void main(String ... stringArray) {
        System.out.println(String.valueOf(RawDicomUtils.getMinimumSoftwareVersion("9.2")));
        System.out.println(String.valueOf(RawDicomUtils.getMinimumSoftwareVersion("Version4")));
        System.out.println(String.valueOf(RawDicomUtils.getMinimumSoftwareVersion("9.2\\8.0m")));
        System.out.println(String.valueOf(RawDicomUtils.getMinimumSoftwareVersion("9.2\\8.0m\\5.6.5 CB13-0A")));
        System.out.println(String.valueOf(RawDicomUtils.getMinimumSoftwareVersion("9.2\\8.0m\\5.6.5 CB13-0A\\mm4mm")));
        System.out.println(String.valueOf(RawDicomUtils.getMinimumSoftwareVersion("9.2\\8.0m\\5.6.5 CB13-0A\\mm4mm\\1.7.0_25-b15")));
        System.out.println(String.valueOf(RawDicomUtils.getMinimumSoftwareVersion("9.2\\8.0m\\5.6.5 CB13-0A\\mm4mm\\1.7.0_25-b15\\Version: 1.2g")));
        System.out.println(String.valueOf(RawDicomUtils.getMinimumSoftwareVersion("Version: 1.2g\\1.7.0_25-b15\\mm4mm\\5.6.5 CB13-0A\\8.0m\\9.2")));
        System.out.println(String.valueOf(RawDicomUtils.getMinimumSoftwareVersion("9.2\\8.0m\\5.6.5 CB13-0A\\mm4mm\\1.7.0_25-b15\\Version: 1.2g\\blah")));
        System.out.println(String.valueOf(RawDicomUtils.getMinimumSoftwareVersion("8.0\\Version: 8.2g")));
    }

    public static interface DicomElementFilter {
        public boolean accept(DicomObject var1, DicomElement var2);
    }
}

