/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.dicom.devices.dump.newDump.AttributeExtractor;
import com.mimvista.internals.statistics.OverlayStatistician;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Hashtable;
import org.dcm4che2.util.StringUtils;

public class ReadableValuesLookup {
    private static Messages READABLE = Messages.a("DumpReadable");
    public static Hashtable<String, Method> tagTable = new Hashtable();
    public boolean localized = true;
    private AttributeExtractor attributeExtractor;

    public String translate(String string, String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        Method method = tagTable.get(string);
        if (method != null && stringArray.length != 0) {
            try {
                String string2 = (String)method.invoke((Object)this, StringUtils.join((String[])stringArray, (char)'\\'));
                return string2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        return null;
    }

    public ReadableValuesLookup(AttributeExtractor attributeExtractor) {
        this.attributeExtractor = attributeExtractor;
    }

    public String getConversionType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("DV")) {
            return READABLE.getProperty("GET_CONVERSION_TYPE_DIGITIZED_VIDEO");
        }
        if (string.equals("DI")) {
            return READABLE.getProperty("GET_CONVERSION_TYPE_DIGITAL_INTERFACE");
        }
        if (string.equals("DF")) {
            return READABLE.getProperty("GET_CONVERSION_TYPE_DIGITIZED_FILM");
        }
        if (string.equals("WSD")) {
            return READABLE.getProperty("GET_CONVERSION_TYPE_WORK_STATION");
        }
        if (string.equals("SD")) {
            return READABLE.getProperty("GET_CONVERSION_TYPE_SCANNED_DOCUMENT");
        }
        if (string.equals("SI")) {
            return READABLE.getProperty("GET_CONVERSION_TYPE_SCANNED_IMAGE");
        }
        if (string.equals("DRW")) {
            return READABLE.getProperty("GET_CONVERSION_TYPE_DRAWING");
        }
        if (string.equals("SYN")) {
            return READABLE.getProperty("GET_CONVERSION_TYPE_SYNTHETIC_IMAGE");
        }
        return null;
    }

    public String getMappingResource(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("DCMR")) {
            return READABLE.getProperty("GET_MAPPING_RESOURCE_DCMR");
        }
        if (string.equals("SDM")) {
            return READABLE.getProperty("GET_MAPPING_RESOURCE_SDM");
        }
        return null;
    }

    public String getLossyImageCompression(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("00")) {
            return READABLE.getProperty("GET_LOSSY_IMAGE_COMPRESSION_NOT_LOSSY");
        }
        if (string.equals("01")) {
            return READABLE.getProperty("GET_LOSSY_IMAGE_COMPRESSION_LOSSY");
        }
        return null;
    }

    public String getPatientsSex(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("M")) {
            return READABLE.getProperty("GET_PATIENTS_SEX_MALE");
        }
        if (string.equals("F")) {
            return READABLE.getProperty("GET_PATIENTS_SEX_FEMALE");
        }
        if (string.equals("O")) {
            return READABLE.getProperty("GET_APTIENTS_SEX_OTHER");
        }
        return null;
    }

    public String getPatientsAge(String string) {
        if (string == null) {
            return null;
        }
        if (string.endsWith("D")) {
            return string.substring(0, string.length() - 1) + " " + READABLE.getProperty("DAYS");
        }
        if (string.endsWith("W")) {
            return string.substring(0, string.length() - 1) + " " + READABLE.getProperty("WEEKS");
        }
        if (string.endsWith("M")) {
            return string.substring(0, string.length() - 1) + " " + READABLE.getProperty("GET_PATIENTS_AGE_M");
        }
        if (string.endsWith("Y")) {
            return string.substring(0, string.length() - 1) + " " + READABLE.getProperty("GET_PATIENTS_AGE_Y");
        }
        return null;
    }

    public String getPatientsSize(String string) {
        return READABLE.getProperty("GET_PATIENTS_SIZE");
    }

    public String getMM(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getPatientsWeight(String string) {
        return READABLE.getProperty("GET_PATIENTS_WEIGHT");
    }

    public String getPregnancyStatus(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("0001")) {
            return READABLE.getProperty("GET_PREGANCY_STATUS_P");
        }
        if (string.equals("0002")) {
            return READABLE.getProperty("GET_PREGANCY_STATUS_PP");
        }
        if (string.equals("0003")) {
            return READABLE.getProperty("GET_PREGANCY_STATUS_DP");
        }
        if (string.equals("0004")) {
            return READABLE.getProperty("UNKNOWN");
        }
        return null;
    }

    public String getExaminedBodyThickness(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getScanningSequence(String string) {
        String[] stringArray = new String[]{"SE", "IR", "GR", "EP", "RM"};
        String[] stringArray2 = new String[]{READABLE.getProperty("GET_SCANNING_SEQUENCE_SE"), READABLE.getProperty("GET_SCANNING_SEQUENCE_IR"), READABLE.getProperty("GET_SCANNING_SEQUENCE_GR"), READABLE.getProperty("GET_SCANNING_SEQUENCE_EP"), READABLE.getProperty("GET_SCANNING_SEQUENCE_RM")};
        return this.vmConvert(string, stringArray, stringArray2);
    }

    public String getSequenceVariant(String string) {
        String[] stringArray = new String[]{"SK", "MTC", "SS", "TRSS", "SP", "MP", "OSP", "NONE"};
        String[] stringArray2 = new String[]{READABLE.getProperty("GET_SEQUENCE_VARIANT_SKS"), READABLE.getProperty("GET_SEQUENCE_VARIANT_MTC"), READABLE.getProperty("GET_SEQUENCE_VARIANT_SS"), READABLE.getProperty("GET_SEQUENCE_VARIANT_TRSS"), READABLE.getProperty("GET_SEQUENCE_VARIANT_S"), READABLE.getProperty("GET_SEQUENCE_VARIANT_MP"), READABLE.getProperty("GET_SEQUENCE_VARIANT_OP"), READABLE.getProperty("GET_SEQUENCE_VARIANT_NSV")};
        return this.vmConvert(string, stringArray, stringArray2);
    }

    public String getScanOptions(String string) {
        String[] stringArray = new String[]{"PER", "RG", "CG", "PPG", "FC", "PFF", "PFP", "SP", "FS", "EKG", "PHY", "TOMO", "CHASE", "STEP", "ROTA"};
        String[] stringArray2 = new String[]{READABLE.getProperty("GET_SCAN_OPTIONS_PER"), READABLE.getProperty("GET_SCAN_OPTIONS_RG"), READABLE.getProperty("GET_SCAN_OPTIONS_CG"), READABLE.getProperty("GET_SCAN_OPTIONS_PPG"), READABLE.getProperty("GET_SCAN_OPTIONS_FC"), READABLE.getProperty("GET_SCAN_OPTIONS_PFF"), READABLE.getProperty("GET_SCAN_OPTIONS_PFP"), READABLE.getProperty("GET_SCAN_OPTIONS_SP"), READABLE.getProperty("GET_SCAN_OPTIONS_FS"), READABLE.getProperty("GET_SCAN_OPTIONS_EET"), READABLE.getProperty("GET_SCAN_OPTIONS_PET"), READABLE.getProperty("GET_SCAN_OPTIONS_T"), READABLE.getProperty("GET_SCAN_OPTIONS_BC"), READABLE.getProperty("GET_SCAN_OPTIONS_S"), READABLE.getProperty("GET_SCAN_OPTIONS_R")};
        return this.vmConvert(string, stringArray, stringArray2);
    }

    public String vmConvert(String string, String[] stringArray, String[] stringArray2) {
        if (string == null) {
            return null;
        }
        String[] stringArray3 = string.split("/");
        boolean bl2 = false;
        block0: for (int i2 = 0; i2 < stringArray3.length; ++i2) {
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                if (!stringArray3[i2].equalsIgnoreCase(stringArray[i3])) continue;
                stringArray3[i2] = stringArray2[i3];
                bl2 = true;
                continue block0;
            }
        }
        if (bl2) {
            return StringUtils.join((String[])stringArray3, (char)'/');
        }
        return null;
    }

    public String getInterventionDrugDose(String string) {
        return READABLE.getProperty("MILLIGRAM");
    }

    public String getCineRate(String string) {
        return READABLE.getProperty("GET_CINE_RATE");
    }

    public String getSliceThickness(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getKVP(String string) {
        return READABLE.getProperty("KILOVOLT");
    }

    public String getAcquisitionTerminationCondition(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("CNTS")) {
            return READABLE.getProperty("GET_ACQUISITION_CONDITION_CL_REACHED");
        }
        if (string.equalsIgnoreCase("DENS")) {
            return READABLE.getProperty("GET_ACQUISITION_CONDITION_CD_REACHED");
        }
        if (string.equalsIgnoreCase("RDD")) {
            return READABLE.getProperty("GET_ACQUISITION_CONDITION_DD_REACHED");
        }
        if (string.equalsIgnoreCase("MANU")) {
            return READABLE.getProperty("GET_ACQUISITION_TERMINATION_CONDITION_TERMINATED_MANULLY");
        }
        if (string.equalsIgnoreCase("OVFL")) {
            return READABLE.getProperty("GET_ACQUISITION_TERMINATION_CONDITION_TERMINATED_AUTOMATICALLY");
        }
        if (string.equalsIgnoreCase("TIME")) {
            return READABLE.getProperty("GET_ACQUISITION_CONDITION_TL_REACHED");
        }
        if (string.equalsIgnoreCase("TRIG")) {
            return READABLE.getProperty("GET_ACQUISITION_CONDITION_T_REACHED");
        }
        return null;
    }

    public String getEffectiveDuration(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getAcquisitionStartCondition(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("CNTS")) {
            return READABLE.getProperty("GET_ACQUISITION_CONDITION_CL_REACHED");
        }
        if (string.equalsIgnoreCase("DENS")) {
            return READABLE.getProperty("GET_ACQUISITION_CONDITION_CD_REACHED");
        }
        if (string.equalsIgnoreCase("RDD")) {
            return READABLE.getProperty("GET_ACQUISITION_CONDITION_DD_REACHED");
        }
        if (string.equalsIgnoreCase("MANU")) {
            return READABLE.getProperty("GET_ACQUISITION_START_CONDITION_MANU");
        }
        if (string.equalsIgnoreCase("AUTO")) {
            return READABLE.getProperty("GET_ACQUISITION_START_CONDITION_AUTO");
        }
        if (string.equalsIgnoreCase("TIME")) {
            return READABLE.getProperty("GET_ACQUISITION_CONDITION_TL_REACHED");
        }
        if (string.equalsIgnoreCase("TRIG")) {
            return READABLE.getProperty("GET_ACQUISITION_CONDITION_T_REACHED");
        }
        return null;
    }

    public String getRepetitionTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getEchoTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getInversionTimes(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getImagingFrequency(String string) {
        return READABLE.getProperty("MEGAHERTZ");
    }

    public String getMagneticFieldStrength(String string) {
        return READABLE.getProperty("TESLA");
    }

    public String getSpacingBetweenSlices(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDataCollectionDiameter(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getPixelBandWidth(String string) {
        return READABLE.getProperty("HERTZ_PIXEL");
    }

    public String getContrastBolusVolume(String string) {
        return OverlayStatistician.t();
    }

    public String getContrastBolusTotalDose(String string) {
        return READABLE.getProperty("MILLILITER");
    }

    public String getSyringeCounts(String string) {
        return READABLE.getProperty("COUNTS_SECOND");
    }

    public String getContrastFlowRate(String string) {
        return MIMFormat.a(READABLE.getProperty("MILLILITER_SECOND"), OverlayStatistician.t());
    }

    public String getContrastBolusIngredientConcentration(String string) {
        return MIMFormat.a(READABLE.getProperty("MILLIGRAM_MILLILITER"), OverlayStatistician.t());
    }

    public String getSpatialResolution(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTriggerTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getNominalInterval(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getFrameTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getFrameTimeVector(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getFrameDelay(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getImageTriggerDelay(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getMultiplexGroupTimeOffset(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getTriggerTimeOffset(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getRadiopharmaceuticalVolume(String string) {
        return READABLE.getProperty("CUBIT_CENTIMETER");
    }

    public String getRadionuclideTotalDose(String string) {
        String string2 = this.attributeExtractor.getModel();
        return this.getRadionuclideTotalDose(string, string2);
    }

    public String getRadionuclideTotalDose(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null) {
            return null;
        }
        double d2 = new BigDecimal(string).doubleValue();
        if (string2.equalsIgnoreCase("PET") || string2.equalsIgnoreCase("PT")) {
            d2 /= 3.7E7;
        } else if (string2.equalsIgnoreCase("NM")) {
            d2 /= 37.0;
        }
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMaximumFractionDigits(3);
        String string3 = numberFormat.format(d2);
        string3 = ") (" + string3 + "mCi";
        if (string2.equalsIgnoreCase("PET") || string2.equalsIgnoreCase("PT")) {
            return READABLE.getProperty("BECQUEREL") + string3;
        }
        if (string2.equalsIgnoreCase("NM")) {
            return READABLE.getProperty("MEGABECQUEREL") + string3;
        }
        return null;
    }

    public String getRadionuclideHalfLife(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getRadioPharmaceuticalSpecificActivity(String string) {
        return READABLE.getProperty("BECQUEREL_MICROMOLE");
    }

    public String getLowRRValue(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getHighRRValue(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getHeartRate(String string) {
        return READABLE.getProperty("BEATES_MINUTE");
    }

    public String getReconstructionDiameter(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDistanceSourceToDetector(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDistanceSourceToPatient(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getGantryDetectorTilt(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getGantryDetectorSlew(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getTableHeight(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTableTraverse(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTableVerticalIncrement(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTableLateralIncrement(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTableLongitudinalIncrement(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTableAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getRotationDirection(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("CW")) {
            return READABLE.getProperty("CLOCKWISE");
        }
        if (string.equalsIgnoreCase("CC")) {
            return READABLE.getProperty("CONTER_CLOCKWISE");
        }
        return null;
    }

    public String getRadialPosition(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getScanArc(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getAngularStep(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getCenterOfRotationOffset(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getFieldOfViewDimensions(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getExposureTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getXRayTubeCurrent(String string) {
        return READABLE.getProperty("MILLIAMPERE");
    }

    public String getExposure(String string) {
        return READABLE.getProperty("MILLIAMPERE");
    }

    public String getAveragePulseWidth(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getRadiationSetting(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("SC")) {
            return READABLE.getProperty("GET_RADIATION_SETTING_LOW");
        }
        if (string.equalsIgnoreCase("GR")) {
            return READABLE.getProperty("GET_RADIATION_SETTING_HIGH");
        }
        return null;
    }

    public String getImageAndFluoroscopyAreaDoseProduct(String string) {
        return READABLE.getProperty("DGY_SQUARE_CM");
    }

    public String getIntensifierSize(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getImagerPixelSpacing(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getGeneratorPower(String string) {
        return READABLE.getProperty("KILOWATT");
    }

    public String getCollimatorType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("PARA")) {
            return READABLE.getProperty("GET_COLLIMATOR_TYPE_PARA");
        }
        if (string.equalsIgnoreCase("PINH")) {
            return READABLE.getProperty("GET_COLLIMATOR_TYPE_PINH");
        }
        if (string.equalsIgnoreCase("FANB")) {
            return READABLE.getProperty("GET_COLLIMATOR_TYPE_FANB");
        }
        if (string.equalsIgnoreCase("CONE")) {
            return READABLE.getProperty("GET_COLLIMATOR_TYPE_CONE");
        }
        if (string.equalsIgnoreCase("SLNT")) {
            return READABLE.getProperty("GET_COLLIMATOR_TYPE_SLNT");
        }
        if (string.equalsIgnoreCase("ASTG")) {
            return READABLE.getProperty("GET_COLLIMATOR_TYPE_ASTG");
        }
        if (string.equalsIgnoreCase("DIVG")) {
            return READABLE.getProperty("GET_COLLIMATOR_TYPE_DIVG");
        }
        if (string.equalsIgnoreCase("NONE")) {
            return READABLE.getProperty("GET_COLLIMATOR_TYPE_NONE");
        }
        if (string.equalsIgnoreCase("UNKN")) {
            return READABLE.getProperty("UNKNOWN");
        }
        if (string.equalsIgnoreCase("RING")) {
            return READABLE.getProperty("GET_COLLIMATOR_TYPE_RING");
        }
        return null;
    }

    public String getFocalDistance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getXFocusCenter(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getYFocusCenter(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getFocalSpot(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getBodyPartThickness(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getCompressionForce(String string) {
        return READABLE.getProperty("NEWTONS");
    }

    public String getActualFrameDuration(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getCountRate(String string) {
        return READABLE.getProperty("COUNTS_SECOND");
    }

    public String getScanVelocity(String string) {
        return READABLE.getProperty("MILLIMETER_SECOND");
    }

    public String getWholeBodyTechnique(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("1PS")) {
            return READABLE.getProperty("GET_WHOLE_BODY_TECHNIQUE_1PS");
        }
        if (string.equalsIgnoreCase("2PS")) {
            return READABLE.getProperty("GET_WHOLE_BODY_TECHNIQUE_2PS");
        }
        if (string.equalsIgnoreCase("PCN")) {
            return READABLE.getProperty("GET_WHOLE_BODY_TECHNIQUE_PCN");
        }
        if (string.equalsIgnoreCase("MSP")) {
            return READABLE.getProperty("GET_WHOLE_BODY_TECHNIQUE_MSP");
        }
        return null;
    }

    public String getScanLength(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getFlipAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getSAR(String string) {
        return READABLE.getProperty("WATTS_KILOGRAM");
    }

    public String getDbDt(String string) {
        return READABLE.getProperty("GET_DB_DT");
    }

    public String getColumnAngulation(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getTomoLayerHeight(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTomoAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getTomoTime(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getPositionerPrimaryAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getPositionerSecondaryAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getPositionerPrimaryAngleIncrement(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getPositionerSecondaryAngleIncrement(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getDetectorPrimaryAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getDetectorSecondaryAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getTimeDistributionProtocol(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("NTP")) {
            return READABLE.getProperty("GET_TIME_DISTRIBUTION_PROTOCOL_NTP");
        }
        if (string.equalsIgnoreCase("IRIG")) {
            return READABLE.getProperty("GET_TIME_DISTRIBUTION_PROTOCOL_IRIG");
        }
        if (string.equalsIgnoreCase("GPS")) {
            return READABLE.getProperty("GET_TIME_DISTRIBUTION_PROTOCOL_GPS");
        }
        if (string.equalsIgnoreCase("SNTP")) {
            return READABLE.getProperty("GET_TIME_DISTRIBUTION_PROTOCOL_SNTP");
        }
        return null;
    }

    public String getFramePrimaryAngleVector(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getFrameSeondaryAngleVector(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getSliceLocationVector(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getNominalScannedPixelSpacing(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getRotationOfScannedFilm(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getIVUSPullbackRate(String string) {
        return READABLE.getProperty("MILLIMETER_SECOND");
    }

    public String getIVUSGatedRate(String string) {
        return READABLE.getProperty("MILLIMETER_BEAT");
    }

    public String getFocusDepth(String string) {
        return READABLE.getProperty("CENTIMETER");
    }

    public String getDepthOfScanField(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getViewPosition(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("AP")) {
            return READABLE.getProperty("GET_VIEW_POSITION_AP");
        }
        if (string.equalsIgnoreCase("PA")) {
            return READABLE.getProperty("GET_VIEW_POSITION_PA");
        }
        if (string.equalsIgnoreCase("LL")) {
            return READABLE.getProperty("GET_VIEW_POSITION_LL");
        }
        if (string.equalsIgnoreCase("RL")) {
            return READABLE.getProperty("GET_VIEW_POSITION_RL");
        }
        if (string.equalsIgnoreCase("RLD")) {
            return READABLE.getProperty("GET_VIEW_POSITION_RLD");
        }
        if (string.equalsIgnoreCase("LLD")) {
            return READABLE.getProperty("GET_VIEW_POSITION_LLD");
        }
        if (string.equalsIgnoreCase("RLO")) {
            return READABLE.getProperty("GET_VIEW_POSITION_RLO");
        }
        if (string.equalsIgnoreCase("LLO")) {
            return READABLE.getProperty("GET_VIEW_POSITION_LLO");
        }
        return null;
    }

    public String getRegionSpatialFormat(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("0000H")) {
            return READABLE.getProperty("NONE_OR_NOT_APPLICABLE");
        }
        if (string.equalsIgnoreCase("0001H")) {
            return READABLE.getProperty("GET_REGION_SPATIAL_FORMAT_2D");
        }
        if (string.equalsIgnoreCase("0002H")) {
            return READABLE.getProperty("GET_REGION_SPATIAL_FORMAT_M_MODE");
        }
        if (string.equalsIgnoreCase("0003H")) {
            return READABLE.getProperty("GET_REGION_SPATIAL_FORMAT_SPECTRAL");
        }
        if (string.equalsIgnoreCase("0004H")) {
            return READABLE.getProperty("GET_REGION_SPATIAL_FORMAT_WAVEFORM");
        }
        if (string.equalsIgnoreCase("0005H")) {
            return READABLE.getProperty("GRAPHICS");
        }
        return null;
    }

    public String getRegionDataType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("0000H")) {
            return READABLE.getProperty("NONE_OR_NOT_APPLICABLE");
        }
        if (string.equalsIgnoreCase("0001H")) {
            return READABLE.getProperty("TISSUE");
        }
        if (string.equalsIgnoreCase("0002H")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_COLOR_FLOW");
        }
        if (string.equalsIgnoreCase("0003H")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_PW");
        }
        if (string.equalsIgnoreCase("0004H")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_CW");
        }
        if (string.equalsIgnoreCase("0005H")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_MEAN");
        }
        if (string.equalsIgnoreCase("0006H")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_MODE");
        }
        if (string.equalsIgnoreCase("0007H")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_MAX");
        }
        if (string.equalsIgnoreCase("0008H")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_VOLUME");
        }
        if (string.equalsIgnoreCase("0009H")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_DVDT");
        }
        if (string.equalsIgnoreCase("000AH")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_ECG");
        }
        if (string.equalsIgnoreCase("000BH")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_PULSE");
        }
        if (string.equalsIgnoreCase("000CH")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_PHONOCARDIOGRAM");
        }
        if (string.equalsIgnoreCase("000DH")) {
            return READABLE.getProperty("GRAY_BAR");
        }
        if (string.equalsIgnoreCase("000EH")) {
            return READABLE.getProperty("COLOR_BAR");
        }
        if (string.equalsIgnoreCase("000FH")) {
            return READABLE.getProperty("INTEGRATED_BACKSCATTER");
        }
        if (string.equalsIgnoreCase("0010H")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_AREA");
        }
        if (string.equalsIgnoreCase("0011H")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_DADT");
        }
        if (string.equalsIgnoreCase("0012H")) {
            return READABLE.getProperty("GET_REGION_DATE_TYPE_OTHER");
        }
        return null;
    }

    public String getRegionFlags(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("1")) {
            return READABLE.getProperty("GET_REGION_FLAGS_LOW");
        }
        if (string.equals("0")) {
            return READABLE.getProperty("GET_REGION_FLAGS_HIGH");
        }
        return null;
    }

    public String getPhysicalUnitsXDirection(String string) {
        return this.getPhysicalUnitsDirection(string);
    }

    public String getPhysicalUnitsDirection(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("0000H")) {
            return READABLE.getProperty("NONE_OR_NOT_APPLICABLE");
        }
        if (string.equalsIgnoreCase("0001H")) {
            return READABLE.getProperty("PERCENT");
        }
        if (string.equalsIgnoreCase("0002H")) {
            return READABLE.getProperty("DECIBEL");
        }
        if (string.equalsIgnoreCase("0003H")) {
            return READABLE.getProperty("CENTIMETER");
        }
        if (string.equalsIgnoreCase("0004H")) {
            return READABLE.getProperty("SECONDS");
        }
        if (string.equalsIgnoreCase("0005H")) {
            return READABLE.getProperty("HERTZ");
        }
        if (string.equalsIgnoreCase("0006H")) {
            return READABLE.getProperty("DECIBEL_SECONDS");
        }
        if (string.equalsIgnoreCase("0007H")) {
            return READABLE.getProperty("CENTIMETER_PER_SECOND");
        }
        if (string.equalsIgnoreCase("0008H")) {
            return READABLE.getProperty("SQUARE_CENTIMETER");
        }
        if (string.equalsIgnoreCase("0009H")) {
            return READABLE.getProperty("SQUARE_CENTIMETER_SECOND");
        }
        if (string.equalsIgnoreCase("000AH")) {
            return READABLE.getProperty("CUBIT_CENTIMETER");
        }
        if (string.equalsIgnoreCase("000BH")) {
            return READABLE.getProperty("CUBIC_CENTIMETER_SECOND");
        }
        if (string.equalsIgnoreCase("000CH")) {
            return READABLE.getProperty("DEGREES");
        }
        return null;
    }

    public String getPhysicalUnitsYDirection(String string) {
        return this.getPhysicalUnitsDirection(string);
    }

    public String getPulseRepetitionFrequency(String string) {
        return READABLE.getProperty("HERTZ");
    }

    public String getDopplerCorrectionAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getSteeringAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getDopplerSampleVolumeXPosition(String string) {
        return READABLE.getProperty("PIXELS");
    }

    public String getDopplerSampleVolumeYPosition(String string) {
        return READABLE.getProperty("PIXELS");
    }

    public String getPixelComponentOrganization(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("0")) {
            return READABLE.getProperty("GET_PIXEL_COMPONENT_ORGANIZATION_BITS");
        }
        if (string.equals("1")) {
            return READABLE.getProperty("GET_PIXEL_COMPONENT_ORGANIZATION_RANGS");
        }
        if (string.equals("2")) {
            return READABLE.getProperty("GET_PIXEL_COMPONENT_ORGANIZATION_TLU");
        }
        if (string.equals("3")) {
            return READABLE.getProperty("GET_PIXEL_COMPONENT_ORGANIZATION_CSLU");
        }
        return null;
    }

    public String getPixelComponentDataType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("0000H")) {
            return READABLE.getProperty("NONE_OR_NOT_APPLICABLE");
        }
        if (string.equalsIgnoreCase("0001H")) {
            return READABLE.getProperty("GET_PIXEL_COMPONENT_DATA_TYPE_TISSUE");
        }
        if (string.equalsIgnoreCase("0002H")) {
            return READABLE.getProperty("GET_PIXEL_COMPONENT_DATA_TYPE_SPECTRAL_DOPPLER");
        }
        if (string.equalsIgnoreCase("0003H")) {
            return READABLE.getProperty("GET_PIXEL_COMPONENT_DATA_TYPE_CF_VELOCITY");
        }
        if (string.equalsIgnoreCase("0004H")) {
            return READABLE.getProperty("GET_PIXEL_COMPONENT_DATA_TYPE_CF_VARIANCE");
        }
        if (string.equalsIgnoreCase("0005H")) {
            return READABLE.getProperty("GET_PIXEL_COMPONENT_DATA_TYPE_CF_INTENSITY");
        }
        if (string.equalsIgnoreCase("0006H")) {
            return READABLE.getProperty("GRAY_BAR");
        }
        if (string.equalsIgnoreCase("0007H")) {
            return READABLE.getProperty("COLOR_BAR");
        }
        if (string.equalsIgnoreCase("0008H")) {
            return READABLE.getProperty("INTEGRATED_BACKSCATTER");
        }
        if (string.equalsIgnoreCase("0009H")) {
            return READABLE.getProperty("GET_PIXEL_COMPONENT_DATA_TYPE_COMPUTED_BORDER");
        }
        if (string.equalsIgnoreCase("000AH")) {
            return READABLE.getProperty("GET_PIXEL_COMPONENT_DATA_TYPE_TISSUE_CLASSIFICATION");
        }
        return null;
    }

    public String getRWaveTimeVector(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getDetectorTemperature(String string) {
        return READABLE.getProperty("GEGREES_CELSIUS");
    }

    public String getDetectorTimeSinceLastExposure(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getDetectorActiveTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getDetectorActivationOffsetFromExposure(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getDetectorElementPhysicalSize(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDetectorElementSpacing(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDetectorActiveDimensions(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getFieldOfViewRotation(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getGridThickness(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getGridPitch(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getGridPeriod(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getGridFocalDistance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getFilterThicknessMinimum(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getFilterThicknessMaximum(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTagAngleFirstAxis(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getOversamplingPhase(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("2D")) {
            return READABLE.getProperty("GET_OVER_SAMPLING_PHASE_PD");
        }
        if (string.equalsIgnoreCase("3D")) {
            return READABLE.getProperty("GET_OVER_SAMPLING_PHASE_OUT_PD");
        }
        if (string.equalsIgnoreCase("2D_3D")) {
            return READABLE.getProperty("GET_OVER_SAMPLING_PHASE_ALL");
        }
        return null;
    }

    public String getTagSpacingFirstDimension(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTagThickness(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getSpectralWidth(String string) {
        return READABLE.getProperty("HERTZ");
    }

    public String getChemicalShiftReference(String string) {
        return READABLE.getProperty("PARTS_PERMILLION");
    }

    public String getDecouplingFrequency(String string) {
        return READABLE.getProperty("HERTZ");
    }

    public String getDecouplingChemicalShiftReference(String string) {
        return READABLE.getProperty("PARTS_PERMILLION");
    }

    public String getAcquisitionDuration(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getEffectiveEchoTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getCardiacSignalSource(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("ECG")) {
            return READABLE.getProperty("GET_CARDIAC_SIGNAL_SOURCE_ECG");
        }
        if (string.equalsIgnoreCase("VCG")) {
            return READABLE.getProperty("GET_CARDIAC_SIGNAL_SOURCE_VCG");
        }
        if (string.equalsIgnoreCase("PP")) {
            return READABLE.getProperty("GET_CARDIAC_SIGNAL_SOURCE_PP");
        }
        if (string.equalsIgnoreCase("MR")) {
            return READABLE.getProperty("GET_CARDIAC_SIGNAL_SOURCE_MR");
        }
        return null;
    }

    public String getDiffusionBValue(String string) {
        return READABLE.getProperty("GET_DIFFUSION_BV");
    }

    public String getVelocityEncodingMinimumValue(String string) {
        return READABLE.getProperty("CENTIMETER_PER_SECOND");
    }

    public String getTransmitterFrequency(String string) {
        return READABLE.getProperty("MEGAHERTZ");
    }

    public String getSlabThickness(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getMidSlabPosition(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getGradientOutputType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("DB_DT")) {
            return READABLE.getProperty("GET_DB_DT");
        }
        if (string.equalsIgnoreCase("ELECTRIC_FIELD")) {
            return READABLE.getProperty("VOLTS_PER_MINUTES");
        }
        if (string.equalsIgnoreCase("PER_NERVE_STIM")) {
            return READABLE.getProperty("GET_GRADIENT_OUTPUT_TYPE_PER_NERVE_STIM");
        }
        return null;
    }

    public String getSpecificAbsorptionRateValue(String string) {
        return READABLE.getProperty("GET_SPECIFIC_ABSORPTION_RATE_VALUE");
    }

    public String getTaggingDelay(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getVelocityEncodingMaximumValue(String string) {
        return READABLE.getProperty("CENTIMETER_PER_SECOND");
    }

    public String getTagSpacingSecondDimension(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTagAngleSecondAxis(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getFrameAcquisitionDuration(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getTubeAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getRevolutionTime(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getSingleCollimationWidth(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTotalCollimationWidth(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTableSpeed(String string) {
        return READABLE.getProperty("MILLIMETER_SECOND");
    }

    public String getTableFeedPerRotation(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDataCollectionCenter(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getReconstructionFieldOfView(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getReconstructionTargetCenter(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getReconstructionAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getReconstructionPixelSpacing(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTablePosition(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDistanceSourceToDataCollectionCenter(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getCTDIVol(String string) {
        return READABLE.getProperty("MEGAGRAY");
    }

    public String getDistanceSourceToIsocenter(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDistanceObjectToTableTop(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getObjectPixelSpacingInCenterOfBeam(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDistanceReceptorPlaneToDetectorHousing(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getIntensifierActiveDimensions(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getPhysicalDetectorSize(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getBeamAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getCalculatedAnatomyThickness(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getFieldOfViewDimensionsInFloat(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getPositionerIsocenterPrimaryAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getPositionerIsocenterSecondaryAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getPositionerIsocenterDetectorRotationAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getTableXPositionToIsocenter(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTableYPositionToIsocenter(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTableZPositionToIsocenter(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTableHorizontalRotationAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getTableHeadTiltAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getTableCradleTiltAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getAcquiredImageAreaDoseProduct(String string) {
        return READABLE.getProperty("DGY_SQUARE_CM");
    }

    public String getPrimaryPositionerScanArc(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getSecondaryPositionerScanArc(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getPrimaryPositionerScanStartAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getSecondaryPositionerScanStartAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getPrimaryPositionerIncrement(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getSecondaryPositionerIncrement(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getImagePosition(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getLaterality(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("R")) {
            return READABLE.getProperty("GET_LATERALITY_R");
        }
        if (string.equalsIgnoreCase("L")) {
            return READABLE.getProperty("GET_LATERALITY_L");
        }
        if (string.equalsIgnoreCase("U")) {
            return READABLE.getProperty("GET_LATERALITY_U");
        }
        if (string.equalsIgnoreCase("B")) {
            return READABLE.getProperty("GET_LATERALITY_B");
        }
        return null;
    }

    public String getImageLaterality(String string) {
        return this.getLaterality(string);
    }

    public String getSliceLocation(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getFrameLaterality(String string) {
        return this.getLaterality(string);
    }

    public String getNominalCardiacTriggerDelayTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getActualCardiacTriggerDelayTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getRespiratoryIntervalTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getNominalRespiratoryTriggerDelayTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getActualRespiratoryTriggerDelayTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getLightPathFilterPassThroughWavelength(String string) {
        return READABLE.getProperty("NANOMETER");
    }

    public String getLightPathFilterPassBand(String string) {
        return READABLE.getProperty("NANOMETER");
    }

    public String getImagePathFilterPassThroughWavelength(String string) {
        return READABLE.getProperty("NANOMETER");
    }

    public String getImgePathFilterPassBand(String string) {
        return READABLE.getProperty("NANOMETER");
    }

    public String getSphericalLensPower(String string) {
        return READABLE.getProperty("DIOPTERS");
    }

    public String getCylinderLensPower(String string) {
        return READABLE.getProperty("DIOPTERS");
    }

    public String getCylinderAxis(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getIntraOcularPressure(String string) {
        return READABLE.getProperty("MILLIMETERS_MERCURY");
    }

    public String getHorizontalFieldOfView(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getDegreeOfDilation(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getStereoBaselineAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getStereoBaselineDisplacement(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getStereoRotation(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getAxialLengthOfTheEye(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDepthSpatialResolution(String string) {
        return READABLE.getProperty("MICRONS");
    }

    public String getAlongScanSpatialResolution(String string) {
        return READABLE.getProperty("MICRONS");
    }

    public String getDepthOfTransverseImage(String string) {
        return READABLE.getProperty("MICRONS");
    }

    public String getAcrossScanSpatialResolution(String string) {
        return READABLE.getProperty("MICRONS");
    }

    public String getIlluminationWaveLength(String string) {
        return READABLE.getProperty("NANOMETER");
    }

    public String getIlluminationPower(String string) {
        return READABLE.getProperty("MILLIWATT");
    }

    public String getIlluminationBandwidth(String string) {
        return READABLE.getProperty("NANOMETER");
    }

    public String getPlanarConfiguration(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("0")) {
            return READABLE.getProperty("COLOR_BY_PIXEL");
        }
        if (string.equals("1")) {
            return READABLE.getProperty("COLOR_BY_PLANE");
        }
        return null;
    }

    public String getUltrasoundColorDataPresent(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("00")) {
            return READABLE.getProperty("GET_ULTRASOUND_COLOR_DATA_NOT_PRESENT");
        }
        if (string.equals("01")) {
            return READABLE.getProperty("GET_ULTRASOUND_COLOR_DATA_PRESENT");
        }
        return null;
    }

    public String getPixelSpacing(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getZoomCenter(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getCorrectedImage(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("DECY")) {
            return READABLE.getProperty("GET_CORRECTED_IMAGE_DECY");
        }
        if (string.equalsIgnoreCase("ATTN")) {
            return READABLE.getProperty("GET_CORRECTED_IMAGE_ATTN");
        }
        if (string.equalsIgnoreCase("SCAT")) {
            return READABLE.getProperty("GET_CORRECTED_IMAGE_SCAT");
        }
        if (string.equalsIgnoreCase("DTIM")) {
            return READABLE.getProperty("GET_CORRECTED_IMAGE_DTIM");
        }
        if (string.equalsIgnoreCase("MOTN")) {
            return READABLE.getProperty("GET_CORRECTED_IMAGE_MOTN");
        }
        if (string.equalsIgnoreCase("PMOT")) {
            return READABLE.getProperty("GET_CORRECTED_IMAGE_PMOT");
        }
        if (string.equalsIgnoreCase("CLN")) {
            return READABLE.getProperty("GET_CORRECTED_IMAGE_CLN");
        }
        if (string.equalsIgnoreCase("RAN")) {
            return READABLE.getProperty("GET_CORRECTED_IMAGE_RAN");
        }
        if (string.equalsIgnoreCase("RADL")) {
            return READABLE.getProperty("GET_CORRECTED_IMAGE_RADL");
        }
        if (string.equalsIgnoreCase("DCAL")) {
            return READABLE.getProperty("GET_CORRECTED_IMAGE_DCAL");
        }
        if (string.equalsIgnoreCase("NORM")) {
            return READABLE.getProperty("GET_CORRECTED_IMAGE_NORM");
        }
        return null;
    }

    public String getPixelRepresentation(String string) {
        if (string == null) {
            return null;
        }
        if (0 == Integer.parseInt(string)) {
            return READABLE.getProperty("GET_PIXEL_REPRESENTATION_UNSIGNED");
        }
        if (1 == Integer.parseInt(string)) {
            return READABLE.getProperty("GET_PIXEL_REPRESENTATION_COMPLEMENT");
        }
        return null;
    }

    public String getPixelIntensityRelationship(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("LIN")) {
            return READABLE.getProperty("GET_PIXEL_INTENSITY_RELATIONSHIP_LIN");
        }
        if (string.equalsIgnoreCase("LOG")) {
            return READABLE.getProperty("GET_PIXEL_INTENSITY_RELATIONSHIP_LOG");
        }
        return null;
    }

    public String getPixelIntensityRelationshipSign(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("1")) {
            return READABLE.getProperty("GET_PIXEL_INTENSITY_RELATIONSHIP_SIGN_LOW");
        }
        if (string.equalsIgnoreCase("-1")) {
            return READABLE.getProperty("GET_PIXEL_INTENSITY_RELATIONSHIP_SIGN_HGIH");
        }
        return null;
    }

    public String getRescaleType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("US")) {
            return READABLE.getProperty("GET_RESCALE_TYPE_US");
        }
        return null;
    }

    public String getRecommandedViewingMode(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("SUB")) {
            return READABLE.getProperty("GET_RECOMMANDED_VIEWING_MODE_SUB");
        }
        if (string.equalsIgnoreCase("NAT")) {
            return READABLE.getProperty("GET_RECOMMANDED_VIEWING_MODE_NAT");
        }
        return null;
    }

    public String getLossyImageCompressionMethod(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("ISO_10918_1")) {
            return READABLE.getProperty("COMPRESSION_METHOD_ISO_10918_1");
        }
        if (string.equalsIgnoreCase("ISO_14495_1")) {
            return READABLE.getProperty("COMPRESSION_METHOD_ISO_14495_1");
        }
        if (string.equalsIgnoreCase("ISO_15444_1")) {
            return READABLE.getProperty("COMPRESSION_METHOD_ISO_15444_1");
        }
        if (string.equalsIgnoreCase("ISO_13818_2")) {
            return READABLE.getProperty("COMPRESSION_METHOD_ISO_13818_2");
        }
        return null;
    }

    public String getMaskOperation(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("AVG_SUB")) {
            return READABLE.getProperty("GET_MASK_OPERATION_AVG_SUB");
        }
        if (string.equalsIgnoreCase("TID")) {
            return READABLE.getProperty("GET_MASK_OPERATION_TID");
        }
        if (string.equalsIgnoreCase("RET_TID")) {
            return READABLE.getProperty("GET_MASK_OPERATION_RET_TID");
        }
        return null;
    }

    public String getDataRepresentation(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("COMPLEX")) {
            return READABLE.getProperty("DATA_REPRESENTATION_COMPLEX");
        }
        if (string.equalsIgnoreCase("REAL")) {
            return READABLE.getProperty("DATA_REPRESENTATION_REAL");
        }
        if (string.equalsIgnoreCase("IMAGINARY")) {
            return READABLE.getProperty("DATA_REPRESENTATION_IMAGINARY");
        }
        if (string.equalsIgnoreCase("MAGNITUDE")) {
            return READABLE.getProperty("DATA_REPRESENTATION_MAGNITUDE");
        }
        return null;
    }

    public String getSamplingFrequency(String string) {
        return READABLE.getProperty("HERTZ");
    }

    public String getChannelTimeSkew(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getChannelOffset(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getFilterLowFrequency(String string) {
        return READABLE.getProperty("HERTZ");
    }

    public String getFilterHighFrequency(String string) {
        return READABLE.getProperty("HERTZ");
    }

    public String getNotchFilterFrequency(String string) {
        return READABLE.getProperty("HERTZ");
    }

    public String getNotchFilterBandwidth(String string) {
        return READABLE.getProperty("HERTZ");
    }

    public String getWaveformDataDiaplayScale(String string) {
        return READABLE.getProperty("MILLIMETER_SECOND");
    }

    public String getScheduledProcedureStepStatus(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("SCHEDULED")) {
            return READABLE.getProperty("SCHEDULED_PROCEDURE_STEP_STATUS_SCHEDULED");
        }
        if (string.equalsIgnoreCase("ARRIVED")) {
            return READABLE.getProperty("SCHEDULED_PROCEDURE_STEP_STATUS_ARRIVED");
        }
        if (string.equalsIgnoreCase("READY")) {
            return READABLE.getProperty("SCHEDULED_PROCEDURE_STEP_STATUS_READY");
        }
        if (string.equalsIgnoreCase("STARTED")) {
            return READABLE.getProperty("SCHEDULED_PROCEDURE_STEP_STATUS_STARTED");
        }
        return null;
    }

    public String getTotalTimeOfFluoroscopy(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getEntranceDose(String string) {
        return READABLE.getProperty("DGY");
    }

    public String getExposedArea(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDistanceSourceToEntrance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getXRayOutput(String string) {
        return READABLE.getProperty("MGY_MAS");
    }

    public String getHalfValueLayer(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getOrganDose(String string) {
        return READABLE.getProperty("DGY");
    }

    public String getXOffsetInSlideCoordinateSystem(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getYOffsetInSlideCoordinateSystem(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getZOffsetInSlideCoordinateSystem(String string) {
        return READABLE.getProperty("MICRONS");
    }

    public String getParticipationType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("SOURCE")) {
            return READABLE.getProperty("GET_PARTICIPATION_TYPE_SOURCE");
        }
        if (string.equalsIgnoreCase("ENT")) {
            return READABLE.getProperty("GET_PARTICIPATION_TYPE_ENT");
        }
        if (string.equalsIgnoreCase("ATTEST")) {
            return READABLE.getProperty("GET_PARTICIPATION_TYPE_ATTEST");
        }
        return null;
    }

    public String getObserverType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("PSN")) {
            return READABLE.getProperty("GET_OBSERVER_TYPE_PSN");
        }
        if (string.equalsIgnoreCase("DEV")) {
            return READABLE.getProperty("GET_OBSERVER_TYPE_DEV");
        }
        return null;
    }

    public String getDeviceLength(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDeviceVolume(String string) {
        return READABLE.getProperty("MILLILITER");
    }

    public String getEnergyWindowLowerLimit(String string) {
        return READABLE.getProperty("KILO_ELECTRON_VOLT");
    }

    public String getEnergyWindowUpperLimit(String string) {
        return READABLE.getProperty("KILO_ELECTRON_VOLT");
    }

    public String getResidualSyringeCounts(String string) {
        return READABLE.getProperty("COUNTS_SECOND");
    }

    public String getPhaseDelay(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getPauseBetweenFrames(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getTimeSlotTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getStartAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getUnits(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("CNTS")) {
            return READABLE.getProperty("CNTS");
        }
        if (string.equalsIgnoreCase("NONE")) {
            return READABLE.getProperty("UNITLESS");
        }
        if (string.equalsIgnoreCase("CM2")) {
            return READABLE.getProperty("SQUARE_CENTIMETER");
        }
        if (string.equalsIgnoreCase("PCNT")) {
            return READABLE.getProperty("PERCENT");
        }
        if (string.equalsIgnoreCase("CPS")) {
            return READABLE.getProperty("COUNTS_SECOND");
        }
        if (string.equalsIgnoreCase("BQML")) {
            return READABLE.getProperty("BQML");
        }
        if (string.equalsIgnoreCase("MGMINML")) {
            return READABLE.getProperty("MGMINML");
        }
        if (string.equalsIgnoreCase("UMOLMINML")) {
            return READABLE.getProperty("UMOLMINML");
        }
        if (string.equalsIgnoreCase("MLMING")) {
            return READABLE.getProperty("MLMING");
        }
        if (string.equalsIgnoreCase("MLG")) {
            return READABLE.getProperty("MLG");
        }
        if (string.equalsIgnoreCase("1CM")) {
            return READABLE.getProperty("1CM");
        }
        if (string.equalsIgnoreCase("UMOLML")) {
            return READABLE.getProperty("UMOLML");
        }
        if (string.equalsIgnoreCase("PROPCNTS")) {
            return READABLE.getProperty("PROPCNTS");
        }
        if (string.equalsIgnoreCase("PROPCPS")) {
            return READABLE.getProperty("PROPCPS");
        }
        if (string.equalsIgnoreCase("MLMINML")) {
            return READABLE.getProperty("MLMINML");
        }
        if (string.equalsIgnoreCase("MLML")) {
            return READABLE.getProperty("MLML");
        }
        if (string.equalsIgnoreCase("GML")) {
            return READABLE.getProperty("GML");
        }
        if (string.equalsIgnoreCase("STDDEV")) {
            return READABLE.getProperty("STDDEV");
        }
        return null;
    }

    public String getRandomsCorrectionMethod(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("NONE")) {
            return READABLE.getProperty("GET_RANDOMS_CORRECTION_METHOD_NONE");
        }
        if (string.equalsIgnoreCase("DLYD")) {
            return READABLE.getProperty("GET_RANDOMS_CORRECTION_METHOD_DLYD");
        }
        if (string.equalsIgnoreCase("SING")) {
            return READABLE.getProperty("GET_RANDOMS_CORRECTION_METHOD_SING");
        }
        return null;
    }

    public String getDecayCorrection(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("NONE")) {
            return READABLE.getProperty("GET_DECAY_CORRECTION_NONE");
        }
        if (string.equalsIgnoreCase("START")) {
            return READABLE.getProperty("GET_DECAY_CORRECTION_START");
        }
        if (string.equalsIgnoreCase("ADMIN")) {
            return READABLE.getProperty("GET_DECAY_CORRECTION_ADMIN");
        }
        return null;
    }

    public String getAxialAcceptance(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getDetectorElementSize(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getCoincidenceWindowWidth(String string) {
        return READABLE.getProperty("NANOSECOND");
    }

    public String getSecondaryCountsType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("DLYD")) {
            return READABLE.getProperty("SECOND_COUNTS_TYPE_DLYD");
        }
        if (string.equalsIgnoreCase("SCAT")) {
            return READABLE.getProperty("SECOND_COUNTS_TYPE_SCAT");
        }
        if (string.equalsIgnoreCase("SING")) {
            return READABLE.getProperty("SECOND_COUNTS_TYPE_SING");
        }
        if (string.equalsIgnoreCase("DTIM")) {
            return READABLE.getProperty("SECOND_COUNTS_TYPE_DTIM");
        }
        return null;
    }

    public String getFrameReferenceTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getGridResolution(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getImageRotation(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getPresentationPixelSpacing(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getContourUncertaintyRadius(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getApplicationMaximumRepaintTime(String string) {
        return READABLE.getProperty("MILLISECOND");
    }

    public String getReformattingThickness(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getReformattingInterval(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getMemoryAllocation(String string) {
        return READABLE.getProperty("KILOBYTE");
    }

    public String getReflectedAmbientLight(String string) {
        return READABLE.getProperty("REFLECTED_AMBIENT_LIGHT");
    }

    public String getPrinterPixelSpacing(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getXRayImageReceptorTranslation(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getXRayImageReceptorAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getImagePlanePixelSpacing(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getRTImagePosition(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getRadiationMachineSAD(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getRadiationMachineSSD(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getRTImageSID(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getSourceToReferenceObjectDistance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDiaphragmPosition(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDoseUnits(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getNormalizationPoint(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getDVHNormalizationPoint(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getROIVolume(String string) {
        return READABLE.getProperty("CUBIT_CENTIMETER");
    }

    public String getContourSlabThickness(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getROIPhysicalProperty(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("REL_MASS_DENSITY")) {
            return READABLE.getProperty("ROI_PHYSICAL_PROPERTY_REL_MASS_DENSITY");
        }
        if (string.equalsIgnoreCase("REL_ELEC_DENSITY")) {
            return READABLE.getProperty("ROI_PHYSICAL_PROPERTY_REL_ELEC_DENSITY");
        }
        if (string.equalsIgnoreCase("EFFECTIVE_Z")) {
            return READABLE.getProperty("ROI_PHYSICAL_PROPERTY_EFFECTIVE_Z");
        }
        if (string.equalsIgnoreCase("EFF_Z_PER_A")) {
            return READABLE.getProperty("ROI_PHYSICAL_PROPERTY_EFF_Z_PER_A");
        }
        if (string.equalsIgnoreCase("REL_STOP_RATIO")) {
            return READABLE.getProperty("ROI_PHYSICAL_PROPERTY_REL_STOP_RATIO");
        }
        if (string.equalsIgnoreCase("ELEM_FRACTION")) {
            return READABLE.getProperty("ROI_PHYSICAL_PROPERTY_ELEM_FRACTION");
        }
        return null;
    }

    public String getMeasuredDoseType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("DIODE")) {
            return READABLE.getProperty("MEASURED_DOSE_TYPE_DIODE");
        }
        if (string.equalsIgnoreCase("TLD")) {
            return READABLE.getProperty("MEASURED_DOSE_TYPE_TLD");
        }
        if (string.equalsIgnoreCase("ION_CHAMBER")) {
            return READABLE.getProperty("MEASURED_DOSE_TYPE_ION_CHAMBER");
        }
        if (string.equalsIgnoreCase("GEL")) {
            return READABLE.getProperty("MEASURED_DOSE_TYPE_GEL");
        }
        if (string.equalsIgnoreCase("EPID")) {
            return READABLE.getProperty("MEASURED_DOSE_TYPE_EPID");
        }
        if (string.equalsIgnoreCase("FILM")) {
            return READABLE.getProperty("MEASURED_DOSE_TYPE_FILM");
        }
        return null;
    }

    public String getTreatmentTerminationStatus(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("NORMAL")) {
            return READABLE.getProperty("TREATMENT_TERMINATION_STATUS_NORMAL");
        }
        if (string.equalsIgnoreCase("OPERATOR")) {
            return READABLE.getProperty("TREATMENT_TERMINATION_STATUS_OPERATOR");
        }
        if (string.equalsIgnoreCase("MACHINE")) {
            return READABLE.getProperty("TREATMENT_TERMINATION_STATUS_MACHINE");
        }
        if (string.equalsIgnoreCase("UNKNOWN")) {
            return READABLE.getProperty("TREATMENT_TERMINATION_STATUS_UNKNOWN");
        }
        return null;
    }

    public String getTreatmentVerificationStatus(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("VERIFIED")) {
            return READABLE.getProperty("TREATMENT_VERIFICATION_STATUS_VERIFIED");
        }
        if (string.equalsIgnoreCase("VERIFIED_OVR")) {
            return READABLE.getProperty("TREATMENT_VERIFICATION_STATUS_VERIFIED_OVR");
        }
        if (string.equalsIgnoreCase("NOT_VERIFIED")) {
            READABLE.getProperty("TREATMENT_VERIFICATION_STATUS_NOT_VERIFIED");
        }
        return null;
    }

    public String getSpecifiedTreatmentTime(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getDeliveredTreatmentTime(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getCumulativeDoseToDoseReference(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getCalculatedDoseReferenceDoseValue(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getSpecifiedChannelTotalTime(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getDeliveredChannelTotalTime(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getSpecifiedPulseRepetitionInterval(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getDeliveredPulseRepetitionInterval(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getDeliveryWarningDose(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getDeliveryMaximumDose(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getTargetMinimumDose(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getTargetPrescriptionDose(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getTargetMaximumDose(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getOrganAtRiskFullVolumeDose(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getOrganAtRiskLimitDose(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getOrganAtRiskMaximumDose(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getPatientSupportAngleTolerance(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getTableTopEccentricAngleTolenrance(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getTableTopPitchAngleTolerance(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getTableTopRollAngleTolerance(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getTableTopVerticalPositionTolerance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTableTopLongitudinalPositionTolerance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTableTopLateralPositionTolerance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getRepeatFractionCycleLength(String string) {
        return READABLE.getProperty("WEEKS");
    }

    public String getBeamDoseSpecificationPoint(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getBeamDose(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getBeamDosePointDepth(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getBeamDosePointEquivalentDepth(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getBrachyApplicationSetupDoseSpecificationPoint(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getBrachyApplicationSetupDose(String string) {
        return READABLE.getProperty("GRAY");
    }

    public String getSourceAxisDistance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getRTBeamLimitingDeviceType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("X")) {
            return READABLE.getProperty("RT_BEAM_LIMITING_DEVICE_TYPE_X");
        }
        if (string.equalsIgnoreCase("Y")) {
            return READABLE.getProperty("RT_BEAM_LIMITING_DEVICE_TYPE_Y");
        }
        if (string.equalsIgnoreCase("ASYMX")) {
            return READABLE.getProperty("RT_BEAM_LIMITING_DEVICE_TYPE_ASYMX");
        }
        if (string.equalsIgnoreCase("ASYMY")) {
            return READABLE.getProperty("RT_BEAM_LIMITING_DEVICE_TYPE_ASYMY");
        }
        if (string.equalsIgnoreCase("MLCX")) {
            return READABLE.getProperty("RT_BEAM_LIMITING_DEVICE_TYPE_MLCX");
        }
        if (string.equalsIgnoreCase("MLCY")) {
            return READABLE.getProperty("RT_BEAM_LIMITING_DEVICE_TYPE_MLCY");
        }
        return null;
    }

    public String getSourceToBeamLimitingDeviceDistance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getIsocenterToBeamLimitingDeviceDistance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getLeafPositionBoundaries(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getHighDoseTechniqueType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("NORMAL")) {
            return READABLE.getProperty("HIGH_DOSE_TECHNIQUE_TYPE_NORMAL");
        }
        if (string.equalsIgnoreCase("TBI")) {
            return READABLE.getProperty("HIGH_DOSE_TECHNIQUE_TYPE_TBI");
        }
        if (string.equalsIgnoreCase("HDR")) {
            return READABLE.getProperty("HIGH_DOSE_RATE");
        }
        return null;
    }

    public String getTreatmentDeliveryType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("TREATMENT")) {
            return READABLE.getProperty("TREATMENT_DELIVERY_TYPE_TREATMENT");
        }
        if (string.equalsIgnoreCase("OPEN_PORTFILM")) {
            return READABLE.getProperty("TREATMENT_DELIVERY_TYPE_OPEN_PORTFILM");
        }
        if (string.equalsIgnoreCase("TRMT_PORTFILM")) {
            return READABLE.getProperty("TREATMENT_DELIVERY_TYPE_TRMT_PORTFILM");
        }
        if (string.equalsIgnoreCase("CONTINUATION")) {
            return READABLE.getProperty("TREATMENT_DELIVERY_TYPE_CONTINUATION");
        }
        if (string.equalsIgnoreCase("SETUP")) {
            return READABLE.getProperty("TREATMENT_DELIVERY_TYPE_SETUP");
        }
        return null;
    }

    public String getWedgeAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getTotalCompensatorTrayWaterEquivalentThickness(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getIsocenterToWedgeTrayDistance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getSourceToWedgeTrayDistance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getWedgeThinEdgePosition(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getSourceToCompensatorTrayDistance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getCompensatorPixelSpacing(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getTotalBlockTrayWaterEquivalentThickness(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getSourceToBlockTrayDistance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getIsocenterToBlockTrayDistance(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getBlockThickness(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getApplicatorType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("ELECTRON_SQUARE")) {
            return READABLE.getProperty("APPLICATION_TYPE_ELECTRON_SQUARE");
        }
        if (string.equalsIgnoreCase("ELECTRON_RECT")) {
            return READABLE.getProperty("APPLICATION_TYPE_ELECTRON_RECT");
        }
        if (string.equalsIgnoreCase("ELECTRON_CIRC")) {
            return READABLE.getProperty("APPLICATION_TYPE_ELECTRON_CIRC");
        }
        if (string.equalsIgnoreCase("ELECTRON_SHORT")) {
            return READABLE.getProperty("APPLICATION_TYPE_ELECTRON_SHORT");
        }
        if (string.equalsIgnoreCase("ELECTRON_OPEN")) {
            return READABLE.getProperty("APPLICATION_TYPE_ELECTRON_OPEN");
        }
        if (string.equalsIgnoreCase("INTRAOPERATIVE")) {
            return READABLE.getProperty("APPLICATION_TYPE_INTRAOPERATIVE");
        }
        if (string.equalsIgnoreCase("STEREOTACTIC")) {
            return READABLE.getProperty("APPLICATION_TYPE_STEREOTACTIC");
        }
        return null;
    }

    public String getDoseRateSet(String string) {
        return READABLE.getProperty("DOSE_RATE_SET");
    }

    public String getLeafJawPositions(String string) {
        return READABLE.getProperty("MILLIMETER");
    }

    public String getGantryAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getGantryRotationDirection(String string) {
        return this.getRotationDirection2(string);
    }

    public String getRotationDirection2(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("CW")) {
            return READABLE.getProperty("CLOCKWISE");
        }
        if (string.equalsIgnoreCase("CC")) {
            return READABLE.getProperty("CONTER_CLOCKWISE");
        }
        if (string.equalsIgnoreCase("NONE")) {
            return READABLE.getProperty("NO_ROTATION");
        }
        return null;
    }

    public String getBeamLimitingDeviceAngle(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getBeamLimitingDeviceRotationDirection(String string) {
        return this.getRotationDirection2(string);
    }

    public String getPatientSupportRotationDirection(String string) {
        return this.getRotationDirection2(string);
    }

    public String getDegrees(String string) {
        return READABLE.getProperty("DEGREES");
    }

    public String getBrachyTreatmentType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("MANUAL")) {
            return READABLE.getProperty("BRANCHY_TREATMENT_TYPE_MANUAL");
        }
        if (string.equalsIgnoreCase("HDR")) {
            return READABLE.getProperty("HIGH_DOSE_RATE");
        }
        if (string.equalsIgnoreCase("MDR")) {
            return READABLE.getProperty("BRANCHY_TREATMENT_TYPE_MDR");
        }
        if (string.equalsIgnoreCase("LDR")) {
            return READABLE.getProperty("BRANCHY_TREATMENT_TYPE_LDR");
        }
        if (string.equalsIgnoreCase("PDR")) {
            return READABLE.getProperty("BRANCHY_TREATMENT_TYPE_PDR");
        }
        return null;
    }

    public String getDays(String string) {
        return READABLE.getProperty("DAYS");
    }

    public String getSeconds(String string) {
        return READABLE.getProperty("SECONDS");
    }

    public String getOverlayType(String string) {
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("G")) {
            return READABLE.getProperty("GRAPHICS");
        }
        if (string.equalsIgnoreCase("R")) {
            return READABLE.getProperty("GET_OVERLAY_TYPE_R");
        }
        return null;
    }

    static {
        try {
            tagTable.put("(0008,0064)", ReadableValuesLookup.class.getMethod("getConversionType", String.class));
            tagTable.put("(0008,0105)", ReadableValuesLookup.class.getMethod("getMappingResource", String.class));
            tagTable.put("(0008,2110)", ReadableValuesLookup.class.getMethod("getLossyImageCompression", String.class));
            tagTable.put("(0010,0040)", ReadableValuesLookup.class.getMethod("getPatientsSex", String.class));
            tagTable.put("(0010,1010)", ReadableValuesLookup.class.getMethod("getPatientsAge", String.class));
            tagTable.put("(0010,1020)", ReadableValuesLookup.class.getMethod("getPatientsSize", String.class));
            tagTable.put("(0010,1030)", ReadableValuesLookup.class.getMethod("getPatientsWeight", String.class));
            tagTable.put("(0010,21C0)", ReadableValuesLookup.class.getMethod("getPregnancyStatus", String.class));
            tagTable.put("(0010,9431)", ReadableValuesLookup.class.getMethod("getExaminedBodyThickness", String.class));
            tagTable.put("(0018,0020)", ReadableValuesLookup.class.getMethod("getScanningSequence", String.class));
            tagTable.put("(0018,0021)", ReadableValuesLookup.class.getMethod("getSequenceVariant", String.class));
            tagTable.put("(0018,0022)", ReadableValuesLookup.class.getMethod("getScanOptions", String.class));
            tagTable.put("(0018,0028)", ReadableValuesLookup.class.getMethod("getInterventionDrugDose", String.class));
            tagTable.put("(0018,0040)", ReadableValuesLookup.class.getMethod("getCineRate", String.class));
            tagTable.put("(0018,0050)", ReadableValuesLookup.class.getMethod("getSliceThickness", String.class));
            tagTable.put("(0018,0060)", ReadableValuesLookup.class.getMethod("getKVP", String.class));
            tagTable.put("(0018,0071)", ReadableValuesLookup.class.getMethod("getAcquisitionTerminationCondition", String.class));
            tagTable.put("(0018,0072)", ReadableValuesLookup.class.getMethod("getEffectiveDuration", String.class));
            tagTable.put("(0018,0073)", ReadableValuesLookup.class.getMethod("getAcquisitionStartCondition", String.class));
            tagTable.put("(0018,0080)", ReadableValuesLookup.class.getMethod("getRepetitionTime", String.class));
            tagTable.put("(0018,0081)", ReadableValuesLookup.class.getMethod("getEchoTime", String.class));
            tagTable.put("(0018,0082)", ReadableValuesLookup.class.getMethod("getInversionTimes", String.class));
            tagTable.put("(0018,0084)", ReadableValuesLookup.class.getMethod("getImagingFrequency", String.class));
            tagTable.put("(0018,0087)", ReadableValuesLookup.class.getMethod("getMagneticFieldStrength", String.class));
            tagTable.put("(0018,0088)", ReadableValuesLookup.class.getMethod("getSpacingBetweenSlices", String.class));
            tagTable.put("(0018,0090)", ReadableValuesLookup.class.getMethod("getDataCollectionDiameter", String.class));
            tagTable.put("(0018,0095)", ReadableValuesLookup.class.getMethod("getPixelBandWidth", String.class));
            tagTable.put("(0018,1041)", ReadableValuesLookup.class.getMethod("getContrastBolusVolume", String.class));
            tagTable.put("(0018,1044)", ReadableValuesLookup.class.getMethod("getContrastBolusTotalDose", String.class));
            tagTable.put("(0018,1045)", ReadableValuesLookup.class.getMethod("getSyringeCounts", String.class));
            tagTable.put("(0018,1046)", ReadableValuesLookup.class.getMethod("getContrastFlowRate", String.class));
            tagTable.put("(0018,1049)", ReadableValuesLookup.class.getMethod("getContrastBolusIngredientConcentration", String.class));
            tagTable.put("(0018,1050)", ReadableValuesLookup.class.getMethod("getSpatialResolution", String.class));
            tagTable.put("(0018,1060)", ReadableValuesLookup.class.getMethod("getTriggerTime", String.class));
            tagTable.put("(0018,1062)", ReadableValuesLookup.class.getMethod("getNominalInterval", String.class));
            tagTable.put("(0018,1063)", ReadableValuesLookup.class.getMethod("getFrameTime", String.class));
            tagTable.put("(0018,1065)", ReadableValuesLookup.class.getMethod("getFrameTimeVector", String.class));
            tagTable.put("(0018,1066)", ReadableValuesLookup.class.getMethod("getFrameDelay", String.class));
            tagTable.put("(0018,1067)", ReadableValuesLookup.class.getMethod("getImageTriggerDelay", String.class));
            tagTable.put("(0018,1068)", ReadableValuesLookup.class.getMethod("getMultiplexGroupTimeOffset", String.class));
            tagTable.put("(0018,1069)", ReadableValuesLookup.class.getMethod("getTriggerTimeOffset", String.class));
            tagTable.put("(0010,1071)", ReadableValuesLookup.class.getMethod("getRadiopharmaceuticalVolume", String.class));
            tagTable.put("(0018,1074)", ReadableValuesLookup.class.getMethod("getRadionuclideTotalDose", String.class));
            tagTable.put("(0018,1075)", ReadableValuesLookup.class.getMethod("getRadionuclideHalfLife", String.class));
            tagTable.put("(0018,1077)", ReadableValuesLookup.class.getMethod("getRadioPharmaceuticalSpecificActivity", String.class));
            tagTable.put("(0010,1081)", ReadableValuesLookup.class.getMethod("getLowRRValue", String.class));
            tagTable.put("(0018,1082)", ReadableValuesLookup.class.getMethod("getHighRRValue", String.class));
            tagTable.put("(0010,1088)", ReadableValuesLookup.class.getMethod("getHeartRate", String.class));
            tagTable.put("(0018,1100)", ReadableValuesLookup.class.getMethod("getReconstructionDiameter", String.class));
            tagTable.put("(0018,1110)", ReadableValuesLookup.class.getMethod("getDistanceSourceToDetector", String.class));
            tagTable.put("(0018,1111)", ReadableValuesLookup.class.getMethod("getDistanceSourceToPatient", String.class));
            tagTable.put("(0018,1120)", ReadableValuesLookup.class.getMethod("getGantryDetectorTilt", String.class));
            tagTable.put("(0018,1121)", ReadableValuesLookup.class.getMethod("getGantryDetectorSlew", String.class));
            tagTable.put("(0018,1130)", ReadableValuesLookup.class.getMethod("getTableHeight", String.class));
            tagTable.put("(0018,1131)", ReadableValuesLookup.class.getMethod("getTableTraverse", String.class));
            tagTable.put("(0018,1135)", ReadableValuesLookup.class.getMethod("getTableVerticalIncrement", String.class));
            tagTable.put("(0018,1136)", ReadableValuesLookup.class.getMethod("getTableLateralIncrement", String.class));
            tagTable.put("(0018,1137)", ReadableValuesLookup.class.getMethod("getTableLongitudinalIncrement", String.class));
            tagTable.put("(0010,1138)", ReadableValuesLookup.class.getMethod("getTableAngle", String.class));
            tagTable.put("(0018,1140)", ReadableValuesLookup.class.getMethod("getRotationDirection", String.class));
            tagTable.put("(0018,1142)", ReadableValuesLookup.class.getMethod("getRadialPosition", String.class));
            tagTable.put("(0018,1143)", ReadableValuesLookup.class.getMethod("getScanArc", String.class));
            tagTable.put("(0018,1144)", ReadableValuesLookup.class.getMethod("getAngularStep", String.class));
            tagTable.put("(0018,1145)", ReadableValuesLookup.class.getMethod("getCenterOfRotationOffset", String.class));
            tagTable.put("(0018,1149)", ReadableValuesLookup.class.getMethod("getFieldOfViewDimensions", String.class));
            tagTable.put("(0018,1150)", ReadableValuesLookup.class.getMethod("getExposureTime", String.class));
            tagTable.put("(0018,1151)", ReadableValuesLookup.class.getMethod("getXRayTubeCurrent", String.class));
            tagTable.put("(0018,1152)", ReadableValuesLookup.class.getMethod("getExposure", String.class));
            tagTable.put("(0018,1154)", ReadableValuesLookup.class.getMethod("getAveragePulseWidth", String.class));
            tagTable.put("(0018,1155)", ReadableValuesLookup.class.getMethod("getRadiationSetting", String.class));
            tagTable.put("(0018,115E)", ReadableValuesLookup.class.getMethod("getImageAndFluoroscopyAreaDoseProduct", String.class));
            tagTable.put("(0018,1162)", ReadableValuesLookup.class.getMethod("getIntensifierSize", String.class));
            tagTable.put("(0018,1164)", ReadableValuesLookup.class.getMethod("getImagerPixelSpacing", String.class));
            tagTable.put("(0018,1170)", ReadableValuesLookup.class.getMethod("getGeneratorPower", String.class));
            tagTable.put("(0018,1181)", ReadableValuesLookup.class.getMethod("getCollimatorType", String.class));
            tagTable.put("(0018,1182)", ReadableValuesLookup.class.getMethod("getFocalDistance", String.class));
            tagTable.put("(0018,1183)", ReadableValuesLookup.class.getMethod("getXFocusCenter", String.class));
            tagTable.put("(0018,1184)", ReadableValuesLookup.class.getMethod("getYFocusCenter", String.class));
            tagTable.put("(0018,1190)", ReadableValuesLookup.class.getMethod("getFocalSpot", String.class));
            tagTable.put("(0018,11A0)", ReadableValuesLookup.class.getMethod("getBodyPartThickness", String.class));
            tagTable.put("(0018,11A2)", ReadableValuesLookup.class.getMethod("getCompressionForce", String.class));
            tagTable.put("(0018,1242)", ReadableValuesLookup.class.getMethod("getActualFrameDuration", String.class));
            tagTable.put("(0018,1243)", ReadableValuesLookup.class.getMethod("getCountRate", String.class));
            tagTable.put("(0018,1300)", ReadableValuesLookup.class.getMethod("getScanVelocity", String.class));
            tagTable.put("(0018,1301)", ReadableValuesLookup.class.getMethod("getWholeBodyTechnique", String.class));
            tagTable.put("(0018,1302)", ReadableValuesLookup.class.getMethod("getScanLength", String.class));
            tagTable.put("(0018,1314)", ReadableValuesLookup.class.getMethod("getFlipAngle", String.class));
            tagTable.put("(0018,1316)", ReadableValuesLookup.class.getMethod("getSAR", String.class));
            tagTable.put("(0018,1318)", ReadableValuesLookup.class.getMethod("getDbDt", String.class));
            tagTable.put("(0018,1450)", ReadableValuesLookup.class.getMethod("getColumnAngulation", String.class));
            tagTable.put("(0018,1460)", ReadableValuesLookup.class.getMethod("getTomoLayerHeight", String.class));
            tagTable.put("(0018,1470)", ReadableValuesLookup.class.getMethod("getTomoAngle", String.class));
            tagTable.put("(0018,1480)", ReadableValuesLookup.class.getMethod("getTomoTime", String.class));
            tagTable.put("(0018,1510)", ReadableValuesLookup.class.getMethod("getPositionerPrimaryAngle", String.class));
            tagTable.put("(0018,1511)", ReadableValuesLookup.class.getMethod("getPositionerSecondaryAngle", String.class));
            tagTable.put("(0018,1520)", ReadableValuesLookup.class.getMethod("getPositionerPrimaryAngleIncrement", String.class));
            tagTable.put("(0018,1521)", ReadableValuesLookup.class.getMethod("getPositionerSecondaryAngleIncrement", String.class));
            tagTable.put("(0018,1530)", ReadableValuesLookup.class.getMethod("getDetectorPrimaryAngle", String.class));
            tagTable.put("(0018,1531)", ReadableValuesLookup.class.getMethod("getDetectorSecondaryAngle", String.class));
            tagTable.put("(0018,1802)", ReadableValuesLookup.class.getMethod("getTimeDistributionProtocol", String.class));
            tagTable.put("(0018,2003)", ReadableValuesLookup.class.getMethod("getFramePrimaryAngleVector", String.class));
            tagTable.put("(0018,2004)", ReadableValuesLookup.class.getMethod("getFrameSeondaryAngleVector", String.class));
            tagTable.put("(0018,2005)", ReadableValuesLookup.class.getMethod("getSliceLocationVector", String.class));
            tagTable.put("(0018,2010)", ReadableValuesLookup.class.getMethod("getNominalScannedPixelSpacing", String.class));
            tagTable.put("(0018,2030)", ReadableValuesLookup.class.getMethod("getRotationOfScannedFilm", String.class));
            tagTable.put("(0018,3101)", ReadableValuesLookup.class.getMethod("getIVUSPullbackRate", String.class));
            tagTable.put("(0018,3102)", ReadableValuesLookup.class.getMethod("getIVUSGatedRate", String.class));
            tagTable.put("(0018,5012)", ReadableValuesLookup.class.getMethod("getFocusDepth", String.class));
            tagTable.put("(0018,5050)", ReadableValuesLookup.class.getMethod("getDepthOfScanField", String.class));
            tagTable.put("(0018,5101)", ReadableValuesLookup.class.getMethod("getViewPosition", String.class));
            tagTable.put("(0018,6012)", ReadableValuesLookup.class.getMethod("getRegionSpatialFormat", String.class));
            tagTable.put("(0018,6014)", ReadableValuesLookup.class.getMethod("getRegionDataType", String.class));
            tagTable.put("(0018,6016)", ReadableValuesLookup.class.getMethod("getRegionFlags", String.class));
            tagTable.put("(0018,6024)", ReadableValuesLookup.class.getMethod("getPhysicalUnitsXDirection", String.class));
            tagTable.put("(0018,6026)", ReadableValuesLookup.class.getMethod("getPhysicalUnitsYDirection", String.class));
            tagTable.put("(0018,6032)", ReadableValuesLookup.class.getMethod("getPulseRepetitionFrequency", String.class));
            tagTable.put("(0018,6034)", ReadableValuesLookup.class.getMethod("getDopplerCorrectionAngle", String.class));
            tagTable.put("(0018,6036)", ReadableValuesLookup.class.getMethod("getSteeringAngle", String.class));
            tagTable.put("(0018,6039)", ReadableValuesLookup.class.getMethod("getDopplerSampleVolumeXPosition", String.class));
            tagTable.put("(0018,603B)", ReadableValuesLookup.class.getMethod("getDopplerSampleVolumeYPosition", String.class));
            tagTable.put("(0018,6044)", ReadableValuesLookup.class.getMethod("getPixelComponentOrganization", String.class));
            tagTable.put("(0018,604E)", ReadableValuesLookup.class.getMethod("getPixelComponentDataType", String.class));
            tagTable.put("(0018,6060)", ReadableValuesLookup.class.getMethod("getRWaveTimeVector", String.class));
            tagTable.put("(0018,7001)", ReadableValuesLookup.class.getMethod("getDetectorTemperature", String.class));
            tagTable.put("(0018,7012)", ReadableValuesLookup.class.getMethod("getDetectorTimeSinceLastExposure", String.class));
            tagTable.put("(0018,7014)", ReadableValuesLookup.class.getMethod("getDetectorActiveTime", String.class));
            tagTable.put("(0018,7016)", ReadableValuesLookup.class.getMethod("getDetectorActivationOffsetFromExposure", String.class));
            tagTable.put("(0018,7020)", ReadableValuesLookup.class.getMethod("getDetectorElementPhysicalSize", String.class));
            tagTable.put("(0018,7022)", ReadableValuesLookup.class.getMethod("getDetectorElementSpacing", String.class));
            tagTable.put("(0018,7026)", ReadableValuesLookup.class.getMethod("getDetectorActiveDimensions", String.class));
            tagTable.put("(0018,7032)", ReadableValuesLookup.class.getMethod("getFieldOfViewRotation", String.class));
            tagTable.put("(0018,7042)", ReadableValuesLookup.class.getMethod("getGridThickness", String.class));
            tagTable.put("(0018,7044)", ReadableValuesLookup.class.getMethod("getGridPitch", String.class));
            tagTable.put("(0018,7048)", ReadableValuesLookup.class.getMethod("getGridPeriod", String.class));
            tagTable.put("(0018,704C)", ReadableValuesLookup.class.getMethod("getGridFocalDistance", String.class));
            tagTable.put("(0018,7052)", ReadableValuesLookup.class.getMethod("getFilterThicknessMinimum", String.class));
            tagTable.put("(0018,7054)", ReadableValuesLookup.class.getMethod("getFilterThicknessMaximum", String.class));
            tagTable.put("(0018,9019)", ReadableValuesLookup.class.getMethod("getTagAngleFirstAxis", String.class));
            tagTable.put("(0018,9029)", ReadableValuesLookup.class.getMethod("getOversamplingPhase", String.class));
            tagTable.put("(0018,9030)", ReadableValuesLookup.class.getMethod("getTagSpacingFirstDimension", String.class));
            tagTable.put("(0018,9035)", ReadableValuesLookup.class.getMethod("getTagThickness", String.class));
            tagTable.put("(0018,9052)", ReadableValuesLookup.class.getMethod("getSpectralWidth", String.class));
            tagTable.put("(0018,9053)", ReadableValuesLookup.class.getMethod("getChemicalShiftReference", String.class));
            tagTable.put("(0018,9061)", ReadableValuesLookup.class.getMethod("getDecouplingFrequency", String.class));
            tagTable.put("(0018,9063)", ReadableValuesLookup.class.getMethod("getDecouplingChemicalShiftReference", String.class));
            tagTable.put("(0018,9073)", ReadableValuesLookup.class.getMethod("getAcquisitionDuration", String.class));
            tagTable.put("(0018,0082)", ReadableValuesLookup.class.getMethod("getInversionTimes", String.class));
            tagTable.put("(0018,9082)", ReadableValuesLookup.class.getMethod("getEffectiveEchoTime", String.class));
            tagTable.put("(0018,9085)", ReadableValuesLookup.class.getMethod("getCardiacSignalSource", String.class));
            tagTable.put("(0018,9087)", ReadableValuesLookup.class.getMethod("getDiffusionBValue", String.class));
            tagTable.put("(0018,9091)", ReadableValuesLookup.class.getMethod("getVelocityEncodingMinimumValue", String.class));
            tagTable.put("(0018,9098)", ReadableValuesLookup.class.getMethod("getTransmitterFrequency", String.class));
            tagTable.put("(0018,9104)", ReadableValuesLookup.class.getMethod("getSlabThickness", String.class));
            tagTable.put("(0018,9106)", ReadableValuesLookup.class.getMethod("getMidSlabPosition", String.class));
            tagTable.put("(0018,9180)", ReadableValuesLookup.class.getMethod("getGradientOutputType", String.class));
            tagTable.put("(0018,9181)", ReadableValuesLookup.class.getMethod("getSpecificAbsorptionRateValue", String.class));
            tagTable.put("(0018,9184)", ReadableValuesLookup.class.getMethod("getTaggingDelay", String.class));
            tagTable.put("(0018,9217)", ReadableValuesLookup.class.getMethod("getVelocityEncodingMaximumValue", String.class));
            tagTable.put("(0018,9218)", ReadableValuesLookup.class.getMethod("getTagSpacingSecondDimension", String.class));
            tagTable.put("(0018,9219)", ReadableValuesLookup.class.getMethod("getTagAngleSecondAxis", String.class));
            tagTable.put("(0018,9220)", ReadableValuesLookup.class.getMethod("getFrameAcquisitionDuration", String.class));
            tagTable.put("(0018,9303)", ReadableValuesLookup.class.getMethod("getTubeAngle", String.class));
            tagTable.put("(0018,9305)", ReadableValuesLookup.class.getMethod("getRevolutionTime", String.class));
            tagTable.put("(0018,9306)", ReadableValuesLookup.class.getMethod("getSingleCollimationWidth", String.class));
            tagTable.put("(0018,9307)", ReadableValuesLookup.class.getMethod("getTotalCollimationWidth", String.class));
            tagTable.put("(0018,9309)", ReadableValuesLookup.class.getMethod("getTableSpeed", String.class));
            tagTable.put("(0018,9310)", ReadableValuesLookup.class.getMethod("getTableFeedPerRotation", String.class));
            tagTable.put("(0018,9313)", ReadableValuesLookup.class.getMethod("getDataCollectionCenter", String.class));
            tagTable.put("(0018,9317)", ReadableValuesLookup.class.getMethod("getReconstructionFieldOfView", String.class));
            tagTable.put("(0018,9318)", ReadableValuesLookup.class.getMethod("getReconstructionTargetCenter", String.class));
            tagTable.put("(0018,9319)", ReadableValuesLookup.class.getMethod("getReconstructionAngle", String.class));
            tagTable.put("(0018,9322)", ReadableValuesLookup.class.getMethod("getReconstructionPixelSpacing", String.class));
            tagTable.put("(0018,9327)", ReadableValuesLookup.class.getMethod("getTablePosition", String.class));
            tagTable.put("(0018,9335)", ReadableValuesLookup.class.getMethod("getDistanceSourceToDataCollectionCenter", String.class));
            tagTable.put("(0018,9345)", ReadableValuesLookup.class.getMethod("getCTDIVol", String.class));
            tagTable.put("(0018,9402)", ReadableValuesLookup.class.getMethod("getDistanceSourceToIsocenter", String.class));
            tagTable.put("(0018,9403)", ReadableValuesLookup.class.getMethod("getDistanceObjectToTableTop", String.class));
            tagTable.put("(0018,9404)", ReadableValuesLookup.class.getMethod("getObjectPixelSpacingInCenterOfBeam", String.class));
            tagTable.put("(0018,9426)", ReadableValuesLookup.class.getMethod("getDistanceReceptorPlaneToDetectorHousing", String.class));
            tagTable.put("(0018,9428)", ReadableValuesLookup.class.getMethod("getIntensifierActiveDimensions", String.class));
            tagTable.put("(0018,9429)", ReadableValuesLookup.class.getMethod("getPhysicalDetectorSize", String.class));
            tagTable.put("(0018,9447)", ReadableValuesLookup.class.getMethod("getColumnAngulation", String.class));
            tagTable.put("(0018,9449)", ReadableValuesLookup.class.getMethod("getBeamAngle", String.class));
            tagTable.put("(0018,9452)", ReadableValuesLookup.class.getMethod("getCalculatedAnatomyThickness", String.class));
            tagTable.put("(0018,9461)", ReadableValuesLookup.class.getMethod("getFieldOfViewDimensionsInFloat", String.class));
            tagTable.put("(0018,9463)", ReadableValuesLookup.class.getMethod("getPositionerIsocenterPrimaryAngle", String.class));
            tagTable.put("(0018,9464)", ReadableValuesLookup.class.getMethod("getPositionerIsocenterSecondaryAngle", String.class));
            tagTable.put("(0018,9465)", ReadableValuesLookup.class.getMethod("getPositionerIsocenterDetectorRotationAngle", String.class));
            tagTable.put("(0018,9466)", ReadableValuesLookup.class.getMethod("getTableXPositionToIsocenter", String.class));
            tagTable.put("(0018,9467)", ReadableValuesLookup.class.getMethod("getTableYPositionToIsocenter", String.class));
            tagTable.put("(0018,9468)", ReadableValuesLookup.class.getMethod("getTableZPositionToIsocenter", String.class));
            tagTable.put("(0018,9469)", ReadableValuesLookup.class.getMethod("getTableHorizontalRotationAngle", String.class));
            tagTable.put("(0018,9470)", ReadableValuesLookup.class.getMethod("getTableHeadTiltAngle", String.class));
            tagTable.put("(0018,9471)", ReadableValuesLookup.class.getMethod("getTableCradleTiltAngle", String.class));
            tagTable.put("(0018,9473)", ReadableValuesLookup.class.getMethod("getAcquiredImageAreaDoseProduct", String.class));
            tagTable.put("(0018,9508)", ReadableValuesLookup.class.getMethod("getPrimaryPositionerScanArc", String.class));
            tagTable.put("(0018,9509)", ReadableValuesLookup.class.getMethod("getSecondaryPositionerScanArc", String.class));
            tagTable.put("(0018,9510)", ReadableValuesLookup.class.getMethod("getPrimaryPositionerScanStartAngle", String.class));
            tagTable.put("(0018,9511)", ReadableValuesLookup.class.getMethod("getSecondaryPositionerScanStartAngle", String.class));
            tagTable.put("(0018,9514)", ReadableValuesLookup.class.getMethod("getPrimaryPositionerIncrement", String.class));
            tagTable.put("(0018,9515)", ReadableValuesLookup.class.getMethod("getSecondaryPositionerIncrement", String.class));
            tagTable.put("(0020,0032)", ReadableValuesLookup.class.getMethod("getImagePosition", String.class));
            tagTable.put("(0020,0060)", ReadableValuesLookup.class.getMethod("getLaterality", String.class));
            tagTable.put("(0020,0062)", ReadableValuesLookup.class.getMethod("getImageLaterality", String.class));
            tagTable.put("(0020,1041)", ReadableValuesLookup.class.getMethod("getSliceLocation", String.class));
            tagTable.put("(0020,9072)", ReadableValuesLookup.class.getMethod("getFrameLaterality", String.class));
            tagTable.put("(0020,9153)", ReadableValuesLookup.class.getMethod("getNominalCardiacTriggerDelayTime", String.class));
            tagTable.put("(0020,9252)", ReadableValuesLookup.class.getMethod("getActualCardiacTriggerDelayTime", String.class));
            tagTable.put("(0020,9254)", ReadableValuesLookup.class.getMethod("getRespiratoryIntervalTime", String.class));
            tagTable.put("(0020,9255)", ReadableValuesLookup.class.getMethod("getNominalRespiratoryTriggerDelayTime", String.class));
            tagTable.put("(0020,9257)", ReadableValuesLookup.class.getMethod("getActualRespiratoryTriggerDelayTime", String.class));
            tagTable.put("(0022,0001)", ReadableValuesLookup.class.getMethod("getLightPathFilterPassThroughWavelength", String.class));
            tagTable.put("(0022,0002)", ReadableValuesLookup.class.getMethod("getLightPathFilterPassBand", String.class));
            tagTable.put("(0022,0003)", ReadableValuesLookup.class.getMethod("getImagePathFilterPassThroughWavelength", String.class));
            tagTable.put("(0022,0004)", ReadableValuesLookup.class.getMethod("getImgePathFilterPassBand", String.class));
            tagTable.put("(0022,0007)", ReadableValuesLookup.class.getMethod("getSphericalLensPower", String.class));
            tagTable.put("(0022,0008)", ReadableValuesLookup.class.getMethod("getCylinderLensPower", String.class));
            tagTable.put("(0022,0009)", ReadableValuesLookup.class.getMethod("getCylinderAxis", String.class));
            tagTable.put("(0022,000B)", ReadableValuesLookup.class.getMethod("getIntraOcularPressure", String.class));
            tagTable.put("(0022,000C)", ReadableValuesLookup.class.getMethod("getHorizontalFieldOfView", String.class));
            tagTable.put("(0022,000E)", ReadableValuesLookup.class.getMethod("getDegreeOfDilation", String.class));
            tagTable.put("(0022,0010)", ReadableValuesLookup.class.getMethod("getStereoBaselineAngle", String.class));
            tagTable.put("(0022,0011)", ReadableValuesLookup.class.getMethod("getStereoBaselineDisplacement", String.class));
            tagTable.put("(0022,0014)", ReadableValuesLookup.class.getMethod("getStereoRotation", String.class));
            tagTable.put("(0022,0030)", ReadableValuesLookup.class.getMethod("getAxialLengthOfTheEye", String.class));
            tagTable.put("(0022,0035)", ReadableValuesLookup.class.getMethod("getDepthSpatialResolution", String.class));
            tagTable.put("(0022,0037)", ReadableValuesLookup.class.getMethod("getAlongScanSpatialResolution", String.class));
            tagTable.put("(0022,0041)", ReadableValuesLookup.class.getMethod("getDepthOfTransverseImage", String.class));
            tagTable.put("(0022,0048)", ReadableValuesLookup.class.getMethod("getAcrossScanSpatialResolution", String.class));
            tagTable.put("(0022,0055)", ReadableValuesLookup.class.getMethod("getIlluminationWaveLength", String.class));
            tagTable.put("(0022,0056)", ReadableValuesLookup.class.getMethod("getIlluminationPower", String.class));
            tagTable.put("(0022,0057)", ReadableValuesLookup.class.getMethod("getIlluminationBandwidth", String.class));
            tagTable.put("(0028,0006)", ReadableValuesLookup.class.getMethod("getPlanarConfiguration", String.class));
            tagTable.put("(0028,0014)", ReadableValuesLookup.class.getMethod("getUltrasoundColorDataPresent", String.class));
            tagTable.put("(0028,0030)", ReadableValuesLookup.class.getMethod("getPixelSpacing", String.class));
            tagTable.put("(0020,0032)", ReadableValuesLookup.class.getMethod("getZoomCenter", String.class));
            tagTable.put("(0028,0051)", ReadableValuesLookup.class.getMethod("getCorrectedImage", String.class));
            tagTable.put("(0028,0103)", ReadableValuesLookup.class.getMethod("getPixelRepresentation", String.class));
            tagTable.put("(0028,1040)", ReadableValuesLookup.class.getMethod("getPixelIntensityRelationship", String.class));
            tagTable.put("(0028,1041)", ReadableValuesLookup.class.getMethod("getPixelIntensityRelationshipSign", String.class));
            tagTable.put("(0028,1054)", ReadableValuesLookup.class.getMethod("getRescaleType", String.class));
            tagTable.put("(0028,1090)", ReadableValuesLookup.class.getMethod("getRecommandedViewingMode", String.class));
            tagTable.put("(0028,2110)", ReadableValuesLookup.class.getMethod("getLossyImageCompression", String.class));
            tagTable.put("(0028,2114)", ReadableValuesLookup.class.getMethod("getLossyImageCompressionMethod", String.class));
            tagTable.put("(0028,6101)", ReadableValuesLookup.class.getMethod("getMaskOperation", String.class));
            tagTable.put("(0028,9108)", ReadableValuesLookup.class.getMethod("getDataRepresentation", String.class));
            tagTable.put("(003A,001A)", ReadableValuesLookup.class.getMethod("getSamplingFrequency", String.class));
            tagTable.put("(003A,0214)", ReadableValuesLookup.class.getMethod("getChannelTimeSkew", String.class));
            tagTable.put("(003A,0218)", ReadableValuesLookup.class.getMethod("getChannelOffset", String.class));
            tagTable.put("(003A,0220)", ReadableValuesLookup.class.getMethod("getFilterLowFrequency", String.class));
            tagTable.put("(003A,0221)", ReadableValuesLookup.class.getMethod("getFilterHighFrequency", String.class));
            tagTable.put("(003A,0222)", ReadableValuesLookup.class.getMethod("getNotchFilterFrequency", String.class));
            tagTable.put("(003A,0223)", ReadableValuesLookup.class.getMethod("getNotchFilterBandwidth", String.class));
            tagTable.put("(003A,0230)", ReadableValuesLookup.class.getMethod("getWaveformDataDiaplayScale", String.class));
            tagTable.put("(0040,0020)", ReadableValuesLookup.class.getMethod("getScheduledProcedureStepStatus", String.class));
            tagTable.put("(0040,0300)", ReadableValuesLookup.class.getMethod("getTotalTimeOfFluoroscopy", String.class));
            tagTable.put("(0040,0302)", ReadableValuesLookup.class.getMethod("getEntranceDose", String.class));
            tagTable.put("(0040,0303)", ReadableValuesLookup.class.getMethod("getExposedArea", String.class));
            tagTable.put("(0040,0306)", ReadableValuesLookup.class.getMethod("getDistanceSourceToEntrance", String.class));
            tagTable.put("(0040,0312)", ReadableValuesLookup.class.getMethod("getXRayOutput", String.class));
            tagTable.put("(0040,0314)", ReadableValuesLookup.class.getMethod("getHalfValueLayer", String.class));
            tagTable.put("(0040,0316)", ReadableValuesLookup.class.getMethod("getOrganDose", String.class));
            tagTable.put("(0040,072A)", ReadableValuesLookup.class.getMethod("getXOffsetInSlideCoordinateSystem", String.class));
            tagTable.put("(0040,073A)", ReadableValuesLookup.class.getMethod("getYOffsetInSlideCoordinateSystem", String.class));
            tagTable.put("(0040,074A)", ReadableValuesLookup.class.getMethod("getZOffsetInSlideCoordinateSystem", String.class));
            tagTable.put("(0040,A080)", ReadableValuesLookup.class.getMethod("getParticipationType", String.class));
            tagTable.put("(0040,A084)", ReadableValuesLookup.class.getMethod("getObserverType", String.class));
            tagTable.put("(0050,0014)", ReadableValuesLookup.class.getMethod("getDeviceLength", String.class));
            tagTable.put("(0050,0018)", ReadableValuesLookup.class.getMethod("getDeviceVolume", String.class));
            tagTable.put("(0054,0014)", ReadableValuesLookup.class.getMethod("getEnergyWindowLowerLimit", String.class));
            tagTable.put("(0054,0015)", ReadableValuesLookup.class.getMethod("getEnergyWindowUpperLimit", String.class));
            tagTable.put("(0054,0017)", ReadableValuesLookup.class.getMethod("getResidualSyringeCounts", String.class));
            tagTable.put("(0054,0036)", ReadableValuesLookup.class.getMethod("getPhaseDelay", String.class));
            tagTable.put("(0054,0038)", ReadableValuesLookup.class.getMethod("getPauseBetweenFrames", String.class));
            tagTable.put("(0054,0073)", ReadableValuesLookup.class.getMethod("getTimeSlotTime", String.class));
            tagTable.put("(0054,0200)", ReadableValuesLookup.class.getMethod("getStartAngle", String.class));
            tagTable.put("(0054,1001)", ReadableValuesLookup.class.getMethod("getUnits", String.class));
            tagTable.put("(0054,1100)", ReadableValuesLookup.class.getMethod("getRandomsCorrectionMethod", String.class));
            tagTable.put("(0054,1102)", ReadableValuesLookup.class.getMethod("getDecayCorrection", String.class));
            tagTable.put("(0054,1200)", ReadableValuesLookup.class.getMethod("getAxialAcceptance", String.class));
            tagTable.put("(0054,1203)", ReadableValuesLookup.class.getMethod("getDetectorElementSize", String.class));
            tagTable.put("(0054,1210)", ReadableValuesLookup.class.getMethod("getCoincidenceWindowWidth", String.class));
            tagTable.put("(0054,1220)", ReadableValuesLookup.class.getMethod("getSecondaryCountsType", String.class));
            tagTable.put("(0054,1300)", ReadableValuesLookup.class.getMethod("getFrameReferenceTime", String.class));
            tagTable.put("(0064,0008)", ReadableValuesLookup.class.getMethod("getGridResolution", String.class));
            tagTable.put("(0070,0042)", ReadableValuesLookup.class.getMethod("getImageRotation", String.class));
            tagTable.put("(0070,0101)", ReadableValuesLookup.class.getMethod("getPresentationPixelSpacing", String.class));
            tagTable.put("(0070,0312)", ReadableValuesLookup.class.getMethod("getContourUncertaintyRadius", String.class));
            tagTable.put("(0072,010E)", ReadableValuesLookup.class.getMethod("getApplicationMaximumRepaintTime", String.class));
            tagTable.put("(0072,0512)", ReadableValuesLookup.class.getMethod("getReformattingThickness", String.class));
            tagTable.put("(0072,0514)", ReadableValuesLookup.class.getMethod("getReformattingInterval", String.class));
            tagTable.put("(2000,0060)", ReadableValuesLookup.class.getMethod("getMemoryAllocation", String.class));
            tagTable.put("(2010,0160)", ReadableValuesLookup.class.getMethod("getReflectedAmbientLight", String.class));
            tagTable.put("(2010,0376)", ReadableValuesLookup.class.getMethod("getPrinterPixelSpacing", String.class));
            tagTable.put("(3002,000D)", ReadableValuesLookup.class.getMethod("getXRayImageReceptorTranslation", String.class));
            tagTable.put("(3002,000E)", ReadableValuesLookup.class.getMethod("getXRayImageReceptorAngle", String.class));
            tagTable.put("(3002,0011)", ReadableValuesLookup.class.getMethod("getImagePlanePixelSpacing", String.class));
            tagTable.put("(3002,0012)", ReadableValuesLookup.class.getMethod("getRTImagePosition", String.class));
            tagTable.put("(3002,0022)", ReadableValuesLookup.class.getMethod("getRadiationMachineSAD", String.class));
            tagTable.put("(3002,0024)", ReadableValuesLookup.class.getMethod("getRadiationMachineSSD", String.class));
            tagTable.put("(3002,0026)", ReadableValuesLookup.class.getMethod("getRTImageSID", String.class));
            tagTable.put("(3002,0028)", ReadableValuesLookup.class.getMethod("getSourceToReferenceObjectDistance", String.class));
            tagTable.put("(3002,0034)", ReadableValuesLookup.class.getMethod("getDiaphragmPosition", String.class));
            tagTable.put("(3004,0002)", ReadableValuesLookup.class.getMethod("getDoseUnits", String.class));
            tagTable.put("(3004,0008)", ReadableValuesLookup.class.getMethod("getNormalizationPoint", String.class));
            tagTable.put("(3004,0040)", ReadableValuesLookup.class.getMethod("getDVHNormalizationPoint", String.class));
            tagTable.put("(3006,002C)", ReadableValuesLookup.class.getMethod("getROIVolume", String.class));
            tagTable.put("(3006,0044)", ReadableValuesLookup.class.getMethod("getContourSlabThickness", String.class));
            tagTable.put("(3006,00B2)", ReadableValuesLookup.class.getMethod("getROIPhysicalProperty", String.class));
            tagTable.put("(3008,0014)", ReadableValuesLookup.class.getMethod("getMeasuredDoseType", String.class));
            tagTable.put("(3008,002A)", ReadableValuesLookup.class.getMethod("getTreatmentTerminationStatus", String.class));
            tagTable.put("(3008,002C)", ReadableValuesLookup.class.getMethod("getTreatmentVerificationStatus", String.class));
            tagTable.put("(3008,003A)", ReadableValuesLookup.class.getMethod("getSpecifiedTreatmentTime", String.class));
            tagTable.put("(3008,003B)", ReadableValuesLookup.class.getMethod("getDeliveredTreatmentTime", String.class));
            tagTable.put("(3008,0052)", ReadableValuesLookup.class.getMethod("getCumulativeDoseToDoseReference", String.class));
            tagTable.put("(3008,0076)", ReadableValuesLookup.class.getMethod("getCalculatedDoseReferenceDoseValue", String.class));
            tagTable.put("(3008,0132)", ReadableValuesLookup.class.getMethod("getSpecifiedChannelTotalTime", String.class));
            tagTable.put("(3008,0134)", ReadableValuesLookup.class.getMethod("getDeliveredChannelTotalTime", String.class));
            tagTable.put("(3008,013A)", ReadableValuesLookup.class.getMethod("getSpecifiedPulseRepetitionInterval", String.class));
            tagTable.put("(3008,013C)", ReadableValuesLookup.class.getMethod("getDeliveredPulseRepetitionInterval", String.class));
            tagTable.put("(300A,0022)", ReadableValuesLookup.class.getMethod("getDeliveryWarningDose", String.class));
            tagTable.put("(300A,0023)", ReadableValuesLookup.class.getMethod("getDeliveryMaximumDose", String.class));
            tagTable.put("(300A,0025)", ReadableValuesLookup.class.getMethod("getTargetMinimumDose", String.class));
            tagTable.put("(300A,0026)", ReadableValuesLookup.class.getMethod("getTargetPrescriptionDose", String.class));
            tagTable.put("(200A,0027)", ReadableValuesLookup.class.getMethod("getTargetMaximumDose", String.class));
            tagTable.put("(300A,002A)", ReadableValuesLookup.class.getMethod("getOrganAtRiskFullVolumeDose", String.class));
            tagTable.put("(300A,002B)", ReadableValuesLookup.class.getMethod("getOrganAtRiskLimitDose", String.class));
            tagTable.put("(300A,002C)", ReadableValuesLookup.class.getMethod("getOrganAtRiskMaximumDose", String.class));
            tagTable.put("(300A,004C)", ReadableValuesLookup.class.getMethod("getPatientSupportAngleTolerance", String.class));
            tagTable.put("(300A,004E)", ReadableValuesLookup.class.getMethod("getTableTopEccentricAngleTolenrance", String.class));
            tagTable.put("(300A,004F)", ReadableValuesLookup.class.getMethod("getTableTopPitchAngleTolerance", String.class));
            tagTable.put("(300A,0050)", ReadableValuesLookup.class.getMethod("getTableTopRollAngleTolerance", String.class));
            tagTable.put("(300A,0051)", ReadableValuesLookup.class.getMethod("getTableTopVerticalPositionTolerance", String.class));
            tagTable.put("(300A,0052)", ReadableValuesLookup.class.getMethod("getTableTopLongitudinalPositionTolerance", String.class));
            tagTable.put("(300A,0053)", ReadableValuesLookup.class.getMethod("getTableTopLateralPositionTolerance", String.class));
            tagTable.put("(300A,007A)", ReadableValuesLookup.class.getMethod("getRepeatFractionCycleLength", String.class));
            tagTable.put("(300A,0082)", ReadableValuesLookup.class.getMethod("getBeamDoseSpecificationPoint", String.class));
            tagTable.put("(300A,0084)", ReadableValuesLookup.class.getMethod("getBeamDose", String.class));
            tagTable.put("(300A,0088)", ReadableValuesLookup.class.getMethod("getBeamDosePointDepth", String.class));
            tagTable.put("(300A,0089)", ReadableValuesLookup.class.getMethod("getBeamDosePointEquivalentDepth", String.class));
            tagTable.put("(300A,00A2)", ReadableValuesLookup.class.getMethod("getBrachyApplicationSetupDoseSpecificationPoint", String.class));
            tagTable.put("(300A,00A4)", ReadableValuesLookup.class.getMethod("getBrachyApplicationSetupDose", String.class));
            tagTable.put("(300A,00B4)", ReadableValuesLookup.class.getMethod("getSourceAxisDistance", String.class));
            tagTable.put("(300A,00B8)", ReadableValuesLookup.class.getMethod("getRTBeamLimitingDeviceType", String.class));
            tagTable.put("(300A,00BA)", ReadableValuesLookup.class.getMethod("getSourceToBeamLimitingDeviceDistance", String.class));
            tagTable.put("(300A,00BB)", ReadableValuesLookup.class.getMethod("getIsocenterToBeamLimitingDeviceDistance", String.class));
            tagTable.put("(300A,00BE)", ReadableValuesLookup.class.getMethod("getLeafPositionBoundaries", String.class));
            tagTable.put("(300A,00C7)", ReadableValuesLookup.class.getMethod("getHighDoseTechniqueType", String.class));
            tagTable.put("(300A,00CE)", ReadableValuesLookup.class.getMethod("getTreatmentDeliveryType", String.class));
            tagTable.put("(300A,00D5)", ReadableValuesLookup.class.getMethod("getWedgeAngle", String.class));
            tagTable.put("(300A,02E3)", ReadableValuesLookup.class.getMethod("getTotalCompensatorTrayWaterEquivalentThickness", String.class));
            tagTable.put("(300A,00D9)", ReadableValuesLookup.class.getMethod("getIsocenterToWedgeTrayDistance", String.class));
            tagTable.put("(300A,00DA)", ReadableValuesLookup.class.getMethod("getSourceToWedgeTrayDistance", String.class));
            tagTable.put("(300A,00DB)", ReadableValuesLookup.class.getMethod("getWedgeThinEdgePosition", String.class));
            tagTable.put("(300A,00E6)", ReadableValuesLookup.class.getMethod("getSourceToCompensatorTrayDistance", String.class));
            tagTable.put("(300A,00E9)", ReadableValuesLookup.class.getMethod("getCompensatorPixelSpacing", String.class));
            tagTable.put("(300A,00F3)", ReadableValuesLookup.class.getMethod("getTotalBlockTrayWaterEquivalentThickness", String.class));
            tagTable.put("(300A,00F6)", ReadableValuesLookup.class.getMethod("getSourceToBlockTrayDistance", String.class));
            tagTable.put("(300A,00F7)", ReadableValuesLookup.class.getMethod("getIsocenterToBlockTrayDistance", String.class));
            tagTable.put("(300A,0100)", ReadableValuesLookup.class.getMethod("getBlockThickness", String.class));
            tagTable.put("(300A,00F9)", ReadableValuesLookup.class.getMethod("getApplicatorType", String.class));
            tagTable.put("(300A,0115)", ReadableValuesLookup.class.getMethod("getDoseRateSet", String.class));
            tagTable.put("(300A,011C)", ReadableValuesLookup.class.getMethod("getLeafJawPositions", String.class));
            tagTable.put("(300A,011E)", ReadableValuesLookup.class.getMethod("getGantryAngle", String.class));
            tagTable.put("(300A,011F)", ReadableValuesLookup.class.getMethod("getGantryRotationDirection", String.class));
            tagTable.put("(300A,0120)", ReadableValuesLookup.class.getMethod("getBeamLimitingDeviceAngle", String.class));
            tagTable.put("(300A,0120)", ReadableValuesLookup.class.getMethod("getBeamLimitingDeviceRotationDirection", String.class));
            tagTable.put("(300A,0122)", ReadableValuesLookup.class.getMethod("getDegrees", String.class));
            tagTable.put("(300A,0123)", ReadableValuesLookup.class.getMethod("getPatientSupportRotationDirection", String.class));
            tagTable.put("(300A,0124)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0125)", ReadableValuesLookup.class.getMethod("getDegrees", String.class));
            tagTable.put("(300A,0126)", ReadableValuesLookup.class.getMethod("getRotationDirection2", String.class));
            tagTable.put("(300A,0128)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0129)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,012A)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,012C)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,012E)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0130)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0140)", ReadableValuesLookup.class.getMethod("getDegrees", String.class));
            tagTable.put("(300A,0142)", ReadableValuesLookup.class.getMethod("getRotationDirection2", String.class));
            tagTable.put("(300A,0144)", ReadableValuesLookup.class.getMethod("getDegrees", String.class));
            tagTable.put("(300A,0146)", ReadableValuesLookup.class.getMethod("getRotationDirection2", String.class));
            tagTable.put("(300A,0148)", ReadableValuesLookup.class.getMethod("getDegrees", String.class));
            tagTable.put("(300A,014A)", ReadableValuesLookup.class.getMethod("getDegrees", String.class));
            tagTable.put("(300A,014C)", ReadableValuesLookup.class.getMethod("getRotationDirection2", String.class));
            tagTable.put("(300A,014E)", ReadableValuesLookup.class.getMethod("getDegrees", String.class));
            tagTable.put("(300A,0199)", ReadableValuesLookup.class.getMethod("getDegrees", String.class));
            tagTable.put("(300A,019A)", ReadableValuesLookup.class.getMethod("getDegrees", String.class));
            tagTable.put("(300A,01D2)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,01D4)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,01D6)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0202)", ReadableValuesLookup.class.getMethod("getBrachyTreatmentType", String.class));
            tagTable.put("(300A,0216)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,021A)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0222)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0228)", ReadableValuesLookup.class.getMethod("getDays", String.class));
            tagTable.put("(300A,0284)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,028C)", ReadableValuesLookup.class.getMethod("getSeconds", String.class));
            tagTable.put("(300A,029C)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,02A0)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,02A4)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,02B8)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,02E2)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,02E3)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,02E4)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,02E6)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,02E8)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,030D)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,033C)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0356)", ReadableValuesLookup.class.getMethod("getDegrees", String.class));
            tagTable.put("(300A,0358)", ReadableValuesLookup.class.getMethod("getDegrees", String.class));
            tagTable.put("(300A,0364)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0366)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0374)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0386)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0388)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,038A)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0394)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(300A,0398)", ReadableValuesLookup.class.getMethod("getMM", String.class));
            tagTable.put("(60XX,0040)", ReadableValuesLookup.class.getMethod("getOverlayType", String.class));
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }
}

