/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mimvista.numerics.MathUtils;
import java.io.Serializable;

public class RescaleConverter
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    public float slope;
    public float intercept;
    public float unitScale;

    public static RescaleConverter createFromMaxMin(float f2, float f3) {
        int n2 = Float.compare(f3, 0.0f) == 0 ? 0 : -32766;
        int n3 = Short.MAX_VALUE;
        float f4 = (f2 - f3) / (float)(n3 - n2);
        float f5 = (f3 * (float)n3 - f2 * (float)n2) / (float)(n3 - n2);
        return new RescaleConverter(f4, f5);
    }

    public RescaleConverter() {
        this(1.0f, 0.0f, 1.0f);
    }

    public RescaleConverter(float f2, float f3) {
        this(f2, f3, 1.0f);
    }

    public RescaleConverter(float f2, float f3, float f4) {
        this.slope = f2;
        this.intercept = f3;
        this.unitScale = f4;
    }

    public float apply(short s2) {
        return ((float)s2 * this.slope + this.intercept) * this.unitScale;
    }

    public float apply(int n2) {
        return ((float)n2 * this.slope + this.intercept) * this.unitScale;
    }

    public float apply(float f2) {
        return (f2 * this.slope + this.intercept) * this.unitScale;
    }

    public float applyContrastWidth(float f2) {
        return f2 * this.slope * this.unitScale;
    }

    public int removeWithBounds(float f2) {
        int n2 = Math.round(this.removeRaw(f2));
        n2 = n2 > Short.MIN_VALUE ? n2 : Short.MIN_VALUE;
        n2 = n2 < Short.MAX_VALUE ? n2 : Short.MAX_VALUE;
        return n2;
    }

    public float removeRaw(float f2) {
        return (f2 / this.unitScale - this.intercept) / this.slope;
    }

    public double removeRaw(double d2) {
        return (d2 / (double)this.unitScale - (double)this.intercept) / (double)this.slope;
    }

    public float removeRawWithBounds(float f2) {
        float f3 = this.removeRaw(f2);
        f3 = f3 > -32768.0f ? f3 : -32768.0f;
        f3 = f3 < 32767.0f ? f3 : 32767.0f;
        return f3;
    }

    public float removeContrastWidth(float f2) {
        return f2 / this.unitScale / this.slope;
    }

    public RescaleConverter clone() {
        try {
            return (RescaleConverter)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public boolean equals(Object object) {
        float f2 = 1.0E-4f;
        if (object instanceof RescaleConverter) {
            RescaleConverter rescaleConverter = (RescaleConverter)object;
            if (MathUtils.a(rescaleConverter.intercept, this.intercept, f2) && MathUtils.a(rescaleConverter.slope, this.slope, f2) && MathUtils.a(rescaleConverter.unitScale, this.unitScale, f2)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.slope * 101.0f) + (int)(this.intercept * 97.0f) * (int)(this.unitScale * 53.0f);
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (Throwable throwable) {
            return super.toString();
        }
    }

    public RescaleConverter rescaleAndSimplify(float f2) {
        RescaleConverter rescaleConverter = this.clone();
        float f3 = f2 * this.unitScale;
        rescaleConverter.slope *= f3;
        rescaleConverter.intercept *= f3;
        rescaleConverter.unitScale = 1.0f;
        return rescaleConverter;
    }
}

