/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.archive.Parser;
import com.mimvista.archive.search.LocalSearchSource;
import com.mimvista.archive.search.RemoteSearchSource;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.dicom.DcmCaptureToImageConverter;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.read.Dicom2DLoader;
import com.mimvista.dicom.read.DicomVolumeLoaderFactory;
import com.mimvista.dicom.read.LoaderDataProvider;
import com.mimvista.dicom.util.ExtendPanel;
import com.mimvista.file.MIMFile;
import com.mimvista.gui.util.ImageManipulator;
import com.mimvista.internals.MimPlanarImage;
import com.mimvista.metabase.s;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.mui.ak;
import com.mimvista.preferencesNew.DcmSecondaryCapturePrefs;
import com.mimvista.preferencesNew.ImagecapturePrefs;
import com.mimvista.properties.ab;
import com.mimvista.properties.bl;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.a;
import com.mimvista.swing.widgets.u;
import com.mimvista.user.LoginChecker;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.progress.o;
import com.mimvista.workflow.backend.x;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SaveCaptureAsImageFrame
extends JDialog {
    private static final long serialVersionUID = -3543819772512618826L;
    public static Messages props = Messages.a("Archive");
    private static File defaultFolder = new File(ab.m());
    private JComboBox typeCombo;
    private JLabel folderLabel = null;
    private JTextField folderPath = new JTextField();
    private JLabel fileNameLabel = null;
    private JTextField fileName = new JTextField();
    private JButton openButton = new JButton(props.getProperty("SAVECAP_FRAME_OPEN"), ImageManipulator.c("folder_with_page", 18));
    protected JButton continueButton = new JButton(props.getProperty("SAVECAP_FRAME_CONTINUE"), ImageManipulator.c("save", 18));
    protected JButton cancelButton = new JButton(props.getProperty("SAVECAP_FRAME_CANCEL"), ImageManipulator.c("stop_sign", 18));
    private Notification dialogNot;
    private DcmSeries series;
    private SearchSource lastSearchedSource;
    private ArrayList<DcmSeries> errorConverting;
    public boolean done = false;

    public SaveCaptureAsImageFrame(DcmSeries dcmSeries, SearchSource searchSource, ArrayList<DcmSeries> arrayList) {
        this.series = dcmSeries;
        this.lastSearchedSource = searchSource;
        this.errorConverting = arrayList;
        this.buildGui();
        this.initialize();
    }

    private void buildGui() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(this.series.getNumberOfImages() + " " + props.getProperty("SAVECAP_FRAME_IMAGENUMBER"));
        this.folderLabel = new JLabel(props.getProperty("SAVECAP_FRAME_SAVE"));
        this.fileNameLabel = new JLabel(props.getProperty("SAVECAP_FRAME_FILE_NAME"));
        this.add(this.getSourceInfoPanel(), new Insets(0, 10, 0, 0), 2, 17, 0, 0, 0, 0, 4, 1);
        this.add(jLabel, new Insets(0, 10, 0, 0), 0, 17, 0, 0, 0, 1, 1, 1);
        this.add(new JLabel(), new Insets(0, 0, 0, 0), 2, 17, 100, 100, 1, 1, 1, 1);
        this.add(new JLabel(props.getProperty("SAVECAP_FRAME_FILE_TYPE")), new Insets(0, 0, 0, 0), 0, 13, 0, 0, 2, 1, 1, 1);
        this.typeCombo = this.getTypeCombo();
        this.add(this.typeCombo, new Insets(0, 0, 0, 0), 0, 13, 0, 0, 3, 1, 1, 1);
        this.add(this.folderLabel, new Insets(0, 10, 5, 0), 0, 17, 0, 0, 0, 2, 4, 1);
        this.add(this.getFolderPathPanel(), new Insets(0, 10, 0, 0), 2, 17, 0, 0, 0, 3, 4, 1);
        this.add(this.fileNameLabel, new Insets(5, 10, 5, 0), 0, 17, 0, 0, 0, 4, 4, 1);
        this.add(this.fileName, new Insets(0, 10, 0, 0), 2, 17, 0, 0, 0, 5, 4, 1);
        this.add(this.getControlButtonPanel(), new Insets(0, 0, 0, 0), 2, 17, 0, 0, 0, 6, 4, 1);
    }

    private void initialize() {
        if (this.lastSearchedSource instanceof LocalSearchSource) {
            String string = this.lastSearchedSource.a(this.series, new o());
            File file = new File(string);
            Dicom2DLoader<MimPlanarImage> dicom2DLoader = DicomVolumeLoaderFactory.getDefault2DLoader();
            dicom2DLoader.load(o.o(), new LoaderDataProvider.FileBasedLoaderDataProvider(file.listFiles()));
            MimPlanarImage mimPlanarImage = dicom2DLoader.getImages().get(0);
            this.fileName.setText(DcmCaptureToImageConverter.getUniqueFilename(mimPlanarImage.getUncopiedMutableInfo()));
        } else if (this.lastSearchedSource instanceof RemoteSearchSource) {
            Object object;
            TreeMap<Integer, String> treeMap = null;
            try {
                object = s.a((RemoteSearchSource)this.lastSearchedSource);
                treeMap = object.dicomDump(((RemoteSearchSource)this.lastSearchedSource).y().k(), this.series.getArchiveDir(), LoginChecker.getInstance().currentCookieBox());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (treeMap != null) {
                object = (String)treeMap.get(0x100010);
                String string = (String)treeMap.get(0x100020);
                String string2 = treeMap.get(4235553);
                String string3 = treeMap.get(528446);
                String string4 = treeMap.get(0x20000E);
                this.fileName.setText(DcmCaptureToImageConverter.getUniqueFilename((String)object, string, string2, string3, string4));
            }
        }
    }

    private JPanel getSourceInfoPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(10));
        Box box = new Box(2);
        box.add(new JLabel(props.getProperty("SAVECAP_FRAME_SOURCE_INFO")));
        box.add(Box.createHorizontalGlue());
        jPanel.add(box);
        Box box2 = new Box(2);
        box2.add(new JLabel(props.getProperty("SAVECAP_FRAME_PATIENT_NAME")));
        box2.add(Box.createHorizontalStrut(150));
        box2.add(new JLabel(this.series.getPatientName()));
        box2.add(Box.createHorizontalGlue());
        jPanel.add(box2);
        Box box3 = new Box(2);
        box3.add(new JLabel(props.getProperty("SAVECAP_FRAME_PATIENT_ID")));
        box3.add(Box.createHorizontalStrut(171));
        box3.add(new JLabel(this.series.getPatientID()));
        box3.add(Box.createHorizontalGlue());
        jPanel.add(box3);
        Box box4 = new Box(2);
        box4.add(new JLabel(props.getProperty("SAVECAP_FRAME_DATE")));
        box4.add(Box.createHorizontalStrut(198));
        box4.add(new JLabel(this.series.getDate()));
        box4.add(Box.createHorizontalGlue());
        jPanel.add(box4);
        Box box5 = new Box(2);
        box5.add(new JLabel(props.getProperty("SAVECAP_FRAME_SERIES_DES")));
        box5.add(Box.createHorizontalStrut(124));
        box5.add(new JLabel(this.series.getSeriesDescription()));
        box5.add(Box.createHorizontalGlue());
        jPanel.add(box5);
        return jPanel;
    }

    private JComboBox getTypeCombo() {
        JComboBox<Object> jComboBox = new JComboBox<Object>(ab.j.toArray());
        for (bl bl2 : ab.j) {
            if (!bl2.b().equalsIgnoreCase(DcmSecondaryCapturePrefs.captureFileType.getValue())) continue;
            jComboBox.setSelectedItem(bl2);
            break;
        }
        return jComboBox;
    }

    private JPanel getFolderPathPanel() {
        ExtendPanel extendPanel = new ExtendPanel();
        extendPanel.setLayout(new GridBagLayout());
        extendPanel.add(this.folderPath, new Insets(0, 0, 0, 0), 2, 13, 100, 0, 0, 0, 1, 1);
        File file = ImagecapturePrefs.lastCaptureDirectory.getValue();
        if (DcmSecondaryCapturePrefs.useDefaultImageFileLocation.getValue().booleanValue()) {
            file = ImagecapturePrefs.defaultCaptureDirectory.getValue();
        }
        if (file == null && defaultFolder != null) {
            file = defaultFolder;
        }
        this.folderPath.setText(file == null ? "" : file.getAbsolutePath());
        extendPanel.add(this.openButton, new Insets(0, 0, 0, 0), 0, 17, 0, 0, 1, 0, 1, 1);
        return extendPanel;
    }

    private JPanel getControlButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        jPanel.add(this.continueButton);
        jPanel.add(this.cancelButton);
        return jPanel;
    }

    public void init() {
        this.dialogNot = new a(Messages.a("Commands", "SAVE_CAPTURES_NAME"), "capture_save_page"){

            @Override
            public Container getContent() {
                return SaveCaptureAsImageFrame.this.getContentPane();
            }

            @Override
            public boolean shouldPopInfo() {
                return true;
            }
        };
        u.b().c(this.dialogNot);
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MIMFileDialog mIMFileDialog = MIMFileDialog.a(ak.b().O(), props.getProperty("SAVECAP_FRAME_DESTINATION"), MIMFileDialog.FileDialogType.a, MIMFileDialog.FileDialogSelectionMode.b, true);
                mIMFileDialog.b(SaveCaptureAsImageFrame.this.folderPath.getText());
                mIMFileDialog.a(true);
                String string = mIMFileDialog.a();
                if (string == null) {
                    return;
                }
                SaveCaptureAsImageFrame.this.folderPath.setText(mIMFileDialog.a());
                defaultFolder = new File(mIMFileDialog.a());
            }
        });
        this.continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                Object object2;
                String string = SaveCaptureAsImageFrame.this.folderPath.getText();
                if (string.trim().length() == 0) {
                    JOptionPane.showMessageDialog(ak.b().M(), SaveCaptureAsImageFrame.this.folderLabel.getText() + " " + props.getProperty("SAVECAP_FRAME_CANNOT_EMPTY"));
                    return;
                }
                if (SaveCaptureAsImageFrame.this.fileName.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog(ak.b().M(), SaveCaptureAsImageFrame.this.fileNameLabel.getText() + " " + props.getProperty("SAVECAP_FRAME_CANNOT_EMPTY"));
                    SaveCaptureAsImageFrame.this.initialize();
                    return;
                }
                boolean bl2 = SaveCaptureAsImageFrame.this.askForOverride();
                if (!bl2) {
                    return;
                }
                if (!new File(string).exists()) {
                    new File(string).mkdirs();
                }
                String string2 = string;
                String string3 = string;
                if (DcmSecondaryCapturePrefs.saveInAbcFolders.getValue().booleanValue()) {
                    object2 = x.c(SaveCaptureAsImageFrame.this.series.getTagValue(0x100010, String.class));
                    object2 = "".equals(object2) ? "_" : ((String)object2).substring(0, 1);
                    object = new MIMFile(string, ((String)object2).toUpperCase());
                    ((File)object).mkdirs();
                    string3 = ((File)object).getAbsolutePath();
                }
                u.b().d(SaveCaptureAsImageFrame.this.dialogNot);
                if (SaveCaptureAsImageFrame.isTypeSC(SaveCaptureAsImageFrame.this.series)) {
                    object2 = (bl)SaveCaptureAsImageFrame.this.typeCombo.getSelectedItem();
                    object = ((bl)object2).b();
                    boolean bl3 = DcmCaptureToImageConverter.convert(SaveCaptureAsImageFrame.this.series, SaveCaptureAsImageFrame.this.lastSearchedSource, string3, SaveCaptureAsImageFrame.this.fileName.getText(), (String)object);
                    if (!bl3) {
                        SaveCaptureAsImageFrame.this.errorConverting.add(SaveCaptureAsImageFrame.this.series);
                    }
                    SaveCaptureAsImageFrame.this.done = true;
                    ImagecapturePrefs.lastCaptureDirectory.setValue(new File(string2));
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                u.b().d(SaveCaptureAsImageFrame.this.dialogNot);
                SaveCaptureAsImageFrame.this.done = true;
            }
        });
    }

    public static boolean isTypeSC(DcmSeries dcmSeries) {
        TreeMap<Integer, String> treeMap = null;
        try {
            treeMap = com.mimvista.archive.gui.a.a(dcmSeries);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ay.d((Object)("Couldn't found the series: " + dcmSeries), fileNotFoundException);
            return false;
        }
        if (treeMap == null) {
            return false;
        }
        String string = treeMap.get(524310);
        return string != null && (string.equals("1.2.840.10008.5.1.4.1.1.7") || string.equals("1.2.840.10008.5.1.4.1.1.7.4"));
    }

    private boolean askForOverride() {
        File[] fileArray;
        int n2 = Parser.getNumSeriesRelatedInstances(this.series.getArchiveDir());
        String string = this.fileName.getText();
        String string2 = ((bl)this.typeCombo.getSelectedItem()).b();
        File file = new File(this.folderPath.getText());
        if (!file.exists()) {
            return true;
        }
        for (File file2 : fileArray = file.listFiles()) {
            if (!this.alreadyExist(file2, string, n2, string2)) continue;
            Object[] objectArray = new Object[]{props.getProperty("SAVECAP_FRAME_YES_TO_ALL"), Messages.a("General").getProperty("YES"), props.getProperty("SAVECAP_FRAME_CANCEL")};
            String string3 = MIMFormat.a(props.getProperty("SAVECAP_FRAME_OVERRIDE_WARNING"), file2.getName());
            int n3 = JOptionPane.showOptionDialog(ak.b().M(), string3, props.getProperty("SAVECAP_FRAME_WARNING"), 0, 2, null, objectArray, objectArray[0]);
            if (n3 == 2) {
                return false;
            }
            if (n3 != 0) continue;
            return true;
        }
        return true;
    }

    private boolean alreadyExist(File file, String string, int n2, String string2) {
        if (n2 == 1) {
            return file.getName().equals(string + "." + string2);
        }
        String string3 = file.getName();
        if (!string3.startsWith(string + "_")) {
            return false;
        }
        if (!(string3 = string3.substring((string + "_").length())).endsWith("." + string2)) {
            return false;
        }
        string3 = string3.substring(0, string3.length() - ("." + string2).length());
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n3 > 0 && n3 < n2;
    }

    private boolean probabilyExist(String string, String string2, String string3) {
        File file = new File(string);
        if (file.exists()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                if (file2.isFile() && file2.getName().equals(string2 + "." + string3)) {
                    return true;
                }
                if (!file2.isFile() || !file2.getName().startsWith(string2 + "_") || !file2.getName().endsWith("." + string3)) continue;
                return true;
            }
        }
        return false;
    }

    protected void add(Component component, Insets insets, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (insets != null) {
            gridBagConstraints.insets = insets;
        }
        if (n2 != -100) {
            gridBagConstraints.fill = n2;
        }
        if (n3 != -100) {
            gridBagConstraints.anchor = n3;
        }
        if (n4 != -100) {
            gridBagConstraints.weightx = n4;
        }
        if (n5 != -100) {
            gridBagConstraints.weighty = n5;
        }
        if (n6 != -100) {
            gridBagConstraints.gridx = n6;
        }
        if (n7 != -100) {
            gridBagConstraints.gridy = n7;
        }
        if (n8 != -100) {
            gridBagConstraints.gridwidth = n8;
        }
        if (n9 != -100) {
            gridBagConstraints.gridheight = n9;
        }
        this.add(component, gridBagConstraints);
    }
}

