/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.SendToDestinationUIFactory;
import com.mimvista.archive.gui.SeriesFilesTransfer;
import com.mimvista.archive.gui.ag;
import com.mimvista.dicom.DcmSeries;
import com.mimvista.dicom.util.secondarycapture.DefaultCaptureImageWriter;
import com.mimvista.dicom.util.secondarycapture.SecondaryCaptureImageHandler;
import com.mimvista.file.MIMFile;
import com.mimvista.file.PathUtils;
import com.mimvista.gui.util.AbstractInputContainer;
import com.mimvista.gui.util.FileBrowser;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.k;
import com.mimvista.gui.util.l;
import com.mimvista.mui.MIMFileDialog;
import com.mimvista.mui.ak;
import com.mimvista.properties.ab;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.o;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DocumentFilter;
import net.tomahawk.ExtensionsFilter;
import org.dcm4che2.util.DateUtils;

public class SecondaryCaptureImageFrame {
    public static Messages props = Messages.a("Dicom");
    private static File lastVisitedFolder = new File(ab.m());
    private JLabel patientNameLabel;
    private JLabel patientIdLabel;
    private JLabel modalityLabel;
    private JLabel dateLabel;
    private JLabel studyDescLabel;
    private JLabel seriesDescLabel;
    private l<SendToDestination> destInput;
    private JComboBox destCombo;
    private l<String> imageInput;
    private FileBrowser fileBrowser;
    private l<String> seriesDescInput;
    private JFormattedTextField seriesDescText;
    private TreeMap<Integer, String> tagsMap;
    private DcmSeries series;
    private String targetSeriesDescriptionString = "";
    private SeriesDescDocuemntFilter seriesDescDocumentFilter = new SeriesDescDocuemntFilter();
    private static String patientName = props.getProperty("PATIENT_NAME");
    private static String patientID = props.getProperty("PATIENT_ID");
    private static String modality = props.getProperty("MODALITY");
    private static String date = props.getProperty("DATE");
    private static String studyDesc = props.getProperty("STUDY_DESC");
    private static String seriesDesc = props.getProperty("SERIES_DESC");

    public SecondaryCaptureImageFrame(TreeMap<Integer, String> treeMap, DcmSeries dcmSeries) {
        this.tagsMap = treeMap;
        this.series = dcmSeries;
    }

    public void showGui() {
        this.buildGui();
        this.initializeValues();
    }

    private void initializeValues() {
        this.patientNameLabel.setText(this.null2Blank(this.tagsMap.get(0x100010)));
        this.patientIdLabel.setText(this.null2Blank(this.tagsMap.get(0x100020)));
        this.modalityLabel.setText(this.null2Blank(this.tagsMap.get(524384)));
        this.dateLabel.setText(this.getFullDate());
        this.studyDescLabel.setText(this.null2Blank(this.tagsMap.get(528432)));
        this.seriesDescLabel.setText(this.null2Blank(this.tagsMap.get(528446)));
        this.setDestination();
        this.fileBrowser.b(lastVisitedFolder.getAbsolutePath());
        this.targetSeriesDescriptionString = this.null2Blank(this.tagsMap.get(528446));
        this.setSeriesDescription(this.targetSeriesDescriptionString);
    }

    private String null2Blank(String string) {
        return string == null ? "" : string;
    }

    private void setDestination() {
        List<SendToDestination> list;
        SendToDestination sendToDestination = ag.a(null);
        if (sendToDestination == null && (sendToDestination = ag.a(this.series.getSearchSource())) == null && (list = ag.a(ag.a(true, true, true, true))).size() > 0) {
            sendToDestination = list.get(0);
        }
        if (sendToDestination != null) {
            this.destInput.a(sendToDestination);
        }
    }

    private String getFullDate() {
        String string = "";
        Date date = DateUtils.parseDA((String)this.tagsMap.get(524320), (boolean)false);
        string = string + new SimpleDateFormat("MM-dd-yyyy").format(date);
        Date date2 = DateUtils.parseTM((String)this.tagsMap.get(524336), (boolean)false);
        string = string + " " + new SimpleDateFormat("HH:mm:ss").format(date2);
        return string;
    }

    private void buildGui() {
        InputNotification inputNotification = new InputNotification(new Notification.a(), Messages.a("Dicom", "DICOM_SAVE_FUSION_SECONDARY_CAPTURE"), "modify_data");
        inputNotification.addLabel(props.getProperty("ENCAPSULATE_FRAME_SOURCE_INFO"));
        inputNotification.setScrollBarType(AbstractInputContainer.ScrollBarType.b);
        this.patientNameLabel = inputNotification.addCollection(patientName, null, 0).b("");
        this.patientIdLabel = inputNotification.addCollection(patientID, null, 0).b("");
        this.modalityLabel = inputNotification.addCollection(modality, null, 0).b("");
        this.dateLabel = inputNotification.addCollection(date, null, 0).b("");
        this.studyDescLabel = inputNotification.addCollection(studyDesc, null, 0).b("");
        this.seriesDescLabel = inputNotification.addCollection(seriesDesc, null, 0).b("");
        List<SendToDestination> list = ag.a(ag.a(true, true, true, true));
        this.destInput = inputNotification.addComboBox(props.getProperty("ENCAPSULATE_FRAME_DESTINATION"), list.toArray(new SendToDestination[0]));
        this.destCombo = (JComboBox)this.destInput.g();
        this.destCombo.setRenderer(new SendToDestinationUIFactory.SourceOrDestListCellRenderer());
        this.imageInput = inputNotification.addFileBrowser(props.getProperty("ENCAPSULATE_FRAME_IMAGE"), MIMFileDialog.FileDialogType.a, new ExtensionsFilter(props.getProperty("ENCAPSULATE_FRAME_IMAGE_DESCRIPTION"), "png", "bmp", "jpg", "jpeg", "gif", "tiff"));
        this.fileBrowser = (FileBrowser)this.imageInput.g();
        this.fileBrowser.a(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                File file = new File(SecondaryCaptureImageFrame.this.fileBrowser.b());
                lastVisitedFolder = file;
                SecondaryCaptureImageFrame.this.updateSeriesDescText(file);
            }
        });
        this.imageInput.a(new k(){

            @Override
            public String validate(Object object) {
                if (cn.h((String)SecondaryCaptureImageFrame.this.imageInput.b())) {
                    return props.getProperty("SECONDARY_CAP_IMG_FRAME_ATTACH");
                }
                return null;
            }
        });
        this.seriesDescInput = inputNotification.addFormattedTextField(props.getProperty("SERIES_DESC"));
        this.seriesDescText = (JFormattedTextField)this.seriesDescInput.g();
        this.seriesDescText.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){
            DefaultFormatter formatter = new DefaultFormatter(){
                private static final long serialVersionUID = 1L;

                @Override
                protected DocumentFilter getDocumentFilter() {
                    return SecondaryCaptureImageFrame.this.seriesDescDocumentFilter;
                }
            };

            @Override
            public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField jFormattedTextField) {
                return this.formatter;
            }
        });
        inputNotification.setShowReset(false);
        inputNotification.setOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new Thread(){

                    @Override
                    public void run() {
                        SecondaryCaptureImageFrame.this.createDicom();
                    }
                }.start();
            }
        });
        if (!inputNotification.containedInGrandNotifier()) {
            inputNotification.addToGrandNotifier();
        } else {
            inputNotification.selectMe();
        }
    }

    private void createDicom() {
        block4: {
            String string = null;
            try {
                ArrayList<BufferedImage> arrayList = new ArrayList<BufferedImage>();
                BufferedImage bufferedImage = ImageIO.read(new File(this.imageInput.b()));
                if (bufferedImage == null) {
                    throw new IOException(this.imageInput.b() + " cannot be read");
                }
                arrayList.add(bufferedImage);
                DefaultCaptureImageWriter defaultCaptureImageWriter = new DefaultCaptureImageWriter(this.tagsMap, arrayList);
                defaultCaptureImageWriter.setSeriesDescription(this.seriesDescInput.b().trim());
                SecondaryCaptureImageHandler secondaryCaptureImageHandler = new SecondaryCaptureImageHandler(defaultCaptureImageWriter, new o());
                string = PathUtils.getTempPathUnique("scImFrame").getAbsolutePath();
                if (secondaryCaptureImageHandler.write(string)) {
                    new SeriesFilesTransfer(this.series.getSearchSource(), string).a((SendToDestination)this.destCombo.getSelectedItem());
                }
                new MIMFile(string).delete();
            }
            catch (IOException iOException) {
                ay.d((Object)iOException, this);
                JOptionPane.showMessageDialog(ak.b().M(), Messages.a("Archive").getProperty("SECONDARY_CAP_IMG_ACTION_CAP_FAIL"), "", 2);
                if (string == null) break block4;
                new MIMFile(string).delete();
            }
        }
    }

    private void updateSeriesDescText(File file) {
        this.seriesDescDocumentFilter.setImageName(file.getName());
    }

    private void setSeriesDescription(String string) {
        this.seriesDescInput.a(string);
        this.seriesDescText.setText(string);
    }

    private class SeriesDescDocuemntFilter
    extends DocumentFilter {
        private String imageName = "";

        private SeriesDescDocuemntFilter() {
        }

        public void setImageName(String string) {
            String string2 = this.getSeriesDes();
            this.imageName = " (" + string + ")";
            SecondaryCaptureImageFrame.this.seriesDescText.setText(string2 + this.imageName);
        }

        public String getSeriesDes() {
            String string = SecondaryCaptureImageFrame.this.seriesDescText.getText();
            if (this.imageName.trim().length() != 0 && string.endsWith(this.imageName)) {
                string = string.substring(0, string.length() - this.imageName.length());
            }
            return string;
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass filterBypass, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = SecondaryCaptureImageFrame.this.seriesDescText.getText();
            if (this.imageName.trim().length() == 0 || !string2.endsWith(this.imageName)) {
                super.insertString(filterBypass, n2, string, attributeSet);
            } else if (n2 <= string2.length() - this.imageName.length()) {
                super.insertString(filterBypass, n2, string, attributeSet);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass filterBypass, int n2, int n3, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2 = SecondaryCaptureImageFrame.this.seriesDescText.getText();
            if (this.imageName.trim().length() == 0 || !string2.endsWith(this.imageName)) {
                super.replace(filterBypass, n2, n3, string, attributeSet);
            } else if (n2 + n3 <= string2.length() - this.imageName.length()) {
                super.replace(filterBypass, n2, n3, string, attributeSet);
                if (string.trim().length() == 0) {
                    throw new IllegalArgumentException();
                }
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass filterBypass, int n2, int n3) throws BadLocationException {
            String string = SecondaryCaptureImageFrame.this.seriesDescText.getText();
            if (this.imageName.trim().length() == 0 || !string.endsWith(this.imageName)) {
                super.remove(filterBypass, n2, n3);
            } else {
                int n4 = this.imageName == null ? 0 : this.imageName.length();
                if (n2 < string.length() - n4) {
                    if (n2 + n3 < string.length() - n4) {
                        super.remove(filterBypass, n2, n3);
                    } else {
                        super.remove(filterBypass, n2, string.length() - n4 - n2);
                    }
                }
            }
        }
    }
}

