/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.collect.Lists;
import com.jayway.jsonpath.JsonPath;
import com.mimvista.dicom.JsonPathUtil;
import com.mimvista.dicom.util.DicomTagParseException;
import com.mimvista.dicom.util.TagPathComponent;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.metabase.MetabaseKeys;
import com.mimvista.util.Pair;
import com.mimvista.util.bm;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.dcm4che2.data.DicomObject;

public class TagPath
implements bm,
Serializable,
Comparable<TagPath> {
    private static final long serialVersionUID = 1L;
    private List<TagPathComponent> tagIndexPairs;

    public TagPath() {
        this.tagIndexPairs = Lists.newArrayList();
    }

    public TagPath(int n2, int n3) {
        this();
        this.addTag(n2, n3);
    }

    public TagPath(int n2) {
        this();
        this.addTag(n2);
    }

    public TagPath(String string) {
        this();
        this.addTag(string);
    }

    public TagPath(String string, int n2) {
        this();
        this.addTag(string, n2);
    }

    public TagPath(Pair<int[], int[]> pair) {
        this((int[])pair.x, (int[])pair.y);
    }

    public TagPath(int[] nArray, int[] nArray2) {
        this();
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
            Arrays.fill(nArray2, -1);
        }
        if (nArray.length != nArray2.length) {
            String string = "'tags' and 'indexes' have different sizes!";
            string = string + " { tags: " + Arrays.toString(nArray);
            string = string + ", indexes: " + Arrays.toString(nArray2) + " }";
            throw new IllegalArgumentException(string);
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            TagPathComponent tagPathComponent = new TagPathComponent(nArray[i2], nArray2[i2]);
            this.tagIndexPairs.add(tagPathComponent);
        }
    }

    public TagPath(TagPath tagPath) {
        this.tagIndexPairs = Lists.newArrayList(tagPath.tagIndexPairs);
    }

    public TagPath(String[] stringArray, int[] nArray) {
        this();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        if (nArray == null) {
            nArray = new int[stringArray.length];
            Arrays.fill(nArray, -1);
        }
        if (stringArray.length != nArray.length) {
            String string = "'tags' and 'indexes' have different sizes!";
            string = string + " { tags: " + Arrays.toString(stringArray);
            string = string + ", indexes: " + Arrays.toString(nArray) + " }";
            throw new IllegalArgumentException(string);
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            TagPathComponent tagPathComponent = new TagPathComponent(stringArray[i2], nArray[i2]);
            this.tagIndexPairs.add(tagPathComponent);
        }
    }

    public TagPath(TagPathComponent tagPathComponent) {
        this();
        this.tagIndexPairs.add(tagPathComponent);
    }

    public TagPath(TagPathComponent[] tagPathComponentArray, int[] nArray) {
        this();
        if (tagPathComponentArray == null) {
            tagPathComponentArray = new TagPathComponent[]{};
        }
        if (nArray == null) {
            nArray = new int[tagPathComponentArray.length];
            Arrays.fill(nArray, -1);
        }
        if (tagPathComponentArray.length != nArray.length) {
            String string = "'tags' and 'indexes' have different sizes!";
            string = string + " { tags: " + Arrays.toString(tagPathComponentArray);
            string = string + ", indexes: " + Arrays.toString(nArray) + " }";
            throw new IllegalArgumentException(string);
        }
        for (int i2 = 0; i2 < tagPathComponentArray.length; ++i2) {
            if (tagPathComponentArray[i2].useStringAsTag) {
                this.tagIndexPairs.add(new TagPathComponent(tagPathComponentArray[i2].tagString, nArray[i2]));
                continue;
            }
            this.tagIndexPairs.add(new TagPathComponent(tagPathComponentArray[i2].tagInt, nArray[i2]));
        }
    }

    public TagPath(TagPathComponent[] tagPathComponentArray) {
        this();
        this.tagIndexPairs.addAll(Lists.newArrayList((Object[])tagPathComponentArray));
    }

    public TagPath addTag(int n2) {
        return this.addTag(n2, -1);
    }

    public TagPath addTag(int n2, int n3) {
        TagPathComponent tagPathComponent = new TagPathComponent(n2, n3);
        this.tagIndexPairs.add(tagPathComponent);
        return this;
    }

    public TagPath addTag(String string) {
        return this.addTag(string, -1);
    }

    public TagPath addTag(String string, int n2) {
        TagPathComponent tagPathComponent = new TagPathComponent(string, n2);
        this.tagIndexPairs.add(tagPathComponent);
        return this;
    }

    public TagPath prependTag(String string, int n2) {
        this.prependTag(new TagPathComponent(string, n2));
        return this;
    }

    public TagPath prependTag(TagPathComponent tagPathComponent) {
        this.tagIndexPairs.add(0, tagPathComponent);
        return this;
    }

    public TagPath newPathByAddingTag(int n2, int n3) {
        return this.deepCopy().addTag(n2, n3);
    }

    public Pair<String, Integer> removeLastTag() {
        return this.removeTag(this.tagIndexPairs.size() - 1);
    }

    public Pair<String, Integer> removeTag(int n2) {
        TagPathComponent tagPathComponent = this.tagIndexPairs.remove(n2);
        return Pair.get(tagPathComponent.tagString, tagPathComponent.index);
    }

    public TagPathComponent getTag(int n2) {
        return this.tagIndexPairs.get(n2);
    }

    public TagPathComponent getLastTag() {
        return this.tagIndexPairs.get(this.tagIndexPairs.size() - 1);
    }

    public int getTagIndex(int n2) {
        return this.tagIndexPairs.get((int)n2).index;
    }

    public TagPathComponent[] getTags() {
        return this.tagIndexPairs.toArray(new TagPathComponent[this.tagIndexPairs.size()]);
    }

    public int[] getSequenceIndexes() {
        int[] nArray = new int[this.tagIndexPairs.size()];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.tagIndexPairs.get((int)i2).index;
        }
        return nArray;
    }

    @Deprecated
    public TagPathComponent[] getTagsAndIndexes() {
        return this.tagIndexPairs.toArray(new TagPathComponent[this.tagIndexPairs.size()]);
    }

    public TagPath getSubPath(int n2) {
        return this.getSubPath(n2, this.size());
    }

    public int[] toDcm4CheStylePath() {
        int[] nArray = new int[this.size() * 2 - 1];
        for (int i2 = 0; i2 < this.size(); ++i2) {
            TagPathComponent tagPathComponent = this.getTag(i2);
            if (tagPathComponent.isStringTag()) {
                return null;
            }
            if (i2 < this.size() - 1) {
                nArray[i2 * 2] = tagPathComponent.index;
                nArray[i2 * 2 + 1] = tagPathComponent.getTagInt();
                continue;
            }
            nArray[i2 * 2] = tagPathComponent.getTagInt();
        }
        return nArray;
    }

    public TagPath getSubPath(int n2, int n3) {
        TagPath tagPath = new TagPath();
        tagPath.tagIndexPairs.addAll(this.tagIndexPairs.subList(n2, n3));
        return tagPath;
    }

    public boolean isEmpty() {
        return this.tagIndexPairs.isEmpty();
    }

    public int size() {
        return this.tagIndexPairs.size();
    }

    public String[] getTagNames() {
        ArrayList arrayList = Lists.newArrayList();
        for (TagPathComponent tagPathComponent : this.tagIndexPairs) {
            if (!tagPathComponent.useStringAsTag) {
                arrayList.add(TagUtils.getTagName(tagPathComponent.tagInt));
                continue;
            }
            arrayList.add(tagPathComponent.tagString);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public TagPath deepCopy() {
        TagPath tagPath = new TagPath();
        tagPath.tagIndexPairs = Lists.newArrayList(this.tagIndexPairs);
        return tagPath;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.tagIndexPairs == null ? 0 : ((Object)this.tagIndexPairs).hashCode());
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TagPath tagPath = (TagPath)object;
        return !(this.tagIndexPairs == null ? tagPath.tagIndexPairs != null : !((Object)this.tagIndexPairs).equals(tagPath.tagIndexPairs));
    }

    public JsonPath toJsonPath() {
        return JsonPathUtil.normalize(TagUtils.toHexStringWithIndexes(this.getTags()));
    }

    public String toDenormalizedPath() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.tagIndexPairs.isEmpty()) {
            this.appendPathPosition(stringBuilder, 0);
        }
        for (int i2 = 1; i2 < this.tagIndexPairs.size(); ++i2) {
            stringBuilder.append('.');
            this.appendPathPosition(stringBuilder, i2);
        }
        return stringBuilder.toString();
    }

    public String toHexPath() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<TagPathComponent> iterator = this.tagIndexPairs.iterator();
        while (iterator.hasNext()) {
            TagPathComponent tagPathComponent = iterator.next();
            if (!tagPathComponent.useStringAsTag) {
                stringBuilder.append(TagUtils.toStringNoParens(tagPathComponent.tagInt));
            } else {
                stringBuilder.append(tagPathComponent.tagString);
            }
            int n2 = tagPathComponent.index;
            if (n2 != -1) {
                stringBuilder.append("[" + n2 + "]");
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append('.');
        }
        return stringBuilder.toString();
    }

    public DicomObject getLeafObject(DicomObject dicomObject) {
        TagPathComponent[] tagPathComponentArray = this.getTags();
        for (int i2 = 0; i2 < tagPathComponentArray.length; ++i2) {
            if (dicomObject == null) {
                return null;
            }
            TagPathComponent tagPathComponent = tagPathComponentArray[i2];
            if (tagPathComponent.isStringTag()) {
                return null;
            }
            if (i2 == tagPathComponentArray.length - 1) {
                return dicomObject;
            }
            dicomObject = dicomObject.getNestedDicomObject(new int[]{tagPathComponent.getTagInt(), tagPathComponent.getIndex()});
        }
        return null;
    }

    public boolean doesContainThisTagPath(DicomObject dicomObject) {
        DicomObject dicomObject2 = this.getLeafObject(dicomObject);
        if (dicomObject2 == null) {
            return false;
        }
        TagPathComponent tagPathComponent = this.getTag(this.size() - 1);
        if (tagPathComponent.isStringTag()) {
            return false;
        }
        return dicomObject2.contains(tagPathComponent.getTagInt());
    }

    private void appendPathPosition(StringBuilder stringBuilder, int n2) {
        int n3 = this.tagIndexPairs.get((int)n2).index;
        TagPathComponent tagPathComponent = this.tagIndexPairs.get(n2);
        if (n3 < 0) {
            stringBuilder.append(TagUtils.getTagName(tagPathComponent));
        } else {
            stringBuilder.append(TagUtils.getTagName(tagPathComponent)).append('[').append(n3).append(']');
        }
    }

    public String toString() {
        return this.toDenormalizedPath();
    }

    @Override
    public String getName() {
        return this.toDenormalizedPath();
    }

    @Override
    public int compareTo(TagPath tagPath) {
        TagPathComponent[] tagPathComponentArray = this.getTags();
        TagPathComponent[] tagPathComponentArray2 = tagPath.getTags();
        for (int i2 = 0; i2 < tagPathComponentArray.length; ++i2) {
            if (i2 >= tagPathComponentArray2.length) {
                return 1;
            }
            int n2 = tagPathComponentArray[i2].tagString.compareTo(tagPathComponentArray2[i2].tagString);
            if (n2 != 0) {
                return n2;
            }
            n2 = Integer.signum(tagPathComponentArray[i2].index - tagPathComponentArray2[i2].index);
            if (n2 == 0) continue;
            return n2;
        }
        if (tagPathComponentArray.length < tagPathComponentArray2.length) {
            return -1;
        }
        return 0;
    }

    public static TagPath parse(String string) throws DicomTagParseException {
        return TagUtils.parse(string);
    }

    public boolean isMIMDataTagPath() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.getTag((int)0).tagString.equalsIgnoreCase("mimdata")) {
            return true;
        }
        return MetabaseKeys.isMIMFakeDicomTag(this.getTag((int)(this.size() - 1)).tagInt);
    }

    public boolean isSubPathOf(TagPath tagPath) {
        if (tagPath.equals(this)) {
            return false;
        }
        if (tagPath.isEmpty() || this.isEmpty()) {
            return false;
        }
        if (tagPath.size() >= this.size()) {
            return false;
        }
        TagPath tagPath2 = this.getSubPath(0, tagPath.size());
        return tagPath.equals(tagPath2);
    }
}

