/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.dicom.util.DicomTagParseException;
import com.mimvista.dicom.util.MIMTag;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.dicom.util.TagPathComponent;
import com.mimvista.util.Pair;
import com.mimvista.util.cn;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.dcm4che2.data.Tag;
import org.dcm4che2.data.VR;
import org.dcm4che2.data.VRMap;
import org.dcm4che2.util.StringUtils;

public class TagUtils {
    public static final String tagSeparatorRegex = "\\.|/";
    private static Map<Integer, String> dcmTagToName = null;
    private static Map<String, Integer> dcmNameToTag = null;
    private static Map<Integer, String> mimTagToName = null;
    private static Map<String, Integer> mimNameToTag = null;
    private static Pattern dicomTagSanitizer = Pattern.compile("\\(|\\)|\\[|\\]");

    private static synchronized void loadTagMaps() {
        String string;
        Field[] fieldArray = Tag.class.getFields();
        Field[] fieldArray2 = MIMTag.class.getFields();
        dcmTagToName = new HashMap<Integer, String>(fieldArray.length);
        dcmNameToTag = new HashMap<String, Integer>(fieldArray2.length);
        for (Field field : fieldArray) {
            try {
                int n2 = field.getInt(null);
                string = field.getName();
                dcmTagToName.put(n2, string);
                dcmNameToTag.put(string.toLowerCase(), n2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mimTagToName = new HashMap<Integer, String>();
        mimNameToTag = new HashMap<String, Integer>();
        for (Field field : fieldArray2) {
            try {
                int n3 = field.getInt(null);
                string = new String(field.getName());
                mimTagToName.put(n3, string);
                mimNameToTag.put(string.toLowerCase(), n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MIMTag.fillSpecialTagNames(mimTagToName, mimNameToTag);
    }

    private static synchronized Map<Integer, String> dcmTagToName() {
        if (dcmTagToName == null) {
            TagUtils.loadTagMaps();
        }
        return dcmTagToName;
    }

    private static synchronized Map<String, Integer> dcmNameToTag() {
        if (dcmNameToTag == null) {
            TagUtils.loadTagMaps();
        }
        return dcmNameToTag;
    }

    private static synchronized Map<Integer, String> mimTagToName() {
        if (mimTagToName == null) {
            TagUtils.loadTagMaps();
        }
        return mimTagToName;
    }

    private static synchronized Map<String, Integer> mimNameToTag() {
        if (mimNameToTag == null) {
            TagUtils.loadTagMaps();
        }
        return mimNameToTag;
    }

    public static List<Integer> getDcmTags() {
        return new ArrayList<Integer>(TagUtils.dcmTagToName().keySet());
    }

    public static List<Integer> getMIMTags() {
        return new ArrayList<Integer>(TagUtils.mimTagToName().keySet());
    }

    public static int parseTagValue(String string) throws DicomTagParseException {
        int n2 = 0;
        string = dicomTagSanitizer.matcher(string).replaceAll("");
        String[] stringArray = cn.f(string).split(",|;|-");
        int n3 = Math.min(stringArray.length, 2);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = -1;
            try {
                n4 = Integer.valueOf(stringArray[i2], 16);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n4 < 0) {
                if (n2 > 0) {
                    return n2;
                }
                throw new DicomTagParseException();
            }
            n2 = n2 << 16 | n4;
        }
        return n2;
    }

    public static VR vrOfTag(TagPath tagPath) {
        return TagUtils.vrOfTag(tagPath.getTag(tagPath.size() - 1));
    }

    public static VR vrOfTag(TagPathComponent tagPathComponent) {
        if (!tagPathComponent.useStringAsTag) {
            return TagUtils.vrOfTag(tagPathComponent.tagInt);
        }
        return TagUtils.vrOfMimdata(tagPathComponent.tagString);
    }

    public static VR vrOfTag(int[] nArray) {
        return TagUtils.vrOfTag(nArray[nArray.length - 1]);
    }

    public static VR vrOfMimdata(String string) {
        if (string.equalsIgnoreCase("mimdata") || string.equalsIgnoreCase("statuses") || string.equalsIgnoreCase("owners") || string.equalsIgnoreCase("references") || string.equalsIgnoreCase("plInfo") || string.equalsIgnoreCase("sops")) {
            return VR.SQ;
        }
        if (string.equalsIgnoreCase("dateAdded") || string.equalsIgnoreCase("searchDate") || string.equalsIgnoreCase("lastAccessed")) {
            return VR.DA;
        }
        if (string.equalsIgnoreCase("folders") || string.equalsIgnoreCase("uid") || string.equalsIgnoreCase("uidType") || string.equalsIgnoreCase("source") || string.equalsIgnoreCase("crunchedName") || string.equalsIgnoreCase("sopInstanceUids") || string.equalsIgnoreCase("user") || string.equalsIgnoreCase("name") || string.equalsIgnoreCase("ownerName") || string.equalsIgnoreCase("actor") || string.equalsIgnoreCase("parentSeriesUids") || string.equalsIgnoreCase("type") || string.equalsIgnoreCase("equalityHash")) {
            return VR.ST;
        }
        if (string.equalsIgnoreCase("time") || string.equalsIgnoreCase("time") || string.equalsIgnoreCase("searchTime")) {
            return VR.TM;
        }
        if (string.equalsIgnoreCase("version") || string.equalsIgnoreCase("patientLists") || string.equalsIgnoreCase("statusId") || string.equalsIgnoreCase("childIds") || string.equalsIgnoreCase("parentId") || string.equalsIgnoreCase("embedIdx") || string.equalsIgnoreCase("sopCount")) {
            return VR.IS;
        }
        return VR.UN;
    }

    public static VR vrOfTag(int n2) {
        VR vR = VRMap.getVRMap().vrOf(n2);
        if (vR == VR.UN) {
            switch (n2) {
                case 930283792: 
                case 930283794: 
                case 930283796: 
                case 930283798: {
                    return VR.SQ;
                }
                case 1253536: 
                case 930295818: 
                case 930295819: {
                    return VR.US;
                }
                case 930283824: {
                    return VR.OF;
                }
                case 0x37733003: 
                case 930295812: 
                case 930308353: {
                    return VR.DT;
                }
                case 1253424: 
                case 930283552: 
                case 930291986: {
                    return VR.SH;
                }
                case 930291988: 
                case 930295814: {
                    return VR.LO;
                }
                case 928059392: {
                    return VR.FL;
                }
                case 930283828: 
                case 930283829: 
                case 930283830: 
                case 930295816: 
                case 930308352: {
                    return VR.ST;
                }
                case 930291989: {
                    return VR.SS;
                }
            }
        }
        return vR;
    }

    public static int forTagName(String string) {
        String string2 = string.toLowerCase();
        Integer n2 = TagUtils.mimNameToTag().get(string2);
        if (n2 != null) {
            return n2;
        }
        Integer n3 = TagUtils.dcmNameToTag().get(string2);
        if (n3 != null) {
            return n3;
        }
        return (int)Long.parseLong(string, 16);
    }

    public static String getTagName(int n2) {
        String string = TagUtils.mimTagToName().get(n2);
        if (string == null) {
            string = TagUtils.dcmTagToName().get(n2);
        }
        return string == null ? TagUtils.toHexString(n2) : string;
    }

    public static String getTagName(TagPathComponent tagPathComponent) {
        if (!tagPathComponent.useStringAsTag) {
            return TagUtils.getTagName(tagPathComponent.tagInt);
        }
        return tagPathComponent.tagString;
    }

    public static boolean isSequenceTag(int n2) {
        return TagUtils.vrOfTag(n2) == VR.SQ;
    }

    public static String toString(int n2) {
        return org.dcm4che2.util.TagUtils.toString((int)n2);
    }

    public static String toStringNoParens(int n2) {
        StringBuffer stringBuffer = new StringBuffer(9);
        StringUtils.shortToHex((int)(n2 >> 16), (StringBuffer)stringBuffer);
        stringBuffer.append(',');
        StringUtils.shortToHex((int)n2, (StringBuffer)stringBuffer);
        return stringBuffer.toString();
    }

    public static String toHexString(int ... nArray) {
        if (nArray.length < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(TagUtils.singleTagToHexString(nArray[0]));
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            stringBuilder.append('.').append(TagUtils.singleTagToHexString(nArray[i2]));
        }
        return stringBuilder.toString();
    }

    public static String singleTagToHexString(int n2) {
        return Integer.toHexString(n2);
    }

    public static String toHexString(TagPathComponent ... tagPathComponentArray) {
        if (tagPathComponentArray.length < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < tagPathComponentArray.length; ++i2) {
            if (tagPathComponentArray[i2].useStringAsTag) {
                stringBuilder.append(tagPathComponentArray[i2].tagString);
            } else {
                stringBuilder.append(TagUtils.toHexString(tagPathComponentArray[i2].tagInt));
            }
            if (i2 >= tagPathComponentArray.length - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public static String toHexStringWithIndexes(int ... nArray) {
        if (nArray.length < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(Integer.toHexString(nArray[0]));
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (n2 < 0) {
                stringBuilder.append("[*].");
            } else {
                stringBuilder.append('[').append(n2).append("].");
            }
            if (++i2 >= nArray.length) break;
            stringBuilder.append(Integer.toHexString(nArray[i2]));
        }
        return stringBuilder.toString();
    }

    public static String toHexStringWithIndexes(TagPathComponent ... tagPathComponentArray) {
        if (tagPathComponentArray.length < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < tagPathComponentArray.length - 1; ++i2) {
            if (!tagPathComponentArray[i2].useStringAsTag) {
                stringBuilder.append(TagUtils.toHexString(tagPathComponentArray[i2].tagInt));
            } else {
                stringBuilder.append(tagPathComponentArray[i2].tagString);
            }
            if (tagPathComponentArray[i2].index < 0) {
                stringBuilder.append("[*].");
                continue;
            }
            stringBuilder.append("[" + tagPathComponentArray[i2].index + "].");
        }
        if (!tagPathComponentArray[tagPathComponentArray.length - 1].useStringAsTag) {
            stringBuilder.append(TagUtils.toHexString(tagPathComponentArray[tagPathComponentArray.length - 1].tagInt));
        } else {
            stringBuilder.append(tagPathComponentArray[tagPathComponentArray.length - 1].tagString);
        }
        if (tagPathComponentArray[tagPathComponentArray.length - 1].index != -1) {
            stringBuilder.append("[" + tagPathComponentArray[tagPathComponentArray.length - 1].index + "]");
        }
        return stringBuilder.toString();
    }

    public static String toNameString(int ... nArray) {
        if (nArray.length < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(TagUtils.getTagName(nArray[0]));
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            stringBuilder.append('.').append(TagUtils.getTagName(nArray[i2]));
        }
        return stringBuilder.toString();
    }

    public static String toNameString(TagPathComponent ... tagPathComponentArray) {
        if (tagPathComponentArray.length < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < tagPathComponentArray.length; ++i2) {
            if (tagPathComponentArray[i2].useStringAsTag) {
                stringBuilder.append(tagPathComponentArray[i2].tagString);
            } else {
                stringBuilder.append(TagUtils.getTagName(tagPathComponentArray[i2].tagInt));
            }
            if (i2 >= tagPathComponentArray.length - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public static String toNameStringWithIndexes(int ... nArray) {
        if (nArray.length < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(TagUtils.getTagName(nArray[0]));
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (n2 < 0) {
                stringBuilder.append("[*].");
            } else {
                stringBuilder.append('[').append(nArray[i2]).append("].");
            }
            if (++i2 >= nArray.length) break;
            stringBuilder.append(TagUtils.getTagName(nArray[i2]));
        }
        return stringBuilder.toString();
    }

    public static String toNameStringWithIndexes(TagPathComponent ... tagPathComponentArray) {
        if (tagPathComponentArray.length < 1) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < tagPathComponentArray.length; ++i2) {
            stringBuilder.append(TagUtils.getTagName(tagPathComponentArray[i2]));
            if (i2 < tagPathComponentArray.length - 1 || tagPathComponentArray[i2].index != -1) {
                if (tagPathComponentArray[i2].index < 0) {
                    stringBuilder.append("[*]");
                } else {
                    stringBuilder.append("[" + tagPathComponentArray[i2].index + "]");
                }
            }
            if (i2 >= tagPathComponentArray.length - 1) continue;
            stringBuilder.append(".");
        }
        return stringBuilder.toString();
    }

    public static TagPath parse(String string) throws DicomTagParseException {
        if (cn.h(string)) {
            return new TagPath();
        }
        if (string.toLowerCase().startsWith("mimdata".toLowerCase())) {
            TagPathComponent[] tagPathComponentArray = TagUtils.parseStringTag(string);
            return new TagPath(tagPathComponentArray);
        }
        Pair<int[], int[]> pair = TagUtils.parseIntTag(string);
        return new TagPath((int[])pair.x, (int[])pair.y);
    }

    private static Pair<int[], int[]> parseIntTag(String string) throws DicomTagParseException {
        String[] stringArray = string.split(tagSeparatorRegex);
        int[] nArray = new int[stringArray.length];
        int[] nArray2 = new int[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string2 = stringArray[i2].trim();
            int n2 = string2.indexOf(91);
            if (n2 >= 0) {
                String string3 = string2.substring(n2 + 1, string2.length() - 1);
                int n3 = -1;
                if (!"*".equals(string3) && (n3 = Integer.parseInt(string3)) < 0) {
                    throw new DicomTagParseException("Tag path string has a negative sequence index: " + string);
                }
                nArray2[i2] = n3;
                nArray[i2] = TagUtils.parseSingleTagName(string2.substring(0, n2));
                continue;
            }
            nArray2[i2] = -1;
            nArray[i2] = TagUtils.parseSingleTagName(string2);
        }
        return Pair.get(nArray, nArray2);
    }

    public static int parseSingleTagName(String string) throws DicomTagParseException {
        try {
            return TagUtils.forTagName(string);
        }
        catch (Exception exception) {
            try {
                return (int)Long.parseLong(string, 16);
            }
            catch (NumberFormatException numberFormatException) {
                int n2 = TagUtils.parseTagValue(string);
                if (n2 > -1) {
                    return n2;
                }
                throw new DicomTagParseException("Unable to parse tag: " + string);
            }
        }
    }

    public static TagPathComponent[] parseStringTag(String string) throws DicomTagParseException {
        String[] stringArray = string.split(tagSeparatorRegex);
        TagPathComponent[] tagPathComponentArray = new TagPathComponent[stringArray.length];
        for (int i2 = 0; i2 < tagPathComponentArray.length; ++i2) {
            int n2;
            String string2 = stringArray[i2].trim();
            int n3 = string2.indexOf(91);
            if (n3 > -1) {
                int n4 = (string2 = string2.substring(0, n3)).indexOf(93) == -1 ? string2.length() : string2.indexOf(91);
                String string3 = string2.substring(n3, n4);
                try {
                    n2 = Integer.parseInt(string3);
                    if (n2 < 0) {
                        throw new DicomTagParseException("Tag path string has a negative sequence index: " + string2);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    n2 = -1;
                }
            } else {
                n2 = -1;
            }
            tagPathComponentArray[i2] = new TagPathComponent(string2, n2);
        }
        return tagPathComponentArray;
    }
}

