/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.google.common.collect.Maps;
import com.mimvista.preferencesNew.MachinePrefs;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.cn;
import java.util.Calendar;
import java.util.Map;

public class UIDGenerator {
    public static final long TIME_IN_SECONDS_OFFSET = 1042217680L;
    public static final String MACHINE_TEXT_NAME = "SERVICES/machine.txt";
    public static final String MACHINE_NUMBER = "MACHINE NUMBER";
    public static final String MIM_UID_PREFIX = "2.16.840.1.114362.1";
    private static final String DOT_STRING = ".".intern();
    private static Map<String, String> nmSopToForMap = Maps.newHashMap();
    private static int anonUidCounter = 1;

    public static String generateNonSeriesUID() {
        return UIDGenerator.generateUIDInternal();
    }

    public static String generateSopInstanceUID() {
        return UIDGenerator.generateNonSeriesUID();
    }

    private static String generateUIDInternal() {
        String string = MIM_UID_PREFIX + DOT_STRING + UIDGenerator.genNumericBuildNumber() + DOT_STRING + UIDGenerator.genMachineNumber() + DOT_STRING + UIDGenerator.genUIDPostfix();
        return string;
    }

    public static String generateUID() {
        return UIDGenerator.generateUIDInternal();
    }

    private static String genMachineNumber() {
        String string = MachinePrefs.machineNumber.getValue();
        if (string == null || string.trim().equals("")) {
            long l2 = (Calendar.getInstance().getTimeInMillis() - 1042217680000L) / 40L;
            string = String.valueOf(l2);
            MachinePrefs.machineNumber.setValue(string);
        }
        return string;
    }

    private static synchronized String genUIDPostfix() {
        String string = String.valueOf(Calendar.getInstance().getTimeInMillis() - 1042217680000L);
        String string2 = string.substring(string.length() - 3);
        String string3 = string.substring(0, string.length() - 3);
        if (string2.startsWith("0")) {
            string2 = "1" + string2;
        }
        if (string3.startsWith("0")) {
            string3 = "1" + string3;
        }
        String string4 = string3 + DOT_STRING + string2 + DOT_STRING + String.valueOf(anonUidCounter);
        anonUidCounter = anonUidCounter % 9999 + 1;
        return string4;
    }

    public static String getOrSetFrameOfRefUidForSop(String string, String string2) {
        String string3 = nmSopToForMap.get(string);
        if (string3 == null) {
            nmSopToForMap.put(string, string2);
            string3 = string2;
        }
        return string3;
    }

    public static String generateCreatorVersionUID() {
        return MIM_UID_PREFIX + DOT_STRING + UIDGenerator.genNumericBuildNumber();
    }

    private static String genNumericBuildNumber() {
        String string;
        String[] stringArray = VersionNumber.loadVersion();
        String string2 = stringArray[3];
        stringArray[3] = string = UIDGenerator.genDateNumber(string2);
        return cn.a(stringArray, ".");
    }

    private static String genDateNumber(String string) {
        if (string.equals("DEVEL")) {
            return "13913";
        }
        String string2 = string.substring(0, string.length() - 3);
        char c2 = string2.charAt(0);
        int n2 = c2 != '9' ? c2 - 55 : 9;
        String string3 = string2.substring(1, 2);
        int n3 = Integer.valueOf(string3, 16);
        String string4 = string2.substring(2, 4);
        return "" + n2 + n3 + string4;
    }

    public static void main(String[] stringArray) {
        System.out.println(UIDGenerator.generateUID());
    }
}

