/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util;

import com.mimvista.dicom.CoercingJsonDicomSeries;
import com.mimvista.dicom.util.TagPath;
import com.mimvista.dicom.util.TagPathComponent;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.util.DateUtils;
import com.mimvista.util.ay;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcm4che2.data.VR;

public class VRUtils {
    public static final String timeFormat = "HH:mm:ss";
    public static final String dateFormat = "yyyy-MM-dd";
    public static final String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
    public static final String dicomDateFormat = "yyyyMMdd";
    public static final String dicomDateTimeFormat = "yyyyMMddHHmmss";
    public static final String dicomTimeFormat = "HHmmss";
    private static final Pattern relativeDateValueFormat = Pattern.compile("\\(\\?( )*(\\+|-)( )*[0-9]+(y|m|d)\\)");
    private static final Pattern relevantRelativeDateValueFormat = Pattern.compile("(\\+|-)( )*[0-9]+(y|m|d)");
    private static final VrValueParserForJsonDicomSeries<String> strParser = new VrValueParserForJsonDicomSeries<String>(){

        @Override
        public Class<? extends String> getParseType() {
            return String.class;
        }
    };
    private static final VrValueParserForJsonDicomSeries<Integer> intParser = new VrValueParserForJsonDicomSeries<Integer>(){

        @Override
        public Class<? extends Integer> getParseType() {
            return Integer.class;
        }
    };
    private static final VrValueParserForJsonDicomSeries<Long> longParser = new VrValueParserForJsonDicomSeries<Long>(){

        @Override
        public Class<? extends Long> getParseType() {
            return Long.class;
        }
    };
    private static final VrValueParserForJsonDicomSeries<Float> floatParser = new VrValueParserForJsonDicomSeries<Float>(){

        @Override
        public Class<? extends Float> getParseType() {
            return Float.class;
        }
    };
    private static final VrValueParserForJsonDicomSeries<Double> doubleParser = new VrValueParserForJsonDicomSeries<Double>(){

        @Override
        public Class<? extends Double> getParseType() {
            return Double.class;
        }
    };
    private static final VrValueParserForJsonDicomSeries<Date> dateParser = new VrValueParserForJsonDicomSeries<Date>(){

        @Override
        public Class<? extends Date> getParseType() {
            return Date.class;
        }

        @Override
        public Date parseJsonDicomValue(Object object) {
            return (Date)CoercingJsonDicomSeries.getConverterForDate(true, false).apply(object);
        }

        @Override
        public Date parseUserInputValue(String string) {
            return VRUtils.parseUserInputToRelativeDate(string);
        }
    };
    private static final VrValueParserForJsonDicomSeries<Date> timeParser = new VrValueParserForJsonDicomSeries<Date>(){

        @Override
        public Class<? extends Date> getParseType() {
            return Date.class;
        }

        @Override
        public Date parseJsonDicomValue(Object object) {
            return (Date)CoercingJsonDicomSeries.getConverterForDate(false, true).apply(object);
        }
    };
    private static final VrValueParserForJsonDicomSeries<Date> dateTimeParser = new VrValueParserForJsonDicomSeries<Date>(){

        @Override
        public Class<? extends Date> getParseType() {
            return Date.class;
        }

        @Override
        public Date parseJsonDicomValue(Object object) {
            return (Date)CoercingJsonDicomSeries.getConverterForDate(true, true).apply(object);
        }

        @Override
        public Date parseUserInputValue(String string) {
            return VRUtils.parseUserInputToRelativeDate(string);
        }
    };

    public static VR fromString(String string) {
        char c2 = string.charAt(0);
        char c3 = string.charAt(1);
        int n2 = 0;
        n2 += c2 << 8;
        return VR.valueOf((int)(n2 += c3 & 0xFF));
    }

    public static boolean isStringTypeVR(VR vR) {
        return !VRUtils.isAnyNumberTypeVR(vR) && !VRUtils.isAnyDateTypeVR(vR) && !VRUtils.isByteArrayTypeVR(vR) && !VRUtils.isSequenceTypeVR(vR) && !VRUtils.isUnknownVR(vR);
    }

    public static boolean isIntOrLongTypeVR(VR vR) {
        return VRUtils.isIntTypeVR(vR) || VRUtils.isLongTypeVR(vR);
    }

    public static boolean isDecimalNumberTypeVR(VR vR) {
        return VRUtils.isFloatTypeVR(vR) || VRUtils.isDoubleTypeVR(vR);
    }

    public static boolean isAnyNumberTypeVR(VR vR) {
        return VRUtils.isIntOrLongTypeVR(vR) || VRUtils.isDecimalNumberTypeVR(vR);
    }

    public static boolean isAnyDateTypeVR(VR vR) {
        return VRUtils.isDateTypeVR(vR) || VRUtils.isTimeTypeVR(vR) || VRUtils.isDateTimeTypeVR(vR);
    }

    public static boolean isIntTypeVR(VR vR) {
        return VR.IS == vR || VR.AT == vR || VR.US == vR || VR.SL == vR || VR.SS == vR;
    }

    public static boolean isLongTypeVR(VR vR) {
        return VR.UL == vR;
    }

    public static boolean isFloatTypeVR(VR vR) {
        return VR.FL == vR;
    }

    public static boolean isDoubleTypeVR(VR vR) {
        return VR.FD == vR || VR.DS == vR;
    }

    public static boolean isDateTypeVR(VR vR) {
        return VR.DA == vR;
    }

    public static boolean isTimeTypeVR(VR vR) {
        return VR.TM == vR;
    }

    public static boolean isDateTimeTypeVR(VR vR) {
        return VR.DT == vR;
    }

    public static boolean isByteArrayTypeVR(VR vR) {
        return VR.OB == vR || VR.OF == vR || VR.OF == vR;
    }

    public static boolean isUnknownVR(VR vR) {
        return VR.UN == vR;
    }

    public static boolean isSequenceTypeVR(VR vR) {
        return VR.SQ == vR;
    }

    public static Comparable parseJsonDicomValue(VR vR, Object object) {
        return VRUtils.getValueParser(vR).parseJsonDicomValue(object);
    }

    public static Comparable parseJsonDicomValue(TagPathComponent tagPathComponent, Object object) {
        return VRUtils.getValueParser(TagUtils.vrOfTag(tagPathComponent)).parseJsonDicomValue(object);
    }

    public static Comparable parseJsonDicomValue(TagPath tagPath, Object object) {
        return VRUtils.parseJsonDicomValue(tagPath.getTag(tagPath.size() - 1), object);
    }

    public static Comparable parseJsonDicomValue(int n2, Object object) {
        return VRUtils.parseJsonDicomValue(TagUtils.vrOfTag(n2), object);
    }

    public static Comparable parseUserInputValue(VR vR, String string) {
        return VRUtils.getValueParser(vR).parseUserInputValue(string);
    }

    public static Comparable parseUserInputValue(TagPathComponent tagPathComponent, String string) {
        return VRUtils.getValueParser(TagUtils.vrOfTag(tagPathComponent)).parseUserInputValue(string);
    }

    public static Comparable parseUserInputValue(int n2, String string) {
        return VRUtils.parseUserInputValue(TagUtils.vrOfTag(n2), string);
    }

    public static Class<? extends Comparable> getParseResultType(int n2) {
        return VRUtils.getParseResultType(TagUtils.vrOfTag(n2));
    }

    public static Class<? extends Comparable> getParseResultType(TagPathComponent tagPathComponent) {
        return VRUtils.getParseResultType(TagUtils.vrOfTag(tagPathComponent));
    }

    public static Class<? extends Comparable> getParseResultType(VR vR) {
        return VRUtils.getValueParser(vR).getParseType();
    }

    public static VrValueParserForJsonDicomSeries<? extends Comparable> getValueParser(VR vR) {
        if (VRUtils.isIntTypeVR(vR)) {
            return intParser;
        }
        if (VRUtils.isLongTypeVR(vR)) {
            return longParser;
        }
        if (VRUtils.isFloatTypeVR(vR)) {
            return floatParser;
        }
        if (VRUtils.isDoubleTypeVR(vR)) {
            return doubleParser;
        }
        if (VRUtils.isDateTypeVR(vR)) {
            return dateParser;
        }
        if (VRUtils.isTimeTypeVR(vR)) {
            return timeParser;
        }
        if (VRUtils.isDateTimeTypeVR(vR)) {
            return dateTimeParser;
        }
        return strParser;
    }

    private static Date parseUserInputToRelativeDate(Object object) {
        if (object instanceof Date) {
            return (Date)object;
        }
        Date date = DateUtils.a(VRUtils.parseRelativeDateFormatTo(object.toString(), dateFormat), new String[]{dicomDateTimeFormat, dateTimeFormat, dicomDateFormat, dateFormat});
        return DateUtils.f(date);
    }

    public static boolean isRelativeDateFormat(String string) {
        return relativeDateValueFormat.matcher(string).matches();
    }

    public static String parseRelativeDateFormatTo(String string, String string2) {
        if (!VRUtils.isRelativeDateFormat(string = string.trim())) {
            return string;
        }
        try {
            Calendar calendar = Calendar.getInstance();
            int n2 = VRUtils.getRelativeDateField(string);
            int n3 = VRUtils.getRelativeDateValue(string);
            calendar.add(n2, n3);
            return DateUtils.a(calendar.getTime(), string2);
        }
        catch (Exception exception) {
            ay.c((Object)exception, VRUtils.class);
            return string;
        }
    }

    public static int getRelativeDateField(String string) {
        String string2 = VRUtils.getRelativeDateGrouping(string);
        char c2 = string2.charAt(string2.length() - 1);
        switch (c2) {
            case 'y': {
                return 1;
            }
            case 'm': {
                return 2;
            }
        }
        return 5;
    }

    private static String getRelativeDateGrouping(String string) {
        Matcher matcher = relevantRelativeDateValueFormat.matcher(string);
        matcher.find();
        String string2 = matcher.group();
        string2 = string2.replaceAll("( |\\+)", "");
        return string2;
    }

    public static int getRelativeDateValue(String string) {
        String string2 = VRUtils.getRelativeDateGrouping(string);
        string2 = string2.substring(0, string2.length() - 1);
        return Integer.parseInt(string2);
    }

    public static abstract class VrValueParserForJsonDicomSeries<ParseType extends Comparable<ParseType>> {
        public abstract Class<? extends ParseType> getParseType();

        public ParseType parseUserInputValue(String string) {
            return this.parseJsonDicomValue(string);
        }

        public ParseType parseJsonDicomValue(Object object) {
            return (ParseType)((Comparable)CoercingJsonDicomSeries.getConverterFor(this.getParseType()).apply(object));
        }
    }
}

