/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util.encrypt;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import javax.crypto.KeyGenerator;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class CMSUtil {
    public static SecureRandom rand;
    public static KeyPairGenerator kpg;
    public static KeyGenerator seedKg;
    public static BigInteger serialNumber;

    public static KeyPair makeKeyPair() {
        return kpg.generateKeyPair();
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2) throws GeneralSecurityException, IOException {
        return CMSUtil.makeCertificate(keyPair, string, keyPair2, string2, false);
    }

    public static X509Certificate makeCertificate(KeyPair keyPair, String string, KeyPair keyPair2, String string2, boolean bl2) throws GeneralSecurityException, IOException {
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair2.getPrivate();
        PublicKey publicKey2 = keyPair2.getPublic();
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        x509V3CertificateGenerator.reset();
        x509V3CertificateGenerator.setSerialNumber(CMSUtil.allocateSerialNumber());
        x509V3CertificateGenerator.setIssuerDN(new X509Name(string2));
        x509V3CertificateGenerator.setNotBefore(new Date(System.currentTimeMillis()));
        x509V3CertificateGenerator.setNotAfter(new Date(System.currentTimeMillis() + 8640000000L));
        x509V3CertificateGenerator.setSubjectDN(new X509Name(string));
        x509V3CertificateGenerator.setPublicKey(publicKey);
        if (publicKey2 instanceof RSAPublicKey) {
            x509V3CertificateGenerator.setSignatureAlgorithm("SHA1WithRSA");
        } else if (publicKey2.getAlgorithm().equals("DSA")) {
            x509V3CertificateGenerator.setSignatureAlgorithm("SHA1withDSA");
        } else if (publicKey2.getAlgorithm().equals("ECDSA")) {
            x509V3CertificateGenerator.setSignatureAlgorithm("SHA1withECDSA");
        } else if (publicKey2.getAlgorithm().equals("ECGOST3410")) {
            x509V3CertificateGenerator.setSignatureAlgorithm("GOST3411withECGOST3410");
        } else {
            x509V3CertificateGenerator.setSignatureAlgorithm("GOST3411WithGOST3410");
        }
        x509V3CertificateGenerator.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)CMSUtil.createSubjectKeyId(publicKey));
        x509V3CertificateGenerator.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)CMSUtil.createAuthorityKeyId(publicKey2));
        x509V3CertificateGenerator.addExtension(X509Extensions.BasicConstraints, false, (DEREncodable)new BasicConstraints(bl2));
        X509Certificate x509Certificate = x509V3CertificateGenerator.generate(privateKey);
        x509Certificate.checkValidity(new Date());
        x509Certificate.verify(publicKey2);
        return x509Certificate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey publicKey) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        try (ASN1InputStream aSN1InputStream = null;){
            aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)aSN1InputStream.readObject());
            AuthorityKeyIdentifier authorityKeyIdentifier = new AuthorityKeyIdentifier(subjectPublicKeyInfo);
            return authorityKeyIdentifier;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(publicKey.getEncoded());
        try (ASN1InputStream aSN1InputStream = null;){
            aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)aSN1InputStream.readObject());
            SubjectKeyIdentifier subjectKeyIdentifier = new SubjectKeyIdentifier(subjectPublicKeyInfo);
            return subjectKeyIdentifier;
        }
    }

    private static BigInteger allocateSerialNumber() {
        BigInteger bigInteger = serialNumber;
        serialNumber = serialNumber.add(BigInteger.ONE);
        return bigInteger;
    }

    static {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            rand = new SecureRandom();
            kpg = KeyPairGenerator.getInstance("RSA", "BC");
            kpg.initialize(1024, rand);
            seedKg = KeyGenerator.getInstance("SEED", "BC");
            serialNumber = new BigInteger("1");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }
}

