/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util.encrypt;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.mimvista.d;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.PKCS5Scheme2PBEKey;
import org.bouncycastle.cms.PasswordRecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class DecryptReader {
    public static String password;

    public static InputStream getPossiblyDecryptingInputStream(File file, @d char[] cArray) throws IOException, CMSException, GeneralSecurityException {
        FileInputStream fileInputStream = new FileInputStream(file);
        if (cArray == null) {
            return fileInputStream;
        }
        return DecryptReader.decryptFromStream(fileInputStream, cArray);
    }

    public static InputStream decryptFromStream(InputStream inputStream, char[] cArray) throws IOException, CMSException, GeneralSecurityException {
        Preconditions.checkArgument((cArray != null && cArray.length > 0 ? 1 : 0) != 0);
        try {
            CMSEnvelopedData cMSEnvelopedData = new CMSEnvelopedData(inputStream);
            RecipientInformationStore recipientInformationStore = cMSEnvelopedData.getRecipientInfos();
            Collection collection = recipientInformationStore.getRecipients();
            PasswordRecipientInformation passwordRecipientInformation = (PasswordRecipientInformation)Iterables.get((Iterable)collection, (int)0);
            return passwordRecipientInformation.getContentStream((Key)DecryptReader.getKeyFromPassword(passwordRecipientInformation, cArray), "BC").getContentStream();
        }
        catch (GeneralSecurityException generalSecurityException) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw generalSecurityException;
        }
        catch (CMSException cMSException) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw cMSException;
        }
    }

    private static PKCS5Scheme2PBEKey getKeyFromPassword(PasswordRecipientInformation passwordRecipientInformation, char[] cArray) throws InvalidAlgorithmParameterException, NoSuchProviderException, CMSException {
        AlgorithmParameters algorithmParameters = passwordRecipientInformation.getKeyDerivationAlgParameters("BC");
        return new PKCS5Scheme2PBEKey(cArray, algorithmParameters);
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

