/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util.encrypt;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Random;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSPBEKey;
import org.bouncycastle.cms.PKCS5Scheme2PBEKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.dcm4che2.io.DicomOutputStream;

public class DicomOutputEncryptedStream
extends DicomOutputStream {
    private static final int NUM_ITERATIONS = 1000;

    public DicomOutputEncryptedStream(OutputStream outputStream, char[] cArray) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        super(DicomOutputEncryptedStream.buildEncryptedOutputStream(outputStream, cArray));
    }

    public static OutputStream buildEncryptedOutputStream(OutputStream outputStream, char[] cArray) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException, IOException {
        Preconditions.checkArgument((cArray != null && cArray.length > 0 ? 1 : 0) != 0);
        CMSEnvelopedDataStreamGenerator cMSEnvelopedDataStreamGenerator = new CMSEnvelopedDataStreamGenerator();
        byte[] byArray = new byte[20];
        new Random().nextBytes(byArray);
        cMSEnvelopedDataStreamGenerator.addPasswordRecipient((CMSPBEKey)new PKCS5Scheme2PBEKey(cArray, byArray, 1000), CMSEnvelopedDataGenerator.AES128_CBC);
        return cMSEnvelopedDataStreamGenerator.open(outputStream, CMSEnvelopedDataGenerator.AES128_CBC, "BC");
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

