/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util.jpeg;

import com.google.common.base.Throwables;
import com.google.common.io.Files;
import com.mimvista.ExternallyVisible;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.util.secondarycapture.J2KLosslessCaptureImageWriter;
import com.mimvista.dicom.util.secondarycapture.SecondaryCaptureImageHandler;
import com.mimvista.util.ay;
import com.mimvista.util.b.h;
import com.mimvista.util.bg;
import com.mimvista.util.progress.g;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.dcm4che2.data.DicomObject;

@ExternallyVisible
public class DicomJpegCompressor {
    private DicomJpegCompressor() {
    }

    public static void compressDicomDirectoryJ2KLossless(File file, File file2, g g2) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file3 : fileArray) {
            File file4 = new File(file2, file3.getName());
            DicomJpegCompressor.compressDicomFileJ2KLossless(file3, file4, g2);
        }
    }

    public static void compressDicomFileJ2KLossless(File file, final File file2, g g2) {
        String string = "JPEG 2000 Compress file " + file.getAbsolutePath();
        bg.b(string);
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file);
        if (dicomObject == null) {
            throw new UnsupportedOperationException("Can not compress given file, not valid DICOM?: " + file);
        }
        if (!dicomObject.contains(2145386512)) {
            ay.a((Object)("Not Compressing because it doesn't contain pixel data: \n" + file), "");
            try {
                Files.copy((File)file, (File)file2);
            }
            catch (IOException iOException) {
                Throwables.propagate((Throwable)iOException);
            }
            return;
        }
        SecondaryCaptureImageHandler secondaryCaptureImageHandler = new SecondaryCaptureImageHandler(new J2KLosslessCaptureImageWriter(dicomObject), g2);
        try {
            secondaryCaptureImageHandler.write(new h(){

                @Override
                public OutputStream createOutputStream(String string) throws IOException {
                    return new FileOutputStream(file2);
                }
            });
            ay.a((Object)DicomJpegCompressor.getResults(file, file2, string), DicomJpegCompressor.class);
        }
        catch (IOException iOException) {
            ay.d((Object)iOException, DicomJpegCompressor.class);
        }
    }

    private static String getResults(File file, File file2, String string) {
        long l2 = DicomJpegCompressor.getFilesize(file);
        long l3 = DicomJpegCompressor.getFilesize(file2);
        double d2 = (double)l3 / (double)l2;
        int n2 = 100 - (int)(d2 * 100.0);
        String string2 = "ms";
        double d3 = (int)((double)bg.d(string) / 1000.0 / 1000.0);
        if (d3 > 1000.0) {
            d3 /= 1000.0;
            string2 = "s";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Compression Results:");
        stringBuilder.append("\n\tSource File: ");
        stringBuilder.append(file.getAbsolutePath());
        stringBuilder.append("\n\tDestination File: ");
        stringBuilder.append(file2.getAbsolutePath());
        stringBuilder.append("\n\tUncompressed Size: ");
        stringBuilder.append(l2);
        stringBuilder.append("\n\tCompressed Size: ");
        stringBuilder.append(l3);
        stringBuilder.append("\n\tCompression Ratio: ");
        stringBuilder.append(n2);
        stringBuilder.append("%\n\tCompression Duration: ");
        stringBuilder.append(d3);
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    private static long getFilesize(File file) {
        try {
            return file.length();
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, DicomJpegCompressor.class);
            return -1L;
        }
    }
}

