/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util.jpeg;

import com.google.common.collect.Lists;
import com.mimvista.ExternallyVisible;
import com.mimvista.dicom.read.DicomReader;
import com.mimvista.dicom.util.jpeg.ImageReaderFactory;
import com.mimvista.numerics.ColorSpaceUtility;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.ay;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.media.FileMetaInformation;

@ExternallyVisible
public class DicomJpegDecompressor {
    private static final int RGB_SAMPLES_PER_PIXEL = 3;
    private static final String[] supportedTS = new String[]{"1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.4.91"};
    private static final String[] losslessFormats = new String[]{"1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.90"};

    private DicomJpegDecompressor() {
    }

    public static final boolean isJpegCompressed(String string) {
        if (string == null) {
            return false;
        }
        for (int i2 = 0; i2 < supportedTS.length; ++i2) {
            if (!string.equals(supportedTS[i2])) continue;
            return true;
        }
        return false;
    }

    public static final boolean isJpeg2000(String string) {
        return "1.2.840.10008.1.2.4.90".equals(string) || "1.2.840.10008.1.2.4.91".equals(string);
    }

    public static boolean isJPEGLossless(DicomObject dicomObject) {
        String string = new FileMetaInformation(dicomObject).getTransferSyntaxUID();
        return DicomJpegDecompressor.isJPEGLossless(string);
    }

    public static boolean isJPEGLossless(String string) {
        for (int i2 = 0; i2 < losslessFormats.length; ++i2) {
            if (!string.equals(losslessFormats[i2])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decompressFile(File file, File file2) {
        DicomObject dicomObject = DicomJpegDecompressor.decompressFileToDicomObject(file);
        if (dicomObject == null) {
            throw new DicomDecompressException("Can not decompress given file: " + file);
        }
        FileOutputStream fileOutputStream = null;
        DicomOutputStream dicomOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            dicomOutputStream = new DicomOutputStream((OutputStream)fileOutputStream);
            dicomOutputStream.writeDicomFile(dicomObject);
        }
        catch (IOException iOException) {
            ay.d((Object)"Error occurs when write dataset to file", (Throwable)iOException, DicomJpegDecompressor.class);
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (dicomOutputStream != null) {
                    dicomOutputStream.close();
                }
            }
            catch (IOException iOException) {
                ay.d((Object)iOException, DicomJpegDecompressor.class);
            }
        }
    }

    public static DicomObject decompressFileToDicomObject(File file) {
        DicomObject dicomObject = DicomReader.readFileIntoDicomObject(file);
        if (dicomObject == null) {
            String string = "Can not read file into DataSet: " + file.getAbsolutePath();
            ay.d((Object)string, DicomJpegDecompressor.class);
            return null;
        }
        if (DicomJpegDecompressor.isJpegCompressed(dicomObject.getString(131088))) {
            return DicomJpegDecompressor.decompressDicomObject(dicomObject);
        }
        return dicomObject;
    }

    public static DicomObject decompressFileToDicomObject(String string) {
        return DicomJpegDecompressor.decompressFileToDicomObject(new File(string));
    }

    private static DicomObject decompressDicomObject(DicomObject dicomObject) {
        int n2;
        short[] sArray = DicomJpegDecompressor.getShortArrayFromDataset(dicomObject, false);
        if (sArray == null) {
            try {
                return DicomReader.saveOutToTempFileAndDecompress(dicomObject);
            }
            catch (IOException iOException) {
                ay.d((Object)"Tried two ways of decompressing this, and both failed. ", (Throwable)iOException, DicomJpegDecompressor.class);
                return null;
            }
        }
        int n3 = dicomObject.getInt(0x280002, 1);
        int n4 = dicomObject.getInt(2621696, 0);
        byte[] byArray = null;
        if (n4 == 16) {
            byArray = new byte[sArray.length * 2];
            for (n2 = 0; n2 < sArray.length; ++n2) {
                byArray[n2 * 2] = (byte)sArray[n2];
                byArray[n2 * 2 + 1] = (byte)(sArray[n2] >> 8);
            }
        } else if (n4 == 8) {
            byArray = new byte[sArray.length];
            for (n2 = 0; n2 < sArray.length; ++n2) {
                byArray[n2] = (byte)sArray[n2];
            }
        } else {
            throw new IllegalArgumentException("Unexpected BitAllocated: " + n4);
        }
        FileMetaInformation fileMetaInformation = new FileMetaInformation(dicomObject);
        fileMetaInformation.setTransferSyntaxUID("1.2.840.10008.1.2.1");
        if (n3 == 3) {
            dicomObject.putString(2621444, null, ColorSpaceUtility.ColorSpace.a.name());
        }
        dicomObject.putBytes(2145386512, VR.OW, byArray);
        return dicomObject;
    }

    public static byte[] getBGRArrayFromDataset(DicomObject dicomObject) {
        BufferedImage[] bufferedImageArray = DicomJpegDecompressor.getBufferedImageFromDicomObject(dicomObject, -1);
        if (bufferedImageArray == null) {
            return null;
        }
        int n2 = DicomJpegDecompressor.getFrameSize(dicomObject);
        byte[] byArray = new byte[n2 * bufferedImageArray.length];
        for (int i2 = 0; i2 < bufferedImageArray.length; ++i2) {
            BufferedImage bufferedImage = bufferedImageArray[i2];
            if (bufferedImage == null) {
                return null;
            }
            byte[] byArray2 = DicomJpegDecompressor.rgbImageToBgrArray(bufferedImage);
            System.arraycopy(byArray2, 0, byArray, i2 * n2, n2);
        }
        return byArray;
    }

    public static DecompressResult getDecompressResultFromDataset(DicomObject dicomObject, boolean bl2) {
        return DicomJpegDecompressor.getDecompressResultFromDataset(dicomObject, -1, bl2);
    }

    public static short[] getShortArrayFromDataset(DicomObject dicomObject, boolean bl2) {
        DecompressResult decompressResult = DicomJpegDecompressor.getDecompressResultFromDataset(dicomObject, bl2);
        return decompressResult == null ? null : decompressResult.decompressedData;
    }

    private static DecompressResult getDecompressResultFromDataset(DicomObject dicomObject, int n2, boolean bl2) {
        BufferedImage[] bufferedImageArray = DicomJpegDecompressor.getBufferedImageFromDicomObject(dicomObject, n2);
        if (bufferedImageArray == null) {
            return null;
        }
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < bufferedImageArray.length; ++i2) {
            arrayList.add(bufferedImageArray[i2]);
        }
        return DicomJpegDecompressor.imagesToShortArray(dicomObject, arrayList, bl2);
    }

    public static BufferedImage[] getBufferedImageFromDicomObject(DicomObject dicomObject) {
        return DicomJpegDecompressor.getBufferedImageFromDicomObject(dicomObject, -1);
    }

    private static BufferedImage[] getBufferedImageFromDicomObject(DicomObject dicomObject, int n2) {
        int n3 = dicomObject.getInt(0x280008, 1);
        if (n2 < 1 || n2 > n3) {
            n2 = n3;
        }
        try {
            byte[][] byArray = DicomJpegDecompressor.getFramesFromPixelData(dicomObject.get(2145386512), n2);
            return DicomJpegDecompressor.readBufferedImagesFromFramesUsingImageIO(dicomObject, n2, byArray);
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, DicomJpegDecompressor.class);
            return null;
        }
    }

    private static BufferedImage[] readBufferedImagesFromFramesUsingImageIO(final DicomObject dicomObject, int n2, byte[][] byArray) {
        ImageReader imageReader;
        FileMetaInformation fileMetaInformation = new FileMetaInformation(dicomObject);
        try {
            imageReader = ImageReaderFactory.getInstance().getReaderForTransferSyntax(fileMetaInformation.getTransferSyntaxUID());
        }
        catch (RuntimeException runtimeException) {
            ay.c((Object)("No ImageReader found for Transfer Syntax: " + fileMetaInformation.getTransferSyntaxUID()), (Throwable)runtimeException, DicomJpegDecompressor.class);
            return null;
        }
        if (imageReader == null) {
            return null;
        }
        BufferedImage[] bufferedImageArray = new BufferedImage[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            ImageInputStream imageInputStream = null;
            try {
                imageInputStream = ImageIO.createImageInputStream(new ByteArrayInputStream(byArray[i2]));
                imageReader.setInput(imageInputStream, true);
                bufferedImageArray[i2] = imageReader.read(0);
                continue;
            }
            catch (Exception exception) {
                FuncUtils.a(new Runnable(){

                    @Override
                    public void run() {
                        ay.c((Object)("Exception thrown when reading Dataset with SOP instance " + dicomObject.getString(524312) + ": " + exception.toString() + " May still be ok, most code paths will fall back to trying dcmdjpeg."), DicomJpegDecompressor.class);
                    }
                }, 5000L, "Stage 1 Decompress Failure Warning");
                return null;
            }
        }
        return bufferedImageArray;
    }

    private static byte[][] getFramesFromPixelData(DicomElement dicomElement, int n2) {
        byte[][] byArrayArray = new byte[n2][];
        int n3 = dicomElement.countItems();
        if (n3 == -1) {
            byArrayArray[0] = dicomElement.getBytes();
            return byArrayArray;
        }
        if (n2 == 1) {
            byArrayArray[0] = DicomJpegDecompressor.concatItem(dicomElement, 1, n3);
            return byArrayArray;
        }
        int[] nArray = DicomJpegDecompressor.getBasicOffsetTableFromEncodedPixelData(dicomElement);
        if (nArray == null) {
            return null;
        }
        int n4 = 1;
        int n5 = 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] byArray;
            if (nArray.length > 1) {
                if (i2 != n2 - 1) {
                    int n6;
                    int n7 = nArray[i2 + 1] - nArray[i2];
                    for (int i3 = 0; i3 < n7; i3 += n6 + 8) {
                        n6 = dicomElement.getFragment(n5++).length;
                    }
                } else {
                    n5 = n3;
                }
                byArray = DicomJpegDecompressor.concatItem(dicomElement, n4, n5);
                n4 = n5;
            } else {
                byArray = dicomElement.getFragment(i2 + 1);
            }
            byArrayArray[i2] = byArray;
        }
        return byArrayArray;
    }

    private static byte[] concatItem(DicomElement dicomElement, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < n3; ++i2) {
            n4 += dicomElement.getFragment(i2).length;
        }
        byte[] byArray = new byte[n4];
        int n5 = 0;
        for (int i3 = n2; i3 < n3; ++i3) {
            byte[] byArray2 = dicomElement.getFragment(i3);
            System.arraycopy(byArray2, 0, byArray, n5, byArray2.length);
            n5 += byArray2.length;
        }
        return byArray;
    }

    public static int getFrameSize(DicomObject dicomObject) {
        int n2 = dicomObject.getInt(2621457, 0);
        int n3 = dicomObject.getInt(2621456, 0);
        int n4 = dicomObject.getInt(0x280002, 1);
        return n2 * n3 * n4;
    }

    private static int[] getBasicOffsetTableFromEncodedPixelData(DicomElement dicomElement) {
        int n2 = dicomElement.getFragment(0).length;
        byte[] byArray = dicomElement.getFragment(0);
        if (n2 % 4 != 0) {
            ay.e("Basic offset table is NOT in 32-bit integers.");
            return null;
        }
        int n3 = n2 / 4;
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = 0xFF & byArray[4 * i2] | (0xFF & byArray[4 * i2 + 1]) << 8 | (0xFF & byArray[4 * i2 + 2]) << 16 | (0xFF & byArray[4 * i2 + 3]) << 24;
        }
        return nArray;
    }

    public static byte[] rgbImageToBgrArray(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n2 = DicomJpegDecompressor.getImgSize(writableRaster);
        byte[] byArray = new byte[n2];
        int[] nArray = writableRaster.getPixels(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), new int[n2]);
        int n3 = 0;
        while (n3 + 2 < nArray.length) {
            byArray[n3 + 2] = (byte)nArray[n3];
            byArray[n3 + 1] = (byte)nArray[n3 + 1];
            byArray[n3] = (byte)nArray[n3 + 2];
            n3 += 3;
        }
        return byArray;
    }

    public static DecompressResult imagesToShortArray(DicomObject dicomObject, List<BufferedImage> list, boolean bl2) {
        Object object;
        int n2;
        if (list == null || list.isEmpty() || list.contains(null)) {
            return null;
        }
        int n3 = dicomObject.getInt(2621699, 1);
        int n4 = dicomObject.getInt(2621696);
        int n5 = dicomObject.getInt(2621697);
        boolean bl3 = false;
        if (n4 == 16 && n3 == 0) {
            bl3 = n5 >= n4;
        }
        int n6 = 0;
        if (bl3 && bl2) {
            n2 = 0;
            int n7 = 0;
            for (BufferedImage bufferedImage : list) {
                object = bufferedImage.getRaster();
                if (((Raster)object).getDataBuffer().getDataType() == 1) {
                    ++n7;
                    continue;
                }
                ++n2;
            }
            if (n7 > 0 && n2 > 0) {
                ay.d((Object)"It looks like this JPEG pixeldata contains both sign and unsigned data??? This image is not going to load correctly...", DicomJpegDecompressor.class);
            }
            if (n7 > 0) {
                n6 = Short.MIN_VALUE;
            }
        }
        n2 = DicomJpegDecompressor.getFrameSize(dicomObject);
        short[] sArray = new short[n2 * list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            BufferedImage bufferedImage;
            bufferedImage = list.get(i2);
            if (bufferedImage == null) {
                return null;
            }
            object = DicomJpegDecompressor.imageToShortArray(bufferedImage, n6);
            System.arraycopy(object, 0, sArray, i2 * n2, n2);
        }
        return new DecompressResult(n6, sArray);
    }

    public static short[] imageToShortArray(BufferedImage bufferedImage, int n2) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        int n3 = DicomJpegDecompressor.getImgSize(writableRaster);
        short[] sArray = new short[n3];
        int[] nArray = writableRaster.getPixels(0, 0, writableRaster.getWidth(), writableRaster.getHeight(), new int[n3]);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n4 = nArray[i2];
            sArray[i2] = (short)(n4 + n2);
        }
        return sArray;
    }

    public static BufferedImage shortArrayToImage(short[] sArray, int n2, int n3, int n4) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, n4);
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray = new int[sArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = sArray[i2];
        }
        writableRaster.setPixels(0, 0, n2, n3, nArray);
        return bufferedImage;
    }

    public static int getImgSize(Raster raster) {
        int n2 = raster.getHeight();
        int n3 = raster.getWidth();
        int n4 = raster.getNumBands();
        return n2 * n3 * n4;
    }

    public static DicomObject decompress(DicomObject dicomObject) {
        if (DicomJpegDecompressor.isJpegCompressed(dicomObject.getString(131088))) {
            return DicomJpegDecompressor.decompressDicomObject(dicomObject);
        }
        return dicomObject;
    }

    public static class DecompressResult {
        public final int appliedOffset;
        public final short[] decompressedData;

        public DecompressResult(int n2, short[] sArray) {
            this.appliedOffset = n2;
            this.decompressedData = sArray;
        }
    }

    public static class DicomDecompressException
    extends UnsupportedOperationException {
        private static final long serialVersionUID = 1L;

        public DicomDecompressException(String string) {
            super(string);
        }
    }
}

