/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util.jpeg;

import com.mimvista.dicom.util.jpeg.ConfigurationException;
import com.mimvista.util.ay;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

public class ImageReaderFactory {
    private static final ImageReaderFactory instance = new ImageReaderFactory();
    private final Properties map = new Properties();
    private boolean performedPluginScan = false;

    public static final ImageReaderFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageReaderFactory() {
        InputStream inputStream = null;
        try {
            inputStream = this.getClass().getResourceAsStream("/properties/ImageReaderFactory.properties");
            this.map.load(inputStream);
        }
        catch (IOException iOException) {
            ay.d((Object)iOException, this);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    ay.d((Object)iOException, this);
                }
            }
        }
    }

    public ImageReader getReaderForTransferSyntax(String string) {
        try {
            String string2 = this.map.getProperty(string);
            if (string2 == null) {
                throw new UnsupportedOperationException("No Image Reader available for Transfer Syntax: " + string);
            }
            String[] stringArray = string2.split(",");
            if (stringArray.length < 2) {
                throw new ConfigurationException("Missing ',' in " + string + "=" + string2);
            }
            String string3 = stringArray[0];
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                String string4 = stringArray[i2];
                Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string3);
                while (iterator.hasNext()) {
                    ImageReader imageReader = iterator.next();
                    if (!string4.equals(imageReader.getClass().getName())) continue;
                    return imageReader;
                }
            }
            if (!this.performedPluginScan) {
                ImageIO.scanForPlugins();
                this.performedPluginScan = true;
                return this.getReaderForTransferSyntax(string);
            }
            throw new ConfigurationException("No Image Reader of available for format: " + string3);
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, this);
            return null;
        }
    }
}

