/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util.jpeg;

import com.mimvista.dicom.util.jpeg.ConfigurationException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;

public class ImageWriterFactory {
    private static final ImageWriterFactory instance = new ImageWriterFactory();
    private final Properties map = new Properties();

    public static final ImageWriterFactory getInstance() {
        return instance;
    }

    private ImageWriterFactory() {
        try {
            this.map.load(this.getClass().getResourceAsStream("/properties/ImageWriterFactory.properties"));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public ImageWriter getWriterForTransferSyntax(String string) {
        String[] stringArray;
        String string2 = this.map.getProperty(string);
        if (string2 == null) {
            throw new UnsupportedOperationException("No Image Writer available for Transfer Syntax:" + string);
        }
        int n2 = string2.indexOf(44);
        if (n2 == -1) {
            throw new ConfigurationException("Missing ',' in " + string + "=" + string2);
        }
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2 + 1);
        for (String string5 : stringArray = string4.split(",")) {
            Iterator<ImageWriter> iterator;
            Iterator<ImageWriter> iterator2 = iterator = ImageIO.getImageWritersByFormatName(string3);
            while (iterator2.hasNext()) {
                ImageWriter imageWriter = iterator2.next();
                if (!string5.equals(imageWriter.getClass().getName())) continue;
                return imageWriter;
            }
        }
        throw new ConfigurationException("No Image Writer of classes " + string4 + " available for format:" + string3);
    }
}

