/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util.secondarycapture;

import com.mimvista.archive.Parser;
import com.mimvista.commands.keyboard.r;
import com.mimvista.d;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.read.NonCrashyDicomObject;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.dicom.util.secondarycapture.CaptureImageWriter;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.dicom.write.DcmWriterFactory;
import com.mimvista.numerics.az;
import com.mimvista.util.cn;
import com.mimvista.viewer.SeriesInfo;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;

public class DefaultCaptureImageWriter
implements CaptureImageWriter {
    private final List<BufferedImage> images;
    private final DicomObject dataSet = new NonCrashyDicomObject();
    private final int largestWidth;
    private final int largestHeight;
    private int numBytesWritten = 0;
    private boolean isMultiframe = true;
    private int singleframeIndex = -1;
    private boolean isMultifile = false;
    private DcmWriter.DcmSaveOptions saveOptions = null;
    private boolean isAnnotated = false;
    private String seriesDescPrefix = "";
    private String seriesDescription = null;
    private String studyDescription = null;
    private String modality = null;
    private boolean monochromeMode = false;
    private static final int[] SecondaryCaptureImageFilter = new int[]{0x100010, 0x100020, 0x100030, 0x100040, 0x20000D, 524320, 524336, 524432, 0x200010, 524368, 0x200011, 524293, 524400, 528528, 1576992};

    public DefaultCaptureImageWriter(SeriesInfo seriesInfo, List<BufferedImage> list) {
        this(list);
        this.loadFields(seriesInfo);
    }

    public DefaultCaptureImageWriter(TreeMap<Integer, String> treeMap, List<BufferedImage> list) {
        this(list);
        this.loadFields(treeMap);
    }

    private DefaultCaptureImageWriter(List<BufferedImage> list) {
        this.images = list;
        int n2 = 0;
        int n3 = 0;
        for (BufferedImage bufferedImage : list) {
            n2 = n2 > bufferedImage.getWidth() ? n2 : bufferedImage.getWidth();
            n3 = n3 > bufferedImage.getHeight() ? n3 : bufferedImage.getHeight();
        }
        this.largestWidth = n2;
        this.largestHeight = n3;
    }

    private int computeFrameSize(BufferedImage bufferedImage) {
        if (this.isMultifile) {
            return bufferedImage.getWidth() * bufferedImage.getHeight() * this.getBytesPerPixel();
        }
        return this.largestWidth * this.largestHeight * this.getBytesPerPixel();
    }

    private int computeTotalBytes(BufferedImage bufferedImage) {
        int n2 = this.computeFrameSize(bufferedImage);
        int n3 = this.isMultifile ? n2 : n2 * this.size();
        if (n3 % 2 != 0) {
            ++n3;
        }
        return n3;
    }

    public void setMonochromeMode(boolean bl2) {
        this.monochromeMode = bl2;
    }

    public void setAnnotated(boolean bl2) {
        this.isAnnotated = bl2;
    }

    public void setSaveOptions(DcmWriter.DcmSaveOptions dcmSaveOptions) {
        this.saveOptions = dcmSaveOptions;
    }

    public void setSeriesDescPrefix(String string) {
        this.seriesDescPrefix = string;
    }

    public void setSeriesDescription(String string) {
        this.seriesDescription = string;
    }

    public void setStudyDescription(String string) {
        this.studyDescription = string;
    }

    public void setModality(String string) {
        this.modality = string;
    }

    @Override
    public void setSingleframeIndex(int n2) {
        this.singleframeIndex = n2;
        this.isMultiframe = n2 < 0;
    }

    @Override
    public Iterator<BufferedImage> iterator() {
        return this.images.iterator();
    }

    @Override
    public int size() {
        return this.images.size();
    }

    public int columns(BufferedImage bufferedImage) {
        if (!this.isMultifile) {
            return this.largestWidth;
        }
        return bufferedImage.getWidth();
    }

    public int rows(BufferedImage bufferedImage) {
        if (!this.isMultifile) {
            return this.largestHeight;
        }
        return bufferedImage.getHeight();
    }

    @Override
    public boolean requiresMultiframeOutput() {
        return false;
    }

    private int getSamplesPerPixel() {
        return this.monochromeMode ? 1 : 3;
    }

    private int getBytesPerSample() {
        return this.monochromeMode ? 2 : 1;
    }

    private int getBytesPerPixel() {
        return this.getSamplesPerPixel() * this.getBytesPerSample();
    }

    @Override
    public byte[] getBytes(BufferedImage bufferedImage) {
        int n2 = this.computeFrameSize(bufferedImage);
        byte[] byArray = new byte[n2];
        int n3 = bufferedImage.getWidth();
        int n4 = bufferedImage.getHeight();
        short[] sArray = null;
        int[] nArray = null;
        int n5 = -1;
        int n6 = this.columns(bufferedImage);
        int n7 = this.rows(bufferedImage);
        if (this.monochromeMode) {
            sArray = new short[n3 * n4];
            r.a(bufferedImage, sArray, new az(0, 0), n3, n4);
            n5 = sArray.length;
        } else {
            nArray = bufferedImage.getRGB(0, 0, n3, n4, null, 0, n3);
            n5 = nArray.length;
        }
        int n8 = this.getBytesPerPixel();
        for (int i2 = 0; i2 < n5; ++i2) {
            int n9 = i2 / n3 * (n6 * n8) + (n7 - n4) / 2 * (n6 * n8) + i2 % n3 * n8 + (n6 - n3) / 2 * n8;
            if (this.monochromeMode) {
                byArray[n9] = (byte)(sArray[i2] >> 16 & 0xFF);
                byArray[n9 + 1] = (byte)(sArray[i2] >> 8 & 0xFF);
                continue;
            }
            byArray[n9] = (byte)(nArray[i2] >> 16 & 0xFF);
            byArray[n9 + 1] = (byte)(nArray[i2] >> 8 & 0xFF);
            byArray[n9 + 2] = (byte)(nArray[i2] & 0xFF);
        }
        return byArray;
    }

    @Override
    public DicomObject getNonImageDicom(@d BufferedImage bufferedImage) {
        if (this.isMultifile && bufferedImage == null) {
            throw new IllegalArgumentException("Must provide image for multifile dicom.");
        }
        this.dataSet.initFileMetaInformation("1.2.840.10008.1.2.1");
        this.applyGenericTemplate();
        this.applyDcmSaveOptions();
        if (this.isMultiframe) {
            this.applyMultiframeTemplate();
        } else {
            this.applySingleframeTemplate();
        }
        this.dataSet.putInt(2621456, VR.US, this.rows(bufferedImage));
        this.dataSet.putInt(2621457, VR.US, this.columns(bufferedImage));
        return this.dataSet;
    }

    @Override
    public void writePixelDataHeader(DicomOutputStream dicomOutputStream, @d BufferedImage bufferedImage) throws IOException {
        this.numBytesWritten = 0;
        dicomOutputStream.writeHeader(2145386512, VR.OW, this.computeTotalBytes(bufferedImage));
    }

    @Override
    public void writePixelData(DicomOutputStream dicomOutputStream, byte[] byArray) throws IOException {
        dicomOutputStream.write(byArray);
        this.numBytesWritten += byArray.length;
    }

    @Override
    public void writePixelDataFooter(DicomOutputStream dicomOutputStream, @d BufferedImage bufferedImage) throws IOException {
        int n2 = this.computeTotalBytes(bufferedImage);
        if (this.numBytesWritten < n2) {
            byte[] byArray = new byte[n2 - this.numBytesWritten];
            dicomOutputStream.write(byArray);
        }
    }

    private void loadFields(SeriesInfo seriesInfo) {
        this.dataSet.putString(0x100010, null, seriesInfo.patientNameRaw);
        this.dataSet.putString(0x100020, null, seriesInfo.patientId);
        this.dataSet.putString(0x100030, null, seriesInfo.birthDate);
        this.dataSet.putString(0x100040, null, seriesInfo.sex);
        String string = seriesInfo.studyUID;
        if (cn.g(string)) {
            string = UIDGenerator.generateUID();
        }
        this.dataSet.putString(0x20000D, null, string);
        this.dataSet.putString(524320, null, seriesInfo.N());
        this.dataSet.putDate(524336, null, seriesInfo.studyTime);
        this.dataSet.putString(524432, null, seriesInfo.referringPhys);
        this.dataSet.putString(0x200010, null, seriesInfo.studyID);
        this.dataSet.putString(524368, null, seriesInfo.accession);
        this.dataSet.putString(524400, null, seriesInfo.manufacturer);
        this.dataSet.putString(528528, null, seriesInfo.modelName);
        this.dataSet.putString(1576992, null, seriesInfo.softwareVersions);
        Date date = seriesInfo.studyTime;
        if (date == null) {
            date = new Date(0L);
        }
        Date date2 = new Date();
        long l2 = date2.getTime() - date.getTime();
        long l3 = l2 / 1000L;
        this.dataSet.putString(0x200011, null, "" + (l3 += 50000L));
        this.dataSet.putString(524388, null, "WSD");
        this.dataSet.putString(524321, null, seriesInfo.M());
        this.dataSet.putString(524337, null, seriesInfo.P());
        this.dataSet.putDate(524322, null, seriesInfo.acqDate);
        this.dataSet.putDate(524338, null, seriesInfo.acqTime);
    }

    private void loadFields(TreeMap<Integer, String> treeMap) {
        Parser.setDefaultSpecificCharacterSet(this.dataSet);
        if (treeMap.get(0x20000D) == null) {
            treeMap.put(0x20000D, UIDGenerator.generateUID());
        }
        for (int i2 = 0; i2 < SecondaryCaptureImageFilter.length; ++i2) {
            String string = treeMap.get(SecondaryCaptureImageFilter[i2]);
            if (string == null) {
                string = "";
            }
            this.dataSet.putString(SecondaryCaptureImageFilter[i2], null, string);
        }
    }

    private void applyMultiframeTemplate() {
        this.dataSet.putString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.7.4");
        this.dataSet.putString(131074, VR.UI, "1.2.840.10008.5.1.4.1.1.7.4");
        this.dataSet.putString(0x200060, VR.CS, "");
        this.dataSet.putInt(2621449, VR.AT, 1581057);
        int[] nArray = new int[this.size()];
        for (int i2 = 0; i2 < this.size(); ++i2) {
            nArray[i2] = i2 + 1;
        }
        this.dataSet.putInts(1581057, VR.IS, nArray);
        this.dataSet.putInt(2097171, VR.IS, 1);
        this.dataSet.putString(0x200020, VR.CS, "");
        this.dataSet.putInt(0x280008, null, this.size());
    }

    private void applySingleframeTemplate() {
        this.dataSet.putString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.7");
        this.dataSet.putString(131074, VR.UI, "1.2.840.10008.5.1.4.1.1.7");
        this.dataSet.putInt(2097171, null, this.singleframeIndex);
        this.dataSet.putFloat(2101313, null, (float)this.singleframeIndex);
        this.dataSet.putInt(0x280008, null, 1);
    }

    private String getPhotometricInterp() {
        return this.monochromeMode ? "MONOCHROME2" : "RGB";
    }

    private int getBitsPerSample() {
        return this.getBytesPerSample() * 8;
    }

    private void applyGenericTemplate() {
        Parser.setDefaultSpecificCharacterSet(this.dataSet);
        String string = Modality.OT.get();
        if (!cn.g(this.modality)) {
            string = this.modality;
        }
        this.dataSet.putString(524384, VR.CS, string);
        if (this.saveOptions != null && !this.saveOptions.keepAssociation) {
            this.dataSet.putString(0x20000D, VR.UI, UIDGenerator.generateUID());
        }
        String string2 = UIDGenerator.generateUID();
        this.dataSet.putString(524312, VR.UI, string2);
        this.dataSet.putString(131075, VR.UI, string2);
        this.dataSet.putString(0x20000E, VR.UI, UIDGenerator.generateUID());
        this.dataSet.putString(524388, VR.CS, "WSD");
        if (!cn.g(this.seriesDescription)) {
            this.dataSet.putString(528446, VR.LO, this.seriesDescription);
        }
        if (!cn.g(this.studyDescription)) {
            this.dataSet.putString(528432, VR.LO, this.studyDescription);
        }
        this.dataSet.putInt(0x280002, VR.US, this.getSamplesPerPixel());
        this.dataSet.putString(2621444, VR.CS, this.getPhotometricInterp());
        this.dataSet.putInt(2621696, VR.US, this.getBitsPerSample());
        this.dataSet.putInt(2621697, VR.US, this.getBitsPerSample());
        this.dataSet.putInt(2621698, VR.US, this.getBitsPerSample() - 1);
        this.dataSet.putInt(2621699, VR.US, 0);
        this.dataSet.putInt(2621446, VR.US, 0);
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        this.dataSet.putString(524323, VR.DA, simpleDateFormat.format(date));
        this.dataSet.putDate(524339, VR.TM, date);
        this.dataSet.putString(1576982, null, "MIM Software");
        this.dataSet.putStrings(524296, null, new String[]{"DERIVED", "SECONDARY"});
        if (this.isAnnotated) {
            this.dataSet.putString(2622209, VR.CS, "YES");
        } else {
            this.dataSet.putString(2622209, VR.CS, "NO");
        }
    }

    private void applyDcmSaveOptions() {
        if (this.saveOptions == null) {
            return;
        }
        this.dataSet.putString(524368, VR.SH, this.saveOptions.accession);
        this.dataSet.putString(0x100010, VR.PN, this.saveOptions.dicomName);
        this.dataSet.putString(0x100020, VR.LO, this.saveOptions.patientID);
        this.dataSet.putString(524432, null, DcmWriterFactory.formatNameForDICOM(this.saveOptions.referringFirst, null, this.saveOptions.referringLast));
        this.dataSet.putString(528446, null, this.seriesDescPrefix + this.saveOptions.seriesDescription);
        this.dataSet.putString(528432, null, this.saveOptions.studyDescription);
        this.dataSet.putString(0x200010, null, this.saveOptions.studyID);
        if (!this.saveOptions.keepAssociation) {
            this.dataSet.putString(0x20000D, VR.UI, UIDGenerator.generateUID());
        } else if (this.saveOptions.savedAssociatedUID != null) {
            this.dataSet.putString(0x20000D, VR.UI, this.saveOptions.savedAssociatedUID);
        }
    }

    @Override
    public void setMultiFile(boolean bl2) {
        this.isMultifile = bl2;
    }
}

