/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.util.secondarycapture;

import com.mimvista.d;
import com.mimvista.dicom.DicomImageConverter;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.read.NonCrashyDicomObject;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.dicom.util.jpeg.ImageWriterFactory;
import com.mimvista.dicom.util.secondarycapture.CaptureImageWriter;
import com.mimvista.install.MimInstaller;
import com.mimvista.numerics.ColorSpaceUtility;
import com.mimvista.util.ay;
import com.sun.media.imageio.plugins.jpeg2000.J2KImageWriteParam;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.LookupOp;
import java.awt.image.ShortLookupTable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4che2.media.FileMetaInformation;

public class J2KLosslessCaptureImageWriter
implements CaptureImageWriter {
    private final DicomObject source;
    private final int numberOfFrames;
    private final MonochromeCorrector monoCorrect;
    private boolean multiFile = false;

    public J2KLosslessCaptureImageWriter(DicomObject dicomObject) {
        this.source = dicomObject;
        this.numberOfFrames = dicomObject.getInt(0x280008, 1);
        this.monoCorrect = new MonochromeCorrector(dicomObject);
    }

    @Override
    public void setSingleframeIndex(int n2) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support single-frame image writing");
    }

    @Override
    public int size() {
        if (this.numberOfFrames > 0) {
            return this.numberOfFrames;
        }
        return 1;
    }

    public int columns() {
        return this.source.getInt(2621457);
    }

    public int rows() {
        return this.source.getInt(2621456);
    }

    @Override
    public boolean requiresMultiframeOutput() {
        return true;
    }

    @Override
    public Iterator<BufferedImage> iterator() {
        return new LazyImageLoaderIterator();
    }

    @Override
    public byte[] getBytes(BufferedImage bufferedImage) {
        return J2KLosslessCaptureImageWriter.compress(bufferedImage);
    }

    @Override
    public DicomObject getNonImageDicom(@d BufferedImage bufferedImage) {
        NonCrashyDicomObject nonCrashyDicomObject = new NonCrashyDicomObject();
        this.source.subSet(524293, 2145386511).copyTo((DicomObject)nonCrashyDicomObject, false);
        this.source.subSet(2145386513, -1).copyTo((DicomObject)nonCrashyDicomObject, false);
        nonCrashyDicomObject.initFileMetaInformation("1.2.840.10008.1.2.1");
        FileMetaInformation fileMetaInformation = new FileMetaInformation((DicomObject)nonCrashyDicomObject);
        fileMetaInformation.setTransferSyntaxUID("1.2.840.10008.1.2.4.90");
        nonCrashyDicomObject.putInt(2621446, VR.US, 0);
        if (this.source.getInt(0x280002) == 3) {
            nonCrashyDicomObject.putString(2621444, VR.CS, ColorSpaceUtility.ColorSpace.a.name());
        }
        if (Modality.OT.isSameModality(this.source.getString(524384, Modality.OT.get()))) {
            fileMetaInformation.setImplementationClassUID("2.16.840.1.114362.1");
            fileMetaInformation.setImplementationVersionName("MIM " + MimInstaller.getVersion());
            fileMetaInformation.setSourceApplicationEntityTitle("MIM");
            nonCrashyDicomObject.putString(524312, VR.UI, UIDGenerator.generateUID());
            nonCrashyDicomObject.putString(524388, VR.CS, "WSD");
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            nonCrashyDicomObject.putString(524323, VR.DA, simpleDateFormat.format(date));
            nonCrashyDicomObject.putDate(524339, VR.TM, date);
            nonCrashyDicomObject.putString(1576982, null, "MIM Software");
            nonCrashyDicomObject.putStrings(524296, null, new String[]{"DERIVED", "SECONDARY"});
            String string = "1.2.840.10008.5.1.4.1.1.7.4";
            nonCrashyDicomObject.putString(131074, VR.UI, string);
            nonCrashyDicomObject.putString(524310, VR.UI, string);
        }
        return nonCrashyDicomObject;
    }

    @Override
    public void writePixelDataHeader(DicomOutputStream dicomOutputStream, @d BufferedImage bufferedImage) throws IOException {
        dicomOutputStream.writeHeader(2145386512, VR.OW, -1);
        dicomOutputStream.writeHeader(-73728, null, 0);
    }

    @Override
    public void writePixelData(DicomOutputStream dicomOutputStream, byte[] byArray) throws IOException {
        if (byArray == null) {
            return;
        }
        int n2 = byArray.length % 2 == 0 ? byArray.length : byArray.length + 1;
        dicomOutputStream.writeHeader(-73728, null, n2);
        dicomOutputStream.write(byArray);
        if (byArray.length % 2 != 0) {
            dicomOutputStream.write(0);
        }
    }

    @Override
    public void writePixelDataFooter(DicomOutputStream dicomOutputStream, @d BufferedImage bufferedImage) throws IOException {
        dicomOutputStream.writeHeader(-73728, null, 0);
        dicomOutputStream.writeHeader(-73507, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] compress(BufferedImage bufferedImage) {
        IIOImage iIOImage;
        if (bufferedImage == null) {
            return null;
        }
        ImageWriter imageWriter = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ImageOutputStream imageOutputStream = null;
        try {
            imageWriter = ImageWriterFactory.getInstance().getWriterForTransferSyntax("1.2.840.10008.1.2.4.90");
            byteArrayOutputStream = new ByteArrayOutputStream();
            imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            imageWriter.setOutput(imageOutputStream);
            J2KImageWriteParam j2KImageWriteParam = new J2KImageWriteParam();
            j2KImageWriteParam.setWriteCodeStreamOnly(true);
            iIOImage = new IIOImage(bufferedImage, null, null);
            imageWriter.write(null, iIOImage, (ImageWriteParam)j2KImageWriteParam);
            imageOutputStream.flush();
            if (byteArrayOutputStream.size() == 0) {
                ay.c((Object)"Attempting to compress image to J2KLossless results in 0byte output", J2KLosslessCaptureImageWriter.class);
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Throwable throwable) {
            ay.d((Object)throwable, J2KLosslessCaptureImageWriter.class);
            iIOImage = null;
            return iIOImage;
        }
        finally {
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (imageWriter != null) {
                imageWriter.dispose();
            }
        }
    }

    @Override
    public void setMultiFile(boolean bl2) {
        this.multiFile = bl2;
    }

    private static class MonochromeCorrector {
        private final boolean isMonochrome1;
        private final boolean isMonochrome2;
        private final boolean is16bit;
        private static final BufferedImageOp inverseOp;

        public MonochromeCorrector(DicomObject dicomObject) {
            String string = dicomObject.getString(2621444);
            this.isMonochrome1 = "MONOCHROME1".equals(string);
            this.isMonochrome2 = "MONOCHROME2".equals(string);
            this.is16bit = dicomObject.getInt(2621696, -1) == 16;
        }

        private boolean needsCorrection() {
            return this.is16bit && (this.isMonochrome1 || this.isMonochrome2);
        }

        public BufferedImage correct(BufferedImage bufferedImage) {
            if (bufferedImage == null || !this.needsCorrection()) {
                return bufferedImage;
            }
            BufferedImage bufferedImage2 = bufferedImage;
            bufferedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 11);
            if (this.isMonochrome1) {
                inverseOp.filter(bufferedImage2, bufferedImage);
            } else {
                bufferedImage.setData(bufferedImage2.getData());
            }
            return bufferedImage;
        }

        static {
            short[] sArray = new short[256];
            for (int i2 = 0; i2 < sArray.length; ++i2) {
                sArray[i2] = (short)(255 - i2);
            }
            inverseOp = new LookupOp(new ShortLookupTable(0, sArray), null);
        }
    }

    private class LazyImageLoaderIterator
    implements Iterator<BufferedImage> {
        private int frameCount = 1;
        private boolean hasMore = true;

        private LazyImageLoaderIterator() {
        }

        @Override
        public boolean hasNext() {
            if (J2KLosslessCaptureImageWriter.this.numberOfFrames > 0) {
                return this.frameCount <= J2KLosslessCaptureImageWriter.this.numberOfFrames;
            }
            return this.hasMore;
        }

        @Override
        public BufferedImage next() {
            try {
                BufferedImage bufferedImage = DicomImageConverter.toBufferedImage(J2KLosslessCaptureImageWriter.this.source, this.frameCount++);
                BufferedImage bufferedImage2 = J2KLosslessCaptureImageWriter.this.monoCorrect.correct(bufferedImage);
                return bufferedImage2;
            }
            finally {
                this.hasMore = false;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

