/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.dicom.write.AbstractVolumetricDcmWriter;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.internals.ReadOnlyContrast;
import com.mimvista.viewer.SeriesInfo;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public abstract class AbstractDcmModule {
    protected final DcmWriter writer;

    protected static void fillContrastTagsUsingRescale(DcmWriter dcmWriter, DicomObject dicomObject, SeriesInfo seriesInfo) {
        RescaleConverter rescaleConverter = dcmWriter.getRescaleConverterForSave();
        if (rescaleConverter != null) {
            dicomObject.putFloat(2625619, null, rescaleConverter.slope * rescaleConverter.unitScale);
            dicomObject.putFloat(2625618, null, rescaleConverter.intercept * rescaleConverter.unitScale);
        } else {
            ReadOnlyContrast readOnlyContrast = dcmWriter.getContrast();
            dicomObject.putFloat(2625619, null, readOnlyContrast.z() * seriesInfo.rescale.unitScale);
            dicomObject.putFloat(2625618, null, readOnlyContrast.y() * seriesInfo.rescale.unitScale);
        }
    }

    protected static void fillWidthAndCenterTags(DcmWriter dcmWriter, DicomObject dicomObject, SeriesInfo seriesInfo) {
        ReadOnlyContrast readOnlyContrast = dcmWriter.getContrast();
        if (dcmWriter.shouldWriteDeactualizedPixelValues()) {
            float f2 = readOnlyContrast.c();
            float f3 = readOnlyContrast.h();
            dicomObject.putFloat(2625617, null, f3);
            dicomObject.putFloat(2625616, null, f2);
        } else {
            RescaleConverter rescaleConverter = dcmWriter.getVolume().getUncopiedMutableInfo().rescale.clone();
            rescaleConverter.unitScale = 1.0f;
            float f4 = rescaleConverter.apply(readOnlyContrast.d());
            float f5 = rescaleConverter.apply(readOnlyContrast.e());
            dicomObject.putFloat(2625617, null, f5 - f4);
            dicomObject.putFloat(2625616, null, (f4 + f5) / 2.0f);
        }
    }

    public static boolean isNMConvertedToCPS(SeriesInfo seriesInfo) {
        return "NM".equals(seriesInfo.modality) && seriesInfo.af() != null && DataUnitUtils.COUNTS_CANON_.matchesUnit(seriesInfo.af()) && (DataUnitUtils.CPS_CANON_.matchesUnit(seriesInfo.u().z()) || DataUnitUtils.CPS_PER_ML_CANON_.matchesUnit(seriesInfo.u().z()));
    }

    public AbstractDcmModule(DcmWriter dcmWriter) {
        this.writer = dcmWriter;
    }

    public void fillOrientationTags(DicomObject dicomObject) {
        float[] fArray = AbstractVolumetricDcmWriter.calculateNewOrientation(this.writer.vs.ap(), this.writer.saveOptions.applyGantryTilt, this.writer.saveOptions.applyViewingRotation, this.writer.saveOptions.saveAsOrthogonal, this.writer.plane);
        dicomObject.putFloats(2097207, VR.DS, fArray);
    }

    public void updateTags(DicomObject dicomObject) {
    }

    public abstract void fillTags(DicomObject var1);
}

