/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.collect.Lists;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.dicom.write.AbstractDcmModule;
import com.mimvista.dicom.write.DcmCommonModule;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.SimpleOrientationHelper;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ViewStateNew;
import com.mimvista.internals.a.v;
import com.mimvista.internals.ab;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.bc;
import com.mimvista.mui.be;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.ImageCube;
import com.mimvista.numerics.ImageSlice;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.VoxelPoint3f;
import com.mimvista.numerics.VoxelViewingPoint3f;
import com.mimvista.numerics.bk;
import com.mimvista.numerics.bm;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.cm;
import com.mimvista.util.progress.Progress;
import com.mimvista.viewer.Interpolator;
import java.awt.Point;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomOutputStream;

public abstract class AbstractVolumetricDcmWriter
extends DcmWriter {
    public static final float SQUARE_VOX_THRESHOLD = 1.0E-4f;
    protected ViewController3D vs3D;
    protected RawDicomUtils rawDicomUtils = new RawDicomUtils();
    protected String transferSyntax = "1.2.840.10008.1.2.1";
    protected String sopClassUID;
    List<AbstractDcmModule> modules;

    public static boolean isMatrixIdentity(Matrix4f matrix4f) {
        Matrix4f matrix4f2 = MatrixMultiplier.b();
        return matrix4f2.epsilonEquals(matrix4f, 0.001f);
    }

    public static float[] calculateNewOrientation(ViewStateNew viewStateNew, boolean bl2, boolean bl3, boolean bl4, PresentationType presentationType) {
        float f2;
        Float f3;
        Object object;
        float[] fArray;
        if (bl4) {
            fArray = SimpleOrientationHelper.a();
        } else {
            object = AbstractVolumetricDcmWriter.getSaveMatrix(viewStateNew, bl2, bl3);
            f3 = bl2 || bl3 ? viewStateNew.i().getUncopiedMutableInfo().H() : null;
            fArray = ab.a(viewStateNew.i().getUncopiedMutableInfo().imageOrientation, f3, object);
        }
        object = ab.a(fArray, presentationType);
        f3 = new Vector3f((float)object[0], (float)object[1], (float)object[2]);
        Vector3f vector3f = new Vector3f((float)object[3], (float)object[4], (float)object[5]);
        float f4 = f3.length();
        if (f4 != 0.0f) {
            f3.scale(1.0f / f4);
        }
        if ((f2 = vector3f.length()) != 0.0f) {
            vector3f.scale(1.0f / f2);
        }
        return new float[]{((Vector3f)f3).x, ((Vector3f)f3).y, ((Vector3f)f3).z, vector3f.x, vector3f.y, vector3f.z};
    }

    public AbstractVolumetricDcmWriter(ViewController viewController) {
        this.setViewController(viewController);
        this.modules = Lists.newArrayList();
        this.modules.add(new DcmCommonModule(this));
    }

    @Override
    public void setViewController(ViewController viewController) {
        super.setViewController(viewController);
        if (viewController instanceof ViewController3D) {
            this.vs3D = (ViewController3D)viewController;
        }
    }

    protected DicomPoint3f addImagePositionTag(DicomObject dicomObject, int[] nArray, int n2, ImageVolumeShort imageVolumeShort, Matrix4f matrix4f) {
        DicomPoint3f dicomPoint3f;
        int[] nArray2 = this.plane.a();
        float[] fArray = new float[3];
        float[] fArray2 = this.getXYScaleFactor();
        for (int i2 = 0; i2 < 2; ++i2) {
            fArray[nArray2[i2]] = (float)nArray[i2 * 2] + 0.5f * fArray2[i2];
        }
        fArray[nArray2[2]] = (float)n2 + 0.5f * fArray2[2];
        VoxelPoint3f voxelPoint3f = new VoxelPoint3f(fArray, (SimpleImageFrame)imageVolumeShort);
        MetricPoint3f metricPoint3f = voxelPoint3f.a(imageVolumeShort);
        if (this.saveOptions.saveAsOrthogonal) {
            metricPoint3f.z *= -1.0f;
            dicomPoint3f = new DicomPoint3f(metricPoint3f.f(), (SimpleImageFrame)imageVolumeShort);
        } else {
            matrix4f.transform((Point3f)metricPoint3f);
            dicomPoint3f = metricPoint3f.d();
        }
        dicomObject.putFloats(0x200032, VR.DS, dicomPoint3f.f());
        return dicomPoint3f;
    }

    protected void createDataForSlice(int[] nArray, int n2, ImageVolumeShort imageVolumeShort, Matrix4f matrix4f, ByteBuffer byteBuffer, boolean bl2) {
        boolean bl3;
        int[] nArray2 = this.plane.a();
        ViewStateNew viewStateNew = this.vs.ap();
        short s2 = bc.a(this.vs.ap(), imageVolumeShort);
        boolean bl4 = true;
        RescaleConverter rescaleConverter = null;
        RescaleConverter rescaleConverter2 = null;
        if (this.shouldWriteDeactualizedPixelValues()) {
            rescaleConverter2 = this.getRescaleConverterForSave();
            bl4 = this.needsUnsignedDeactualizedSave();
        } else {
            rescaleConverter = imageVolumeShort.getUncopiedMutableInfo().rescale.clone();
            rescaleConverter.unitScale = 1.0f;
            bl4 = this.needsUnsignedActualizedSave();
        }
        boolean bl5 = bl3 = Math.abs(imageVolumeShort.b()[nArray2[0]] - imageVolumeShort.b()[nArray2[1]]) < 1.0E-4f;
        if (AbstractVolumetricDcmWriter.isMatrixIdentity(matrix4f) && (!this.saveOptions.squareVoxels || this.saveOptions.squareVoxels && bl3)) {
            int[] nArray3 = imageVolumeShort.a();
            short[] sArray = (short[])((ImageSlice.ImageSliceShort)((ImageCube.ImageCubeShort)imageVolumeShort.ad()).a((int)n2, (int)nArray2[2])).data;
            short[] sArray2 = null;
            ImageVolumeShort imageVolumeShort2 = (ImageVolumeShort)this.vs.ap().b();
            if (imageVolumeShort2 != null) {
                sArray2 = (short[])((ImageSlice.ImageSliceShort)((ImageCube.ImageCubeShort)imageVolumeShort2.ad()).a((int)n2, (int)nArray2[2])).data;
            }
            int n3 = this.plane == PresentationType.b ? nArray3[1] : nArray3[0];
            for (int i2 = nArray[2]; i2 <= nArray[3]; ++i2) {
                int n4 = i2 * n3 + nArray[0];
                int n5 = nArray[0];
                while (n5 <= nArray[1]) {
                    float f2;
                    short s3 = sArray2 != null && sArray2[n4] == 0 ? s2 : sArray[n4];
                    if (rescaleConverter != null) {
                        f2 = rescaleConverter.apply(s3);
                        if (bl4) {
                            byteBuffer.putChar(MathUtils.g(f2));
                        } else {
                            byteBuffer.putShort(MathUtils.f(f2));
                        }
                    } else if (rescaleConverter2 != null) {
                        f2 = imageVolumeShort.getUncopiedMutableInfo().rescale.apply(s3);
                        float f3 = rescaleConverter2.removeRaw(f2);
                        if (bl4) {
                            byteBuffer.putChar(MathUtils.g(f3));
                        } else {
                            byteBuffer.putShort(MathUtils.f(f3));
                        }
                    } else {
                        byteBuffer.putShort(s3);
                    }
                    ++n5;
                    ++n4;
                }
            }
        } else {
            int[] nArray4 = this.getOutputVolumeDims();
            VoxelViewingPoint3f voxelViewingPoint3f = new VoxelViewingPoint3f((float)this.extent[0], (float)this.extent[2], (float)this.extent[4], imageVolumeShort);
            VoxelViewingPoint3f voxelViewingPoint3f2 = new VoxelViewingPoint3f((float)(this.extent[1] + 1), (float)(this.extent[3] + 1), (float)(this.extent[5] + 1), imageVolumeShort);
            VoxelViewingPoint3f voxelViewingPoint3f3 = voxelViewingPoint3f.a();
            VoxelViewingPoint3f voxelViewingPoint3f4 = voxelViewingPoint3f.a();
            voxelViewingPoint3f4.a(nArray2[1], voxelViewingPoint3f2.b(nArray2[1]));
            VoxelViewingPoint3f voxelViewingPoint3f5 = voxelViewingPoint3f.a();
            voxelViewingPoint3f5.a(nArray2[0], voxelViewingPoint3f2.b(nArray2[0]));
            VoxelViewingPoint3f voxelViewingPoint3f6 = voxelViewingPoint3f5.a();
            voxelViewingPoint3f6.a(nArray2[1], voxelViewingPoint3f2.b(nArray2[1]));
            bm bm2 = new bm(voxelViewingPoint3f3, new Point(0, 0));
            bm bm3 = new bm(voxelViewingPoint3f4, new Point(0, nArray4[1]));
            bm bm4 = new bm(voxelViewingPoint3f5, new Point(nArray4[0], 0));
            bm bm5 = new bm(voxelViewingPoint3f6, new Point(nArray4[0], nArray4[1]));
            bk bk2 = new bk(bm2, bm3, bm4, bm5);
            be.l l2 = new be.l();
            v v2 = imageVolumeShort.d(matrix4f, (float)n2 + 0.5f, nArray2, s2, bk2, Interpolator.InterpolationType.b);
            if (!bl2) {
                v2.j = null;
            }
            ImageSlice.ImageSliceShort imageSliceShort = l2.a(imageVolumeShort, (ImageVolumeShort)viewStateNew.b(), v2);
            short[] sArray = (short[])imageSliceShort.data;
            if (rescaleConverter != null) {
                for (int i3 = 0; i3 < sArray.length; ++i3) {
                    float f4 = rescaleConverter.apply(sArray[i3]);
                    if (bl4) {
                        byteBuffer.putChar(MathUtils.g(f4));
                        continue;
                    }
                    byteBuffer.putShort(MathUtils.f(f4));
                }
            } else if (rescaleConverter2 != null) {
                for (int i4 = 0; i4 < sArray.length; ++i4) {
                    float f5 = imageVolumeShort.getUncopiedMutableInfo().rescale.apply(sArray[i4]);
                    float f6 = rescaleConverter2.removeRaw(f5);
                    if (bl4) {
                        byteBuffer.putChar(MathUtils.g(f6));
                        continue;
                    }
                    byteBuffer.putShort(MathUtils.f(f6));
                }
            } else {
                byteBuffer.asShortBuffer().put(sArray);
                byteBuffer.position(byteBuffer.position() + sArray.length * 2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean output(DicomObject dicomObject, FuncUtils.n<DicomOutputStream, IOException> n2, String string) {
        boolean bl2;
        DicomOutputStream dicomOutputStream = null;
        try {
            dicomOutputStream = new DicomOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(string))));
            dicomOutputStream.writeDicomFile(dicomObject);
            n2.doIt(dicomOutputStream);
            if (this.progress != null && this.progress.n() == Progress.Status.e) {
                boolean bl3 = false;
                cm.a((Closeable)dicomOutputStream, null, null);
                return bl3;
            }
            bl2 = true;
            cm.a((Closeable)dicomOutputStream, null, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            boolean bl4 = false;
            return bl4;
        }
        finally {
            cm.a(dicomOutputStream, null, null);
        }
        return bl2;
    }

    @Override
    public String getImageType() {
        return "DERIVED\\PRIMARY\\" + this.plane.toString().toUpperCase();
    }

    @Override
    public String getExtraDerivationText() {
        if (this.plane != PresentationType.a) {
            return Messages.a("Dicom").getProperty("ABSTRACTVOL_REORIENTED");
        }
        return "";
    }

    @Override
    int[] getOutputVolumeDims() {
        int[] nArray = this.getRawOutputDims();
        float[] fArray = this.getOriginalRawOutputVoxel();
        if (this.saveOptions.squareVoxels && !MathUtils.a(fArray[0], fArray[1], 1.0E-4f)) {
            if (fArray[0] < fArray[1]) {
                nArray[1] = (int)Math.ceil((float)nArray[1] * fArray[1] / fArray[0]);
            } else {
                nArray[0] = (int)Math.ceil((float)nArray[0] * fArray[0] / fArray[1]);
            }
        }
        return nArray;
    }

    private int[] getRawOutputDims() {
        int n2 = this.plane.a()[2];
        int n3 = this.extent[n2 * 2 + 1] - this.extent[n2 * 2] + 1;
        if (this.plane == PresentationType.c) {
            return new int[]{this.extent[1] - this.extent[0] + 1, this.extent[5] - this.extent[4] + 1, n3};
        }
        if (this.plane == PresentationType.b) {
            return new int[]{this.extent[3] - this.extent[2] + 1, this.extent[5] - this.extent[4] + 1, n3};
        }
        return new int[]{this.extent[1] - this.extent[0] + 1, this.extent[3] - this.extent[2] + 1, n3};
    }

    @Override
    float[] getOutputVoxel() {
        return this.getRawOutputVoxel();
    }

    private float[] getRawOutputVoxel() {
        float[] fArray = this.vs.ao_();
        float[] fArray2 = this.plane == PresentationType.c ? new float[]{fArray[0], fArray[2], fArray[1]} : (this.plane == PresentationType.b ? new float[]{fArray[1], fArray[2], fArray[0]} : new float[]{fArray[0], fArray[1], fArray[2]});
        if (this.saveOptions.squareVoxels && !MathUtils.a(fArray2[0], fArray2[1], 1.0E-4f)) {
            if (fArray2[0] > fArray2[1]) {
                fArray2[0] = fArray2[1];
            } else {
                fArray2[1] = fArray2[0];
            }
        }
        return fArray2;
    }

    private float[] getOriginalRawOutputVoxel() {
        float[] fArray = this.vs.ao_();
        if (this.plane == PresentationType.c) {
            return new float[]{fArray[0], fArray[2], fArray[1]};
        }
        if (this.plane == PresentationType.b) {
            return new float[]{fArray[1], fArray[2], fArray[0]};
        }
        return new float[]{fArray[0], fArray[1], fArray[2]};
    }

    float[] getXYScaleFactor() {
        int[] nArray = this.getRawOutputDims();
        int[] nArray2 = this.getOutputVolumeDims();
        return new float[]{(float)nArray[0] / (float)nArray2[0], (float)nArray[1] / (float)nArray2[1], 1.0f};
    }

    @Override
    Matrix4f getSaveMatrix() {
        return AbstractVolumetricDcmWriter.getSaveMatrix(this.vs3D.am(), this.saveOptions.applyGantryTilt, this.saveOptions.applyViewingRotation);
    }
}

