/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mimvista.commands.workflow.Create4DCTMIPCommand;
import com.mimvista.dicom.write.Dynamic4DCTVolumeDeriver;
import com.mimvista.gui.util.c;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.ViewController3D;
import com.mimvista.internals.ViewControllerFactory;
import com.mimvista.internals.linking.AffineTransformImpl;
import com.mimvista.internals.linking.TransformEdge;
import com.mimvista.internals.linking.ViewLink;
import com.mimvista.internals.linking.ViewLinker;
import com.mimvista.internals.o;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.numerics.MathUtils;
import com.mimvista.numerics.helpers.FuncUtils;
import com.mimvista.proui.MIMLookAndFeel;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.gnotifier.NotifierPanel;
import com.mimvista.swing.widgets.gnotifier.b;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.MIMFormat;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.bc;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.state.AbstractVolumeLoadingEdit;
import com.mimvista.util.state.ViewLoadState;
import com.mimvista.util.work.m;
import com.mimvista.viewer.ModalitySeriesInfo;
import com.mimvista.viewer.NMSeriesInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class ChronoSlabber {
    private ChronoSlabParams params;
    private List<ImageVolumeShort> derivedVols;

    public ChronoSlabber(ChronoSlabParams chronoSlabParams) {
        this.params = chronoSlabParams;
    }

    public List<ImageVolumeShort> getDerivedVolsGenerateIfNeeded() {
        if (this.derivedVols == null) {
            try {
                this.generateDerivedSeries();
            }
            catch (Exception exception) {
                ay.d((Object)"Error.", (Throwable)exception, ChronoSlabber.class);
            }
        }
        return this.derivedVols;
    }

    private o getSourceSeries() {
        return this.params.sourceSeries;
    }

    private void generateDerivedSeries() throws Exception {
        int n2;
        o o2 = this.getSourceSeries();
        ModalitySeriesInfo modalitySeriesInfo = o2.e().getUncopiedMutableInfo().modInfo;
        String string = o2.e().I().imageType;
        if (!modalitySeriesInfo.c()) {
            throw new Exception("Not an NM (or no NM info).");
        }
        NMSeriesInfo nMSeriesInfo = modalitySeriesInfo.d();
        int n3 = nMSeriesInfo.phases.length;
        this.derivedVols = Lists.newArrayList();
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        ArrayList arrayList3 = Lists.newArrayList();
        ArrayList arrayList4 = Lists.newArrayList();
        ArrayList arrayList5 = Lists.newArrayList();
        ArrayList arrayList6 = Lists.newArrayList();
        NMSeriesInfo nMSeriesInfo2 = nMSeriesInfo.b();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            Cloneable cloneable;
            int n5;
            Serializable serializable;
            int n6;
            int n7 = this.params.phaseMultipliers.get(n2);
            ArrayList arrayList7 = Lists.newArrayList();
            ArrayList arrayList8 = Lists.newArrayList();
            Integer n8 = null;
            for (n6 = 0; n6 < o2.n(); ++n6) {
                serializable = (ImageVolumeShort)o2.c(n6);
                n5 = ((SimpleImageVolume)serializable).c();
                cloneable = nMSeriesInfo.e(n5);
                if (cloneable == null) {
                    throw new Exception("Bad phase information.");
                }
                if (((NMSeriesInfo.PhaseInfo)cloneable).a() != n2) continue;
                arrayList7.add(n6);
                arrayList8.add(n5);
                if (n8 == null) {
                    n8 = nMSeriesInfo.detectorVector[n5];
                    continue;
                }
                if (n8 == nMSeriesInfo.detectorVector[n5]) continue;
                throw new Exception("Mismatched detectors?");
            }
            if (arrayList7.size() % n7 != 0) {
                throw new Exception("Multiplier doesn't evenly divide.");
            }
            n6 = arrayList7.size() / n7;
            arrayList.add(n6);
            serializable = nMSeriesInfo.phases[n2].b();
            ((NMSeriesInfo.PhaseInfo)serializable).actualFrameDurationInMs *= (float)n7;
            ((NMSeriesInfo.PhaseInfo)serializable).actualFrameDurationInMs += ((NMSeriesInfo.PhaseInfo)serializable).pauseBetweenFramesInMs * (float)(n7 - 1);
            ((NMSeriesInfo.PhaseInfo)serializable).numberOfFramesInPhase /= n7;
            ((NMSeriesInfo.PhaseInfo)serializable).a(n2);
            arrayList2.add(serializable);
            for (n5 = 0; n5 < n6; ++n5) {
                int n9;
                cloneable = Sets.newHashSet();
                for (int i2 = n9 = n7 * n5; i2 < n7 * (n5 + 1); ++i2) {
                    cloneable.add(arrayList7.get(i2));
                }
                arrayList3.add(n2 + 1);
                arrayList6.add(n5 + 1);
                arrayList4.add(nMSeriesInfo.detectorVector[n9]);
                arrayList5.add(nMSeriesInfo.energyWindowVector[n9]);
                Dynamic4DCTVolumeDeriver.DynamicDerivationOptions dynamicDerivationOptions = new Dynamic4DCTVolumeDeriver.DynamicDerivationOptions(o2, Create4DCTMIPCommand.MIPType.c);
                dynamicDerivationOptions.frameFilter = new Predicate<Integer>((Set)((Object)cloneable)){
                    final /* synthetic */ Set val$frmsForThisSlab;
                    {
                        this.val$frmsForThisSlab = set;
                    }

                    public boolean apply(Integer n2) {
                        return this.val$frmsForThisSlab.contains(n2);
                    }
                };
                Dynamic4DCTVolumeDeriver dynamic4DCTVolumeDeriver = new Dynamic4DCTVolumeDeriver(dynamicDerivationOptions);
                ImageVolumeShort imageVolumeShort = dynamic4DCTVolumeDeriver.getOutputVolume();
                imageVolumeShort.getUncopiedMutableInfo().imageType = string;
                imageVolumeShort.getUncopiedMutableInfo().modInfo = nMSeriesInfo2;
                imageVolumeShort.a(true);
                imageVolumeShort.a(n4++);
                this.derivedVols.add(imageVolumeShort);
            }
        }
        nMSeriesInfo2.phases = arrayList2.toArray(new NMSeriesInfo.PhaseInfo[0]);
        nMSeriesInfo2.phaseVector = new int[arrayList3.size()];
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            nMSeriesInfo2.phaseVector[n2] = (Integer)arrayList3.get(n2);
        }
        nMSeriesInfo2.detectorVector = new int[arrayList4.size()];
        for (n2 = 0; n2 < arrayList4.size(); ++n2) {
            nMSeriesInfo2.detectorVector[n2] = (Integer)arrayList4.get(n2);
        }
        nMSeriesInfo2.energyWindows = Arrays.copyOf(nMSeriesInfo.energyWindows, nMSeriesInfo.energyWindows.length);
        nMSeriesInfo2.energyWindowVector = new int[arrayList5.size()];
        for (n2 = 0; n2 < arrayList5.size(); ++n2) {
            nMSeriesInfo2.energyWindowVector[n2] = (Integer)arrayList5.get(n2);
        }
        nMSeriesInfo2.timeSliceVector = new int[arrayList6.size()];
        for (n2 = 0; n2 < arrayList6.size(); ++n2) {
            nMSeriesInfo2.timeSliceVector[n2] = (Integer)arrayList6.get(n2);
        }
        nMSeriesInfo2.numberOfFrames = this.derivedVols.size();
        nMSeriesInfo2.actualFrameDuration = nMSeriesInfo2.phases.length > 0 ? (int)nMSeriesInfo2.phases[0].actualFrameDurationInMs : -1;
    }

    public static void showChronoSlabNotification(ViewController3D viewController3D) {
        final FuncUtils.z<JComponent> z2 = new FuncUtils.z<JComponent>();
        final BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.e, "", new Notification.a(viewController3D)){

            @Override
            public JComponent getContent() {
                return (JComponent)z2.get();
            }

            @Override
            public String getTitle() {
                return Messages.a("mui", "DYNAMIC_CTRL_CHRONO_SLAB");
            }

            @Override
            public b getIconRenderer() {
                return new b.b("icon_clock");
            }
        };
        JComponent jComponent = ChronoSlabber.buildChronoSlabComponent(viewController3D, new Runnable(){

            @Override
            public void run() {
                u.b().d(basicNotification);
            }
        });
        z2.a(jComponent);
        u.b().c(basicNotification);
    }

    private static NMSeriesInfo.PhaseInfo getMultipliedPhaseInfo(NMSeriesInfo.PhaseInfo phaseInfo, int n2) {
        NMSeriesInfo.PhaseInfo phaseInfo2 = phaseInfo.b();
        phaseInfo2.actualFrameDurationInMs *= (float)n2;
        phaseInfo2.actualFrameDurationInMs += (float)(n2 - 1) * phaseInfo.pauseBetweenFramesInMs;
        phaseInfo2.numberOfFramesInPhase /= n2;
        return phaseInfo2;
    }

    public static JComponent buildChronoSlabComponent(final ViewController3D viewController3D, final Runnable runnable) {
        JComponent jComponent;
        Serializable serializable;
        o o2 = viewController3D.cE();
        NMSeriesInfo nMSeriesInfo = viewController3D.ck();
        if (nMSeriesInfo == null) {
            ay.d((Object)"Target has no NM info, cannot chrono slab.", ChronoSlabber.class);
            return null;
        }
        int n2 = nMSeriesInfo.phases.length;
        ArrayList arrayList = Lists.newArrayList();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(i2 + 1);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        Box box = Box.createVerticalBox();
        final ArrayList arrayList2 = Lists.newArrayList();
        final ArrayList arrayList3 = Lists.newArrayList();
        for (int i3 = 0; i3 < n2; ++i3) {
            Serializable serializable2;
            Integer[] integerArray2;
            serializable = nMSeriesInfo.phases[i3];
            jComponent = Box.createVerticalBox();
            jComponent.setBorder(new TitledBorder(MIMFormat.a(Messages.a("mui", "CHON_SLAB_PHASE"), i3 + 1)));
            int n3 = nMSeriesInfo.a(i3, o2);
            int n4 = nMSeriesInfo.b(i3, o2);
            int n5 = n4 - n3 + 1;
            HashSet hashSet = Sets.newHashSet();
            for (int i4 = 1; i4 < n5 / 2 + 1; ++i4) {
                if (n5 % i4 != 0) continue;
                hashSet.add(i4);
                hashSet.add(n5 / i4);
            }
            ArrayList arrayList4 = Lists.newArrayList((Iterable)hashSet);
            Collections.sort(arrayList4);
            arrayList3.add(arrayList4);
            ArrayList arrayList5 = Lists.newArrayList();
            ArrayList arrayList6 = Lists.newArrayList();
            for (Integer[] integerArray2 : arrayList4) {
                serializable2 = ChronoSlabber.getMultipliedPhaseInfo(serializable, integerArray2.intValue());
                arrayList5.add(serializable2);
                arrayList6.add(Float.valueOf(((NMSeriesInfo.PhaseInfo)serializable2).actualFrameDurationInMs));
            }
            Object object = bc.a(arrayList6);
            integerArray2 = new Integer[arrayList4.size()];
            for (int i5 = 0; i5 < arrayList4.size(); ++i5) {
                integerArray2[i5] = i5;
            }
            serializable2 = new JComboBox<Integer>(integerArray2);
            ((JComboBox)serializable2).setRenderer(new DefaultListCellRenderer((TimeUnit)((Object)object), arrayList6){
                private static final long serialVersionUID = 1L;
                final /* synthetic */ TimeUnit val$tu;
                final /* synthetic */ List val$newDurs;
                {
                    this.val$tu = timeUnit;
                    this.val$newDurs = list;
                }

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n2, boolean bl2, boolean bl3) {
                    int n3 = (Integer)object;
                    double d2 = bc.a(this.val$tu, ((Float)this.val$newDurs.get(n3)).floatValue());
                    object = bc.a(MathUtils.b(d2, 1), this.val$tu);
                    return super.getListCellRendererComponent((JList<?>)jList, object, n2, bl2, bl3);
                }
            });
            Box box2 = Box.createHorizontalBox();
            box2.add(new JLabel(Messages.a("mui", "CHON_SLAB_CURR_DUR")));
            box2.add(Box.createRigidArea(new Dimension(5, 0)));
            double d2 = bc.a(object, serializable.actualFrameDurationInMs);
            box2.add(new JLabel(bc.a(MathUtils.b(d2, 1), object)));
            jComponent.add(box2);
            Box box3 = Box.createHorizontalBox();
            box3.add(new JLabel(Messages.a("mui", "CHON_SLAB_NEW_DUR")));
            box3.add(Box.createRigidArea(new Dimension(5, 0)));
            box3.add((Component)serializable2);
            jComponent.add(box3);
            arrayList2.add(serializable2);
            box.add(jComponent);
            Dimension dimension = jComponent.getMaximumSize();
            dimension.height = jComponent.getPreferredSize().height;
            jComponent.setMaximumSize(dimension);
        }
        JButton jButton = c.c(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
                m.b.a(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList arrayList = Lists.newArrayList();
                        for (int i2 = 0; i2 < arrayList2.size(); ++i2) {
                            JComboBox jComboBox = (JComboBox)arrayList2.get(i2);
                            arrayList.add(((List)arrayList3.get(i2)).get(jComboBox.getSelectedIndex()));
                        }
                        viewController3D.g().r().a(new CreateChronoSlabEdit(viewController3D, arrayList, new com.mimvista.util.progress.o()));
                    }
                }, "ChronoSlab");
            }
        }, Messages.a("mui", "CHON_SLAB_OK_TIP"));
        serializable = c.a(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                runnable.run();
            }
        }, "");
        jComponent = new JScrollPane(box);
        jComponent.setBorder(new CompoundBorder(new EmptyBorder(0, 0, 10, 0), new LineBorder(MIMLookAndFeel.b())));
        jPanel.add((Component)jComponent, "Center");
        Box box4 = Box.createHorizontalBox();
        box4.add(Box.createHorizontalGlue());
        box4.add(jButton);
        box4.add(Box.createRigidArea(new Dimension(5, 0)));
        box4.add((Component)serializable);
        jPanel.add((Component)box4, "South");
        jPanel.setMinimumSize(new Dimension(NotifierPanel.c, 250));
        jPanel.setPreferredSize(new Dimension(NotifierPanel.c, 250));
        jPanel.setMaximumSize(new Dimension(NotifierPanel.c, 250));
        return jPanel;
    }

    public static class DeriveChronoSlabState
    extends ViewLoadState {
        private static final long serialVersionUID = 1L;
        private transient long createdID = -1L;
        private ViewController3D vc;
        private List<Integer> mults;

        public DeriveChronoSlabState(ViewController3D viewController3D, List<Integer> list) {
            this.vc = viewController3D;
            this.session = viewController3D.g();
            this.mults = list;
        }

        @Override
        public void stamp() {
            o o2 = this.vc.cE();
            ChronoSlabParams chronoSlabParams = new ChronoSlabParams(o2, this.mults);
            ChronoSlabber chronoSlabber = new ChronoSlabber(chronoSlabParams);
            List<ImageVolumeShort> list = chronoSlabber.getDerivedVolsGenerateIfNeeded();
            if (list == null) {
                return;
            }
            ViewControllerFactory.h h2 = new ViewControllerFactory.h(this.session, list, (ViewLoadState)this);
            h2.e = this.createdID;
            ViewController3D viewController3D = ViewControllerFactory.a(h2);
            this.createdID = viewController3D.aV();
            o o3 = viewController3D.cE();
            TransformEdge.TransformEdgeInfo transformEdgeInfo = new TransformEdge.TransformEdgeInfo(TransformEdge.TransformEdgeType.a);
            AffineTransformImpl affineTransformImpl = new AffineTransformImpl(o2.e(), o3.e());
            affineTransformImpl.f();
            this.vc.aG().a((ImageFrame)o2.e(), (ImageFrame)o3.e(), affineTransformImpl, true, 1.0f, transformEdgeInfo);
            ViewLinker.a(viewController3D, (ViewController)this.vc, false);
            this.vc.bO().b(ViewLink.ViewEvent.a);
        }

        @Override
        public void doLoad(List<Long> list) {
            this.createdID = list.get(0);
        }

        public long getCreatedID() {
            return this.createdID;
        }

        @Override
        public List<Long> getCreatedIDs() {
            return Lists.newArrayList((Object[])new Long[]{this.createdID});
        }
    }

    public static class CreateChronoSlabEdit
    extends AbstractVolumeLoadingEdit {
        private static final long serialVersionUID = -3324821555871973754L;

        public CreateChronoSlabEdit(ViewController3D viewController3D, List<Integer> list, Progress progress) {
            super(viewController3D.g(), new DeriveChronoSlabState(viewController3D, list), Messages.a("mui", "DYNAMIC_CTRL_CHRONO_SLAB_UNDO_NAME"), progress);
        }

        @Override
        public String getPresentationName() {
            return Messages.a("mui", "DYNAMIC_CTRL_CHRONO_SLAB_UNDO_NAME");
        }
    }

    public static class ChronoSlabParams {
        public o sourceSeries;
        public List<Integer> phaseMultipliers;

        public ChronoSlabParams(o o2, List<Integer> list) {
            this.sourceSeries = o2;
            this.phaseMultipliers = list;
        }
    }
}

