/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.mimvista.archive.Parser;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.dicom.write.AbstractDcmModule;
import com.mimvista.dicom.write.AbstractVolumetricDcmWriter;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.dicom.write.DcmWriterFactory;
import com.mimvista.internals.ab;
import com.mimvista.internals.volumes.SimpleImageVolume;
import com.mimvista.mui.PresentationType;
import com.mimvista.mui.ao;
import com.mimvista.numerics.MathUtils;
import com.mimvista.preferencesNew.DicomPrefs;
import com.mimvista.update.VersionNumber;
import com.mimvista.util.DateUtils;
import com.mimvista.util.cn;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.vecmath.Matrix4f;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DcmCommonModule
extends AbstractDcmModule {
    public DcmCommonModule(DcmWriter dcmWriter) {
        super(dcmWriter);
    }

    @Override
    public void fillTags(DicomObject dicomObject) {
        SimpleImageVolume simpleImageVolume = (SimpleImageVolume)((Object)this.writer.vs.aw());
        SeriesInfo seriesInfo = simpleImageVolume.getUncopiedMutableInfo();
        String string = (String)this.writer.vs.getDicomSeries().getTagValue(524293);
        Parser.setDefaultSpecificCharacterSet(dicomObject, string);
        if (seriesInfo.nativeShortAxis) {
            dicomObject.putString(0x540500, VR.CS, "APEX_TO_BASE");
        }
        this.fillMetaHeader(dicomObject);
        this.fillPatientInfo(dicomObject, seriesInfo);
        dicomObject.putString(524306, null, DateUtils.e());
        dicomObject.putString(524307, null, DateUtils.f());
        dicomObject.putInt(2621696, VR.US, 16);
        dicomObject.putInt(2621697, VR.US, 16);
        dicomObject.putInt(2621698, VR.US, 15);
        boolean bl2 = false;
        bl2 = this.writer.shouldWriteDeactualizedPixelValues() ? this.writer.needsUnsignedDeactualizedSave() : this.writer.needsUnsignedActualizedSave();
        dicomObject.putInt(2621699, VR.US, bl2 ? 0 : 1);
        dicomObject.putString(524296, null, this.writer.getImageType());
        if (seriesInfo.seriesType.length() > 0) {
            dicomObject.putString(5509120, null, seriesInfo.seriesType);
        }
        dicomObject.putString(2621444, null, "MONOCHROME2");
        dicomObject.putInt(0x280002, null, 1);
        dicomObject.putString(1593600, VR.CS, seriesInfo.origPatientPosition == null ? "" : seriesInfo.origPatientPosition.toString());
        dicomObject.putString(0x200060, VR.CS, dicomObject.getString(0x200060, ""));
        dicomObject.putString(0x200011, null, this.getSecondsFromMidnight());
        if (seriesInfo.numOfBins > 0) {
            dicomObject.putInt(930308097, VR.IS, seriesInfo.binNum);
            dicomObject.putInt(930308098, VR.IS, seriesInfo.numOfBins);
            dicomObject.putString(930308099, VR.SH, seriesInfo.binDesc);
            dicomObject.putInt(930308096, VR.IS, seriesInfo.binnedID);
        }
        if (seriesInfo.X()) {
            UnitHelper unitHelper = seriesInfo.u();
            String string2 = unitHelper.g();
            if (cn.h(string2)) {
                string2 = "UNKNOWN";
            }
            dicomObject.putString(930308352, VR.ST, string2);
            dicomObject.putDate(930308353, VR.DT, new Date(unitHelper.j()));
        }
        dicomObject.putString(2101312, VR.LO, dicomObject.getString(2101312, ""));
        if (this.writer.getSaveDynamic()) {
            int n2 = this.writer.getViewController().bh().cE().n();
            dicomObject.putInt(5505137, VR.US, n2);
        }
    }

    private void fillMetaHeader(DicomObject dicomObject) {
        dicomObject.putBytes(131073, null, new byte[]{0, 1});
        dicomObject.putString(131088, VR.UI, "1.2.840.10008.1.2.1");
        dicomObject.putString(524310, VR.UI, this.writer.getSopClass());
        dicomObject.putString(131074, VR.UI, this.writer.getSopClass());
        dicomObject.putString(131090, VR.UI, "2.16.840.1.114362.1");
        String string = "MIM";
        String[] stringArray = VersionNumber.loadVersion();
        if (ao.T()) {
            string = "MIMviewer";
            stringArray[0] = String.valueOf(Integer.parseInt(stringArray[0]) - 3);
        }
        String string2 = stringArray[0] + "." + stringArray[1] + "." + stringArray[2];
        String string3 = string + " " + string2;
        dicomObject.putString(131091, VR.SH, string3);
        dicomObject.putString(131094, VR.AE, string);
        String string4 = this.writer.saveOptions.sopInstanceUID;
        if (string4 == null) {
            string4 = UIDGenerator.generateSopInstanceUID();
        }
        dicomObject.putString(524312, VR.UI, string4);
        dicomObject.putString(131075, VR.UI, string4);
        String string5 = this.writer.vs.getUncopiedMutableInfo().lossyCompression;
        if (!cn.h(string5)) {
            dicomObject.putString(2629904, VR.CS, string5);
        }
    }

    private String getSecondsFromMidnight() {
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(11);
        int n3 = calendar.get(12);
        int n4 = calendar.get(13);
        return Integer.toString((n2 * 60 + n3) * 60 + n4);
    }

    private void fillPatientInfo(DicomObject dicomObject, SeriesInfo seriesInfo) {
        boolean bl2;
        Object object;
        Object object2;
        String string;
        String string2;
        DcmWriter.DcmSaveOptions dcmSaveOptions = this.writer.saveOptions;
        String string3 = this.getSeriesDescPrefix();
        if (dcmSaveOptions != null) {
            dicomObject.putString(524368, VR.SH, dcmSaveOptions.accession);
            dicomObject.putString(0x100010, VR.PN, dcmSaveOptions.dicomName);
            dicomObject.putString(0x100020, VR.LO, dcmSaveOptions.patientID);
            dicomObject.putString(524432, null, DcmWriterFactory.formatNameForDICOM(dcmSaveOptions.referringFirst, null, dcmSaveOptions.referringLast));
            string3 = string3 + dcmSaveOptions.seriesDescription;
            dicomObject.putString(528432, null, dcmSaveOptions.studyDescription);
            dicomObject.putString(0x200010, null, dcmSaveOptions.studyID);
            dicomObject.putString(524384, null, dcmSaveOptions.modality);
            if (!dcmSaveOptions.keepAssociation || dcmSaveOptions.saveAsOrthogonal) {
                dicomObject.putString(0x20000D, VR.UI, UIDGenerator.generateUID());
                dicomObject.putString(0x200052, VR.UI, UIDGenerator.generateUID());
            } else {
                string2 = seriesInfo.studyUID;
                if (string2 == null || "".equals(string2)) {
                    string2 = UIDGenerator.generateUID();
                }
                dicomObject.putString(0x200052, VR.UI, seriesInfo.frameOfRefUID);
                dicomObject.putString(0x20000D, VR.UI, string2);
            }
        } else {
            string3 = string3 + seriesInfo.seriesDesc;
            string2 = seriesInfo.studyUID;
            if (string2.length() < 1) {
                string2 = UIDGenerator.generateUID();
            }
            if ((string = seriesInfo.ag()).length() < 1) {
                string = UIDGenerator.generateUID();
            }
            dicomObject.putString(0x20000D, VR.UI, string2);
            dicomObject.putString(0x20000E, VR.UI, string);
            dicomObject.putString(0x100010, null, seriesInfo.patientNameRaw);
            dicomObject.putString(524432, null, seriesInfo.referringPhysRaw);
            dicomObject.putString(528432, null, seriesInfo.studyDesc);
        }
        dicomObject.putString(528446, null, string3);
        if (seriesInfo.weight > 0.0f) {
            dicomObject.putFloat(0x101030, null, seriesInfo.weight);
        }
        if (seriesInfo.patientSize > 0.0f) {
            dicomObject.putFloat(0x101020, null, seriesInfo.patientSize);
        }
        dicomObject.putString(0x101010, null, seriesInfo.A());
        dicomObject.putString(1577008, null, seriesInfo.protocolName);
        dicomObject.putString(524416, null, seriesInfo.institutionName);
        dicomObject.putString(528496, null, seriesInfo.operatorName);
        string2 = seriesInfo.manufacturer;
        if (string2 != null && !string2.toLowerCase().contains("mimvista") && !string2.toLowerCase().contains("mim software") && !string2.toLowerCase().contains("mimsoftware") && DicomPrefs.includeMimvistaInManu.getValue().booleanValue()) {
            string2 = (string2 = string2.trim()).length() == 0 ? "MIM Software" : string2 + " / MIM Software";
        }
        dicomObject.putString(524400, null, string2);
        dicomObject.putString(528528, null, seriesInfo.modelName);
        dicomObject.putString(528400, null, seriesInfo.stationName);
        string = seriesInfo.derivationDescription + "Image data converted" + this.writer.getDerivationText() + " from DICOM." + this.writer.getExtraDerivationText();
        dicomObject.putString(532753, null, string);
        if (this.writer.vs.bt()) {
            RawDicomUtils.writeCodeSequence(dicomObject, new int[]{561685}, new String[]{"DCM", "113062", "Pixel by pixel subtraction"});
        }
        if (seriesInfo.compositedFrom != null) {
            dicomObject.putString(928055553, VR.ST, seriesInfo.compositedFrom.name());
        }
        if (seriesInfo.clusterParams != null) {
            dicomObject.putFloat(0x37733000, VR.DS, seriesInfo.clusterParams.smoothFWHM);
            dicomObject.putFloat(930295809, VR.DS, seriesInfo.clusterParams.stddev);
            dicomObject.putFloat(930295810, VR.DS, seriesInfo.clusterParams.pValue);
        }
        if (seriesInfo.reSlicerProducedVolume) {
            dicomObject.putString(928055632, VR.ST, "ReSlicer Produced");
        }
        if (seriesInfo.a() != null) {
            object2 = seriesInfo.a();
            dicomObject.putFloats(928059392, VR.FL, (float[])object2);
        }
        if (seriesInfo.aj() != null) {
            object2 = seriesInfo.aj();
            object = dicomObject.putSequence(930291992);
            object.addDicomObject((DicomObject)object2);
        }
        object2 = seriesInfo.ag();
        if (!seriesInfo.mimDerivedVolume || seriesInfo.volumeHasBeenSaved || object2 == null || ((String)object2).length() == 0 || seriesInfo.forceNewSeriesUidOnNextSave) {
            object2 = UIDGenerator.generateUID();
            seriesInfo.k((String)object2);
            seriesInfo.forceNewSeriesUidOnNextSave = false;
        }
        dicomObject.putString(0x20000E, null, (String)object2);
        dicomObject.putString(0x100030, null, seriesInfo.birthDate);
        dicomObject.putString(524336, null, seriesInfo.studyTimeRaw);
        object = seriesInfo.N();
        if (seriesInfo.hasStudyDate) {
            dicomObject.putString(524320, VR.DA, (String)object);
        } else {
            dicomObject.putString(524320, VR.DA, "");
        }
        dicomObject.putString(524337, null, seriesInfo.P());
        dicomObject.putString(524321, null, seriesInfo.M());
        dicomObject.putDate(524338, null, seriesInfo.acqTime);
        dicomObject.putDate(524322, null, seriesInfo.acqDate);
        dicomObject.putString(524339, null, DateUtils.f());
        dicomObject.putString(524323, null, DateUtils.e());
        dicomObject.putString(0x100040, null, seriesInfo.sex);
        boolean bl3 = bl2 = !cn.h(seriesInfo.alignedToVolumeSeriesUID);
        if (bl2) {
            dicomObject.putString(0x37730030, VR.LO, "MIM Software Inc.");
            DicomElement dicomElement = dicomObject.putSequence(0x37733007);
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            basicDicomObject.putString(0x20000D, VR.UI, seriesInfo.alignedToVolumeStudyUID);
            basicDicomObject.putString(0x20000E, VR.UI, seriesInfo.alignedToVolumeSeriesUID);
        }
    }

    private String getSeriesDescPrefix() {
        if ("RTIMAGE".equalsIgnoreCase(this.writer.getModality())) {
            return "";
        }
        if (this.writer instanceof AbstractVolumetricDcmWriter) {
            String string;
            AbstractVolumetricDcmWriter abstractVolumetricDcmWriter = (AbstractVolumetricDcmWriter)this.writer;
            ArrayList<String> arrayList = new ArrayList<String>(4);
            PresentationType presentationType = ab.a(abstractVolumetricDcmWriter.vs, this.writer.plane, this.writer.saveOptions.applyViewingRotation);
            if (presentationType == PresentationType.c) {
                arrayList.add("Coronal.");
            }
            if (presentationType == PresentationType.b) {
                arrayList.add("Sagittal.");
            }
            Matrix4f matrix4f = abstractVolumetricDcmWriter.vs3D.cw().M();
            if ((this.writer.saveOptions.applyGantryTilt || this.writer.saveOptions.applyViewingRotation) && !AbstractVolumetricDcmWriter.isMatrixIdentity(matrix4f)) {
                arrayList.add("(applied.gantry.tilt)");
            }
            boolean bl2 = false;
            if (!MathUtils.j(abstractVolumetricDcmWriter.vs3D.getUncopiedMutableInfo().imageOrientation, abstractVolumetricDcmWriter.vs3D.getUncopiedMutableInfo().origImageOrientation)) {
                arrayList.add("(reoriented)");
                bl2 = true;
            }
            Matrix4f matrix4f2 = abstractVolumetricDcmWriter.vs3D.bq();
            if (this.writer.saveOptions.applyViewingRotation && !AbstractVolumetricDcmWriter.isMatrixIdentity(matrix4f2)) {
                string = abstractVolumetricDcmWriter.vs3D.cw().N();
                Matrix4f matrix4f3 = new Matrix4f();
                matrix4f3.set(matrix4f);
                matrix4f3.invert();
                matrix4f3.mul((Matrix4f)string);
                if (!AbstractVolumetricDcmWriter.isMatrixIdentity(matrix4f3) && matrix4f2.epsilonEquals((Matrix4f)string, 0.001f)) {
                    if (!bl2) {
                        arrayList.add("(reoriented)");
                    }
                } else if (AbstractVolumetricDcmWriter.isMatrixIdentity(matrix4f) || !matrix4f2.epsilonEquals(matrix4f, 0.001f)) {
                    arrayList.add("(rotated)");
                }
            }
            string = "";
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                if (i2 != 0) {
                    string = string + ".";
                }
                string = string + (String)arrayList.get(i2);
            }
            return string;
        }
        return "";
    }

    @Override
    public void fillOrientationTags(DicomObject dicomObject) {
        int[] nArray = this.writer.getOutputVolumeDims();
        float[] fArray = this.writer.getOutputVoxel();
        dicomObject.putInt(2621457, VR.US, nArray[0]);
        dicomObject.putInt(2621456, VR.US, nArray[1]);
        dicomObject.putFloats(2621488, VR.DS, new float[]{fArray[1], fArray[0]});
        dicomObject.putFloat(1572944, VR.DS, fArray[2]);
    }
}

