/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.collect.Lists;
import com.lowagie.text.DocumentException;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.search.FolderSearchSource;
import com.mimvista.dicom.CoercingJsonDicomSeries;
import com.mimvista.dicom.JsonDicomSeries;
import com.mimvista.dicom.util.EncapsulateDocumentHandler;
import com.mimvista.dicom.util.TagUtils;
import com.mimvista.file.Path;
import com.mimvista.mui.bm;
import com.mimvista.report.b.d;
import com.mimvista.report.nodes.Report;
import com.mimvista.swing.widgets.BasicNotification;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.u;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cm;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import com.mimvista.viewer.SeriesInfo;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TreeMap;
import org.dcm4che2.data.VR;
import org.dcm4che2.util.DateUtils;

public class DcmEncapsulatedReportWriter {
    final Report report;
    private String seriesUID;
    private String sopInstanceUID;

    public DcmEncapsulatedReportWriter(Report report) {
        this.report = report;
    }

    public void writeTo(SendToDestination sendToDestination, Progress progress) {
        this.writeTo(sendToDestination, progress, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(SendToDestination sendToDestination, Progress progress, String string, String string2) {
        progress.a(true);
        try {
            TreeMap<Integer, String> treeMap = this.getTagMap();
            if (!cn.h(string2)) {
                treeMap.put(528496, string2);
            }
            EncapsulateDocumentHandler encapsulateDocumentHandler = new EncapsulateDocumentHandler(treeMap, progress);
            encapsulateDocumentHandler.setSeriesDescription(string);
            File file = this.saveTemporaryPdf();
            encapsulateDocumentHandler.setFiles(Lists.newArrayList((Object[])new File[]{file}));
            File file2 = encapsulateDocumentHandler.writeToTemporary();
            this.seriesUID = encapsulateDocumentHandler.getSeriesInstanceUID();
            this.sopInstanceUID = encapsulateDocumentHandler.getSOPInstanceUID();
            FolderSearchSource.a(sendToDestination, file2.getParentFile().getAbsolutePath(), true);
        }
        catch (Throwable throwable) {
            ay.d((Object)"Error saving encapsulated PDF report", throwable, this);
            progress.k();
            Notification.a a2 = new Notification.a(bm.b());
            BasicNotification basicNotification = new BasicNotification(BasicNotification.NotificationType.a, Messages.a("Report", "SAVE_PDF_ERROR"), a2);
            u.b().c(basicNotification);
        }
        finally {
            progress.b();
        }
    }

    public String getSeriesInstanceUID() {
        return this.seriesUID;
    }

    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File saveTemporaryPdf() throws IOException, DocumentException {
        File file;
        FileOutputStream fileOutputStream = null;
        try {
            d d2 = new d(this.report);
            File file2 = new File(Path.getTempPath("report"), "report.pdf");
            fileOutputStream = new FileOutputStream(file2);
            d2.a(fileOutputStream);
            file = file2;
        }
        catch (Throwable throwable) {
            cm.a(fileOutputStream, "Error closing filestream", (Object)this);
            throw throwable;
        }
        cm.a((Closeable)fileOutputStream, "Error closing filestream", (Object)this);
        return file;
    }

    private TreeMap<Integer, String> getTagMap() {
        SeriesInfo seriesInfo = this.report.d();
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        JsonDicomSeries jsonDicomSeries = seriesInfo.y();
        if (jsonDicomSeries != null) {
            int[] nArray = jsonDicomSeries.getTagKeys();
            for (int n2 : nArray) {
                Object object = jsonDicomSeries.getTagValue(n2);
                if (object instanceof Date) {
                    Date date = (Date)object;
                    VR vR = TagUtils.vrOfTag(n2);
                    object = vR == VR.TM ? DateUtils.formatTM((Date)date) : (vR == VR.DA ? DateUtils.formatDA((Date)date) : (vR == VR.DT ? DateUtils.formatDT((Date)date) : CoercingJsonDicomSeries.getConverterFor(String.class).apply(object)));
                    treeMap.put(n2, object.toString());
                    continue;
                }
                if (object == null) continue;
                treeMap.put(n2, object.toString());
            }
            Object object = new SimpleDateFormat("HHmmss");
            treeMap.put(524336, seriesInfo.studyTime != null ? ((DateFormat)object).format(seriesInfo.studyTime) : seriesInfo.studyTimeRaw);
        } else {
            treeMap.put(0x100010, seriesInfo.patientName);
            treeMap.put(0x100020, seriesInfo.patientId);
            treeMap.put(0x100030, seriesInfo.birthDate);
            treeMap.put(0x100040, seriesInfo.sex);
            treeMap.put(0x20000D, seriesInfo.studyUID);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HHmmss");
            treeMap.put(524337, seriesInfo.P());
            treeMap.put(524336, seriesInfo.studyTime != null ? simpleDateFormat.format(seriesInfo.studyTime) : seriesInfo.studyTimeRaw);
            treeMap.put(0x200010, seriesInfo.studyID);
            treeMap.put(0x200011, seriesInfo.seriesNumber);
            treeMap.put(524384, seriesInfo.modality);
            treeMap.put(524368, seriesInfo.accession);
        }
        if (this.report.B() != null) {
            treeMap.put(0x20000E, this.report.B());
        }
        return treeMap;
    }
}

