/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.dicom.write.AbstractDcmModule;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.dicom.write.NMPetPatientOrientationWriter;
import com.mimvista.internals.ReadOnlyContrast;
import com.mimvista.internals.SliceInfo;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.viewer.NMSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import org.apache.commons.lang3.ArrayUtils;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DcmNMModule
extends AbstractDcmModule {
    public DcmNMModule(DcmWriter dcmWriter) {
        super(dcmWriter);
    }

    @Override
    public void fillTags(DicomObject dicomObject) {
        Object object;
        int n2;
        int[] nArray;
        ImageVolumeShort imageVolumeShort = this.writer.getVolume();
        SeriesInfo seriesInfo = imageVolumeShort.getUncopiedMutableInfo();
        NMSeriesInfo nMSeriesInfo = seriesInfo.modInfo instanceof NMSeriesInfo ? (NMSeriesInfo)seriesInfo.modInfo : new NMSeriesInfo();
        dicomObject.putInt(2097171, null, 1);
        float[] fArray = this.writer.getOutputVoxel();
        dicomObject.putFloat(0x180088, null, fArray[2]);
        dicomObject.putInt(5505041, VR.US, 1);
        dicomObject.putInt(5505057, null, 1);
        dicomObject.putInt(5505105, null, 1);
        if (seriesInfo.Z()) {
            dicomObject.putString(0x200060, VR.CS, seriesInfo.laterality);
        }
        int n3 = (nArray = this.writer.getOutputVolumeDims())[0] == 1 || nArray[1] == 1 || nArray[2] == 1 ? 1 : this.writer.getOutputVolumeDims()[2];
        Object object2 = new int[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            object2[n2] = n2 + 1;
        }
        if ("US".equals(this.writer.getModality()) && imageVolumeShort.ab().size() == ((int[])object2).length) {
            n2 = 0;
            for (SliceInfo sliceInfo : imageVolumeShort.ab()) {
                object2[n2++] = sliceInfo.sliceNumber;
            }
            ArrayUtils.reverse((int[])object2);
        }
        if (this.writer.getSaveDynamic()) {
            n2 = this.writer.getViewController().bh().cE().n();
            object = new int[((int[])object2).length * n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                System.arraycopy(object2, 0, object, ((int[])object2).length * i2, ((int[])object2).length);
            }
            object2 = object;
        }
        dicomObject.putInts(5505152, null, object2);
        if (this.writer.getSaveDynamic()) {
            int n4;
            n2 = this.writer.getViewController().bh().cE().n();
            dicomObject.putInt(0x280008, null, n3 * n2);
            object = new int[n3 * n2];
            for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                object[n4] = n4 / n3 + 1;
            }
            dicomObject.putInts(5505136, null, (int[])object);
            n4 = this.writer.getViewController().bh().at().e().c();
            if (n4 >= 0 && n2 > 0) {
                nMSeriesInfo = nMSeriesInfo.b();
                nMSeriesInfo.a(n4, n4 + n2);
            }
            nMSeriesInfo.a(dicomObject, ((Object)object).length);
        } else {
            dicomObject.putInt(0x280008, null, n3);
        }
        dicomObject.putInt(2621449, null, 5505152);
        nMSeriesInfo.a(dicomObject);
        if (this.writer.shouldWriteDeactualizedPixelValues()) {
            DicomElement dicomElement = dicomObject.putSequence(4231318);
            object = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)object);
            object.putInt(4231702, null, (int)((short)imageVolumeShort.ah()));
            object.putInt(4231697, null, (int)((short)imageVolumeShort.ai()));
            ReadOnlyContrast readOnlyContrast = this.writer.getContrast();
            object.putDouble(4231716, null, (double)(readOnlyContrast.y() * seriesInfo.rescale.unitScale));
            object.putDouble(4231717, null, (double)(readOnlyContrast.z() * seriesInfo.rescale.unitScale));
            object.putString(2633731, null, "Rescaled data");
            object.putString(4231696, null, seriesInfo.u().y());
            DicomElement dicomElement2 = object.putSequence(4196586);
            BasicDicomObject basicDicomObject = new BasicDicomObject();
            dicomElement2.addDicomObject((DicomObject)basicDicomObject);
            String string = DataUnitUtils.getCodeValueForUnit(seriesInfo.u().y(), seriesInfo.modality);
            basicDicomObject.putString(524544, null, string);
            basicDicomObject.putString(524546, null, "UCUM");
            basicDicomObject.putString(524549, null, "DCMR");
            DataUnitUtils.UnitCodeInfo unitCodeInfo = DataUnitUtils.getInfoForCode(string);
            if (unitCodeInfo != null) {
                basicDicomObject.putString(524548, null, unitCodeInfo.codeMeaning);
                basicDicomObject.putString(524559, null, unitCodeInfo.contextID);
                basicDicomObject.putString(524550, null, unitCodeInfo.contextGroupVersion);
            } else {
                basicDicomObject.putString(524548, null, seriesInfo.u().C());
                basicDicomObject.putString(524559, null, "84");
                basicDicomObject.putString(524550, null, "20121105");
                basicDicomObject.putString(524555, null, "Y");
                basicDicomObject.putString(524551, null, "20140801");
                basicDicomObject.putString(524557, null, "2.16.840.1.114362.1");
            }
        }
        DcmNMModule.fillWidthAndCenterTags(this.writer, dicomObject, seriesInfo);
    }

    @Override
    public void fillOrientationTags(DicomObject dicomObject) {
        NMPetPatientOrientationWriter.fillOrientationTags(this.writer, dicomObject);
        super.fillOrientationTags(dicomObject);
    }
}

