/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.mimvista.dicom.DataUnitUtils;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.write.AbstractDcmModule;
import com.mimvista.dicom.write.DcmNMModule;
import com.mimvista.dicom.write.SingleFileDcmWriter;
import com.mimvista.internals.ViewController;
import com.mimvista.viewer.SeriesInfo;
import java.util.ArrayList;

public class DcmNMWriter
extends SingleFileDcmWriter {
    public DcmNMWriter(ViewController viewController) {
        super(viewController);
        this.sopClassUID = "1.2.840.10008.5.1.4.1.1.20";
        this.modules.add(new DcmNMModule(this));
    }

    @Override
    public String getModality() {
        return "NM";
    }

    @Override
    public String getSopClass() {
        return "1.2.840.10008.5.1.4.1.1.20";
    }

    @Override
    public String getImageType() {
        String string = this.getVolume().getUncopiedMutableInfo().imageType;
        ViewController viewController = this.getViewController();
        boolean bl2 = viewController.bl();
        boolean bl3 = viewController.ay()[2] > 1;
        Modality modality = Modality.get(this.vs.getModality());
        if (string != null && modality == Modality.NM) {
            String[] stringArray = string.split("\\\\");
            if (stringArray.length > 4 || stringArray.length < 3) {
                return string;
            }
            ArrayList arrayList = Lists.newArrayList((Object[])new String[]{"DERIVED", stringArray[1]});
            String string2 = stringArray[2];
            if (!bl2) {
                if (stringArray[2].equals("GATED TOMO")) {
                    string2 = "TOMO";
                }
                if (stringArray[2].equals("RECON GATED TOMO")) {
                    string2 = "RECON TOMO";
                }
                if (stringArray[2].equals("GATED TOMO")) {
                    string2 = "TOMO";
                }
                if (stringArray[2].equals("DYNAMIC")) {
                    string2 = "STATIC";
                }
                if (stringArray[2].equals("GATED")) {
                    string2 = "STATIC";
                }
            }
            arrayList.add(string2);
            if (stringArray.length > 3) {
                arrayList.add(stringArray[3]);
            }
            return Joiner.on((char)'\\').join((Iterable)arrayList);
        }
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{"DERIVED", "PRIMARY"});
        if (bl3 && bl2) {
            arrayList.add("RECON GATED TOMO");
        } else if (bl3 && !bl2) {
            arrayList.add("RECON TOMO");
        } else if (!bl3 && bl2) {
            arrayList.add("GATED");
        } else {
            arrayList.add("STATIC");
        }
        arrayList.add("EMISSION");
        return String.join((CharSequence)"\\", arrayList);
    }

    @Override
    public boolean shouldWriteDeactualizedPixelValues() {
        SeriesInfo seriesInfo = this.getVolume().getUncopiedMutableInfo();
        if (AbstractDcmModule.isNMConvertedToCPS(seriesInfo)) {
            return false;
        }
        String string = seriesInfo.u().z();
        return !DataUnitUtils.COUNTS_CANON_.matchesUnit(string);
    }

    @Override
    protected boolean shouldWrite32Bit() {
        return false;
    }
}

