/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.dicom.write.AbstractDcmModule;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.dicom.write.NMPetPatientOrientationWriter;
import com.mimvista.internals.EditTargetInfo;
import com.mimvista.internals.ReadOnlyContrast;
import com.mimvista.viewer.PTSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import org.dcm4che2.data.DicomObject;

public class DcmPTModule
extends AbstractDcmModule {
    public DcmPTModule(DcmWriter dcmWriter) {
        super(dcmWriter);
    }

    @Override
    public void fillTags(DicomObject dicomObject) {
        PTSeriesInfo pTSeriesInfo;
        SeriesInfo seriesInfo = this.writer.getVolume().getUncopiedMutableInfo();
        if (seriesInfo.modInfo instanceof PTSeriesInfo) {
            pTSeriesInfo = (PTSeriesInfo)seriesInfo.modInfo;
        } else {
            pTSeriesInfo = new PTSeriesInfo();
            pTSeriesInfo.origUnits = null;
        }
        pTSeriesInfo.a(dicomObject);
        this.fillContrastTags(dicomObject, seriesInfo);
    }

    @Override
    public void updateTags(DicomObject dicomObject) {
        SeriesInfo seriesInfo = this.writer.getVolume().getUncopiedMutableInfo();
        this.fillContrastTags(dicomObject, seriesInfo);
    }

    private void fillContrastTags(DicomObject dicomObject, SeriesInfo seriesInfo) {
        ReadOnlyContrast readOnlyContrast = this.writer.getSaveDynamic() && this.writer.getFrmIdx() >= 0 ? this.writer.vs.g(new EditTargetInfo(this.writer.getFrmIdx(), true)) : this.writer.vs.s();
        UnitHelper unitHelper = seriesInfo.u();
        if (this.writer.saveOptions.saveSUV && unitHelper.x()) {
            dicomObject.putString(5509121, null, "GML");
            DcmPTModule.fillContrastTagsUsingRescale(this.writer, dicomObject, seriesInfo);
            DcmPTModule.fillWidthAndCenterTags(this.writer, dicomObject, seriesInfo);
            String string = dicomObject.getString(528446, this.writer.saveOptions.seriesDescription);
            String string2 = unitHelper.A();
            string = "SUV" + string2 + ":" + string;
            dicomObject.putString(528446, null, string);
        } else if (DcmPTModule.isNMConvertedToCPS(seriesInfo)) {
            dicomObject.putString(5509121, null, unitHelper.z());
            DcmPTModule.fillContrastTagsUsingRescale(this.writer, dicomObject, seriesInfo);
            DcmPTModule.fillWidthAndCenterTags(this.writer, dicomObject, seriesInfo);
        } else {
            Object object;
            String string = dicomObject.getString(5509121, "");
            if ((string == null || "".equals(string)) && (object = unitHelper.c()) != null) {
                dicomObject.putString(5509121, null, (String)object);
            }
            if ((object = this.writer.getRescaleConverterForSave()) != null) {
                dicomObject.putFloat(2625619, null, ((RescaleConverter)object).slope);
                dicomObject.putFloat(2625618, null, ((RescaleConverter)object).intercept);
            } else {
                dicomObject.putFloat(2625619, null, readOnlyContrast.z());
                dicomObject.putFloat(2625618, null, readOnlyContrast.y());
            }
            RescaleConverter rescaleConverter = seriesInfo.rescale.clone();
            rescaleConverter.unitScale = 1.0f;
            dicomObject.putFloat(2625617, null, rescaleConverter.applyContrastWidth(readOnlyContrast.m()));
            dicomObject.putFloat(2625616, null, rescaleConverter.apply(readOnlyContrast.l()));
        }
    }

    @Override
    public void fillOrientationTags(DicomObject dicomObject) {
        NMPetPatientOrientationWriter.fillOrientationTags(this.writer, dicomObject);
        super.fillOrientationTags(dicomObject);
    }
}

