/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.dicom.write.DcmPTModule;
import com.mimvista.dicom.write.MultiFileDcmWriter;
import com.mimvista.internals.SimpleImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.volumes.ImageVolumeShort;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.algo.BestContrastor;
import javax.vecmath.Matrix4f;
import org.dcm4che2.data.DicomObject;

public class DcmPTWriter
extends MultiFileDcmWriter {
    public DcmPTWriter(ViewController viewController) {
        super(viewController);
        this.modules.add(new DcmPTModule(this));
    }

    @Override
    public String getModality() {
        return "PT";
    }

    @Override
    public String getSopClass() {
        return "1.2.840.10008.5.1.4.1.1.128";
    }

    @Override
    public boolean shouldWriteDeactualizedPixelValues() {
        return true;
    }

    @Override
    protected void addPositionalTags(DicomObject dicomObject, int[] nArray, int n2, ImageVolumeShort imageVolumeShort, Matrix4f matrix4f) {
        super.addPositionalTags(dicomObject, nArray, n2, imageVolumeShort, matrix4f);
        if (this.getSaveDynamic()) {
            int n3 = nArray[5] - nArray[4] + 1;
            int n4 = this.vs3D.cE().b((SimpleImageFrame)imageVolumeShort);
            dicomObject.putInt(5509936, null, n3 * n4 + n2 + 1);
        } else {
            dicomObject.putInt(5509936, null, n2 + 1);
        }
    }

    @Override
    public RescaleConverter getRescaleConverterForSave() {
        int n2;
        int n3;
        boolean bl2;
        ImageVolumeShort imageVolumeShort = this.getVolume();
        SeriesInfo seriesInfo = imageVolumeShort.getUncopiedMutableInfo();
        RescaleConverter rescaleConverter = seriesInfo.rescale.clone();
        rescaleConverter.intercept = 0.0f;
        BestContrastor bestContrastor = imageVolumeShort.k();
        float f2 = seriesInfo.rescale.apply(bestContrastor.i());
        float f3 = seriesInfo.rescale.apply(bestContrastor.h());
        boolean bl3 = bl2 = f2 >= 0.0f;
        if (bl2) {
            n3 = 0;
            n2 = 65535;
        } else {
            n3 = Short.MIN_VALUE;
            n2 = Short.MAX_VALUE;
        }
        float f4 = seriesInfo.rescale.slope;
        if (rescaleConverter.removeRaw(f2) < (float)n3 || rescaleConverter.removeRaw(f3) > (float)n2) {
            float f5 = n3 != 0 ? f2 / (float)n3 : 0.0f;
            float f6 = f3 / (float)n2;
            f4 = Math.max(f5, f6);
        }
        rescaleConverter.slope = f4;
        return rescaleConverter;
    }

    @Override
    public boolean needsUnsignedDeactualizedSave() {
        ImageVolumeShort imageVolumeShort = this.getVolume();
        SeriesInfo seriesInfo = imageVolumeShort.getUncopiedMutableInfo();
        return seriesInfo.rescale.apply(imageVolumeShort.ah()) >= 0.0f;
    }
}

