/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.mimvista.dicom.util.RescaleConverter;
import com.mimvista.dicom.util.UIDGenerator;
import com.mimvista.dicom.write.AbstractDcmModule;
import com.mimvista.dicom.write.DcmWriter;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.preferencesNew.DosePrefs;
import com.mimvista.util.cn;
import com.mimvista.viewer.RTDoseSeriesInfo;
import com.mimvista.viewer.SeriesInfo;
import com.mimvista.viewer.UnitHelper;
import java.util.List;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DcmRTDOSEModule
extends AbstractDcmModule {
    private SeriesInfo ownerInfo;

    public DcmRTDOSEModule(DcmWriter dcmWriter, ViewController viewController) {
        super(dcmWriter);
        if (viewController != null) {
            this.ownerInfo = viewController.getUncopiedMutableInfo();
        }
    }

    public DcmRTDOSEModule(DcmWriter dcmWriter, ImageFrame imageFrame) {
        super(dcmWriter);
        if (imageFrame != null) {
            this.ownerInfo = imageFrame.getUncopiedMutableInfo();
        }
    }

    @Override
    public void fillTags(DicomObject dicomObject) {
        long l2;
        long l3;
        DicomElement dicomElement;
        BasicDicomObject basicDicomObject;
        boolean bl2;
        SeriesInfo seriesInfo = this.writer.getVolume().getUncopiedMutableInfo();
        if (!(seriesInfo.modInfo instanceof RTDoseSeriesInfo)) {
            throw new IllegalArgumentException("Error: attempting to save a malformed RTdose series.");
        }
        RTDoseSeriesInfo rTDoseSeriesInfo = (RTDoseSeriesInfo)seriesInfo.modInfo;
        dicomObject.putString(805568514, VR.CS, "GY");
        UnitHelper unitHelper = seriesInfo.u();
        boolean bl3 = true;
        float f2 = seriesInfo.rescale.apply(this.writer.getVolume().ah());
        if (f2 < 0.0f) {
            dicomObject.putString(0x30040004, VR.CS, "ERROR");
            bl3 = false;
        } else if (unitHelper.y().equals("BED")) {
            dicomObject.putString(0x30040004, VR.CS, "EFFECTIVE");
        } else {
            dicomObject.putString(0x30040004, VR.CS, "PHYSICAL");
        }
        dicomObject.putInt(2621699, VR.US, bl3 ? 0 : 1);
        boolean bl4 = bl2 = seriesInfo.accumulationProducedVolume && DosePrefs.doseSummationMultiPlan.getValue() != false;
        if (bl2) {
            dicomObject.putString(805568522, VR.CS, "MULTI_PLAN");
        } else {
            dicomObject.putString(805568522, VR.CS, "PLAN");
        }
        dicomObject.putInt(2097171, VR.IS, 1);
        dicomObject.putInt(2621449, null, 805568524);
        int n2 = this.writer.getOutputVolumeDims()[2];
        dicomObject.putInt(0x280008, null, n2);
        float[] fArray = new float[n2];
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            fArray[i2] = (float)i2 * this.writer.getVolume().b()[2];
        }
        dicomObject.putFloats(805568524, VR.DS, fArray);
        if (rTDoseSeriesInfo.referencedRtStructUID != null && !rTDoseSeriesInfo.referencedRtStructUID.isEmpty()) {
            DicomElement dicomElement2 = dicomObject.putSequence(806092896);
            basicDicomObject = new BasicDicomObject();
            dicomElement2.addDicomObject((DicomObject)basicDicomObject);
            basicDicomObject.putString(528720, VR.UI, "1.2.840.10008.5.1.4.1.1.481.3");
            basicDicomObject.putString(528725, VR.UI, rTDoseSeriesInfo.referencedRtStructUID);
        }
        if (bl2 && rTDoseSeriesInfo.tissueHeterogeneityCorrection.size() > 0) {
            String[] stringArray = rTDoseSeriesInfo.tissueHeterogeneityCorrection.toArray(new String[0]);
            dicomObject.putStrings(805568532, VR.CS, stringArray);
        }
        if (bl2) {
            dicomElement = dicomObject.putSequence(806092802);
            boolean bl5 = false;
            for (String string : rTDoseSeriesInfo.referencedRtPlanUIDs) {
                if (cn.g(string)) continue;
                BasicDicomObject basicDicomObject2 = new BasicDicomObject();
                dicomElement.addDicomObject((DicomObject)basicDicomObject2);
                basicDicomObject2.putString(528720, VR.UI, "1.2.840.10008.5.1.4.1.1.481.5");
                basicDicomObject2.putString(528725, VR.UI, string);
                bl5 = true;
            }
            if (!bl5) {
                BasicDicomObject basicDicomObject3 = new BasicDicomObject();
                dicomElement.addDicomObject((DicomObject)basicDicomObject3);
                basicDicomObject3.putString(528720, VR.UI, "1.2.840.10008.5.1.4.1.1.481.5");
                basicDicomObject3.putString(528725, VR.UI, UIDGenerator.generateUID());
            }
        } else if (!cn.g(rTDoseSeriesInfo.referencedRtPlanUID)) {
            dicomElement = dicomObject.putSequence(806092802);
            basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            basicDicomObject.putString(528720, VR.UI, "1.2.840.10008.5.1.4.1.1.481.5");
            basicDicomObject.putString(528725, VR.UI, rTDoseSeriesInfo.referencedRtPlanUID);
        } else {
            dicomElement = dicomObject.putSequence(806092802);
            basicDicomObject = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject);
            basicDicomObject.putString(528720, VR.UI, "1.2.840.10008.5.1.4.1.1.481.5");
            basicDicomObject.putString(528725, VR.UI, UIDGenerator.generateUID());
        }
        if (this.ownerInfo != null) {
            dicomElement = dicomObject.putSequence(528704);
            BasicDicomObject basicDicomObject4 = new BasicDicomObject();
            dicomElement.addDicomObject((DicomObject)basicDicomObject4);
            basicDicomObject4.putString(528720, VR.UI, "1.2.840.10008.5.1.4.1.1.2");
            basicDicomObject4.putString(528725, VR.UI, this.ownerInfo.ag());
            if (this.writer.saveOptions.keepAssociation && !this.writer.saveOptions.saveAsOrthogonal) {
                dicomObject.putString(0x20000D, VR.UI, this.ownerInfo.studyUID);
            }
        }
        seriesInfo.modInfo.a(dicomObject);
        boolean bl6 = DosePrefs.write32bitData.getValue();
        if (bl6) {
            dicomObject.putInt(2621696, VR.US, 32);
            dicomObject.putInt(2621697, VR.US, 32);
            dicomObject.putInt(2621698, VR.US, 31);
        } else {
            dicomObject.putInt(2621696, VR.US, 16);
            dicomObject.putInt(2621697, VR.US, 16);
            dicomObject.putInt(2621698, VR.US, 15);
        }
        float f3 = seriesInfo.rescale.slope;
        if (bl3) {
            l3 = 0L;
            l2 = bl6 ? 0xFFFFFFFFL : 65535L;
        } else if (bl6) {
            l3 = Integer.MIN_VALUE;
            l2 = Integer.MAX_VALUE;
        } else {
            l3 = -32768L;
            l2 = 32767L;
        }
        RescaleConverter rescaleConverter = seriesInfo.rescale.clone();
        rescaleConverter.intercept = 0.0f;
        float f4 = seriesInfo.rescale.apply(this.writer.getVolume().ah());
        float f5 = seriesInfo.rescale.apply(this.writer.getVolume().ai());
        if (rescaleConverter.removeRaw(f4) < (float)l3 || rescaleConverter.removeRaw(f5) > (float)l2) {
            float f6 = l3 != 0L ? f4 / (float)l3 : 0.0f;
            float f7 = f5 / (float)l2;
            f3 = Math.max(f6, f7);
        }
        dicomObject.putFloat(805568526, null, f3);
        dicomObject.putString(930283808, VR.ST, rTDoseSeriesInfo.curDose.b().name());
        dicomObject.putFloat(930283810, VR.FL, rTDoseSeriesInfo.curDose.c().getValueInGy());
        if (seriesInfo.extraInfo.containsKey("BED ALGORITHM INFO")) {
            dicomObject.putString(930304000, VR.ST, seriesInfo.extraInfo.get("BED ALGORITHM INFO"));
        }
        this.addParents(dicomObject, rTDoseSeriesInfo.accumParents);
    }

    private void addParents(DicomObject dicomObject, List<RTDoseSeriesInfo.DoseAccumParent> list) {
        if (!list.isEmpty()) {
            DicomElement dicomElement = dicomObject.putSequence(930295840);
            for (RTDoseSeriesInfo.DoseAccumParent doseAccumParent : list) {
                BasicDicomObject basicDicomObject = new BasicDicomObject();
                dicomElement.addDicomObject((DicomObject)basicDicomObject);
                basicDicomObject.putString(930295841, VR.LO, doseAccumParent.name);
                basicDicomObject.putDate(930295842, VR.DT, doseAccumParent.date);
                basicDicomObject.putString(930295843, VR.UI, doseAccumParent.seriesUID);
                basicDicomObject.putFloat(930295844, VR.FL, doseAccumParent.numerator);
                basicDicomObject.putFloat(930295845, VR.FL, doseAccumParent.denominator);
                this.addParents((DicomObject)basicDicomObject, doseAccumParent.parents);
            }
        }
    }
}

