/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.google.common.collect.Lists;
import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.ag;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.commands.workflow.DicomSaveCommand;
import com.mimvista.d;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.dicom.util.DicomRegUtils;
import com.mimvista.dicom.util.RawDicomUtils;
import com.mimvista.dicom.write.deformable.DcmDeformableRegQAHelper;
import com.mimvista.gui.util.InputNotification;
import com.mimvista.gui.util.af;
import com.mimvista.gui.util.l;
import com.mimvista.internals.ImageFrame;
import com.mimvista.internals.ViewController;
import com.mimvista.internals.linking.AffineTransform;
import com.mimvista.internals.s;
import com.mimvista.mui.Session;
import com.mimvista.mui.ak;
import com.mimvista.numerics.DicomPoint3f;
import com.mimvista.numerics.MatrixMultiplier;
import com.mimvista.numerics.MetricPoint3f;
import com.mimvista.numerics.TypedMatrix;
import com.mimvista.swing.widgets.Notification;
import com.mimvista.swing.widgets.ProgressQueueNotification;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.progress.Progress;
import com.mimvista.util.progress.g;
import com.mimvista.util.work.m;
import com.mimvista.viewer.algo.b;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.vecmath.Matrix4f;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;

public class DcmRegWriter
extends b {
    public static Messages props = Messages.a("Dicom");
    private s fusion;
    private String contentCreator;

    public DcmRegWriter(s s2) {
        this.viewState = s2.V();
        this.info = this.viewState.getUncopiedMutableInfo();
        this.fusion = s2;
    }

    @Override
    public String getProgressTitle() {
        return Messages.a("Dicom", "DCM_SERIES_SAVE_REG");
    }

    @Override
    public Modality getModality() {
        return Modality.REG;
    }

    @Override
    public UIDContainer getSopClassUID() {
        return new UIDContainer.SOPClassUID("1.2.840.10008.5.1.4.1.1.66.1");
    }

    @Override
    public String getSeriesDate() {
        return this.info.M();
    }

    @Override
    public String getSeriesTime() {
        return this.info.P();
    }

    public void setContentCreator(String string) {
        this.contentCreator = string;
    }

    public InputNotification createNotification(Component component, final ActionListener actionListener, final @d Runnable runnable) {
        final InputNotification inputNotification = new InputNotification(new Notification.a(this.viewState), props.getProperty("DCM_REG_W_SAVE"), "save");
        inputNotification.addTitle(props.getProperty("DCM_REG_W_SAVE"));
        final af af2 = inputNotification.addStringField(props.getProperty("DCM_REG_W_SERIES")).g(false).d("REG");
        final af af3 = inputNotification.addStringField(props.getProperty("DCM_REG_W_CREATOR")).g(true);
        SearchSource searchSource = this.fusion.c.bG();
        SendToDestination sendToDestination = ag.a(searchSource);
        if (ag.d() != null) {
            sendToDestination = ag.d();
        }
        final l<SendToDestination> l2 = inputNotification.addSendToCombo(props.getProperty("DCM_REG_W_DESTINATION")).a(sendToDestination);
        inputNotification.setOkActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DcmRegWriter.this.seriesDescription = (String)af2.b();
                DcmRegWriter.this.contentCreator = (String)af3.b();
                ProgressQueueNotification.a(new ProgressQueueNotification.b(){

                    @Override
                    public void run(g g2) {
                        DcmRegWriter.this.writeTo((SendToDestination)l2.b(), (Progress)g2);
                        if (runnable != null) {
                            runnable.run();
                        }
                    }
                });
                ArrayList arrayList = Lists.newArrayList();
                arrayList.add(DcmRegWriter.this.fusion.V());
                arrayList.add(DcmRegWriter.this.fusion.W());
                for (final ViewController viewController : arrayList) {
                    boolean bl2 = false;
                    if (viewController.getUncopiedMutableInfo().mimDerivedVolume && !viewController.getUncopiedMutableInfo().volumeHasBeenSaved) {
                        if (viewController == DcmRegWriter.this.fusion.V()) {
                            bl2 = 0 == JOptionPane.showConfirmDialog(ak.b().O(), props.getProperty("DICOM_SAVE_FUSION_REG_DERIVED_PRIMARY"), props.getProperty("DICOM_SAVE_FUSION_REG_DERIVED_TITLE"), 0, 3);
                        } else {
                            boolean bl3 = bl2 = 0 == JOptionPane.showConfirmDialog(ak.b().O(), props.getProperty("DICOM_SAVE_FUSION_REG_DERIVED_SECONDARY"), props.getProperty("DICOM_SAVE_FUSION_REG_DERIVED_TITLE"), 0, 3);
                        }
                    }
                    if (!bl2) continue;
                    inputNotification.setDismissActionListener(null);
                    m.e.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (actionListener != null) {
                                DicomSaveCommand.get(viewController).executeWithGUI(actionListener);
                            } else {
                                DicomSaveCommand.get(viewController).execute();
                            }
                        }
                    });
                }
            }
        });
        return inputNotification;
    }

    @Override
    protected void fillIodSpecificTags(DicomObject dicomObject) {
        dicomObject.putString(524323, VR.DA, DateUtils.e());
        dicomObject.putString(524339, VR.TM, DateUtils.f());
        String string = this.fusion.V().aP().studyUID;
        String string2 = this.fusion.W().aP().studyUID;
        if (string != null && string.equalsIgnoreCase(string2)) {
            RawDicomUtils.getReferencedSeriesSequence(dicomObject, this.fusion.c.cw(), this.fusion.d.cw());
        } else {
            RawDicomUtils.addScorisObjectAllSops(dicomObject, this.fusion.C());
            RawDicomUtils.getReferencedSeriesSequence(dicomObject, this.fusion.c.cw());
        }
        dicomObject.putString(2097171, null, "1");
        dicomObject.putString(0x200052, VR.UI, this.info.frameOfRefUID);
        dicomObject.putString(2101312, null, "");
        dicomObject.putString(0x700080, null, "REGISTRATION");
        dicomObject.putString(7340161, null, "Fusion Registration");
        dicomObject.putString(7340164, null, this.contentCreator);
        DicomElement dicomElement = dicomObject.putSequence(7340808);
        this.addPrimaryRegSeq(dicomElement);
        this.addRegSeq(dicomElement);
        if (DcmDeformableRegQAHelper.shouldAddLockedAlignmentsSequence(this.fusion.cw(), this.fusion.C())) {
            DcmDeformableRegQAHelper.createRRSequence(dicomObject, this.fusion.cw(), this.fusion.C());
        }
    }

    private void addRegSeq(DicomElement dicomElement) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        DicomElement dicomElement2 = basicDicomObject.putSequence(528704);
        RawDicomUtils.getImageSOPInstanceMacroAllSops(dicomElement2, this.fusion.d.cw());
        basicDicomObject.putString(0x200052, VR.UI, this.fusion.B().frameOfRefUID);
        BasicDicomObject basicDicomObject2 = new BasicDicomObject();
        basicDicomObject.putNestedDicomObject(7340809, (DicomObject)basicDicomObject2);
        this.addCodeSequence(basicDicomObject2.putSequence(7340813), "125025", "DCM", "Visual Alignment");
        this.addMatrixSeq(basicDicomObject2.putSequence(7340810));
    }

    private void addPrimaryRegSeq(DicomElement dicomElement) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        DicomElement dicomElement2 = basicDicomObject.putSequence(528704);
        RawDicomUtils.getImageSOPInstanceMacroAllSops(dicomElement2, this.fusion.c.cw());
        basicDicomObject.putString(0x200052, VR.UI, this.fusion.getUncopiedMutableInfo().frameOfRefUID);
        BasicDicomObject basicDicomObject2 = new BasicDicomObject();
        basicDicomObject.putNestedDicomObject(7340809, (DicomObject)basicDicomObject2);
        this.addCodeSequence(basicDicomObject2.putSequence(7340813), "125025", "DCM", "Visual Alignment");
        DcmRegWriter.addIdentityMatrixSeq(basicDicomObject2.putSequence(7340810));
    }

    private void addMatrixSeq(DicomElement dicomElement) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(7340812, null, "RIGID");
        basicDicomObject.putFloats(805699782, null, DcmRegWriter.getTMatrixArray(this.fusion.g(), this.fusion.cw(), this.fusion.C()));
    }

    public static void addIdentityMatrixSeq(DicomElement dicomElement) {
        float[] fArray = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomElement.addDicomObject((DicomObject)basicDicomObject);
        basicDicomObject.putString(7340812, null, "RIGID");
        basicDicomObject.putFloats(805699782, null, fArray);
    }

    public static float[] getTMatrixArray(Session session, ImageFrame imageFrame, ImageFrame imageFrame2) {
        AffineTransform affineTransform = session.q().d(imageFrame, imageFrame2);
        if (affineTransform == null) {
            return null;
        }
        Matrix4f matrix4f = affineTransform.d();
        matrix4f.invert();
        TypedMatrix typedMatrix = new TypedMatrix(matrix4f);
        TypedMatrix<DicomPoint3f, MetricPoint3f> typedMatrix2 = DicomRegUtils.generate_DICOM_M_METRIC(imageFrame);
        TypedMatrix<MetricPoint3f, DicomPoint3f> typedMatrix3 = DicomRegUtils.generate_METRIC_M_DICOM(imageFrame2);
        TypedMatrix<DicomPoint3f, DicomPoint3f> typedMatrix4 = typedMatrix3.a(typedMatrix).a(typedMatrix2);
        return MatrixMultiplier.l(typedMatrix4.b());
    }
}

