/*
 * Decompiled with CFR 0.152.
 */
package com.mimvista.dicom.write;

import com.mimvista.archive.gui.SendToDestination;
import com.mimvista.archive.gui.fractions.FractionGrade;
import com.mimvista.archive.search.SearchSource;
import com.mimvista.archive.search.g;
import com.mimvista.dicom.Modality;
import com.mimvista.dicom.UIDContainer;
import com.mimvista.metabase.DbWriteResult;
import com.mimvista.report.automated.service.AutomatedWorkflowSandbox;
import com.mimvista.report.cbct.FractionInformation;
import com.mimvista.report.cbct.config.ArtAssistConfig;
import com.mimvista.report.cbct.config.FractionUpdate;
import com.mimvista.report.cbct.config.h;
import com.mimvista.report.codes.ConceptCode;
import com.mimvista.report.codes.GeneralConcept;
import com.mimvista.report.comprehensive.images.ImageReference;
import com.mimvista.report.comprehensive.nodes.ReportNodeFactory;
import com.mimvista.report.comprehensive.nodes.a;
import com.mimvista.report.gui.content.c;
import com.mimvista.report.gui.content.constraints.ReportConstraintComparisonState;
import com.mimvista.report.gui.content.header.a.b;
import com.mimvista.report.nodes.Report;
import com.mimvista.util.DateUtils;
import com.mimvista.util.Messages;
import com.mimvista.util.ay;
import com.mimvista.util.cn;
import com.mimvista.util.progress.Progress;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.hibernate.cfg.NotYetImplementedException;

public class DcmSRWriter
extends com.mimvista.viewer.algo.b {
    final a<?> rootNode;
    private final Report report;
    private String providedDesc;
    private String providedOperator;

    public DcmSRWriter(Report report, String string, String string2) {
        this.report = report;
        this.rootNode = report.n().c();
        this.info = report.d();
        this.providedDesc = string;
        this.providedOperator = string2;
    }

    public DcmSRWriter(Report report) {
        this(report, null, null);
    }

    @Override
    public String getProgressTitle() {
        return Messages.a("Dicom", "DCM_SERIES_SAVE_SR");
    }

    @Override
    public Modality getModality() {
        return Modality.SR;
    }

    @Override
    public UIDContainer getSopClassUID() {
        return new UIDContainer.SOPClassUID("1.2.840.10008.5.1.4.1.1.88.33");
    }

    @Override
    public String getSeriesDescription() {
        if (cn.h(this.providedDesc)) {
            return cn.h(this.report.f()) || this.report.h() < 0L ? "" : this.report.f();
        }
        return this.providedDesc;
    }

    @Override
    public String getOperatorName() {
        return this.providedOperator;
    }

    @Override
    public String getSeriesDate() {
        return DateUtils.e();
    }

    @Override
    public String getSeriesTime() {
        return DateUtils.f();
    }

    @Override
    protected void fillIodSpecificTags(DicomObject dicomObject) {
        Integer n2;
        Object object;
        b b2;
        ArtAssistConfig artAssistConfig;
        if (this.report.B() != null) {
            dicomObject.putString(1245186, VR.UI, this.report.B());
        }
        if ((artAssistConfig = (b2 = this.report.o().g()).b()) != null && (object = artAssistConfig.b()) != null) {
            dicomObject.putString(0x37733030, VR.ST, (String)object);
        }
        if ((object = b2.h()) != null) {
            dicomObject.putInt(930295857, VR.IS, ((Integer)object).intValue());
        }
        if ((n2 = b2.i()) != null) {
            dicomObject.putInt(930295858, VR.IS, n2.intValue());
        }
        this.createConstraintResult(dicomObject);
        this.generateContent(this.rootNode, dicomObject);
    }

    @Override
    public boolean writeTo(SendToDestination sendToDestination, Progress progress) {
        this.updateFractionGrade(sendToDestination);
        return super.writeTo(sendToDestination, progress);
    }

    private void updateFractionGrade(SendToDestination sendToDestination) {
        b b2;
        ArtAssistConfig artAssistConfig;
        SearchSource searchSource = g.a(sendToDestination);
        if (searchSource != null && searchSource.s() && (artAssistConfig = (b2 = this.report.o().g()).b()) != null) {
            FractionInformation fractionInformation = null;
            Integer n2 = b2.h();
            Integer n3 = b2.i();
            if (n2 != null && n3 != null) {
                fractionInformation = artAssistConfig.a(n2, n3);
            }
            if (fractionInformation != null) {
                try {
                    FractionGrade fractionGrade = FractionGrade.valueOf(this.getDicomObject().getString(0x130003));
                    ay.b((Object)("Updating ART Fraction's SR with Constraint Grade: " + (Object)((Object)fractionGrade) + " for " + fractionInformation.getLogString()), AutomatedWorkflowSandbox.class);
                    FractionUpdate fractionUpdate = new FractionUpdate(artAssistConfig, fractionInformation).a(fractionGrade);
                    h h2 = b2.c();
                    DbWriteResult dbWriteResult = h2.a(fractionUpdate);
                    if (dbWriteResult.b()) {
                        fractionInformation.setGrade(fractionUpdate.i());
                    }
                }
                catch (Throwable throwable) {
                    ay.d((Object)("Error updating ART Fraction with Constraint Grade for" + fractionInformation.getLogString()), throwable, this);
                }
            } else {
                ay.c((Object)"No ART fraction found to update constraint grade", this);
            }
        }
    }

    private DicomObject createConstraintResult(DicomObject dicomObject) {
        Object object;
        LinkedList<c> linkedList = new LinkedList<c>();
        linkedList.addAll(this.report.m().k());
        ArrayList<FractionGrade> arrayList = new ArrayList<FractionGrade>();
        while (!linkedList.isEmpty()) {
            object = (c)linkedList.poll();
            if (object instanceof com.mimvista.report.gui.content.g) {
                linkedList.addAll(((com.mimvista.report.gui.content.g)object).k());
                continue;
            }
            if (!(object instanceof ReportConstraintComparisonState)) continue;
            ReportConstraintComparisonState reportConstraintComparisonState = (ReportConstraintComparisonState)object;
            FractionGrade fractionGrade = ReportConstraintComparisonState.a(reportConstraintComparisonState);
            arrayList.add(fractionGrade);
        }
        object = FractionGrade.getMostSevereGrade(arrayList.stream());
        dicomObject.putString(0x130003, VR.ST, ((Enum)object).name());
        return dicomObject;
    }

    private DicomObject generateContent(a<?> b2, DicomObject dicomObject) {
        if (b2.c()) {
            ReportNodeFactory.b b3 = ReportNodeFactory.a(b2.e(), b2.g(), GeneralConcept.aj.getCode());
            b3.a(b2.i(), b2.g());
            for (a<?> a2 : b2.h()) {
                b3.a(a2);
            }
            b2 = b3;
        }
        this.writeBasicNodeInformation(dicomObject, b2);
        this.writeValueTypeSpecificInfo(dicomObject, b2);
        this.writeChildNodeInformation(dicomObject, b2);
        return dicomObject;
    }

    private void writeBasicNodeInformation(DicomObject dicomObject, a<?> a2) {
        DicomElement dicomElement = dicomObject.putSequence(4235331);
        this.addCodeSequenceMacro(dicomElement, a2.e());
        dicomObject.putString(0x40A040, VR.CS, a2.f().name());
        if (a2.i() != null) {
            dicomObject.putString(4235280, VR.CS, a2.g().a());
        }
    }

    private void writeValueTypeSpecificInfo(DicomObject dicomObject, a<?> a2) {
        switch (a2.f()) {
            case a: {
                this.writeContainerInfo(dicomObject, a2);
                break;
            }
            case b: {
                this.writeTextInfo(dicomObject, a2);
                break;
            }
            case c: {
                this.writeCodeNodeInfo(dicomObject, a2);
                break;
            }
            case d: {
                this.writeNumberInfo(dicomObject, a2);
                break;
            }
            case e: {
                this.writePnameInfo(dicomObject, a2);
                break;
            }
            case f: {
                this.writeDayInfo(dicomObject, a2);
                break;
            }
            case g: {
                this.writeTimeInfo(dicomObject, a2);
                break;
            }
            case h: {
                this.writeDayAndTimeInfo(dicomObject, a2);
                break;
            }
            case i: {
                this.writeUidRefInfo(dicomObject, a2);
                break;
            }
            case j: {
                this.writeImageInfo(dicomObject, a2);
                break;
            }
            case k: {
                this.writeWaveformInfo(dicomObject, a2);
                break;
            }
            case l: {
                this.writeCompositeInfo(dicomObject, a2);
                break;
            }
            case m: {
                this.writeScoordInfo(dicomObject, a2);
                break;
            }
            case n: {
                throw new NotYetImplementedException("Not yet implemented");
            }
        }
    }

    private void writeChildNodeInformation(DicomObject dicomObject, a<?> a2) {
        if (!a2.isLeaf()) {
            DicomElement dicomElement = dicomObject.putSequence(4237104);
            for (a<?> a3 : a2.h()) {
                BasicDicomObject basicDicomObject = new BasicDicomObject();
                dicomElement.addDicomObject((DicomObject)basicDicomObject);
                this.generateContent(a3, (DicomObject)basicDicomObject);
                if (!basicDicomObject.isEmpty()) continue;
                dicomElement.removeDicomObject((DicomObject)basicDicomObject);
            }
        }
    }

    private void writeContainerInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.c) {
            ReportNodeFactory.c c2 = (ReportNodeFactory.c)a2;
            ReportNodeFactory.ContinuityOfContent continuityOfContent = (ReportNodeFactory.ContinuityOfContent)c2.d();
            if (continuityOfContent == null) {
                continuityOfContent = ReportNodeFactory.ContinuityOfContent.a;
            }
            dicomObject.putString(4235344, VR.CS, continuityOfContent.name());
        } else if (a2 instanceof ReportNodeFactory.f) {
            ReportNodeFactory.f f2 = (ReportNodeFactory.f)a2;
            dicomObject.putFloats(805568600, VR.DS, ((ReportNodeFactory.FloatArrayNodeWrapper)f2.d()).value);
        } else if (a2 instanceof ReportNodeFactory.a) {
            ReportNodeFactory.a a3 = (ReportNodeFactory.a)a2;
            dicomObject.putBytes(2145386512, VR.OW, ((ReportNodeFactory.ByteArrayNodeWrapper)a3.d()).value);
        } else if (a2 instanceof ReportNodeFactory.e) {
            ReportNodeFactory.e e2 = (ReportNodeFactory.e)a2;
            dicomObject.putNestedDicomObject(928055808, ((ReportNodeFactory.EmbeddedDicomNodeWrapper)e2.d()).dicom);
        } else {
            ay.d((Object)"Could not write node in SR because it was of type CONTAINER but wasn't actually a container node", this);
        }
    }

    private void writeTextInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.k) {
            ReportNodeFactory.k k2 = (ReportNodeFactory.k)a2;
            String string = cn.i(k2.d() != null ? ((ReportNodeFactory.StringNodeWrapper)k2.d()).value : null);
            dicomObject.putString(4235616, VR.UT, string);
        } else {
            ay.d((Object)"Could not write node in SR because it was of type CONTAINER but wasn't actually a container node", this);
        }
    }

    private void writeCodeNodeInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.b) {
            ReportNodeFactory.b b2 = (ReportNodeFactory.b)a2;
            ConceptCode conceptCode = (ConceptCode)b2.d();
            if (conceptCode != null) {
                DicomElement dicomElement = dicomObject.putSequence(4235624);
                this.addCodeSequenceMacro(dicomElement, conceptCode);
            } else {
                ay.d((Object)"Concept code was null", this);
            }
        } else {
            ay.d((Object)"Could not write node in SR because it was of type CODE but wasn't actually a concept code", this);
        }
    }

    private void writeNumberInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.h) {
            ReportNodeFactory.h h2 = (ReportNodeFactory.h)a2;
            ReportNodeFactory.MeasuredValue measuredValue = (ReportNodeFactory.MeasuredValue)h2.d();
            DicomElement dicomElement = dicomObject.putSequence(4236032);
            if (measuredValue != null) {
                BasicDicomObject basicDicomObject = new BasicDicomObject();
                dicomElement.addDicomObject((DicomObject)basicDicomObject);
                basicDicomObject.putString(4236042, VR.DS, measuredValue.number == null ? null : measuredValue.number.toString());
                DicomElement dicomElement2 = basicDicomObject.putSequence(4196586);
                this.addCodeSequenceMacro(dicomElement2, measuredValue.unitsCode);
            }
        } else {
            ay.d((Object)"Could not write node in SR because it was of type NUM but wasn't actually a measurement value", this);
        }
    }

    private void writePnameInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.k) {
            String string;
            ReportNodeFactory.k k2 = (ReportNodeFactory.k)a2;
            String string2 = string = k2.d() != null ? ((ReportNodeFactory.StringNodeWrapper)k2.d()).value : null;
            if (string != null) {
                dicomObject.putString(4235555, VR.PN, string);
            }
        } else {
            ay.d((Object)"Could not write node in SR because it was of type PNAME but didn't have a string type", this);
        }
    }

    private void writeDayInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.d) {
            Date date;
            ReportNodeFactory.d d2 = (ReportNodeFactory.d)a2;
            Date date2 = date = d2.d() != null ? ((ReportNodeFactory.DateNodeWrapper)d2.d()).value : null;
            if (date != null) {
                dicomObject.putDate(4235553, VR.DA, date);
            } else {
                ay.d((Object)"Could not write the date because it was null", this);
            }
        } else {
            ay.d((Object)"Could not write node in SR because it was of type DATE but didn't have a date value", this);
        }
    }

    private void writeTimeInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.d) {
            Date date;
            ReportNodeFactory.d d2 = (ReportNodeFactory.d)a2;
            Date date2 = date = d2.d() != null ? ((ReportNodeFactory.DateNodeWrapper)d2.d()).value : null;
            if (date != null) {
                dicomObject.putDate(4235554, VR.TM, date);
            } else {
                ay.d((Object)"Could not write the time because it was null", this);
            }
        } else {
            ay.d((Object)"Could not write node in SR because it was of type TIME but didn't have a date value", this);
        }
    }

    private void writeDayAndTimeInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.d) {
            Date date;
            ReportNodeFactory.d d2 = (ReportNodeFactory.d)a2;
            Date date2 = date = d2.d() != null ? ((ReportNodeFactory.DateNodeWrapper)d2.d()).value : null;
            if (date != null) {
                dicomObject.putDate(4235552, VR.DT, date);
            } else {
                ay.d((Object)"Could not write the date because it was null", this);
            }
        } else {
            ay.d((Object)"Could not write node in SR because it was of type DATETIME but didn't have a date value", this);
        }
    }

    private void writeUidRefInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.k) {
            String string;
            ReportNodeFactory.k k2 = (ReportNodeFactory.k)a2;
            String string2 = string = k2.d() != null ? ((ReportNodeFactory.StringNodeWrapper)k2.d()).value : null;
            if (string != null) {
                dicomObject.putString(4235556, VR.UI, string);
            } else {
                ay.d((Object)"Could not write the UID because it was null", this);
            }
        } else {
            ay.d((Object)"Could not write node in SR because it was of type UIDREF but didn't have a string value", this);
        }
    }

    private void writeImageInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.g) {
            ReportNodeFactory.g g2 = (ReportNodeFactory.g)a2;
            ImageReference imageReference = (ImageReference)g2.d();
            if (imageReference != null && imageReference.sopReference != null) {
                this.addSopSequenceMacro(dicomObject, imageReference.sopReference);
                if (imageReference.frameIndices != null) {
                    dicomObject.putInts(528736, VR.IS, imageReference.frameIndices);
                }
            } else {
                ay.d((Object)"Could not write the Image reference because it was null", this);
            }
        } else {
            ay.d((Object)"Could not write node in SR because it was of type IMAGE but didn't have an image ref value", this);
        }
    }

    private void writeWaveformInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.m) {
            ReportNodeFactory.m m2 = (ReportNodeFactory.m)a2;
            ReportNodeFactory.Waveform waveform = (ReportNodeFactory.Waveform)m2.d();
            if (waveform != null && waveform.sopReference != null) {
                this.addSopSequenceMacro(dicomObject, waveform.sopReference);
                if (waveform.channelNumbers != null) {
                    dicomObject.putInts(4235440, VR.IS, waveform.channelNumbers);
                }
            }
            if (waveform != null && waveform.waveformData != null) {
                BasicDicomObject basicDicomObject = new BasicDicomObject();
                dicomObject.putNestedDicomObject(1409286400, (DicomObject)basicDicomObject);
                basicDicomObject.putString(3801092, VR.DS, "ORIGINAL");
                basicDicomObject.putString(3801093, VR.IS, "1");
                basicDicomObject.putString(3801104, VR.IS, "16");
                basicDicomObject.putString(3801114, VR.IS, "44100");
                basicDicomObject.putString(3801626, VR.IS, String.valueOf(waveform.waveformData.length / 16));
                basicDicomObject.putString(1409290244, VR.IS, "16");
                basicDicomObject.putString(1409290246, VR.CS, "SS");
                basicDicomObject.putBytes(1409290256, VR.OB, waveform.waveformData);
            }
        } else {
            ay.d((Object)"Could not write node in SR because it was of type WAVEFORM but didn't have a Waveform value", this);
        }
    }

    private void writeCompositeInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.j) {
            ReportNodeFactory.j j2 = (ReportNodeFactory.j)a2;
            ReportNodeFactory.SopReference sopReference = (ReportNodeFactory.SopReference)j2.d();
            if (sopReference != null) {
                this.addSopSequenceMacro(dicomObject, sopReference);
            } else {
                ay.d((Object)"Could not write the Sop Reference because it was null", this);
            }
        } else {
            ay.d((Object)"Could not write node in SR because it was of type COMPOSITE but didn't have a SOP Reference value", this);
        }
    }

    private void writeScoordInfo(DicomObject dicomObject, a<?> a2) {
        if (a2 instanceof ReportNodeFactory.i) {
            ReportNodeFactory.i i2 = (ReportNodeFactory.i)a2;
            ReportNodeFactory.SliceCoordinates sliceCoordinates = (ReportNodeFactory.SliceCoordinates)i2.d();
            if (sliceCoordinates != null && sliceCoordinates.graphicType != null && sliceCoordinates.voxelPoints != null) {
                float[] fArray = new float[sliceCoordinates.voxelPoints.length * 2];
                for (int i3 = 0; i3 < sliceCoordinates.voxelPoints.length; ++i3) {
                    fArray[i3 * 2] = sliceCoordinates.voxelPoints[i3].x;
                    fArray[i3 * 2 + 1] = sliceCoordinates.voxelPoints[i3].y;
                }
                dicomObject.putString(7340067, VR.CS, sliceCoordinates.graphicType.name());
                dicomObject.putFloats(0x700022, VR.FL, fArray);
            } else {
                ay.d((Object)"Could not write the UID because it was null", this);
            }
        } else {
            ay.d((Object)"Could not write node in SR because it was of type UIDREF but didn't have a string value", this);
        }
    }

    private void addCodeSequenceMacro(DicomElement dicomElement, ConceptCode conceptCode) {
        this.addCodeSequence(dicomElement, conceptCode.a(), conceptCode.b(), conceptCode.c());
    }

    private void addSopSequenceMacro(DicomObject dicomObject, ReportNodeFactory.SopReference sopReference) {
        BasicDicomObject basicDicomObject = new BasicDicomObject();
        dicomObject.putNestedDicomObject(528793, (DicomObject)basicDicomObject);
        basicDicomObject.putString(524310, VR.UI, sopReference.sopClassUID);
        basicDicomObject.putString(524312, VR.UI, sopReference.sopInstanceUID);
    }
}

